/*****************************************************************************/
/* td_db_connect.h : Objet Gtk+
 * td_db_connect.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

/*****************************************************************************/
/*** Macros */
/*****************************************************************************/
#define TD_TYPE_DB_CONNECT (td_db_connect_get_type())
#define TD_DB_CONNECT(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_DB_CONNECT, TdDbConnect))
#define TD_DB_CONNECT_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_DB_CONNECT, TdDbConnectClass))
#define TD_IS_DB_CONNECT(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_DB_CONNECT))
#define TD_IS_DB_CONNECT_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_DB_CONNECT))

/*****************************************************************************/
/*** Enumration - Enumeration */
/*****************************************************************************/
typedef enum {
  TD_CONNECT_TYPE_FILE, /*** Fichier - File */
  TD_CONNECT_TYPE_TEMPLATE, /*** Gabarit - Template */
  TD_CONNECT_TYPE_DATABASE, /*** Database - Base de donnes */
  TD_CONNECT_TYPE_URL, /*** Fichier distant - Remote file */
  TD_CONNECT_TYPE_RECOVERY, /*** Rcupration - Recovery */
  TD_CONNECT_TYPE_RECOVERY_START, /*** Rcupration dmmarrage - Recovery starting */
  TD_CONNECT_TYPE_NONE, /*** Aucun - None */
} TdConnectType;

/*****************************************************************************/
/*** Structure */
/*****************************************************************************/
typedef struct _TdDbConnect TdDbConnect;
typedef struct _TdDbConnectClass TdDbConnectClass;

struct _TdDbConnect
{
  /*< public >*/
  GtkObject object;
  gchar *name; /*** Nom - Name */
  TdConnectType type; /*** Type */
  gchar *interface; /*** Interface */
  gchar *host; /*** Hte - Host */
  gchar *port; /*** Port */
  gchar *base; /*** Base */
  gchar *user; /*** Utilisateur - User */
  gchar *password; /*** Mot de passe - Password */
  gchar *file; /*** Fichier - File */
  gchar *template; /*** Gabarit - Template */
};

struct _TdDbConnectClass
{
  GtkObjectClass parent_class;
  void (*set_type) (TdDbConnect *connect, TdConnectType type);
};

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static void td_db_connect_set_name (TdDbConnect *connect, gchar *name);
static void td_db_connect_set_interface (TdDbConnect *connect, gchar *interface);
static void td_db_connect_set_host (TdDbConnect *connect, gchar *host);
static void td_db_connect_set_port (TdDbConnect *connect, gchar *port);
static void td_db_connect_set_user (TdDbConnect *connect, gchar *user);
static void td_db_connect_set_password (TdDbConnect *connect, gchar *password);
static void td_db_connect_set_base (TdDbConnect *connect, gchar *base);
static void td_db_connect_set_file (TdDbConnect *connect, gchar *file);
static void td_db_connect_set_template (TdDbConnect *connect, gchar *template);
static void td_db_connect_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_db_connect_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_db_connect_init (TdDbConnect *connect);
static void td_db_connect_class_init (TdDbConnectClass *klass);
GtkType td_db_connect_get_type (void);
GtkObject *td_db_connect_new (void);

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/
void td_db_connect_set_type (TdDbConnect *connect, TdConnectType type);

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/
TdConnectType td_db_connect_parse_type (gchar *value);
gchar *td_db_connect_print_type (TdConnectType value);

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/
gboolean td_db_connect_load (GtkWidget *menuitem, GtkObject *connect_bookmark);
gboolean td_db_connect_save (GtkMenuItem *menuitem, gpointer user_data);
gboolean td_db_connect_close (GtkWidget *menuitem, gpointer user_data);
gboolean td_db_connect_open_oldfile (gchar *file);
