/*****************************************************************************/
/*** td_db_base.c : Objet Gtk+
 *** td_db_base.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"
#include "database.h"
#include "td_app.h"
#include "td_db_base.h"
#include "td_db_connect.h"
#include "td_db_table.h"
#include "td_db_mod.h"
#include "td_db_mod_table.h"
#include "td_db_mod_menu.h"
#include "td_db_datatable.h"
#include "td_field.h"
#include "td_rule.h"
#include "td_function.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_COMMENT,
  ARG_ENCODING,
};

static void td_db_base_set_name (TdDbBase *db_base, gchar *name)
{
  g_return_if_fail (db_base != NULL);
  g_return_if_fail (TD_IS_DB_BASE (db_base));
  if (db_base->name != name)
    db_base->name = name;
}

static void td_db_base_set_comment (TdDbBase *db_base, gchar *comment)
{
  g_return_if_fail (db_base != NULL);
  g_return_if_fail (TD_IS_DB_BASE (db_base));
  if (db_base->comment != comment)
    db_base->comment = comment;
}

static void td_db_base_set_encoding (TdDbBase *db_base, gchar *encoding)
{
  g_return_if_fail (db_base != NULL);
  g_return_if_fail (TD_IS_DB_BASE (db_base));
  if (db_base->encoding != encoding)
    db_base->encoding = encoding;
}

static void td_db_base_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdDbBase *db_base;
  db_base = TD_DB_BASE (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_db_base_set_name (db_base, GTK_VALUE_STRING (*arg));
      break;
    case ARG_COMMENT:
      td_db_base_set_comment (db_base, GTK_VALUE_STRING (*arg));
      break;
    case ARG_ENCODING:
      td_db_base_set_encoding (db_base, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_db_base_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdDbBase *db_base;
  db_base = TD_DB_BASE (object);
   switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = db_base->name;
      break;
    case ARG_COMMENT:
      GTK_VALUE_STRING (*arg) = db_base->comment;
      break;
    case ARG_ENCODING:
      GTK_VALUE_STRING (*arg) = db_base->encoding;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_db_base_init (TdDbBase *db_base)
{
  db_base->name = NULL;
  db_base->comment = NULL;
  db_base->encoding = NULL;
  db_base->table = NULL;
  db_base->mod = NULL;
  db_base->datatable = NULL;
  db_base->connection = NULL;
}

static void td_db_base_class_init (TdDbBaseClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdDbBase::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdDbBase::comment", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_COMMENT);
  gtk_object_add_arg_type ("TdDbBase::encoding", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_ENCODING);
  object_class->set_arg = td_db_base_set_arg;
  object_class->get_arg = td_db_base_get_arg;
  klass->add_table = td_db_base_add_table;
  klass->add_mod = td_db_base_add_mod;
  klass->add_datatable = td_db_base_add_datatable;
  klass->set_connection = td_db_base_set_connection;
}

GtkType td_db_base_get_type (void)
{
  static GtkType db_base_type = 0;
  if (!db_base_type)
    {
      static const GtkTypeInfo db_base_info =
      {
  	"TdDbBase", sizeof (TdDbBase), sizeof (TdDbBaseClass),
  	(GtkClassInitFunc) td_db_base_class_init,
	(GtkObjectInitFunc) td_db_base_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      db_base_type = gtk_type_unique (GTK_TYPE_OBJECT, &db_base_info);
    }
  return db_base_type;
}

/**
 * td_db_base_new:
 * 
 * fr: Cr une nouvelle base
 *
 * en: Creates a new base
 * 
 * Return value: base
 **/

GtkObject *td_db_base_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_db_base_get_type()));
}

/**
 * td_db_base_destroy:
 * @db_base: base
 * 
 * fr: Dtruit la base
 *
 * en: Destroys the base
 **/

void td_db_base_destroy (TdDbBase *db_base)
{
  int i;
  g_return_if_fail (db_base != NULL);
  g_return_if_fail (TD_IS_DB_BASE (db_base));
  for (i=0; i<g_list_length (db_base->table); i++)
    gtk_object_destroy (GTK_OBJECT (g_list_nth_data (db_base->table, i)));
  g_list_free (db_base->table);
  for (i=0; i<g_list_length (db_base->mod); i++)
    gtk_object_destroy (GTK_OBJECT (g_list_nth_data (db_base->mod, i)));
  g_list_free (db_base->mod);
  for (i=0; i<g_list_length (db_base->datatable); i++)
    gtk_object_destroy (GTK_OBJECT (g_list_nth_data (db_base->datatable, i)));
  g_list_free (db_base->datatable);
  gtk_object_destroy (GTK_OBJECT (db_base));
}

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/

/**
 * td_db_base_add_table:
 * @db_base: base
 * @table: table
 * 
 * fr: Ajoute le schma de la table  la base
 *
 * en: Adds the table schema to base
 **/

void td_db_base_add_table (TdDbBase *db_base, GtkObject *table)
{
  g_return_if_fail (db_base != NULL);
  g_return_if_fail (TD_IS_DB_BASE (db_base));
  db_base->table = g_list_append (db_base->table, table);
}

/**
 * td_db_base_add_mod:
 * @db_base: base
 * @mod: module
 * 
 * fr: Ajoute le paramtrage du module  la base
 *
 * en: Adds the module parameters to base
 **/

void td_db_base_add_mod (TdDbBase *db_base, GtkObject *mod)
{
  g_return_if_fail (db_base != NULL);
  g_return_if_fail (TD_IS_DB_BASE (db_base));
  db_base->mod = g_list_append (db_base->mod, mod);
}

/**
 * td_db_base_add_datatable:
 * @db_base: base
 * @datatable: datatable
 * 
 * fr: Ajoute la table de donnes  la base
 *
 * en: Adds the datatable to base
 **/

void td_db_base_add_datatable (TdDbBase *db_base, GtkObject *datatable)
{
  g_return_if_fail (db_base != NULL);
  g_return_if_fail (TD_IS_DB_BASE (db_base));
  db_base->datatable = g_list_append (db_base->datatable, datatable);
}

/**
 * td_db_base_set_connection:
 * @db_base: base
 * @connection: connection
 * 
 * fr: Affecte la connexion  la base
 *
 * en: Allocates the connection to base
 **/

void td_db_base_set_connection (TdDbBase *db_base, GtkObject *connection)
{
  g_return_if_fail (db_base != NULL);
  g_return_if_fail (TD_IS_DB_BASE (db_base));
  if (db_base->connection != connection)
    db_base->connection = connection;
}

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/

/**
 * td_db_base_load:
 * @file: file location
 * 
 * fr: Retourne la base correspondante au fichier
 *
 * en: Return the base corresponding the file
 * 
 * Return value: base
 **/

GtkObject *td_db_base_load (gchar *file)
{
  GtkObject *ret;
  XmlDoc *doc;
  XmlNs *ns;
  XmlNode *cur;
  XmlNode *cur_root;

  /*** Vrif du contenu du fichier - Checking the content of file */
  doc = xmlParseFile (file);
  if (!doc)
    {
      td_app_message (NULL, g_strdup_printf (_("Parsing XML file '%s' : doc == NULL"), file), TD_MSG_FAILED);
      return (NULL);
    }
  cur = xmlDocGetRootElement (doc);
  if (!cur)
    {
      td_app_message (NULL, g_strdup_printf (_("Parsing XML file '%s' : cur == NULL"), file), TD_MSG_FAILED);
      xmlFreeDoc (doc);
      return (NULL);
    }
  ns = NULL;

  /*** Base */
  ret = td_db_base_new();
  cur_root = xmlDocGetRootElement (doc);
  gtk_object_set (GTK_OBJECT (ret),
		  "name", xmlGetProp (cur, "name"),
		  "comment", xmlGetProp (cur, "comment"), NULL);
  if (doc->encoding)
    gtk_object_set (GTK_OBJECT (ret),
		    "name", doc->encoding, NULL);

  /*** Table */
  cur = cur_root->xmlChildrenNode->xmlChildrenNode;
  while (cur)
    {
      if (!strcmp (cur->name, "table"))
	td_db_base_add_table (TD_DB_BASE (ret), td_db_table_load (doc, ns, cur));
      cur = cur->next;
    }

  /*** Module */
  cur = cur_root->xmlChildrenNode->next->xmlChildrenNode;
  while (cur)
    {
      if (!strcmp (cur->name, "mod"))
	td_db_base_add_mod (TD_DB_BASE (ret), td_db_mod_load (doc, ns, cur));
      cur = cur->next;
    }

  /*** Donnes - Data */
  cur = cur_root->xmlChildrenNode->next->next->xmlChildrenNode;
  while (cur)
    {
      if (!strcmp (cur->name, "datatable"))
	td_db_base_add_datatable (TD_DB_BASE (ret), td_db_datatable_load (doc, ns, cur));
      cur = cur->next;
    }
  xmlFreeDoc (doc);
  td_app_message (NULL, g_strdup_printf (_("Loading file '%s'"), file), TD_MSG_DONE);
  return (ret);
}

/**
 * td_db_base_save:
 * @base: td_db_base
 * @file: file location
 * 
 * fr: Cr un fichier correspondante  la base
 *
 * en: Creates the file corresponding the base
 *
 * Return value: FALSE on error
 **/

gboolean td_db_base_save (TdDbBase *base, gchar *file)
{
  GList *data = NULL;
  GList *item = NULL;
  TdDbTable *table = NULL;
  TdField *table_field = NULL;
  TdRule *table_rule = NULL;
  TdFunction *table_function = NULL;
  TdDbMod *mod = NULL;
  TdDbModTable *mod_table = NULL;
  TdField *mod_table_field = NULL;
  TdField *mod_interface_field = NULL;
  TdField *mod_bench_field = NULL;
  TdField *mod_etabliste_field = NULL;
  TdDbDatatable *datatable = NULL;

  FILE *fp;
  XmlDoc *doc;
  XmlNs *ns;
  XmlNode *tree_tables;
  XmlNode *tree_table;
  XmlNode *tree_mods;
  XmlNode *tree_mod;
  XmlNode *tree_fields;
  XmlNode *tree_field;
  XmlNode *tree_properties;
  XmlNode *tree_property;
  XmlNode *tree_datatables;
  XmlNode *tree_datatable;
  XmlNode *tree_items; 
  XmlNode *tree_item;
  int i, j, k, m;

  /*** Base */
  doc = xmlNewDoc ("1.0");
  doc->xmlRootNode = xmlNewDocNode (doc, NULL, "database", NULL);
  if (strcmp (td_app_custom_value ("file", "data file", "namespace href"), "none"))
    ns = xmlNewNs (doc->xmlRootNode, td_app_custom_value ("file", "data file", "namespace href"), td_app_custom_value ("file", "data file", "namespace prefix"));
  else
    ns = NULL;
  xmlSetProp (doc->xmlRootNode, "name", base->name);
  xmlSetProp (doc->xmlRootNode, "comment", base->comment);

  /*** Tables */
  tree_tables = xmlNewChild (doc->xmlRootNode, ns, "tables", NULL);
  for (i=0; i<g_list_length (base->table); i++)
    {
      table = (TdDbTable*) g_list_nth_data (base->table, i);
      tree_table = xmlNewChild (tree_tables, ns, "table", NULL);
      xmlSetProp (tree_table, "name", table->name);
      xmlSetProp (tree_table, "comment", table->comment);

      /*** Champs - Field */
      tree_fields = xmlNewChild (tree_table, ns, "fields", NULL);
      for (j=0; j<g_list_length (table->field); j++)
	{
	  table_field = (TdField*) g_list_nth_data (table->field, j);
	  tree_field = xmlNewChild (tree_fields, ns, "field", NULL);
	  xmlSetProp (tree_field, "name", table_field->name);
	  xmlSetProp (tree_field, "comment", table_field->comment);
	  tree_properties = xmlNewChild (tree_field, ns, "properties", NULL);
	  for (k=0; k<g_list_length (table_field->property_name); k++)
	    {
	      tree_property = xmlNewChild (tree_properties, ns, "property", NULL);
	      xmlSetProp (tree_property, "name", (gchar*) g_list_nth_data (table_field->property_name, k));
	      xmlSetProp (tree_property, "value", (gchar*) g_list_nth_data (table_field->property_value, k));
	    }
	}

      /*** Rgles - Rules */
      tree_fields = xmlNewChild (tree_table, ns, "rules", NULL);
      for (j=0; j<g_list_length (table->rule); j++)
	{
	  table_rule = (TdRule*) g_list_nth_data (table->rule, j);
	  tree_field = xmlNewChild (tree_fields, ns, "rule", NULL);
	  xmlSetProp (tree_field, "name", table_rule->name);
	  xmlSetProp (tree_field, "comment", table_rule->comment);
	  tree_properties = xmlNewChild (tree_field, ns, "properties", NULL);
	  for (k=0; k<g_list_length (table_rule->property_name); k++)
	    {
	      tree_property = xmlNewChild (tree_properties, ns, "property", NULL);
	      xmlSetProp (tree_property, "name", (gchar*) g_list_nth_data (table_rule->property_name, k));
	      xmlSetProp (tree_property, "value", (gchar*) g_list_nth_data (table_rule->property_value, k));
	    }
	}

      /*** Fonctions - Functions */
      tree_fields = xmlNewChild (tree_table, ns, "functions", NULL);
      for (j=0; j<g_list_length (table->function); j++)
	{
	  table_function = (TdFunction*) g_list_nth_data (table->function, j);
	  tree_field = xmlNewChild (tree_fields, ns, "function", NULL);
	  xmlSetProp (tree_field, "name", table_function->name);
	  xmlSetProp (tree_field, "comment", table_function->comment);
	  tree_properties = xmlNewChild (tree_field, ns, "properties", NULL);
	  for (k=0; k<g_list_length (table_function->property_name); k++)
	    {
	      tree_property = xmlNewChild (tree_properties, ns, "property", NULL);
	      xmlSetProp (tree_property, "name", (gchar*) g_list_nth_data (table_function->property_name, k));
	      xmlSetProp (tree_property, "value", (gchar*) g_list_nth_data (table_function->property_value, k));
	    }
	}
    }

  /*** Modules */
  tree_mods = xmlNewChild (doc->xmlRootNode, ns, "mods", NULL);
  for (i=0; i<g_list_length (base->mod); i++)
    {
      mod = (TdDbMod*) g_list_nth_data (base->mod, i);
      tree_mod = xmlNewChild (tree_mods, ns, "mod", NULL);
      xmlSetProp (tree_mod, "name", mod->name);
      xmlSetProp (tree_mod, "name_param", mod->name_param);
      xmlSetProp (tree_mod, "group", mod->group);
      xmlSetProp (tree_mod, "comment", mod->comment);
      xmlSetProp (tree_mod, "icon", mod->icon);

      /*** Tables */
      tree_tables = xmlNewChild (tree_mod, ns, "tables", NULL);
      for (j=0; j<g_list_length (mod->table); j++)
	{
	  mod_table = (TdDbModTable*) g_list_nth_data (mod->table, j);
	  tree_table = xmlNewChild (tree_tables, ns, "table", NULL);
	  xmlSetProp (tree_table, "name", mod_table->name);
	  xmlSetProp (tree_table, "table", mod_table->table);
	  tree_fields = xmlNewChild (tree_table, ns, "fields", NULL);
	  for (k=0; k<g_list_length (mod_table->field); k++)
	    {
	      mod_table_field = (TdField*) g_list_nth_data (mod_table->field, k);
	      tree_field = xmlNewChild (tree_fields, ns, "field", NULL);
	      xmlSetProp (tree_field, "name", mod_table_field->name);
	      xmlSetProp (tree_field, "table_field", mod_table_field->table_field);
	    }
	}

      /*** Interface */
      tree_table = xmlNewChild (tree_mod, ns, "interface", NULL);
      for (j=0; j<g_list_length (mod->interface_field); j++)
	{
	  mod_interface_field = (TdField*) g_list_nth_data (mod->interface_field, j);
	  tree_field = xmlNewChild (tree_table, ns, "field", NULL);
	  xmlSetProp (tree_field, "name", mod_interface_field->name);
	  xmlSetProp (tree_field, "table_field", mod_interface_field->table_field);
	  tree_properties = xmlNewChild (tree_field, ns, "properties", NULL);
	  for (k=0; k<g_list_length (mod_interface_field->property_name); k++)
	    {
	      tree_property = xmlNewChild (tree_properties, ns, "property", NULL);
	      xmlSetProp (tree_property, "name", (gchar*) g_list_nth_data (mod_interface_field->property_name, k));
	      xmlSetProp (tree_property, "value", (gchar*) g_list_nth_data (mod_interface_field->property_value, k));
	    }
	}

      /*** Etabli - Bench */
      tree_table = xmlNewChild (tree_mod, ns, "bench", NULL);
      for (j=0; j<g_list_length (mod->bench_field); j++)
	{
	  mod_bench_field = (TdField*) g_list_nth_data (mod->bench_field, j);
	  tree_field = xmlNewChild (tree_table, ns, "field", NULL);
	  xmlSetProp (tree_field, "name", mod_bench_field->name);
	  xmlSetProp (tree_field, "table_field", mod_bench_field->table_field);
	  tree_properties = xmlNewChild (tree_field, ns, "properties", NULL);
	  for (k=0; k<g_list_length (mod_bench_field->property_name); k++)
	    {
	      tree_property = xmlNewChild (tree_properties, ns, "property", NULL);
	      xmlSetProp (tree_property, "name", (gchar*) g_list_nth_data (mod_bench_field->property_name, k));
	      xmlSetProp (tree_property, "value", (gchar*) g_list_nth_data (mod_bench_field->property_value, k));
	    }
	}

      /*** Etabliste - Bench of lists */
      tree_table = xmlNewChild (tree_mod, ns, "etabliste", NULL);
      for (j=0; j<g_list_length (mod->etabliste_field); j++)
	{
	  mod_etabliste_field = (TdField*) g_list_nth_data (mod->etabliste_field, j);
	  tree_field = xmlNewChild (tree_table, ns, "field", NULL);
	  xmlSetProp (tree_field, "name", mod_etabliste_field->name);
	  xmlSetProp (tree_field, "table_field", mod_etabliste_field->table_field);
	  tree_properties = xmlNewChild (tree_field, ns, "properties", NULL);
	  for (k=0; k<g_list_length (mod_etabliste_field->property_name); k++)
	    {
	      tree_property = xmlNewChild (tree_properties, ns, "property", NULL);
	      xmlSetProp (tree_property, "name", (gchar*) g_list_nth_data (mod_etabliste_field->property_name, k));
	      xmlSetProp (tree_property, "value", (gchar*) g_list_nth_data (mod_etabliste_field->property_value, k));
	    }
	}

      /*** Menu */
      tree_table = xmlNewChild (tree_mod, ns, "menu", NULL);
    }
  
  /*** Table de donnes - Datatables */
  tree_datatables = xmlNewChild (doc->xmlRootNode, ns, "datatables", NULL);
  for (i=0; i<g_list_length (base->datatable); i++)
    {
      datatable = (TdDbDatatable*) g_list_nth_data (base->datatable, i);
      tree_datatable = xmlNewChild (tree_datatables, ns, "datatable", NULL);
      xmlSetProp (tree_datatable, "table", datatable->table);
      tree_items = xmlNewChild (tree_datatable, ns, "items", NULL);
      for (j=0; j<g_list_length (datatable->item); j++)
	{
	  item = g_list_nth_data (datatable->item, j);
	  tree_item = xmlNewChild (tree_items, ns, "item", NULL);
	  for (k=0; k<g_list_length (item); k++)
	    xmlSetProp (tree_item, g_strdup_printf ("field%d", k), (gchar*) g_list_nth_data (item, k));
	}
    }

  /*** Enregistrement - Save */
  fp = fopen (file, "w");
  if (!fp)
    {
      td_app_message (_("Opening file"), NULL, TD_MSG_FAILED);
      xmlFreeDoc (doc);
      return FALSE;
    }
  fclose (fp);
  /* FIXME: libxml2 : attente d'une version plus mature - libxml2 : wait a more mature version */ 
  /* if (base->encoding) */
  /* { */
  /* if (xmlSaveFileEnc (file, doc, base->encoding)<0) */
  /* { */
  /* td_app_message (NULL, g_strdup_printf (_("Saving geometry '%s'"), file), TD_MSG_FAILED); */
  /* xmlFreeDoc (doc); */
  /* return FALSE; */
  /* } */
  /* } */
  /* else */
  if (xmlSaveFile (file, doc)<0)
    {
      td_app_message (_("Saving file"), NULL, TD_MSG_FAILED);
      xmlFreeDoc (doc);
      return FALSE;
    }
  xmlFreeDoc (doc);
  return TRUE;
}

