/*****************************************************************************/
/*** td_app_menu.c : Objet Gtk+
 *** td_app_menu.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <dlfcn.h>
#include <fcntl.h>
#include <dirent.h>
#include <sys/stat.h>

#include "commons.h"
#include "gtdk.h"
#include "icons.h"
#include "td_app.h"
#include "td_app_menu.h"
#include "td_app_palette.h"
#include "td_db_connect.h"
#include "td_mod.h"
#include "td_about.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_LABEL,
  ARG_TYPE,
  ARG_PATH,
  ARG_PATH_PARENT,
  ARG_FILE,
  ARG_SYMBOL,
};

static void td_app_menu_set_label (TdAppMenu *menu, gchar *label)
{
  g_return_if_fail (menu != NULL);
  g_return_if_fail (TD_IS_APP_MENU (menu));
  if (menu->label != label)
    menu->label = label;
}

static void td_app_menu_set_type (TdAppMenu *menu, gchar *type)
{
  g_return_if_fail (menu != NULL);
  g_return_if_fail (TD_IS_APP_MENU (menu));
  if (menu->type != type)
    menu->type = type;
}

static void td_app_menu_set_path (TdAppMenu *menu, gchar *path)
{
  g_return_if_fail (menu != NULL);
  g_return_if_fail (TD_IS_APP_MENU (menu));
  if (menu->path != path)
    menu->path = path;
}

static void td_app_menu_set_path_parent (TdAppMenu *menu, gchar *path_parent)
{
  g_return_if_fail (menu != NULL);
  g_return_if_fail (TD_IS_APP_MENU (menu));
  if (menu->path_parent != path_parent)
    menu->path_parent = path_parent;
}

static void td_app_menu_set_file (TdAppMenu *menu, gchar *file)
{
  g_return_if_fail (menu != NULL);
  g_return_if_fail (TD_IS_APP_MENU (menu));
  if (menu->file != file)
    menu->file = file;
}

static void td_app_menu_set_symbol (TdAppMenu *menu, gchar *symbol)
{
  g_return_if_fail (menu != NULL);
  g_return_if_fail (TD_IS_APP_MENU (menu));
  if (menu->symbol != symbol)
    menu->symbol = symbol;
}

static void td_app_menu_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdAppMenu *menu;
  menu = TD_APP_MENU (object);
  switch (arg_id)
    {
    case ARG_LABEL:
      td_app_menu_set_label (menu, GTK_VALUE_STRING (*arg));
      break;
    case ARG_TYPE:
      td_app_menu_set_type (menu, GTK_VALUE_STRING (*arg));
      break;
    case ARG_PATH:
      td_app_menu_set_path (menu, GTK_VALUE_STRING (*arg));
      break;
    case ARG_PATH_PARENT:
      td_app_menu_set_path_parent (menu, GTK_VALUE_STRING (*arg));
      break;
    case ARG_FILE:
      td_app_menu_set_file (menu, GTK_VALUE_STRING (*arg));
      break;
    case ARG_SYMBOL:
      td_app_menu_set_symbol (menu, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_app_menu_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdAppMenu *menu;
  menu = TD_APP_MENU (object);
   switch (arg_id)
    {
    case ARG_LABEL:
      GTK_VALUE_STRING (*arg) = menu->label;
      break;
    case ARG_TYPE:
      GTK_VALUE_STRING (*arg) = menu->type;
      break;
    case ARG_PATH:
      GTK_VALUE_STRING (*arg) = menu->path;
      break;
    case ARG_PATH_PARENT:
      GTK_VALUE_STRING (*arg) = menu->path_parent;
      break;
    case ARG_FILE:
      GTK_VALUE_STRING (*arg) = menu->file;
      break;
    case ARG_SYMBOL:
      GTK_VALUE_STRING (*arg) = menu->symbol;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_app_menu_init (TdAppMenu *menu)
{
  menu->label = NULL;
  menu->type = NULL;
  menu->path = NULL;
  menu->path_parent = NULL;
  menu->file = NULL;
  menu->symbol = NULL;
}

static void td_app_menu_class_init (TdAppMenuClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdAppMenu::label", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_LABEL);
  gtk_object_add_arg_type ("TdAppMenu::type", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_TYPE);
  gtk_object_add_arg_type ("TdAppMenu::path", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_PATH);
  gtk_object_add_arg_type ("TdAppMenu::path_parent", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_PATH_PARENT);
  gtk_object_add_arg_type ("TdAppMenu::file", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_FILE);
  gtk_object_add_arg_type ("TdAppMenu::symbol", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_SYMBOL);
  object_class->set_arg = td_app_menu_set_arg;
  object_class->get_arg = td_app_menu_get_arg;
}

GtkType td_app_menu_get_type (void)
{
  static GtkType app_menu_type = 0;
  if (!app_menu_type)
    {
      static const GtkTypeInfo app_menu_info =
      {
  	"TdAppMenu", sizeof (TdAppMenu), sizeof (TdAppMenuClass),
  	(GtkClassInitFunc) td_app_menu_class_init,
	(GtkObjectInitFunc) td_app_menu_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      app_menu_type = gtk_type_unique (GTK_TYPE_OBJECT, &app_menu_info);
    }
  return app_menu_type;
}

/**
 * td_app_menu_new:
 * 
 * fr: Cr un nouveau menu
 *
 * en: Creates a new menu
 * 
 * Return value: menu
 **/

GtkObject *td_app_menu_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_app_menu_get_type()));
}

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/

/**
 * td_app_menu_activate:
 * @menuitem: menuitem
 * @user_data: NULL
 * 
 * fr: Active une commande du menu de l'application
 *
 * en: Activate a command of application menu
 **/

void td_app_menu_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  td_app_menu_gtk_activate (NULL, GTK_WIDGET (menuitem)->name);
}

/**
 * td_app_menu_gtk_activate:
 * @menuitem: menuitem
 * @path: menu's path
 * 
 * fr: Active une commande du menu de l'application
 *
 * en: Activate a command of application menu
 * 
 * Return value: FALSE on error
 **/

gboolean td_app_menu_gtk_activate (GtkWidget *menuitem, gchar *path)
{
  void (*symbol)() = NULL;
  TdAppMenu *menu_tmp = NULL;
  gboolean bool_tmp;
  int i;
  gchar *txt_tmp;
  int fp;

  /*** Localisation du menu - Menu location */
  bool_tmp = FALSE;
  for (i=0; i<g_list_length (TD_APP (APP)->menu_mod); i++)
    {
      menu_tmp = g_list_nth_data (TD_APP (APP)->menu_mod, i);
      if ((!strcmp (path, TD_APP_MENU (menu_tmp)->path))||
	  (!strcmp (path, g_strdup_printf ("%s%s", PREFIX_WIDGET_CORE, TD_APP_MENU (menu_tmp)->path)))||
	  (!strcmp (path, g_strdup_printf ("%s%s", PREFIX_WIDGET_PLUGINS, TD_APP_MENU (menu_tmp)->path))))
	{
	  bool_tmp = TRUE;
	  break;
	}
    }
  if (!bool_tmp)
    {
      td_app_message (_("Executing plug-in"), g_strdup_printf (_("%s : plug-in for '%s' not loaded"), _("Executing plug-in"), path), TD_MSG_FAILED);
      return FALSE;
    }

  /*** Manuel - Manual */
  if (!strcmp (TD_APP_MENU (menu_tmp)->type, "manual"))
    {
      txt_tmp = g_strdup_printf (("%s/doc/%s/user/%s/%s"), TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, _("en"), TD_APP_MENU (menu_tmp)->file);
      if (!td_file_exist (txt_tmp))
	txt_tmp = g_strdup_printf (("%s/doc/%s/user/%s/%s"), TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, "en", TD_APP_MENU (menu_tmp)->file);
      td_browser (txt_tmp);
      return TRUE;
    }

  /*** Module des greffons - Plugins module */
  if ((!strcmp (TD_APP_MENU (menu_tmp)->type, "module")) && (!strcmp (TD_APP_MENU (menu_tmp)->file, "libhelp_xts.so")))
    {
      if (PLUGINS_CORE_XTS)
	{
	  (gpointer*) symbol = td_dlsym (PLUGINS_CORE_XTS, NULL, NULL, TD_APP_MENU (menu_tmp)->symbol, TRUE);
	  symbol();
	  return TRUE;
	}
      PLUGINS_CORE_XTS = dlopen (g_strdup_printf ("%s%s", TD_PACKAGE_PLUGINS_DIR, "libhelp_xts.so"), RTLD_LAZY);
      (gpointer*) symbol = td_dlsym (PLUGINS_CORE_XTS, NULL, NULL, TD_APP_MENU (menu_tmp)->symbol, TRUE);
      symbol();
      return TRUE;
    }

  /*** Module */
  if (!strcmp (TD_APP_MENU (menu_tmp)->type, "module"))
    {

      /*** Module dj charg ? - Module already loaded ? */
      txt_tmp = g_strconcat (TD_PACKAGE_PLUGINS_DIR, TD_APP_MENU (menu_tmp)->file, NULL);
      bool_tmp = FALSE;
      for (i=0; i<g_list_length (TD_APP (APP)->mod_core); i++)
	if (!strcmp ((gchar*) g_list_nth_data (TD_APP (APP)->mod_core, i), txt_tmp))
	  {
	    bool_tmp = TRUE;
	    break;
	  }

      /*** Oui - Yes */
      if (bool_tmp)
	{
	  (gpointer*) symbol = td_dlsym (PLUGINS_CORE[i], TD_PACKAGE_PLUGINS_DIR, TD_APP_MENU (menu_tmp)->file, TD_APP_MENU (menu_tmp)->symbol, TRUE);
	  symbol();
	  return TRUE;
	}

      /*** Non - No */
      td_app_add_mod_core (NULL, NULL, TD_APP_MENU (menu_tmp)->file);
      if (strcmp (TD_APP_MENU (menu_tmp)->symbol, "plugins_init"))
	{
	  (gpointer*) symbol = td_dlsym (PLUGINS_CORE[g_list_length (TD_APP (APP)->mod_core)-1], TD_PACKAGE_PLUGINS_DIR, TD_APP_MENU (menu_tmp)->file, TD_APP_MENU (menu_tmp)->symbol, TRUE);
	  symbol();
	}
    }
  return TRUE;
}

/*****************************************************************************/
/*** Menus standards - Standards menu */
/*****************************************************************************/

/**
 * td_app_menu_std_new:
 * @menu: module's menu
 * @mod: module
 * 
 * fr: Ajoute au menu du module les menu standard
 *
 * en: Adds standard menu to the module's menu
 **/

void td_app_menu_std_new (GtkWidget *menu, GtkObject *mod)
{
  void (*symbol)() = NULL;
  GtkWidget *menu1;
  GtkWidget *menu1_item;
  GtkWidget *menu2;
  GtkWidget *menu2_item[4];
  GtkWidget *menu3_item;
  GtkWidget *menu4;
  GtkWidget *menu4_item[2];

  /*** Menu des outils - Tools menu */
  /* menu4_item[0] = gtdk_menu_item_new (_("Tools"), NULL, "list_tools.xpm"); */
  /* gtk_menu_append (GTK_MENU (menu), menu4_item[0]); */
  /* menu4 = gtk_menu_new(); */
  /* gtdk_menu_item_set_submenu (GTK_MENU_ITEM (menu4_item[0]), menu4); */

  /* menu4_item[1] = gtdk_menu_item_new (_("Search"), NULL, "list_search.xpm"); */
  /* gtk_signal_connect_object (GTK_OBJECT (menu4_item[1]), "activate", GTK_SIGNAL_FUNC (td_mod_search_show), mod); */
  /* gtk_menu_append (GTK_MENU (menu4), menu4_item[1]); */

  /*** Menu des import-export - Import-export menu */
  menu1_item = gtdk_menu_item_new (_("Import - Export"), NULL, "list_import_export.xpm");
  gtk_menu_append (GTK_MENU (menu), menu1_item);
  (gpointer*) symbol = td_dlsym (PLUGINS_CORE_BOOKMARKS, NULL, "libbookmarks.so", "plugins_menu_def_commands", TRUE);
  symbol (menu1_item, TD_APP (APP)->accel_group, mod);

  /*** Menu aide - Help menu */
  menu2_item[0] = gtdk_menu_item_new (_("Help"), NULL, "list_help.xpm");
  gtk_menu_append (GTK_MENU (menu), menu2_item[0]);
  menu2 = gtk_menu_new();
  gtdk_menu_item_set_submenu (GTK_MENU_ITEM (menu2_item[0]), menu2);

  /*** Menu personnalisation - Customize menu */
  if ((td_file_exist (g_strdup_printf ("%s/customize/%s.xml", TD_PACKAGE_VAR_DIR, TD_MOD (mod)->name))) ||
      (td_file_exist (g_strdup_printf("%s/share/%s/%s/customize-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, TD_MOD (mod)->name, _("en")))) ||
      (td_file_exist (g_strdup_printf("%s/share/%s/%s/customize-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, TD_MOD (mod)->name, "en"))))
    {
      menu2_item[1] = gtdk_menu_item_new (_("Customize"), NULL, "list_preferences.xpm");
      gtk_signal_connect_object (GTK_OBJECT (menu2_item[1]), "activate", GTK_SIGNAL_FUNC (td_mod_custom_show), mod);
      gtk_menu_append (GTK_MENU (menu2), menu2_item[1]);
    }

  /*** Menu presto - Presto menu */
  if ((td_file_exist (g_strdup_printf("%s/share/%s/%s/presto-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, TD_MOD (mod)->name, _("en")))) ||
      (td_file_exist (g_strdup_printf("%s/share/%s/%s/presto-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, TD_MOD (mod)->name, "en"))))
    {
      menu2_item[2] = gtdk_menu_item_new (_("Presto"), NULL, "list_presto.xpm");
      gtk_signal_connect_object (GTK_OBJECT (menu2_item[2]), "activate", GTK_SIGNAL_FUNC (td_mod_presto_show), mod);
      gtk_menu_append (GTK_MENU (menu2), menu2_item[2]);
    }

  /*** Menu A propos - About menu */
  menu2_item[3] = gtdk_menu_item_new (_("About"), NULL, "list_about.xpm");
  gtk_signal_connect_object (GTK_OBJECT (menu2_item[3]), "activate", GTK_SIGNAL_FUNC (td_about_show), GTK_OBJECT (TD_MOD (mod)->about));
  gtk_menu_append (GTK_MENU (menu2), menu2_item[3]);

  /*** Fin standard - Standard end */
  menu3_item = gtdk_menu_item_accel_new (_("Close"), NULL, "list_close.xpm", TD_APP (APP)->accel_group, GDK_W, GDK_CONTROL_MASK),
  gtk_signal_connect_object (GTK_OBJECT (menu3_item), "activate", GTK_SIGNAL_FUNC (td_mod_hide), mod);
  gtk_menu_append (GTK_MENU (menu), menu3_item);
}



