/*****************************************************************************/
/* td_app.h : Objet Gtk+
 * td_app.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

/*****************************************************************************/
/*** Macros */
/*****************************************************************************/
#define TD_TYPE_APP (td_app_get_type())
#define TD_APP(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_APP, TdApp))
#define TD_APP_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_APP, TdAppClass))
#define TD_IS_APP(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_APP))
#define TD_IS_APP_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_APP))

/*****************************************************************************/
/*** Enumration - Enumeration */
/*****************************************************************************/
typedef enum {
  TD_MSG_DONE, /*** Message russit - Message done */
  TD_MSG_TESTED, /*** Message test - Message tested */
  TD_MSG_PLUGINS, /*** Message greffon - Message plug-in */
  TD_MSG_COMMAND, /*** Message commande - Message command */
  TD_MSG_SQL, /*** Message sql */
  TD_MSG_SQL_CACHE, /*** Message sql cache */
  TD_MSG_FUNCTION, /*** Message fonction - Message function */
  TD_MSG_FAILED, /*** Message chou - Message failed */
  TD_MSG_STOP, /*** Message stop */
  TD_MSG_BEGIN, /*** Message dbut - Message begin */
  TD_MSG_END, /*** Message fin - Message end */
  TD_MSG_MESSAGE, /*** Message message */
  TD_MSG_YES, /*** Message oui - Message yes */
  TD_MSG_NO, /*** Message non - Message no */
} TdMsg;

typedef enum {
  TD_MODE_ECHO_0, /*** NULL */
  TD_MODE_ECHO_ALL_COLORS, /*** Echo tout en couleur - Echo all with colors */
  TD_MODE_ECHO_COLORS, /*** Echo en couleur - Echo colored */
  TD_MODE_ECHO_ALL_BW, /*** Echo all en noir et blanc - Echo all whitout colors */
  TD_MODE_ECHO_BW, /*** Echo en noir et blanc - Echo whitout colors */
  TD_MODE_ECHO_NO, /*** Sans cho - Whitout echo */
} TdModeEcho;

/*****************************************************************************/
/*** Structure */
/*****************************************************************************/
typedef struct _TdApp TdApp;
typedef struct _TdAppClass TdAppClass;

struct _TdApp
{
  /*< public >*/
  GtkObject object;
  int pid; /*** Indentificatuer du processus - Process identifier */
  gchar *pid_database; /*** Base de donnes locale du processus - Locale database of process */
  GtkObject *palette; /*** Palette */
  GtkObject *bench; /*** Etabli - Bench */
  GtkObject *etabliste; /*** Etabli des listes - Bench of lists */
  gboolean modified; /*** Drapeau de modifications non enregistres - Flag for unsaved changes */
  int mode_echo; /*** Mode de l'echo de l'application - The echo mode of Application */
  GList *admin_field; /*** Champs d'administration - Administration fields */
  GtkObject *connect; /*** Connexion courante - Current connection */
  GtkObject *base; /*** Base courante - Current base */

  GtkAccelGroup *accel_group; /*** Groupe des acclrateur - Accelerators group */
  GtkWidget *menu_main;  /*** Menu principale - Main menu */
  GnomeUIInfo *menu_gnomeui; /*** Menu principale - Main menu */
  GtkWidget *menu_palette; /*** Menu de la palette - Palette menu */
  GtkWidget *menu_favorites; /*** Menu des favoris - Favorites menu */
  GtkWidget *menu_templates; /*** Menu des gabarits - Templates menu */
  GtkWidget *menu_commands; /*** Menu des commandes - Commands menu */
  GtkWidget *menu_history; /*** Menu de l'historique - History menu */

  GtkObject *about; /*** Description */
  GtkObject *presto_browser; /*** Interface d'aide - Help interface */
  GtkObject *custom_browser; /*** Interface de personnalisation - Customize interface */
  GList *menu_mod; /*** Liste des menus  module - Module menus list */
  GList *mod_core; /*** Liste des modules noyaux - Core modules list */
  GList *mod_data; /*** Liste des modules de donnes - Data modules list */
  GList *mod_filter; /*** Liste des modules de filtre - Filter modules list */
  GList *process; /*** Liste des processus - Process list */

  GList *function; /*** Liste des fonctions - Functions list */
  GList *function_input; /*** Liste des champs lis - Linked fields list */
};

struct _TdAppClass
{
  GtkObjectClass parent_class;
  void (*set_palette) (TdApp *app, GtkObject *palette);
  void (*set_bench) (TdApp *app, GtkObject *bench);
  void (*set_etabliste) (TdApp *app, GtkObject *etabliste);
  void (*add_admin_field) (TdApp *app, gchar *field);
  void (*set_accel_group) (TdApp *app, GtkAccelGroup *accel_group);
  void (*set_menu_main) (TdApp *app, GnomeUIInfo *menu_gnomeui);
  void (*set_menu_palette) (TdApp *app, GtkWidget *menu_palette);
  void (*set_menu_favorites) (TdApp *app, GtkWidget *menu_favorites);
  void (*set_menu_templates) (TdApp *app, GtkWidget *menu_templates);
  void (*set_menu_commands) (TdApp *app, GtkWidget *menu_commands);
  void (*set_menu_history) (TdApp *app, GtkWidget *menu_history);
  void (*set_current) (TdApp *app, GtkObject *connect, GtkObject *base);
  void (*set_modified) (TdApp *app, gboolean modified);
  void (*set_about) (TdApp *app, GtkObject *about);
  void (*add_menu_mod) (TdApp *app, GtkObject *menu_mod);
  void (*add_function) (TdApp *app, GtkObject *function);
  void (*create) (TdApp *app);
  void (*quit) (TdApp *app);
};

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static void td_app_set_modified (TdApp *app, gboolean modified);
static void td_app_set_mode_echo (TdApp *app, int mode_echo);
static void td_app_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_app_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_app_init (TdApp *app);
static void td_app_class_init (TdAppClass *klass);
GtkType td_app_get_type (void);
GtkObject *td_app_new (void);
void td_app_quit (TdApp *app);

/*****************************************************************************/
/*** Affectations - Allocations*/
/*****************************************************************************/
void td_app_set_palette (TdApp *app, GtkObject *palette);
void td_app_set_bench (TdApp *app, GtkObject *bench);
void td_app_set_etabliste (TdApp *app, GtkObject *etabliste);
void td_app_add_admin_field (TdApp *app, gchar *field);
void td_app_set_accel_group (TdApp *app, GtkAccelGroup *accel_group);
void td_app_set_menu_main (TdApp *app, GnomeUIInfo *menu_gnomeui);
void td_app_set_menu_palette (TdApp *app, GtkWidget *menu_palette);
void td_app_set_menu_favorites (TdApp *app, GtkWidget *menu_favorites);
void td_app_set_menu_templates (TdApp *app, GtkWidget *menu_templates);
void td_app_set_menu_commands (TdApp *app, GtkWidget *menu_commands);
void td_app_set_menu_history (TdApp *app, GtkWidget *menu_history);
void td_app_set_current (TdApp *app, GtkObject *connect, GtkObject *base);
void td_app_set_about (TdApp *app, GtkObject *about);
gboolean td_app_add_mod_core (TdApp *app, gchar *dir, gchar *file);
gboolean td_app_add_mod_filter (TdApp *app, gchar *dir, gchar *file, gchar *name, gchar *name_intl);
gboolean td_app_add_mod_data (TdApp *app, gchar *dir, gchar *file);
void td_app_add_process (TdApp *app, GtkObject *process);
void td_app_add_menu_mod (TdApp *app, GtkObject *menu_mod);
void td_app_add_function (TdApp *app, GtkObject *function);

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/
void td_app_create (TdApp *app);
void td_app_custom_show (TdApp *app);
void td_app_presto_show (TdApp *app);
void td_app_message (gchar *chtit_message, gchar *message, TdMsg type);
gpointer *td_app_mod_core_symbol (TdApp *app, gchar *dir, gchar *file, gchar *symbol, gboolean warning);
gboolean td_app_mod_core_activate (TdApp *app, gchar *dir, gchar *file, gchar *symbol, gboolean warning);
gpointer *td_app_mod_data_symbol (int mod_id, gchar *symbol, gboolean warning);
gboolean td_app_mod_data_activate (int mod_id, gchar *symbol, gboolean warning);
void td_app_action_function (gchar *table, GtkObject *mod);
TdModeEcho td_app_mode_echo_parse (gchar *value);

/*****************************************************************************/
/*** Personnalisation et paramtrage - Customizing and parameters */
/*****************************************************************************/
gchar *td_app_custom_value (gchar *category, gchar *group, gchar *option);

/*****************************************************************************/
/*** Verrou - Lock */
/*****************************************************************************/
static void td_app_lock_add (TdApp *app);
static void td_app_lock_update (TdApp *app, gchar *file);
static void td_app_lock_remove (TdApp *app, int pid);
