/*****************************************************************************/
/* td_about.h : Objet Gtk+
 * td_about.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

/*****************************************************************************/
/*** Macros */
/*****************************************************************************/
#define TD_TYPE_ABOUT (td_about_get_type())
#define TD_ABOUT(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_ABOUT, TdAbout))
#define TD_ABOUT_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_ABOUT, TdAboutClass))
#define TD_IS_ABOUT(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_ABOUT))
#define TD_IS_ABOUT_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_ABOUT))

/*****************************************************************************/
/*** Structure */
/*****************************************************************************/
typedef struct _TdAbout TdAbout;
typedef struct _TdAboutClass TdAboutClass;

struct _TdAbout
{
  /*< public >*/
  GtkObject object;
  gchar *name; /*** Nom - Name */
  gchar *type; /*** Type (preference, communication, view, help) */
  gchar *version; /*** Version */
  gchar *authors; /*** Auteurs - Authors */
  gchar *help; /*** Rsum - Summary */
  gchar *category1; /*** Classification : 1 catgorie - Sorting : 1 category */
  gchar *category2; /*** Classification : 2 catgorie - Sorting : 2 category */
  gchar *category3; /*** Classification : nom - Sorting : name */
  gchar *copyright; /*** Copyright */
  gchar *license; /*** Licence - License */
  gchar *icon; /*** Icne - Icon */
  gchar *logo; /*** Logo */
  gchar *web; /*** Site web - Web site */
};

struct _TdAboutClass
{
  GtkObjectClass parent_class;
  void (*show) (TdAbout *about);
};

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static void td_about_set_name (TdAbout *about, gchar *name);
static void td_about_set_type (TdAbout *about, gchar *type);
static void td_about_set_version (TdAbout *about, gchar *version);
static void td_about_set_authors (TdAbout *about, gchar *authors);
static void td_about_set_help (TdAbout *about, gchar *help);
static void td_about_set_category1 (TdAbout *about, gchar *category1);
static void td_about_set_category2 (TdAbout *about, gchar *category2);
static void td_about_set_category3 (TdAbout *about, gchar *category3);
static void td_about_set_copyright (TdAbout *about, gchar *copyright);
static void td_about_set_license (TdAbout *about, gchar *license);
static void td_about_set_icon (TdAbout *about, gchar *icon);
static void td_about_set_logo (TdAbout *about, gchar *logo);
static void td_about_set_web (TdAbout *about, gchar *web);
static void td_about_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_about_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_about_init (TdAbout *about);
static void td_about_class_init (TdAboutClass *klass);
GtkType td_about_get_type (void);
GtkObject *td_about_new (void);

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/
void td_about_show (TdAbout *about);

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/
TdAbout *td_about_get (gchar *file);
GList *td_about_filelist (gchar *directory, gchar *type);
void td_about_categorytree (GtkCTree *ctree, GList *plugins_list, GList *file_list);
