/*****************************************************************************/
/*** td_about.c : Objet Gtk+
 *** td_about.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <dlfcn.h>
#include <dirent.h>
#include <sys/stat.h>

#include "commons.h"
#include "gtdk.h"
#include "td_app.h"
#include "td_mod.h"
#include "td_about.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_TYPE,
  ARG_VERSION,
  ARG_AUTHORS,
  ARG_HELP,
  ARG_CATEGORY1,
  ARG_CATEGORY2,
  ARG_CATEGORY3,
  ARG_COPYRIGHT,
  ARG_LICENSE,
  ARG_ICON,
  ARG_LOGO,
  ARG_WEB,
};

static void td_about_set_name (TdAbout *about, gchar *name)
{
  g_return_if_fail (about != NULL);
  g_return_if_fail (TD_IS_ABOUT (about));
  if (about->name != name)
    about->name = name;
}

static void td_about_set_type (TdAbout *about, gchar *type)
{
  g_return_if_fail (about != NULL);
  g_return_if_fail (TD_IS_ABOUT (about));
  if (about->type != type)
    about->type = type;
}

static void td_about_set_version (TdAbout *about, gchar *version)
{
  g_return_if_fail (about != NULL);
  g_return_if_fail (TD_IS_ABOUT (about));
  if (about->version != version)
    about->version = version;
}

static void td_about_set_authors (TdAbout *about, gchar *authors)
{
  g_return_if_fail (about != NULL);
  g_return_if_fail (TD_IS_ABOUT (about));
  if (about->authors != authors)
    about->authors = authors;
}

static void td_about_set_help (TdAbout *about, gchar *help)
{
  g_return_if_fail (about != NULL);
  g_return_if_fail (TD_IS_ABOUT (about));
  if (about->help != help)
    about->help = help;
}

static void td_about_set_category1 (TdAbout *about, gchar *category1)
{
  g_return_if_fail (about != NULL);
  g_return_if_fail (TD_IS_ABOUT (about));
  if (about->category1 != category1)
    about->category1 = category1;
}

static void td_about_set_category2 (TdAbout *about, gchar *category2)
{
  g_return_if_fail (about != NULL);
  g_return_if_fail (TD_IS_ABOUT (about));
  if (about->category2 != category2)
    about->category2 = category2;
}

static void td_about_set_category3 (TdAbout *about, gchar *category3)
{
  g_return_if_fail (about != NULL);
  g_return_if_fail (TD_IS_ABOUT (about));
  if (about->category3 != category3)
    about->category3 = category3;
}

static void td_about_set_copyright (TdAbout *about, gchar *copyright)
{
  g_return_if_fail (about != NULL);
  g_return_if_fail (TD_IS_ABOUT (about));
  if (about->copyright != copyright)
    about->copyright = copyright;
}

static void td_about_set_license (TdAbout *about, gchar *license)
{
  g_return_if_fail (about != NULL);
  g_return_if_fail (TD_IS_ABOUT (about));
  if (about->license != license)
    about->license = license;
}

static void td_about_set_icon (TdAbout *about, gchar *icon)
{
  g_return_if_fail (about != NULL);
  g_return_if_fail (TD_IS_ABOUT (about));
  if (about->icon != icon)
    about->icon = icon;
}

static void td_about_set_logo (TdAbout *about, gchar *logo)
{
  g_return_if_fail (about != NULL);
  g_return_if_fail (TD_IS_ABOUT (about));
  if (about->logo != logo)
    about->logo = logo;
}

static void td_about_set_web (TdAbout *about, gchar *web)
{
  g_return_if_fail (about != NULL);
  g_return_if_fail (TD_IS_ABOUT (about));
  if (about->web != web)
    about->web = web;
}

static void td_about_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdAbout *about;
  about = TD_ABOUT (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_about_set_name (about, GTK_VALUE_STRING (*arg));
      break;
    case ARG_TYPE:
      td_about_set_type (about, GTK_VALUE_STRING (*arg));
      break;
    case ARG_VERSION:
      td_about_set_version (about, GTK_VALUE_STRING (*arg));
      break;
    case ARG_AUTHORS:
      td_about_set_authors (about, GTK_VALUE_STRING (*arg));
      break;
    case ARG_HELP:
      td_about_set_help (about, GTK_VALUE_STRING (*arg));
      break;
    case ARG_CATEGORY1:
      td_about_set_category1 (about, GTK_VALUE_STRING (*arg));
      break;
    case ARG_CATEGORY2:
      td_about_set_category2 (about, GTK_VALUE_STRING (*arg));
      break;
    case ARG_CATEGORY3:
      td_about_set_category3 (about, GTK_VALUE_STRING (*arg));
      break;
    case ARG_COPYRIGHT:
      td_about_set_copyright (about, GTK_VALUE_STRING (*arg));
      break;
    case ARG_LICENSE:
      td_about_set_license (about, GTK_VALUE_STRING (*arg));
      break;
    case ARG_ICON:
      td_about_set_icon (about, GTK_VALUE_STRING (*arg));
      break;
    case ARG_LOGO:
      td_about_set_logo (about, GTK_VALUE_STRING (*arg));
      break;
    case ARG_WEB:
      td_about_set_web (about, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_about_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdAbout *about;
  about = TD_ABOUT (object);
   switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = about->name;
      break;
    case ARG_TYPE:
      GTK_VALUE_STRING (*arg) = about->type;
      break;
    case ARG_VERSION:
      GTK_VALUE_STRING (*arg) = about->version;
      break;
    case ARG_AUTHORS:
      GTK_VALUE_STRING (*arg) = about->authors;
      break;
    case ARG_HELP:
      GTK_VALUE_STRING (*arg) = about->help;
      break;
    case ARG_CATEGORY1:
      GTK_VALUE_STRING (*arg) = about->category1;
      break;
    case ARG_CATEGORY2:
      GTK_VALUE_STRING (*arg) = about->category2;
      break;
    case ARG_CATEGORY3:
      GTK_VALUE_STRING (*arg) = about->category3;
      break;
    case ARG_COPYRIGHT:
      GTK_VALUE_STRING (*arg) = about->copyright;
      break;
    case ARG_LICENSE:
      GTK_VALUE_STRING (*arg) = about->license;
      break;
    case ARG_ICON:
      GTK_VALUE_STRING (*arg) = about->icon;
      break;
    case ARG_LOGO:
      GTK_VALUE_STRING (*arg) = about->logo;
      break;
    case ARG_WEB:
      GTK_VALUE_STRING (*arg) = about->web;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/

static void td_about_init (TdAbout *about)
{
  about->name = NULL;
  about->type = NULL;
  about->version = NULL;
  about->authors = NULL;
  about->help = NULL;
  about->category1 = NULL;
  about->category2 = NULL;
  about->category3 = NULL;
  about->copyright = NULL;
  about->license = NULL;
  about->icon = NULL;
  about->logo = NULL;
  about->web = NULL;
}

static void td_about_class_init (TdAboutClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdAbout::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdAbout::type", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_TYPE);
  gtk_object_add_arg_type ("TdAbout::version", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_VERSION);
  gtk_object_add_arg_type ("TdAbout::authors", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_AUTHORS);
  gtk_object_add_arg_type ("TdAbout::help", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_HELP);
  gtk_object_add_arg_type ("TdAbout::category1", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_CATEGORY1);
  gtk_object_add_arg_type ("TdAbout::category2", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_CATEGORY2);
  gtk_object_add_arg_type ("TdAbout::category3", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_CATEGORY3);
  gtk_object_add_arg_type ("TdAbout::copyright", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_COPYRIGHT);
  gtk_object_add_arg_type ("TdAbout::license", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_LICENSE);
  gtk_object_add_arg_type ("TdAbout::icon", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_ICON);
  gtk_object_add_arg_type ("TdAbout::logo", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_LOGO);
  gtk_object_add_arg_type ("TdAbout::web", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_WEB);
  object_class->set_arg = td_about_set_arg;
  object_class->get_arg = td_about_get_arg;
  klass->show = td_about_show;
}

GtkType td_about_get_type (void)
{
  static GtkType about_type = 0;
  if (!about_type)
    {
      static const GtkTypeInfo about_info =
      {
  	"TdAbout", sizeof (TdAbout), sizeof (TdAboutClass),
  	(GtkClassInitFunc) td_about_class_init,
	(GtkObjectInitFunc) td_about_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      about_type = gtk_type_unique (GTK_TYPE_OBJECT, &about_info);
    }
  return about_type;
}

/**
 * td_about_new:
 * 
 * fr: Cr une nouvelle description
 *
 * en: Creates a new description
 * 
 * Return value: description
 **/

GtkObject *td_about_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_about_get_type()));
}

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/

/**
 * td_about_show:
 * @about: td_about object
 * 
 * fr: Affiche la fentre  propos 
 *
 * en: Displays the about window
 **/

void td_about_show (TdAbout *about)
{
  GtkWidget *window;
  GtkWidget *eventbox1;
  GtkWidget *vbox1;
  GtkWidget *viewport1;
  GtkWidget *viewport2;
  GtkWidget *label1 = NULL;
  GtkWidget *label2;
  GtkWidget *label3;
  GtkWidget *frame1;
  GtkWidget *scrolledwindow1;
  GtkWidget *text1;
  GtkWidget *frame2;
  GtkWidget *scrolledwindow2;
  GtkWidget *text2;
  gchar *txt_tampon;
  GtkWidget *href1;
  GdkFont *font = NULL;
  int txt_long;
  GtkWidget *box_tmp = NULL;
  g_return_if_fail (about != NULL);
  g_return_if_fail (TD_IS_ABOUT (about));

  /*** Fentre - Window */
  window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtdk_window_set_title (GTK_WINDOW (window), g_strdup_printf ("%s : %s", about->name, _("About")), TD_WINDOW_TYPE_TOOL);
  gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, FALSE);
  eventbox1 = gtk_event_box_new();
  gtk_widget_show (eventbox1);
  gtk_container_add (GTK_CONTAINER (window), eventbox1);
  viewport2 = gtk_viewport_new (NULL, NULL);
  gtk_widget_show (viewport2);
  gtk_container_add (GTK_CONTAINER (eventbox1), viewport2);
  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (viewport2), vbox1);

  /*** Titre - Title */
  viewport1 = gtk_viewport_new (NULL, NULL);
  gtk_widget_show (viewport1);
  gtk_box_pack_start (GTK_BOX (vbox1), viewport1, FALSE, FALSE, 0);
  gtk_viewport_set_shadow_type (GTK_VIEWPORT (viewport1), GTK_SHADOW_OUT);
  txt_tampon = g_strdup_printf ("%s - %s", about->name, about->version);
  label1 = gtk_label_new (txt_tampon);
  gtk_widget_show (label1);
  gtk_container_add (GTK_CONTAINER (viewport1), label1);
  font = label1->style->font;
  txt_long = gdk_string_width (font, txt_tampon);
  gtk_widget_set_usize (label1, txt_long+10, -1);

  /*** License - Licence */
  box_tmp = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (box_tmp);
  gtk_container_set_border_width (GTK_CONTAINER (box_tmp), 5);
  gtk_box_pack_start (GTK_BOX (vbox1), box_tmp, FALSE, TRUE, 0);
  txt_tampon = g_strdup_printf ("%s", about->copyright);
  label2 = gtk_label_new (txt_tampon);
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (box_tmp), label2, FALSE, TRUE, 0);
  font = label2->style->font;
  txt_long = gdk_string_width (font, about->copyright);
  gtk_widget_set_usize (label2, txt_long+10, -1);
  txt_tampon = g_strdup_printf ("%s", about->license);
  label3 = gtk_label_new (txt_tampon);
  gtk_widget_show (label3);
  gtk_box_pack_start (GTK_BOX (box_tmp), label3, FALSE, TRUE, 0);
  font = label3->style->font;
  txt_long = gdk_string_width (font, about->license);
  gtk_widget_set_usize (label3, txt_long+10, -1);

  /*** Description */
  frame2 = gtk_frame_new (_("Description"));
  gtk_widget_show (frame2);
  gtk_container_set_border_width (GTK_CONTAINER (frame2), 5);
  gtk_box_pack_start (GTK_BOX (vbox1), frame2, TRUE, TRUE, 0);
  box_tmp = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (box_tmp);
  gtk_container_set_border_width (GTK_CONTAINER (box_tmp), 5);
  gtk_container_add (GTK_CONTAINER (frame2), box_tmp);
  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow2);
  gtk_container_add (GTK_CONTAINER (box_tmp), scrolledwindow2);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  text2 = gtk_text_new (NULL, NULL);
  gtk_widget_show (text2);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), text2);
  gtk_widget_realize (text2);
  if ((about->help) && (strcmp (about->help, "(null)")))
    gtk_text_insert (GTK_TEXT (text2), NULL, NULL, NULL, about->help, -2);

  /*** Auteurs - Authors */
  frame1 = gtk_frame_new (_("Authors"));
  gtk_widget_show (frame1);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 5);
  gtk_box_pack_start (GTK_BOX (vbox1), frame1, TRUE, TRUE, 0);
  box_tmp = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (box_tmp);
  gtk_container_set_border_width (GTK_CONTAINER (box_tmp), 5);
  gtk_container_add (GTK_CONTAINER (frame1), box_tmp);
  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_container_add (GTK_CONTAINER (box_tmp), scrolledwindow1);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  text1 = gtk_text_new (NULL, NULL);
  gtk_widget_show (text1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), text1);
  gtk_widget_realize (text1);
  gtk_text_insert (GTK_TEXT (text1), NULL, NULL, NULL, about->authors, -2);

  /*** Site web - Web site */
  if ((about->web) && (strcmp (about->web, "(null)")))
    {
      href1 = gtdk_button_href (about->web, NULL);
      gtk_widget_show (href1);
      gtk_box_pack_start (GTK_BOX (vbox1), href1, FALSE, FALSE, 0);
    }

  /*** Appels - Calls */
  gtk_widget_realize (window);
  gdk_window_set_cursor (window->window, gdk_cursor_new (GDK_ARROW));
  gtk_signal_connect_object (GTK_OBJECT (window), "delete_event", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (window));
  gtk_signal_connect_object (GTK_OBJECT (eventbox1), "button_press_event", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (window));
  gtk_widget_show (window);
}

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/

/**
 * td_about_get:
 * @file: file location of plug-in
 * 
 * fr: Retourne l'objet td_about du greffon
 *
 * en: Return td_about object of the plug-in
 * 
 * Return value: td_about object
 **/

TdAbout *td_about_get (gchar *file)
{
  TdAbout *ret;
  TdAbout *(*symbol)() = NULL;
  void *plugins_tmp;
  plugins_tmp = dlopen (file, RTLD_LAZY);
  if (dlerror() !=NULL)
    {
      td_app_message (_("Loading plug-in"), g_strdup_printf (_("Loading plug-in : file '%s' unreadable"), file), TD_MSG_FAILED);
      return NULL;
    }
  (gpointer*) symbol = td_dlsym (plugins_tmp, "", file, "plugins_about_def", TRUE);
  ret = symbol();
  /* dlclose (plugins_tmp); */
  return ret;
}

/**
 * td_about_filelist:
 * @directory: directory location of plug-ins
 * @type: type of plug-ins
 * 
 * fr: Retourne la liste des greffons du rpertoire
 *
 * en: Return the plug-in lis tof the directory
 * 
 * Return value: list
 **/

GList *td_about_filelist (gchar *directory, gchar *type)
{
  /*** THANKS: little source reused from
       File: gnumeric/src/plugins.c
       Author: Tom Dyas <tdyas@romulus.rutgers.edu> */

  TdAbout *about_plugins;
  GList *ret = NULL;
  DIR *d;
  struct dirent *e;
  if (!directory)
    directory = TD_PACKAGE_PLUGINS_DIR;
    
  /*** Fichiers - File */
  if ((d = opendir (directory)) == NULL)
    {
      td_app_message (_("Reading plug-ins's directory"), _("Reading plug-ins's directory : directory unreadable"), TD_MSG_FAILED);
      return NULL; 
    }
  while ((e = readdir (d)) != NULL)
    if (strncmp (e->d_name + strlen (e->d_name) - 3, ".so", 3) == 0)
      {
	/*** Avec type - With type */
	if (type)
	  {
	    about_plugins = td_about_get (g_strconcat (directory, e->d_name, NULL));
	    if (about_plugins)
	      {
		if (!strcmp (type, about_plugins->type))
		  ret = g_list_append (ret, g_strconcat (directory, e->d_name, NULL));
		gtk_object_destroy (GTK_OBJECT (about_plugins));
	      }
	  }
	/*** Sans type - Without type */
	else
	  {
	    about_plugins = td_about_get (g_strconcat (directory, e->d_name, NULL));
	    if (about_plugins)
	      {
		ret = g_list_append (ret, g_strconcat (directory, e->d_name, NULL));
		gtk_object_destroy (GTK_OBJECT (about_plugins));
	      }
	  }
      }
  closedir (d);
  return ret;
}

/**
 * td_about_categorytree:
 * @ctree: ctree widget
 * @plugins_list: td_about list of plug-ins
 * @file_list: file location of plug-ins
 * 
 * fr: Construit l'arbre des catgories des greffons
 *
 * en: Build the category tree of plug-ins
 **/

void td_about_categorytree (GtkCTree *ctree, GList *plugins_list, GList *file_list)
{
  gchar *txt[2];
  int i, j, k, n;
  GtkCTreeNode *node1 = NULL;
  GtkCTreeNode *node2 = NULL;
  GtkCTreeNode *node3 = NULL;
  gboolean existe;
  gchar *txt_tampon;
  GdkPixmap *pixmap_tampon;
  GdkBitmap *mask_tampon;
  guint8 spacing_tampon;
  int nb_categorie_greffon;

  /*** Recherche d'une branche similaire - Searching a similar branch */
  for (i=0; i<g_list_length (plugins_list); i++)
    {
      if (!strcmp (TD_ABOUT (g_list_nth_data (plugins_list, i))->category1, "(null)"))
	continue;

      /*** Scan niveau 1 - Scan level 1 */
      existe = FALSE;
      node1 = gtk_ctree_node_nth (GTK_CTREE(ctree), 0);
      while ((node1) && (!existe))
	{
	  gtk_ctree_node_get_pixtext (GTK_CTREE (ctree), node1, 0, &txt_tampon, &spacing_tampon, &pixmap_tampon, &mask_tampon);
	  if (strcmp (TD_ABOUT (g_list_nth_data (plugins_list, i))->category1, txt_tampon))
	    {
	      if (GTK_CTREE_ROW (node1)->sibling)
		node1 = GTK_CTREE_ROW (node1)->sibling;
	      else
		node1 = NULL;
	    }
	  else
	      existe = TRUE;
	}

      /*** Cration niveau 1 - Creating level 1 */
      if (!existe)
	{
	  txt[0] = TD_ABOUT (g_list_nth_data (plugins_list, i))->category1;
	  txt[1] = "(null)";
	  node1 = gtk_ctree_insert_node (GTK_CTREE (ctree), NULL, NULL, txt, 3, NULL, NULL, NULL, NULL, FALSE, FALSE);
	  if (!strcmp (TD_ABOUT (g_list_nth_data (plugins_list, i))->category2, "(null)"))
	    {
	      txt[0] = g_list_nth_data (file_list, i);
	      gtk_ctree_node_set_text (GTK_CTREE (ctree), node1, 1, txt[0]);
	    }
	  else
	    {
	      txt[0] = TD_ABOUT (g_list_nth_data (plugins_list, i))->category2;
	      txt[1] = "(null)";
	      node2 = gtk_ctree_insert_node (GTK_CTREE (ctree), node1, NULL, txt, 3, NULL, NULL, NULL, NULL, FALSE, FALSE);
	      if (!strcmp (TD_ABOUT (g_list_nth_data (plugins_list, i))->category3, "(null)"))
		{
		  txt[0] = g_list_nth_data (file_list, i);
		  gtk_ctree_node_set_text (GTK_CTREE (ctree), node2, 1, txt[0]);
		}
	      else
		{
		  txt[0] = TD_ABOUT (g_list_nth_data (plugins_list, i))->category3;
		  txt[1] = g_list_nth_data (file_list, i);
		  node3 = gtk_ctree_insert_node (GTK_CTREE (ctree), node2, NULL, txt, 3, NULL, NULL, NULL, NULL, FALSE, FALSE);
		}
	    }
	  continue;
	}

      /*** Scan niveau 2 - Scan level 2 */
      existe = FALSE;
      gtk_ctree_collapse(GTK_CTREE (ctree), node1);
      if (GTK_CTREE_ROW (node1)->children)
	node2 = GTK_CTREE_ROW (node1)->children;
      else
	node2 = NULL;
      while ((node2)&& (!existe))
	{
	  gtk_ctree_node_get_pixtext (GTK_CTREE (ctree), node2, 0, &txt_tampon, &spacing_tampon, &pixmap_tampon, &mask_tampon);
	  if (strcmp (TD_ABOUT (g_list_nth_data (plugins_list, i))->category2, txt_tampon))
	    {
	      if (GTK_CTREE_ROW (node2)->sibling)
		node2 = GTK_CTREE_ROW (node2)->sibling;
	      else
		node2 = NULL;
	    }
	  else
	    existe = TRUE;
	}

      /*** Cration niveau 2 - Creation level 2 */
      if (!existe)
	{
	  txt[0] = TD_ABOUT (g_list_nth_data (plugins_list, i))->category2;
	  txt[1] = "(null)";
	  node2 = gtk_ctree_insert_node (GTK_CTREE (ctree), node1, NULL, txt, 3, NULL, NULL, NULL, NULL, FALSE, FALSE);
	  if (!strcmp (TD_ABOUT (g_list_nth_data (plugins_list, i))->category3, "(null)"))
	    {
	      txt[0] = g_list_nth_data (file_list, i);
	      gtk_ctree_node_set_text (GTK_CTREE (ctree), node2, 1, txt[0]);
	    }
	  else
	    {
	      txt[0] = TD_ABOUT (g_list_nth_data (plugins_list, i))->category3;
	      txt[1] = g_list_nth_data (file_list, i);
	      node3 = gtk_ctree_insert_node (GTK_CTREE (ctree), node2, NULL, txt, 3, NULL, NULL, NULL, NULL, FALSE, FALSE);
	    }
	  continue;
	}

      /*** Scan niveau 3 - Scan level 3 */
      existe = FALSE;
      gtk_ctree_collapse (GTK_CTREE (ctree), node1);
      if (GTK_CTREE_ROW (node2)->children)
	node3 = GTK_CTREE_ROW (node2)->children;
      else
	node3 = NULL;
      while ((node3) && (!existe))
	{
	  gtk_ctree_node_get_pixtext (GTK_CTREE (ctree), node3, 0, &txt_tampon, &spacing_tampon, &pixmap_tampon, &mask_tampon);
	  if (strcmp (TD_ABOUT (g_list_nth_data (plugins_list, i))->category3, txt_tampon))
	    {
	      if (GTK_CTREE_ROW (node3)->sibling)
		node3 = GTK_CTREE_ROW (node3)->sibling;
	      else
		node3 = NULL;
	    }
	  else
	    existe = TRUE;
	}

      /*** Cration niveau 2 - Creation level 2 */
      if (!existe)
	{
	  txt[0] = TD_ABOUT (g_list_nth_data (plugins_list, i))->category3;
	  txt[1] = g_list_nth_data (file_list, i);
	  node3 = gtk_ctree_insert_node (GTK_CTREE (ctree), node2, NULL, txt, 3, NULL, NULL, NULL, NULL, FALSE, FALSE);
	}
    }
}
