/*****************************************************************************/
/*** icons.c : Icnes
 *** icons.c : Icons
 * 
 * 
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "icons.h"

/**
 * td_mod_tree_icon_parse:
 * @value: string
 * 
 * fr: Retourne l'icne correspondante  la chane de caractres
 *
 * en: Returns the icon corresponding the string
 * 
 * Return value: string
 **/

gchar *td_icon_parse (gchar *value)
{
  gchar *char_tmp = (guchar*) value;
  switch (*char_tmp)
    {

    case 'a':
      if (!strcmp (value, "applications"))
	return (gchar*) TD_STOCK_LIST_BOOKOPEN;
      break;

    case 'b':
      if (!strcmp (value, "bench"))
	return (gchar*) TD_STOCK_LIST_BENCH;
      if (!strcmp (value, "bookclose"))
	return (gchar*) TD_STOCK_LIST_BOOKCLOSE;
      if (!strcmp (value, "bookopen"))
	return (gchar*) TD_STOCK_LIST_BOOKOPEN;
      if (!strcmp (value, "build"))
	return (gchar*) TD_STOCK_LIST_BUILD;
      break;

    case 'c':
      if (!strcmp (value, "command"))
	return (gchar*) TD_STOCK_LIST_COMMAND;
      if (!strcmp (value, "console"))
	return (gchar*) TD_STOCK_LIST_CONSOLE;
      if (!strcmp (value, "custom"))
	return (gchar*) TD_STOCK_LIST_CUSTOMIZE;
      break;

    case 'd':
      if (!strcmp (value, "database"))
	return (gchar*) TD_STOCK_LIST_DATABASE;
      if (!strcmp (value, "debug"))
	return (gchar*) TD_STOCK_LIST_DEBUG;
      if (!strcmp (value, "dialog"))
	return (gchar*) TD_STOCK_LIST_DIALOG;
      if (!strcmp (value, "directory"))
	return (gchar*) TD_STOCK_LIST_DIRECTORY;
      break;

    case 'e':
      if (!strcmp (value, "editor"))
	return (gchar*) TD_STOCK_LIST_EDITOR;
      break;

    case 'f':
      if (!strcmp (value, "favorites"))
	return (gchar*) TD_STOCK_LIST_FAVORITES;
      if (!strcmp (value, "folder"))
	return (gchar*) TD_STOCK_LIST_FOLDER;
      if (!strcmp (value, "flash"))
	return (gchar*) TD_STOCK_LIST_FLASH;
      if (!strcmp (value, "function"))
	return (gchar*) TD_STOCK_LIST_FUNCTION;
      break;

    case 'i':
      if (!strcmp (value, "import-export"))
	return (gchar*) TD_STOCK_LIST_IMPORT_EXPORT;
      break;

    case 'h':
      if (!strcmp (value, "help"))
	return (gchar*) TD_STOCK_LIST_HELP;
      break;

    case 'm':
      if (!strcmp (value, "manual"))
	return (gchar*) TD_STOCK_LIST_MANUAL;
      if (!strcmp (value, "messages"))
	return (gchar*) TD_STOCK_LIST_MESSAGES;
      break;

    case 'n':
      if (!strcmp (value, "new"))
	return (gchar*) TD_STOCK_LIST_NEW;
      if (!strcmp (value, "no"))
	return (gchar*) TD_STOCK_LIST_NO;
      break;

    case 'l':
      if (!strcmp (value, "light"))
	return (gchar*) TD_STOCK_LIST_LIGHT;
      if (!strcmp (value, "loaded"))
	return (gchar*) TD_STOCK_LIST_LOADED;
      break;

    case 'o':
      if (!strcmp (value, "ok"))
	return (gchar*) TD_STOCK_LIST_OK;
      break;

    case 'p':
      if (!strcmp (value, "package"))
	return (gchar*) TD_STOCK_LIST_PACKAGE;
      if (!strcmp (value, "palette"))
	return (gchar*) TD_STOCK_LIST_PALETTE;
      if (!strcmp (value, "plugins"))
	return (gchar*) TD_STOCK_LIST_PLUGINS;
      if (!strcmp (value, "print"))
	return (gchar*) TD_STOCK_LIST_PRINT;
      if (!strcmp (value, "property"))
	return (gchar*) TD_STOCK_LIST_PROPERTY;
      break;

    case 'r':
      if (!strcmp (value, "rule"))
	return (gchar*) TD_STOCK_LIST_RULE;
      break;

    case 't':
      if (!strcmp (value, "tools"))
	return (gchar*) TD_STOCK_LIST_TOOLS;
      break;

    case 'u':
      if (!strcmp (value, "url"))
	return (gchar*) TD_STOCK_LIST_URL;
      break;

    case 'w':
      if (!strcmp (value, "warning"))
	return (gchar*) TD_STOCK_LIST_WARNING;
      break;

    case 'y':
      if (!strcmp (value, "yes"))
	return (gchar*) TD_STOCK_LIST_YES;
      break;
    default:
      break;
    }
  return (gchar*) TD_STOCK_LIST_BOOKCLOSE;
}
