/*****************************************************************************/
/* gtdk.h : Functions complmentaires aux objects standards gtk
 * gtdk.h : Additionals functions for standards objects
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

/*****************************************************************************/
/*** Enumration - Enumeration */
/*****************************************************************************/
typedef enum {
  TD_HANDLE_HIDE, /*** Poigne cache - Hiden handle */
  TD_HANDLE_CLOSE, /*** Poigne ferme - Closed handle */
  TD_HANDLE_OPEN, /***  Poigne ouverte - Opened handle */
} TdHandleState;

typedef enum {
  TD_DND_DROP_BEFORE, /*** Lch avant - Drop before */
  TD_DND_DROP_IN,  /*** Lch dedans - Drop in */
  TD_DND_DROP_AFTER,  /*** Lch aprs - Drop after */
} TdDndDrop;

typedef enum {
  TD_EVENT_MOUSE_SELECT, /*** Evnement souris selectionne - Mouse event select */
  TD_EVENT_MOUSE_MOVE, /*** Evnement souris dplacer - Mouse event move */
  TD_EVENT_MOUSE_COPY, /*** Evnement souris copie - Mouse event copy */
  TD_EVENT_MOUSE_RESIZE, /*** Evnement souris redimensionner - Mouse event resize */
  TD_EVENT_MOUSE_LINK, /*** Evnement souris lier - Mouse event link */
  TD_EVENT_MOUSE_MENU_ITEM, /*** Evnement souris menu item - Mouse event menu item */
  TD_EVENT_MOUSE_MENU_MAIN, /*** Evnement souris menu principal - Mouse event main menu */
} TdEventMouse;

typedef enum {
  TD_WINDOW_TYPE_VIEW, /*** Fentre vue - View window */
  TD_WINDOW_TYPE_TOOL, /*** Fentre outil - Tool window */
  TD_WINDOW_TYPE_PALETTE, /***  Fentre palette - Palette window */
} TdWindowType;

/*****************************************************************************/
/*** Arbre  collones - Ctree */
/*****************************************************************************/
void gtdk_ctree_expand (GtkCTree *widget, GtkCTreeNode *node, GtkWidget *scrolledwindow);
void gtdk_ctree_clear (GtkCTree *widget);
GtkCTreeNode *gtdk_ctree_next (GtkCTreeNode *node);
int gtdk_ctree_optimal_column_width (GtkCTree *widget, int column);
void gtdk_ctree_invert_expand_recursive (GtkCTree *widget, GtkCTreeNode *node);
GList *gtdk_ctree_read_node (GtkCTree *widget, GtkCTreeNode *node);
void gtdk_ctree_set_strings (GtkCTree *widget, GtkObject *datatable, GList *data);

/*****************************************************************************/
/*** Arbre - Tree */
/*****************************************************************************/
void gtdk_tree_item_set_label (GtkWidget *tree_item, gchar *data);

/*****************************************************************************/
/*** Liste  collones - Clist */
/*****************************************************************************/
int gtdk_clist_correction (GtkCList *widget, int row, int bevent_y);
void gtdk_clist_adjustheight (GtkCList *widget);
void gtdk_clist_title (GtkCList *widget, int column, gchar *title, int size, GtkJustification justification);
void gtdk_clist_set_strings (GtkCList *widget, GList *data);

/*****************************************************************************/
/*** Gomtrie - Geometry */
/*****************************************************************************/
int gtdk_geometry_get (gchar *window, gchar *name);
void gtdk_geometry_set (gchar *window, gchar *name, int value);
void gtdk_geometry_sync (void);

/*****************************************************************************/
/*** Fentre - Window */
/*****************************************************************************/
void gtdk_window_load_conf (gchar *name, GtkWidget *window);
void gtdk_window_save_conf (gchar *name, GtkWidget *window, gboolean size, gboolean position, gboolean visible);
void gtdk_window_save_defaultconf (gchar *name, int size_x, int size_y);
void gtdk_window_set_title (GtkWindow *window, gchar *module, TdWindowType type);

/*****************************************************************************/
/*** Panneau - Paned */
/*****************************************************************************/
void gtdk_paned_load_conf (gchar *name, GtkWidget *paned);
void gtdk_paned_save_conf (gchar *name, GtkWidget *paned);
void gtdk_paned_save_defaultconf (gchar *name, int value);

/*****************************************************************************/
/*** Bote - Box */
/*****************************************************************************/
void gtdk_vbox_title (gchar *title, GtkWidget *vbox);

/*****************************************************************************/
/*** Entre+selecteur - Entry+selector */
/*****************************************************************************/
GtkWidget *gtdk_entry_file_selector (gchar *title, gchar *file , gchar *extension);
static void gtdk_entry_file_selector_clicked (GtkButton *button, GList *data);
GtkWidget *gtdk_entry_date_selector (gchar *current);
static void gtdk_entry_date_selector_clicked (GtkWidget *widget, GtkWidget *entry);
static void gtdk_entry_date_selector_day_selected (GtkCalendar *calendar, GList *data);

/*****************************************************************************/
/*** Menu option - Option menu */
/*****************************************************************************/
void gtdk_option_menu_set_strings (GtkWidget *widget, GList *data, GtkWidget *widget_dest);
void gtdk_option_menu_set_strings_extended (GtkWidget *widget, GList *data, GList *comment, gchar *selected_value, GtkWidget *widget_dest);
static void gtdk_option_menu_activate (GtkWidget *menuitem, GList *data);
GtkWidget *gtdk_entry_option_menu_new (void);
void gtdk_entry_option_menu_set_strings (GtkWidget *widget, GList *data);

/*****************************************************************************/
/*** Item de menu - Menu item */
/*****************************************************************************/
GtkWidget *gtdk_menu_item_new (gchar *text, gchar *dir, gchar *file);
GtkWidget *gtdk_menu_item_accel_new (gchar *text, gchar *dir, gchar *file, GtkAccelGroup *accel_group, guint accel_key, guint accel_mods);
void gtdk_menu_item_add_accelerator (GtkWidget *widget, guint accel_signal_id, GtkAccelGroup *accel_group, guint accel_key, GdkModifierType accel_mods, GtkAccelFlags accel_flags, GtkWidget *label_accel);
void gtdk_menu_item_remove_accelerator (GtkWidget *widget, GtkAccelGroup *accel_group, guint accel_key, GdkModifierType  accel_mods, GtkWidget *label_accel);
void gtdk_menu_item_set_submenu (GtkMenuItem *menuitem, GtkWidget *menu);

/*****************************************************************************/
/*** Types */
/*****************************************************************************/
GtkAnchorType gtdk_anchor_parse (gchar *value);
GtkJustification gtdk_justification_parse (gchar *value);
GdkLineStyle gtdk_linestyle_parse (gchar *value);
GdkCapStyle gtdk_cap_parse (gchar *value);
GdkJoinStyle gtdk_join_parse (gchar *value);
GtkSelectionMode gtdk_selection_mode_parse (gchar *value);

/*****************************************************************************/
/*** Couleurs - Colors */
/*****************************************************************************/
GdkColor gtdk_color_invert (GdkColor color);
GdkColor gtdk_color_theme (gchar *value);
GdkColor gtdk_color_parse (gchar *value);
GdkCursor *gtdk_cursor (const gchar *cursor_source, const gchar *cursor_mask);

/*****************************************************************************/
/*** Cavenas - Canvas */
/*****************************************************************************/
void gtdk_canvas_clear (GnomeCanvas *canvas);
GnomeCanvasGroup *gtdk_canvas_handle (GnomeCanvasGroup *group, float x, float y);
void gtdk_canvas_handle_set_state (GnomeCanvasGroup *handle, TdHandleState state);
TdHandleState gtdk_canvas_handle_get_state (GnomeCanvasGroup *handle);
GnomeCanvasItem *gtdk_canvas_link_get_parent (GnomeCanvas *canvas, GnomeCanvasItem *link);
GnomeCanvasItem *gtdk_canvas_link_get_child (GnomeCanvas *canvas, GnomeCanvasItem *link);
double gtdk_canvas_arrow_x (GnomeCanvasLine *item);
double gtdk_canvas_arrow_y (GnomeCanvasLine *item);
double gtdk_canvas_w2i_x (GnomeCanvasItem *item, double x);
double gtdk_canvas_i2w_x (GnomeCanvasItem *item, double x);
double gtdk_canvas_i2w_y (GnomeCanvasItem *item, double y);
double gtdk_canvas_i2ps_x (GnomeCanvasItem *item, double x);
double gtdk_canvas_i2ps_y (GnomeCanvasItem *item, double y);
GList *gtdk_canvas_item_childs (GnomeCanvasItem *root);

/*****************************************************************************/
/*** Calendrier - Calendar */
/*****************************************************************************/
void gtdk_calendar_select_date (GtkCalendar *calendar, GDate *date);
GDate *gtdk_calendar_get_date (GtkCalendar *calendar);

/*****************************************************************************/
/*** Barre d'outils - Toolbar */
/*****************************************************************************/
GtkWidget *gtdk_toolbar_append_button (GtkToolbar *toolbar, gchar *text, gchar *icon_file);
GtkWidget *gtdk_toolbar_append_button_stock (GtkToolbar *toolbar, gchar *text, GtkWidget *window, gchar *icon);
GtkWidget *gtdk_toolbar_append_togglebutton (GtkToolbar *toolbar, gchar *text, gchar *icon_file);
GtkWidget *gtdk_toolbar_append_togglebutton_stock (GtkToolbar *toolbar, gchar *text, GtkWidget *window, gchar *icon);
GtkWidget *gtdk_toolbar_append_radiobutton (GtkToolbar *toolbar, GtkWidget *sibling, gchar *text, gchar *icon_file);
GtkWidget *gtdk_toolbar_append_radiobutton_stock (GtkToolbar *toolbar, GtkWidget *sibling, gchar *text, GtkWidget *window, gchar *icon);

/*****************************************************************************/
/*** Boutton - Button */
/*****************************************************************************/
GtkWidget *gtdk_button_href (gchar *name, gchar *url);
static void gtdk_button_href_clicked (GtkButton *button, gchar *url);
GtkWidget *gtdk_button_color (GtkWidget *widget_dest);
static void gtdk_button_color_expose_event (GtkWidget *drawingarea, GdkEventExpose *event);
static void gtdk_button_color_clicked (GtkButton *button);
static void gtdk_button_color_drop (GtkWidget *button, GdkDragContext *context, gint x, gint y, GtkSelectionData *selection_data, guint info, guint time, GtkWidget *widget_dest);
void gtdk_button_color_set (GtkWidget *button, gchar *color);
GtkWidget *gtdk_button_font (void);
static void gtdk_button_font_clicked (GtkButton *button);
gchar *gtdk_font_family (gchar *value);
gchar *gtdk_font_size (gchar *value);

/*****************************************************************************/
/*** Souris - Mouse */
/*****************************************************************************/
gboolean gtdk_mouse_event (GdkEventButton *event, TdEventMouse type);

/*****************************************************************************/
/*** Pixmap */
/*****************************************************************************/
GtkWidget *gtdk_pixmap_file (gchar *file);
