/*****************************************************************************/
/*** gtdk.c : Functions complmentaires aux objects standards gtk
 *** gtdk.c : Additionals functions for standards objects
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gnome.h>
#include <math.h>

#include "commons.h"
#include "gtdk.h"
#include "icons.h"
#include "td_flower.h"
#include "td_app.h"
#include "td_app_palette.h"
#include "td_db_datatable.h"
#include "td_db_connect.h"

/*****************************************************************************/
/*** Arbre  collones - Ctree */
/*****************************************************************************/

/**
 * gtdk_ctree_expand:
 * @widget: ctree widget
 * @node: node
 * @scrolledwindow: scrolledwindow of ctree
 * 
 * fr: Lors d'une expansion d'une node, la fentre se dplace afin de la voir compltement
 *
 * en: When node of ctree expanded, scrolledwindow moving for an optimal view
 **/

void gtdk_ctree_expand (GtkCTree *widget, GtkCTreeNode *node, GtkWidget *scrolledwindow)
{
  GtkCList *clist;
  GtkCTreeNode *node_selection;
  int i, row_debut, row_fin;
  GtkAdjustment *tampon_adjustement;

  /*** fr: FIXME: le dplacement de l'expansion est inhib si l'ascenseur vertical se met en route : un bug de GTK+ => bien les gars ! */
  /*** en: FIXME: the expand moving is destroyed if vscrollbar start : GTK+ Bug => great ! */

  /*** Flag interne - Internal flag */
  if (TD_FLAG_ANTI_AUTOEXPAND)
    return;

  /*** Ligne - Line */
  clist = GTK_CLIST (widget);
  i = 0;
  node_selection = GTK_CTREE_NODE (clist->row_list);
  while (node_selection && node_selection != node)
    {
      node_selection = GTK_CTREE_NODE_NEXT (node_selection);
      i++;
    }
  row_debut = i;

  /*** Dtection du dernier - Last detection */
  if (GTK_CTREE_ROW(node_selection)->children)
    {
      node_selection = GTK_CTREE_ROW (node_selection)->children;
      gtk_ctree_collapse (widget, node_selection);
      i++;
      while (GTK_CTREE_ROW (node_selection)->sibling)
	{
	  node_selection = GTK_CTREE_ROW (node_selection)->sibling;
	  gtk_ctree_collapse (widget, node_selection);
	  i++;
	}
    }
  row_fin = i;

  /*** Scroll */
  tampon_adjustement = gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW (scrolledwindow));
  for (i=row_debut; i<row_fin+1; i++)
    if (((i+1)*((GTK_CLIST (widget)->row_height)+1))>(tampon_adjustement->value+tampon_adjustement->page_size))
      if (((row_debut)*((GTK_CLIST (widget)->row_height)+1))>(tampon_adjustement->value))
	{
	  /*** FIXME: bibliothques GTK+ pas claires - GTK+ libs not clear */
	  gtk_adjustment_set_value (tampon_adjustement, (tampon_adjustement->value)+((GTK_CLIST(widget)->row_height)+1));
	  gtk_scrolled_window_set_vadjustment (GTK_SCROLLED_WINDOW (scrolledwindow), tampon_adjustement);
	}
}

/**
 * gtdk_ctree_clear:
 * @widget: ctree widget
 * 
 * fr: Razage du ctree
 *
 * en: Clears the ctree
 **/

void gtdk_ctree_clear (GtkCTree *widget)
{
  GtkCTreeNode *node_tmp;
  GtkCTreeNode *node_tmp_next;
  node_tmp = gtk_ctree_node_nth (widget, 0);
  while (node_tmp)
    {
      gtk_ctree_collapse (widget, node_tmp);
      node_tmp_next =  GTK_CTREE_NODE_NEXT (node_tmp);
      gtk_ctree_remove_node (widget, node_tmp);
      node_tmp = node_tmp_next;
    }
}

/**
 * gtdk_ctree_next:
 * @node: node
 * 
 * fr: Retourne la node suivante
 *
 * en: Returns the next node
 * 
 * Return value: node
 **/

GtkCTreeNode *gtdk_ctree_next (GtkCTreeNode *node)
{
  GtkCTreeNode *node_parent;
  if (GTK_CTREE_ROW (node)->children)
    return (GTK_CTREE_ROW (node)->children);
  if (GTK_CTREE_ROW (node)->sibling)
    return (GTK_CTREE_ROW (node)->sibling);
  do
    {
      node_parent = GTK_CTREE_ROW (node)->parent;
      if (!node_parent)
	node = NULL;
      else
	if (GTK_CTREE_ROW (node_parent)->sibling == NULL)
	  node = node_parent;
	else
	  node = GTK_CTREE_ROW (node_parent)->sibling;
    }
  while ((node == node_parent) && (node));
  return node;
}

/**
 * gtdk_ctree_optimal_column_width:
 * @widget: ctree widget
 * @column: column
 * 
 * fr: Retourne la largeur de colonne pour une vue maximal
 *
 * en: Returns width of column for a maximal view of column
 * 
 * Return value: integer
 **/

int gtdk_ctree_optimal_column_width (GtkCTree *widget, int column)
{
  GtkCTreeNode *node_tampon;
  gchar *txt_tampon;
  GdkPixmap *pixmap_tampon;
  GdkBitmap *mask_tampon;
  guint8 spacing_tampon;
  int txt_long;
  int level_long;
  int ret = 0;
  GdkFont *font = NULL;
  font = GTK_WIDGET (widget)->style->font;
  node_tampon = gtk_ctree_node_nth (widget, 0);
  while (node_tampon)
    {
      gtk_ctree_node_get_pixtext (widget, node_tampon, column, &txt_tampon, &spacing_tampon, &pixmap_tampon, &mask_tampon);
      txt_long = gdk_string_width (font, txt_tampon);
      level_long = (GTK_CTREE_ROW (node_tampon)->level*widget->tree_indent);
      if (txt_long+level_long > ret)
	ret = txt_long+level_long;
      node_tampon = gtdk_ctree_next (node_tampon);
    }
  return ret;
}

/**
 * gtdk_ctree_invert_expand_recursive:
 * @widget: ctree widget
 * @node: node
 * 
 * fr: Expansion rcurcive des nodes parents
 *
 * en: Recursively expand parent of node
 **/

void gtdk_ctree_invert_expand_recursive (GtkCTree *widget, GtkCTreeNode *node)
{
  GtkCTreeNode *node_parent;
  TD_FLAG_ANTI_AUTOEXPAND = TRUE;
  gtk_ctree_expand (widget, node);
  node_parent = GTK_CTREE_ROW (node)->parent;
  while (node_parent)
    {
      gtk_ctree_expand (widget, node_parent);
      node_parent = GTK_CTREE_ROW (node_parent)->parent;
    }
  TD_FLAG_ANTI_AUTOEXPAND = FALSE;
}

/**
 * gtdk_ctree_read_node:
 * @widget: ctree widget
 * @node: node
 * 
 * fr: Retourne la liste des valeurs de la node
 *
 * en: Returns the data list of the node
 * 
 * Return value: list
 **/

GList *gtdk_ctree_read_node (GtkCTree *widget, GtkCTreeNode *node)
{
  GList *ret = NULL;
  gchar *value_tmp;
  guint8 spacing_tmp;
  GdkPixmap *pixmap_tmp;
  GdkBitmap *mask_tmp;
  int i, j;
  gtk_ctree_node_get_pixtext (widget, node, 0, &value_tmp, &spacing_tmp, &pixmap_tmp, &mask_tmp);
  ret = g_list_append (ret, value_tmp);
  for (i=1; i < GTK_CLIST(widget)->columns; i++)
    {
      gtk_ctree_node_get_text (widget, node, i, &value_tmp);
      ret = g_list_append (ret, value_tmp);
    }
  return ret;
}

/**
 * gtdk_ctree_set_strings:
 * @widget: ctree
 * @datatable: double list
 * @data: list
 * 
 * fr: Place une liste ou une liste double dans un arbre  collones
 *
 * en: Puts a list or double list in a ctree
 **/

void gtdk_ctree_set_strings (GtkCTree *widget, GtkObject *datatable, GList *data)
{
  gchar *txt[2];
  GList *data2 = NULL;
  int i;
  gtdk_ctree_clear (widget);

  /* Liste simple */
  if (data)
    {
      for (i=0; i<g_list_length (data); i++)
	if (strlen (g_strstrip (g_list_nth_data (data, i))))
	  data2 = g_list_append (data2, g_list_nth_data (data, i));
      for (i=0; i<g_list_length (data2); i++)
	{
	  txt[0] = (gchar*) g_list_nth_data (data2, i);
	  txt[1] = (gchar*) g_list_nth_data (data2, i);
	  gtk_ctree_insert_node (GTK_CTREE (widget), NULL, NULL, txt, 5, NULL, NULL, NULL, NULL, FALSE, FALSE);
	}
      return;
    }

  /* Liste double */
  for (i=0; i<g_list_length (TD_DB_DATATABLE (datatable)->item); i++)
    {
      txt[0] = (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i), 0);
      txt[1] = (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i), 1);
      gtk_ctree_insert_node (GTK_CTREE (widget), NULL, NULL, txt, 5, NULL, NULL, NULL, NULL, FALSE, FALSE);
    }
}

/*****************************************************************************/
/*** Arbre - Tree */
/*****************************************************************************/

/**
 * gtdk_tree_item_set_label:
 * @tree_item: tree_item
 * @data: label's text
 * 
 * fr: Cr une tiquette justifie  gauche pour un item d'arbre
 *
 * en: Creates label for an item tree
 **/

void gtdk_tree_item_set_label (GtkWidget *tree_item, gchar *data)
{
  GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *label_end;
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER (tree_item), hbox);
  label = gtk_label_new (data);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
  gtk_widget_show (label);
  gtk_label_set_text (GTK_LABEL (label), data);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, TRUE, 10);
  label_end = gtk_label_new ("");
  gtk_widget_show (label_end);
  gtk_box_pack_start (GTK_BOX (hbox), label_end, TRUE, TRUE, 0);
}

/*****************************************************************************/
/*** Liste  collones - Clist */
/*****************************************************************************/

/**
 * gtdk_clist_correction:
 * @widget: clist widget
 * @row: row
 * @bevent_y: y of click event
 * 
 * fr: Corrige le numro de ligne retourn par un 'gtk_clist_get_selection_info'
 *
 * en: Correct row number generated with 'gtk_clist_get_selection_info'
 * 
 * Return value: integer
 **/

int gtdk_clist_correction (GtkCList *widget, int row, int bevent_y)
{
  if ((row==0) && (widget->rows !=0))
    {
      if (bevent_y<=(widget->row_height+1))
	return 0;
      else
	return -1;
    }
  if ((row>=(widget->rows))||(row<0))
    return -1;
  return row;
}

/**
 * gtdk_clist_adjustheight:
 * @widget : clist widget
 * 
 * fr: Ajuste la hauteur d'un 'clist' pour une valeur minimal de 16
 *
 * en: Ajust height of clist with 16 for minimal size
 **/

void gtdk_clist_adjustheight (GtkCList *widget)
{
  if ((widget->row_height) < gdk_string_height (gtk_widget_get_default_style()->font, "O")+6)
    gtk_clist_set_row_height (widget, gdk_string_height (gtk_widget_get_default_style()->font, "O")+6);
}

/**
 * gtdk_clist_title:
 * @widget: clist
 * @column: column
 * @title: title
 * @size: size
 * @justification: justification
 * 
 * fr: Place un titre dans une liste  colonnes
 *
 * en: Puts a title in a clist
 **/

void gtdk_clist_title (GtkCList *widget, int column, gchar *title, int size, GtkJustification justification)
{
  if (size>0)
    gtk_clist_set_column_width (widget, column, size);
  else
    if ((size==-1) || (TD_FLAG_DEBUG_MODE))
      gtk_clist_set_column_auto_resize (widget, column, TRUE);
    else
      gtk_clist_set_column_visibility (widget, column, FALSE);
  if (title)
    gtk_clist_set_column_title (widget, column, title);
  gtk_clist_set_column_justification (widget, column, justification);
}

/**
 * gtdk_clist_set_strings:
 * @widget: clist
 * @data: list
 * 
 * fr: Place une liste dans une liste  collones
 *
 * en: Puts a list in a clist
 **/

void gtdk_clist_set_strings (GtkCList *widget, GList *data)
{
  gchar *txt[1];
  GList *data2 = NULL;
  int i;
  gtk_clist_clear (widget);
  for (i=0; i<g_list_length (data); i++)
    if (strlen (g_strstrip (g_list_nth_data (data, i))))
      data2 = g_list_append (data2, g_list_nth_data (data, i));
  for (i=0; i<g_list_length (data2); i++)
    {
      txt[0] = (gchar*) g_list_nth_data (data2, i);
      gtk_clist_append (widget, txt);
      gtk_clist_set_row_data (widget, i, txt[0]);
    }
}

/*****************************************************************************/
/*** Gomtrie - Geometry */
/*****************************************************************************/

/**
 * gtdk_geometry_get:
 * @window : window
 * @name : name
 * 
 * fr: Retourne le valeur de l'option de la fentre
 *
 * en: Returns the value of the option of the window

 * Return value: integer
 **/

int gtdk_geometry_get (gchar *window, gchar *name)
{
  int i;
  gchar *file;
  gboolean bool_tmp;

  /*** Fichier - File */  
  if (!TD_CUSTOM_GEOMETRY)
    {
      file = g_strdup_printf ("%s/customize/geometry.xml", TD_PACKAGE_VAR_DIR);
      if (!td_file_exist (file))
	return -1;
      TD_CUSTOM_GEOMETRY = td_flower_new();
      gtk_object_set (GTK_OBJECT (TD_CUSTOM_GEOMETRY), "root", "geometry", "branch", "value", NULL);
      td_flower_add_branch_attribut (TD_FLOWER (TD_CUSTOM_GEOMETRY), "window");
      td_flower_add_branch_attribut (TD_FLOWER (TD_CUSTOM_GEOMETRY), "name");
      td_flower_add_branch_attribut (TD_FLOWER (TD_CUSTOM_GEOMETRY), "value");
      if (!td_flower_load_file (TD_FLOWER (TD_CUSTOM_GEOMETRY), file))
	{
	  td_app_message (NULL, g_strdup_printf (_("Loading geometry '%s'"), file), TD_MSG_FAILED);
	  return -1;
	}
      else
	td_app_message (NULL, g_strdup_printf (_("Loading geometry '%s'"), file), TD_MSG_DONE);
    }

  /*** Valeur - Value */
  bool_tmp = FALSE;
  for (i=0; i<g_list_length (TD_FLOWER (TD_CUSTOM_GEOMETRY)->items_value); i++)
    if (!strcmp (window, (gchar*) g_list_nth_data (g_list_nth_data (TD_FLOWER (TD_CUSTOM_GEOMETRY)->items_value, i), 0)))
      if (!strcmp (name, (gchar*) g_list_nth_data (g_list_nth_data (TD_FLOWER (TD_CUSTOM_GEOMETRY)->items_value, i), 1)))
	{
	  bool_tmp = TRUE;
	  break;
	}
  if (!bool_tmp)
    return -1;
  return (atoi (g_list_nth_data (g_list_nth_data (TD_FLOWER (TD_CUSTOM_GEOMETRY)->items_value, i), 2)));
}

/**
 * gtdk_geometry_set:
 * @window : window
 * @name : name
 * @value : value
 * 
 * fr: Affecte la valeur de l'option de la fentre
 *
 * en: Set the value of the option of the window
 **/

void gtdk_geometry_set (gchar *window, gchar *name, int value)
{
  TD_CUSTOM_GEOMETRY_QUEUE = g_list_append (TD_CUSTOM_GEOMETRY_QUEUE, window);
  TD_CUSTOM_GEOMETRY_QUEUE = g_list_append (TD_CUSTOM_GEOMETRY_QUEUE, name);
  TD_CUSTOM_GEOMETRY_QUEUE = g_list_append (TD_CUSTOM_GEOMETRY_QUEUE, g_strdup_printf ("%d", value));
}

/**
 * gtdk_geometry_sync:
 * 
 * fr: Synchonise les donnes des gomtrie avec le fichier de configuration
 *
 * en: Synchonize geometry data with the file configuration
 **/

void gtdk_geometry_sync (void)
{
  FILE *fp;
  gchar *file;
  GtkObject *flower;
  XmlDoc *doc;
  XmlNs *ns;
  XmlNode *tree;
  XmlNode *item_value = NULL;
  int i, j;
  gboolean bool_tmp;
  GList *list_tmp;
  if (g_list_length (TD_CUSTOM_GEOMETRY_QUEUE) == 0)
    return;

  /*** Fichier avant - File before */
  file = g_strdup_printf ("%s/customize/geometry.xml", TD_PACKAGE_VAR_DIR);
  TD_CUSTOM_GEOMETRY = td_flower_new();
  gtk_object_set (GTK_OBJECT (TD_CUSTOM_GEOMETRY), "root", "geometry", "branch", "value", NULL);
  td_flower_add_branch_attribut (TD_FLOWER (TD_CUSTOM_GEOMETRY), "window");
  td_flower_add_branch_attribut (TD_FLOWER (TD_CUSTOM_GEOMETRY), "name");
  td_flower_add_branch_attribut (TD_FLOWER (TD_CUSTOM_GEOMETRY), "value");
  if ((td_file_exist (file)) && (!td_flower_load_file (TD_FLOWER (TD_CUSTOM_GEOMETRY), file)))
    td_app_message (NULL, g_strdup_printf (_("Loading geometry '%s'"), file), TD_MSG_FAILED);
  else
    td_app_message (NULL, g_strdup_printf (_("Loading geometry '%s'"), file), TD_MSG_DONE);

  /*** Fichier aprs - File after */
  flower = td_flower_new();
  gtk_object_set (GTK_OBJECT (flower), "root", "geometry", "branch", "value", NULL);
  td_flower_add_branch_attribut (TD_FLOWER (flower), "window");
  td_flower_add_branch_attribut (TD_FLOWER (flower), "name");
  td_flower_add_branch_attribut (TD_FLOWER (flower), "value");

  /*** Valeur existantes - Existing values */
  for (i=0; i<g_list_length (TD_FLOWER (TD_CUSTOM_GEOMETRY)->items_value); i++)
    {
      bool_tmp = FALSE;
      for (j=0; j<g_list_length (TD_CUSTOM_GEOMETRY_QUEUE); j=j+3)
	if (!strcmp ((gchar*) g_list_nth_data (g_list_nth_data (TD_FLOWER (TD_CUSTOM_GEOMETRY)->items_value, i), 0), (gchar*) g_list_nth_data (TD_CUSTOM_GEOMETRY_QUEUE, j)))
	  if (!strcmp ((gchar*) g_list_nth_data (g_list_nth_data (TD_FLOWER (TD_CUSTOM_GEOMETRY)->items_value, i), 1), (gchar*) g_list_nth_data (TD_CUSTOM_GEOMETRY_QUEUE, j+1)))
	    {
	      bool_tmp = TRUE;
	      break;
	    }
      list_tmp = NULL;
      if (bool_tmp)
	{
	  list_tmp = g_list_append (list_tmp, g_list_nth_data (TD_CUSTOM_GEOMETRY_QUEUE, j));
	  list_tmp = g_list_append (list_tmp, g_list_nth_data (TD_CUSTOM_GEOMETRY_QUEUE, j+1));
	  list_tmp = g_list_append (list_tmp, g_list_nth_data (TD_CUSTOM_GEOMETRY_QUEUE, j+2));
	}
      else
	{
	  list_tmp = g_list_append (list_tmp, g_list_nth_data (g_list_nth_data (TD_FLOWER (TD_CUSTOM_GEOMETRY)->items_value, i), 0));
	  list_tmp = g_list_append (list_tmp, g_list_nth_data (g_list_nth_data (TD_FLOWER (TD_CUSTOM_GEOMETRY)->items_value, i), 1));
	  list_tmp = g_list_append (list_tmp, g_list_nth_data (g_list_nth_data (TD_FLOWER (TD_CUSTOM_GEOMETRY)->items_value, i), 2));
	}
      td_flower_add_item (TD_FLOWER (flower), list_tmp, 0);
    }

  /*** Nouvelles valeurs - New values */
  for (i=0; i<g_list_length (TD_CUSTOM_GEOMETRY_QUEUE); i=i+3)
    {
      bool_tmp = FALSE;
      for (j=0; j<g_list_length (TD_FLOWER (TD_CUSTOM_GEOMETRY)->items_value); j++)
	if (!strcmp ((gchar*) g_list_nth_data (g_list_nth_data (TD_FLOWER (TD_CUSTOM_GEOMETRY)->items_value, j), 0), (gchar*) g_list_nth_data (TD_CUSTOM_GEOMETRY_QUEUE, i)))
	  if (!strcmp ((gchar*) g_list_nth_data (g_list_nth_data (TD_FLOWER (TD_CUSTOM_GEOMETRY)->items_value, j), 1), (gchar*) g_list_nth_data (TD_CUSTOM_GEOMETRY_QUEUE, i+1)))
	    bool_tmp = TRUE;
      if (!bool_tmp)
	{
	  list_tmp = NULL;
	  list_tmp = g_list_append (list_tmp, g_list_nth_data (TD_CUSTOM_GEOMETRY_QUEUE, i));
	  list_tmp = g_list_append (list_tmp, g_list_nth_data (TD_CUSTOM_GEOMETRY_QUEUE, i+1));
	  list_tmp = g_list_append (list_tmp, g_list_nth_data (TD_CUSTOM_GEOMETRY_QUEUE, i+2));
	  td_flower_add_item (TD_FLOWER (flower), list_tmp, 0);
	}
    }
  if (!td_flower_save_file (TD_FLOWER (flower), file))
    td_app_message (NULL, g_strdup_printf (_("Saving geometry '%s'"), file), TD_MSG_FAILED);
  else
    td_app_message (NULL, g_strdup_printf (_("Saving geometry '%s'"), file), TD_MSG_DONE);
  td_flower_destroy (TD_FLOWER (flower));
}

/*****************************************************************************/
/*** Fentre - Window */
/*****************************************************************************/

/**
 * gtdk_window_load_conf:
 * @name : window's name
 * @window : window
 * 
 * fr: Redimensionne une fentre avec la configuration utilisateur
 *
 * en: Resizes window with user configuration
 **/

void gtdk_window_load_conf (gchar *name, GtkWidget *window)
{
  int size_x, size_y, pos_x, pos_y;
  size_x = gtdk_geometry_get (name, "size x");
  size_y = gtdk_geometry_get (name, "size y");
  if ((size_x >= 0) && (size_y >= 0))
    gtk_widget_set_usize (window, size_x, size_y);
  if (TD_CUSTOM_GEOMETRY_PLACEMENT)
    {
      pos_x = gtdk_geometry_get (name, "position x");
      pos_y = gtdk_geometry_get (name, "position y");
      if ((pos_x >= 0) && (pos_y >= 0))
	gtk_widget_set_uposition (window, pos_x, pos_y);
    }
}

/**
 * gtdk_window_save_conf:
 * @name : window's name
 * @window : window
 * @size : save the size
 * @position : save the position
 * @visible : save the visibility
 * 
 * fr: Sauvegarde les dimensions de la fentre dans la configuration utilisateur
 *
 * en: Saves size window with user configuration
 **/

void gtdk_window_save_conf (gchar *name, GtkWidget *window, gboolean size, gboolean position, gboolean visible)
{
  int size_x, size_y, pos_x, pos_y;
  if (!window->window)
    return;
  if (size)
    {
      gdk_window_get_size (window->window, &size_x, &size_y);
      gtdk_geometry_set (name, "size x", size_x);
      gtdk_geometry_set (name, "size y", size_y);
    }
  if (position)
    {
      gdk_window_get_root_origin (window->window, &pos_x, &pos_y);
      gtdk_geometry_set (name, "position x", pos_x);
      gtdk_geometry_set (name, "position y", pos_y);
    }
  if (visible)
    gtdk_geometry_set (name, "visible", GTK_WIDGET_VISIBLE (window));
  gtdk_geometry_sync();
}

/**
 * gtdk_window_save_defaultconf:
 * @name : window's name
 * @size_x : x size
 * @size_y : y size
 * 
 * fr: Sauvegarde size comme configuration utilisateur par dfault
 *
 * en: Saves size like defaults values with user configuration
 **/

void gtdk_window_save_defaultconf (gchar *name, int size_x, int size_y)
{
  gboolean bool_tmp = FALSE;
  if (gtdk_geometry_get (name, "size x") < 0)
    {
      gtdk_geometry_set (name, "size x", size_x);
      bool_tmp = TRUE;
    }
  if (gtdk_geometry_get (name, "size y") < 0)
    {
      gtdk_geometry_set (name, "size y", size_y);
      bool_tmp = TRUE;
    }
  if (bool_tmp)
    gtdk_geometry_sync();
}

/**
 * gtdk_window_set_title:
 * @module : module
 * @type : window type
 * 
 * fr: Dfinis le titre de la fentre
 *
 * en: Sets the title of the window
 **/

void gtdk_window_set_title (GtkWindow *window, gchar *module, TdWindowType type)
{
  gchar *title = NULL;
  switch (type)
    {
    case TD_WINDOW_TYPE_VIEW:
      title = td_app_custom_value ("interface", "windows", "view");
      title = td_string_replace (title, "$database", TD_APP (APP)->pid_database);
      title = td_string_replace (title, "$module", module);
      if (TD_APP (APP)->modified)
	title = td_string_replace (title, "$file", g_strdup_printf ("*%s", TD_DB_CONNECT (TD_APP(APP)->connect)->name));
      else
	title = td_string_replace (title, "$file", g_strdup_printf ("%s", TD_DB_CONNECT (TD_APP(APP)->connect)->name));
      break;
    case TD_WINDOW_TYPE_TOOL:
      title = td_app_custom_value ("interface", "windows", "tool");
      title = td_string_replace (title, "$database", TD_APP (APP)->pid_database);
      title = td_string_replace (title, "$module", module);
      break;
    case TD_WINDOW_TYPE_PALETTE:
      title = td_app_custom_value ("interface", "windows", "palette");
      title = td_string_replace (title, "$database", TD_APP (APP)->pid_database);
      break;
    default:
      break;
    }
  gtk_window_set_title (window, title);
}

/*****************************************************************************/
/*** Panneau - Paned */
/*****************************************************************************/

/**
 * gtdk_paned_load_conf:
 * @name : paned's name
 * @paned : widget
 * 
 * fr: Redimensionne une sparation avec la configuration utilisateur
 *
 * en: Resize paned with user configuration
 **/

void gtdk_paned_load_conf (gchar *name, GtkWidget *paned)
{
  int pos;
  pos = gtdk_geometry_get (name, "position");
  if (pos >= 0)
    gtk_paned_set_position (GTK_PANED (paned), pos);
}

/**
 * gtdk_paned_save_conf:
 * @name : paned's name
 * @paned : widget
 * 
 * fr: Sauvegarde les dimensions de la sparation dans la configuration utilisateur
 *
 * en: Save size paned with user configuration
 **/

void gtdk_paned_save_conf (gchar *name, GtkWidget *paned)
{
  int pos;
  if (GTK_IS_HPANED (paned))
    pos = GTK_PANED (paned)->child1->allocation.width;
  else
    pos = GTK_PANED (paned)->child1->allocation.height;
  gtdk_geometry_set (name, "position", pos);
  gtdk_geometry_sync();
}

/**
 * gtdk_paned_save_defaultconf:
 * @name : paned's name
 * @value : position
 * 
 * fr: Sauvegarde la position comme configuration utilisateur par dfault
 *
 * en: Save position like default value with user configuration
 **/

void gtdk_paned_save_defaultconf (gchar *name, int value)
{
  if (gtdk_geometry_get (name, "position") < 0)
    {
      gtdk_geometry_set (name, "position", value);
      gtdk_geometry_sync();    
    }
}

/*****************************************************************************/
/*** Bote - Box */
/*****************************************************************************/

/**
 * gtdk_vbox_title:
 * @title : title
 * @vbox : vbox widget
 * 
 * fr: Cr et affiche un titre dans un 'vbox'
 *
 * en: Creates and display a title frame in 'vbox'
 **/

void gtdk_vbox_title (gchar *title, GtkWidget *vbox)
{
  GtkWidget *viewport;
  GtkWidget *label;
  viewport = gtk_viewport_new (NULL, NULL);
  gtk_widget_show (viewport);
  gtk_box_pack_start (GTK_BOX (vbox), viewport, FALSE, FALSE, 0);
  gtk_viewport_set_shadow_type (GTK_VIEWPORT (viewport), GTK_SHADOW_OUT);
  label = gtk_label_new (title);
  gtk_widget_show (label);
  gtk_container_add (GTK_CONTAINER (viewport), label);
}

/*****************************************************************************/
/*** Entre+selecteur - Entry+selector */
/*****************************************************************************/

/**
 * gtdk_entry_file_selector:
 * @title: file selector's title
 * @file: default file for file selector
 * @extension: extension of file
 * 
 * fr: Cr et affiche un 'entry' avec un bouton pour selecteur de fichier
 *
 * en: Creates and display a 'entry' with button for file selector
 * 
 * Return value: entry + button
 **/

GtkWidget *gtdk_entry_file_selector (gchar *title, gchar *file , gchar *extension)
{
  GList *data = NULL;
  GtkWidget *ret;
  GtkWidget *entry;
  GtkWidget *toggle_button;
  GtkWidget *arrow;
  if (!file)
    file = g_get_home_dir();
  ret = gtk_hbox_new (FALSE, 0);
  entry = gtk_entry_new();
  gtk_widget_show (entry);
  gtk_box_pack_start (GTK_BOX (ret), entry, TRUE, TRUE, 0);
  toggle_button = gtk_toggle_button_new();
  gtk_widget_show (toggle_button);
  gtk_widget_set_usize (toggle_button, 17, 16);
  arrow = gtk_arrow_new (GTK_ARROW_RIGHT, GTK_SHADOW_OUT);
  gtk_widget_show (arrow);
  gtk_misc_set_padding (GTK_MISC (arrow), 1, 0);
  gtk_container_add (GTK_CONTAINER (toggle_button), arrow);
  gtk_box_pack_start (GTK_BOX (ret), toggle_button, FALSE, FALSE, 0);
  data = g_list_append (data, entry);
  data = g_list_append (data, title);
  data = g_list_append (data, file);
  if (extension)
    data = g_list_append (data, extension);
  else
    data = g_list_append (data, "(null)");
  gtk_signal_connect (GTK_OBJECT (toggle_button), "clicked", GTK_SIGNAL_FUNC (gtdk_entry_file_selector_clicked), data);
  return ret;
}

/**
 * gtdk_entry_file_selector_clicked:
 * @button: button clicked for file selector creation
 * @data: entry + file selector tile + default file location
 * 
 * fr: Cr l'interface du selecteur de fichier
 *
 * en: Creates the interface of file selector
 **/

static void gtdk_entry_file_selector_clicked (GtkButton *button, GList *data)
{
  gchar *txt_tmp;
  if (GTK_TOGGLE_BUTTON (button)->active)
    {
      if (!strcmp ("(null)", (gchar*) g_list_nth_data (data, 3)))
	txt_tmp = td_fileselector_create_window ((gchar*) g_list_nth_data (data, 1), (gchar*) g_list_nth_data (data, 2), NULL, TRUE);
      else
	txt_tmp = td_fileselector_create_window ((gchar*) g_list_nth_data (data, 1), (gchar*) g_list_nth_data (data, 2), (gchar*) g_list_nth_data (data, 3), TRUE);
      if (txt_tmp)
	gtk_entry_set_text (GTK_ENTRY (g_list_nth_data (data, 0)), txt_tmp);
      gtk_button_clicked (GTK_BUTTON (button));
    }
  else
    txt_tmp = td_fileselector_create_window (NULL, NULL, NULL, FALSE);
}

/**
 * gtdk_entry_date_selector:
 * @current: current date
 * 
 * fr: Cr et affiche un 'entry' avec un bouton pour calendrier
 *
 * en: Creates and display a 'entry' with button for calendar
 * 
 * Return value: entry + button
 **/

GtkWidget *gtdk_entry_date_selector (gchar *current)
{
  GtkWidget *ret;
  GtkWidget *entry;
  GtkWidget *toggle_button;
  GtkWidget *arrow;
  ret = gtk_hbox_new (FALSE, 0);
  entry = gtk_entry_new();
  gtk_widget_show (entry);
  gtk_box_pack_start (GTK_BOX (ret), entry, TRUE, TRUE, 0);
  toggle_button = gtk_toggle_button_new();
  gtk_widget_show (toggle_button);
  gtk_widget_set_usize (toggle_button, 17, 16);
  arrow = gtk_arrow_new (GTK_ARROW_DOWN, GTK_SHADOW_OUT);
  gtk_widget_show (arrow);
  gtk_misc_set_padding (GTK_MISC (arrow), 1, 0);
  gtk_container_add (GTK_CONTAINER (toggle_button), arrow);
  gtk_box_pack_start (GTK_BOX (ret), toggle_button, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (toggle_button), "clicked", GTK_SIGNAL_FUNC (gtdk_entry_date_selector_clicked), entry);
  return ret;
}

/**
 * gtdk_entry_date_selector_clicked:
 * @widget: button clicked for calendar creation
 * @entry: entry
 * 
 * fr: Cr l'interface du calendier
 *
 * en: Creates the interface of calendar
 **/

static void gtdk_entry_date_selector_clicked (GtkWidget *widget, GtkWidget *entry)
{
  GList *data = NULL;
  GtkWidget *calendar;
  double x, y;
  GDate *date_tmp;
  if (WINDOW_DATE_SELECTION)
    {
      gtk_widget_destroy (WINDOW_DATE_SELECTION);
      WINDOW_DATE_SELECTION = NULL;
    }
  if (GTK_TOGGLE_BUTTON (widget)->active)
    {
      WINDOW_DATE_SELECTION = gtk_window_new (GTK_WINDOW_POPUP);
      gtk_window_set_policy (GTK_WINDOW (WINDOW_DATE_SELECTION), FALSE, FALSE, TRUE);
      gtk_window_set_position (GTK_WINDOW (WINDOW_DATE_SELECTION), GTK_WIN_POS_MOUSE);
      calendar = gtk_calendar_new();
      gtk_widget_show (calendar);
      gtk_container_add (GTK_CONTAINER (WINDOW_DATE_SELECTION), calendar);
      gtk_calendar_display_options (GTK_CALENDAR (calendar), GTK_CALENDAR_SHOW_HEADING | GTK_CALENDAR_SHOW_DAY_NAMES | GTK_CALENDAR_SHOW_WEEK_NUMBERS | GTK_CALENDAR_WEEK_START_MONDAY);
      gtdk_calendar_select_date (GTK_CALENDAR (calendar), td_date_parse (gtk_entry_get_text (GTK_ENTRY (entry)), "year-month-day"));
      gtk_widget_show (WINDOW_DATE_SELECTION);
      data = g_list_append (data, widget);
      data = g_list_append (data, entry);
      gtk_signal_connect (GTK_OBJECT (calendar), "day_selected", GTK_SIGNAL_FUNC (gtdk_entry_date_selector_day_selected), data);
    }
}

/**
 * gtdk_entry_date_selector_day_selected:
 * @calendar: calendar widget
 * @data: button + entry
 * 
 * fr: Evnement 'day_selected' du calendrier
 *
 * en: Event 'day_selected' of calendar
 **/

static void gtdk_entry_date_selector_day_selected (GtkCalendar *calendar, GList *data)
{
  gchar *txt_tmp;
  gchar *txt_tmp2;
  txt_tmp = gtk_entry_get_text (GTK_ENTRY (g_list_nth_data (data, 1)));
  txt_tmp2 = td_date_print (gtdk_calendar_get_date (calendar), "year-month-day");
  if (strcmp (txt_tmp, txt_tmp2))
    gtk_entry_set_text (GTK_ENTRY (g_list_nth_data (data, 1)), txt_tmp2);
  else
    {
      gtk_button_clicked (GTK_BUTTON (g_list_nth_data (data, 0)));
      if (WINDOW_DATE_SELECTION)
	{
	  gtk_widget_destroy (WINDOW_DATE_SELECTION);
	  WINDOW_DATE_SELECTION = NULL;
	}
    }
}

/*****************************************************************************/
/*** Menu option - Option menu */
/*****************************************************************************/

/**
 * gtdk_option_menu_set_strings:
 * @widget: option menu
 * @data: list of value
 * @widget_dest: entry widget for showing value
 * 
 * fr: Place une liste dans un menu  options
 *
 * en: Puts list in option menu
 **/

void gtdk_option_menu_set_strings (GtkWidget *widget, GList *data, GtkWidget *widget_dest)
{
  int i;
  GList *menuitem = NULL;
  GtkWidget *menu;
  GList *data_tmp;

  /*** Menu */
  menu = gtk_menu_new();
  for (i=0; i<g_list_length (data); i++)
    {
      data_tmp = NULL;
      data_tmp = g_list_append (data_tmp, g_list_nth_data (data, i));
      data_tmp = g_list_append (data_tmp, widget_dest);
      if (!strcmp ("(separator)", (gchar*) g_list_nth_data (data, i)))
	menuitem = g_list_append (menuitem, gtk_menu_item_new());
      else
	menuitem = g_list_append (menuitem, gtk_menu_item_new_with_label ((gchar*) g_list_nth_data (data, i)));
      gtk_widget_show (GTK_WIDGET (g_list_nth_data (menuitem, i)));
      gtk_signal_connect (GTK_OBJECT (g_list_nth_data (menuitem, i)), "activate", GTK_SIGNAL_FUNC (gtdk_option_menu_activate), data_tmp);
      gtk_menu_append (GTK_MENU (menu), GTK_WIDGET (g_list_nth_data (menuitem, i)));
    }
  gtk_option_menu_set_menu (GTK_OPTION_MENU (widget), menu);
}

/**
 * gtdk_option_menu_set_strings_extended:
 * @widget: option menu
 * @data: list of value
 * @comment: list of comment
 * @selected_value: the selected value
 * @widget_dest: entry widget for showing value
 * 
 * fr: Place une liste commente dans un menu  options
 *
 * en: Puts a commented list in option menu
 **/

void gtdk_option_menu_set_strings_extended (GtkWidget *widget, GList *data, GList *comment, gchar *selected_value, GtkWidget *widget_dest)
{
  int i;
  GtkWidget *item = NULL;
  GList *menuitem = NULL;
  GtkWidget *menu;
  GtkWidget *label;
  GtkWidget *label2;
  GtkWidget *label_end;
  GtkWidget *label2_end;
  GtkWidget *hbox;
  GList *data_tmp;
  GList *comment2 = NULL;

  /*** Menu */
  menu = gtk_menu_new();
  for (i=0; i<g_list_length (data); i++)
    {
      data_tmp = NULL;
      data_tmp = g_list_append (data_tmp, g_list_nth_data (data, i));
      data_tmp = g_list_append (data_tmp, widget_dest);
      if (!strcmp ("(separator)", (gchar*) g_list_nth_data (data, i)))
	menuitem = g_list_append (menuitem, gtk_menu_item_new());
      else
	{
	  item = gtk_menu_item_new();
	  menuitem = g_list_append (menuitem, item);
	  hbox = gtk_hbox_new (FALSE, 0);
	  gtk_widget_show (hbox);
	  gtk_container_add (GTK_CONTAINER (item), hbox);
	  label = gtk_label_new ((gchar*) g_list_nth_data (data, i));
	  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, TRUE, 0);
	  gtk_widget_show (label);
	  label_end = gtk_label_new ("");
	  gtk_box_pack_start (GTK_BOX (hbox), label_end, TRUE, TRUE, 0);
	  gtk_widget_show (label_end);
	  if ((strlen (g_list_nth_data (comment, i))>0) && (strstr (g_list_nth_data (comment, i), _("(default value)"))))
	    label2 = gtk_label_new (td_string_remove (g_list_nth_data (comment, i), _("(default value)")));
	  else
	    label2 = gtk_label_new ((gchar*) g_list_nth_data (comment, i));
	  gtk_misc_set_padding (GTK_MISC (label2), 10, 0);
	  gtk_box_pack_start (GTK_BOX (hbox), label2, FALSE, FALSE, 0);
	  gtk_widget_show (label2);

	  /*** Couleurs - Colors */
	  if ((strlen (g_list_nth_data (comment, i))>0) && (strstr (g_list_nth_data (comment, i), _("(default value)"))))
	    {
	      gtk_widget_set_style (label, TD_STYLE_TEXT_DEFAULT);
	      gtk_widget_set_style (label2, TD_STYLE_TEXT_DEFAULT);
	    }
	  else
	    if ((selected_value) && (!strcmp (selected_value, (gchar*) g_list_nth_data (data, i))))
	      {
		gtk_widget_set_style (label, TD_STYLE_TEXT_SELECTED);
		gtk_widget_set_style (label2, TD_STYLE_TEXT_SELECTED);
	      }
	}
      gtk_widget_show (GTK_WIDGET (g_list_nth_data (menuitem, i)));
      gtk_signal_connect (GTK_OBJECT (g_list_nth_data (menuitem, i)), "activate", GTK_SIGNAL_FUNC (gtdk_option_menu_activate), data_tmp);
      gtk_menu_append (GTK_MENU (menu), GTK_WIDGET (g_list_nth_data (menuitem, i)));
    }
  gtk_option_menu_set_menu (GTK_OPTION_MENU (widget), menu);
}

/**
 * gtdk_option_menu_activate:
 * @menuitem: item menu
 * @data: value + entry
 *
 * fr: Evnement 'activate' de l'item de menu
 *
 * en: Event 'activate' of item menu
 **/

static void gtdk_option_menu_activate (GtkWidget *menuitem, GList *data)
{
  if (strcmp ("(separator)", (gchar*) g_list_nth_data (data, 0)))
    { 
      /*** gtk_entry */
      if (GTK_IS_ENTRY (g_list_nth_data (data, 1)))
	gtk_entry_set_text (GTK_ENTRY (g_list_nth_data (data, 1)), g_list_nth_data (data, 0));

      /*** gtk_combo */
      if (GTK_IS_COMBO (g_list_nth_data (data, 1)))
	gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (g_list_nth_data (data, 1))->entry), g_list_nth_data (data, 0));

      /*** gtk_spin_button */
      if (GTK_IS_SPIN_BUTTON (g_list_nth_data (data, 1)))
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (g_list_nth_data (data, 1)), atoi (g_list_nth_data (data, 0)));
    }
}

/**
 * gtdk_entry_option_menu_new:
 * 
 * fr: Cr et affiche une entre avec un menu  options
 *
 * en: Creates and display entry with option menu
 * 
 * Return value: entry + option menu
 **/

GtkWidget *gtdk_entry_option_menu_new (void)
{
  GtkWidget *ret;
  GtkWidget *entry;
  GtkWidget *option_menu;
  ret = gtk_hbox_new (FALSE, 0);
  entry = gtk_entry_new();
  gtk_widget_show (entry);
  gtk_box_pack_start (GTK_BOX (ret), entry, TRUE, TRUE, 0);
  option_menu = gtk_option_menu_new();
  gtk_widget_show (option_menu);
  gtk_box_pack_start (GTK_BOX (ret), option_menu, FALSE, FALSE, 0);
  return ret;
}

/**
 * gtdk_entry_option_menu_set_strings:
 * @widget: option menu
 * @data: list
 * 
 * fr: Place une liste dans une entre avec un menu  options
 *
 * en: Puts list in entry with option menu
 **/

void gtdk_entry_option_menu_set_strings (GtkWidget *widget, GList *data)
{
  gtdk_option_menu_set_strings (g_list_nth_data (gtk_container_children (GTK_CONTAINER (widget)), 1), data, g_list_nth_data (gtk_container_children (GTK_CONTAINER (widget)), 0));
}

/*****************************************************************************/
/*** Item de menu - Menu item */
/*****************************************************************************/

/**
 * gtdk_menu_item_new:
 * @text: item menu 's text
 * @dir: item menu 's directory of pixmap
 * @file: item menu 's file of pixmap
 * 
 * fr: Cr un item de menu incluant une image
 *
 * en: Creates menu item including pixmap
 * 
 * Return value: menu item
 **/

GtkWidget *gtdk_menu_item_new (gchar *text, gchar *dir, gchar *file)
{
  return (gtdk_menu_item_accel_new (text, dir, file, NULL, 0, 0));
}

/**
 * gtdk_menu_item_accel_new:
 * @text: text
 * @dir: directory of pixmap (NULL => default directory (TD_PACKAGE_DATA_DIR/share/pixmaps/TD_PACKAGE_DIR/))
 * @file: file of pixmap (NULL => empty pixmap (TD_PACKAGE_DATA_DIR/share/pixmaps/TD_PACKAGE_DIR/list_empty.xpm))
 * @accel_group: accelerator group
 * @accel_key: accelerator key
 * @accel_mods: accelerator modifier
 * 
 * fr: Cr un item de menu incluant une image et un accelerateur
 *
 * en: Creates menu item including pixmap and accelerator
 * 
 * Return value: menu item
 **/

GtkWidget *gtdk_menu_item_accel_new (gchar *text, gchar *dir, gchar *file, GtkAccelGroup *accel_group, guint accel_key, guint accel_mods)
{
  GtkWidget *ret;
  GtkWidget *label;
  GtkWidget *label_end;
  GtkWidget *label_accel;
  GtkWidget *img;
  GtkWidget *hbox;

  /*** Init */
  if (!text)
    {
      ret = gtk_menu_item_new();
      gtk_widget_show (ret);
      return ret;
    }
  if (!dir)
    dir = g_strconcat (TD_PACKAGE_DATA_DIR, "/share/pixmaps/", TD_PACKAGE_DIR, "/", NULL);
  if (!file)
    file = "list_empty.xpm";
  file = g_strconcat (dir, file, NULL);

  /*** Bouton - Button */
  ret = gtk_menu_item_new();
  gtk_widget_show (ret);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER (ret), hbox);
  img = gtdk_pixmap_file (file);
  gtk_widget_show (img);
  gtk_box_pack_start (GTK_BOX (hbox), img, FALSE, TRUE, 0);

  /*** Etiquette - Label */
  label = gtk_label_new (text);
  gtk_misc_set_padding (GTK_MISC (label), 7, 0);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, TRUE, 0);
  gtk_widget_show (label);
  label_end = gtk_label_new ("");
  gtk_box_pack_start (GTK_BOX (hbox), label_end, TRUE, TRUE, 0);
  gtk_widget_show (label_end);

  /*** Accelerateur - Accelerator */
  label_accel = gtk_label_new ("");
  gtk_misc_set_padding (GTK_MISC (label_accel), 10, 0);
  gtk_box_pack_start (GTK_BOX (hbox), label_accel, FALSE, FALSE, 0);
  gtk_widget_show (label_accel);
  gtk_signal_connect (GTK_OBJECT (ret), "add_accelerator", GTK_SIGNAL_FUNC (gtdk_menu_item_add_accelerator), label_accel);
  gtk_signal_connect (GTK_OBJECT (ret), "remove_accelerator", GTK_SIGNAL_FUNC (gtdk_menu_item_remove_accelerator), label_accel);
  if (accel_group)
    gtk_widget_add_accelerator (ret, "activate", accel_group, accel_key, accel_mods, GTK_ACCEL_VISIBLE);
  return ret;
}

/**
 * gtdk_menu_item_add_accelerator:
 * @widget: item menu
 * @accel_signal_id: accelerator identifier
 * @accel_group: accelerator group
 * @accel_key: accelerator key
 * @accel_mods: acceleration modifier
 * @accel_flags: accelerator flags
 * @label_accel: label
 * 
 * fr: Ajoute le raccourcis  l'item de menu
 *
 * en: Adds the accelerator to item menu
 **/

void gtdk_menu_item_add_accelerator (GtkWidget *widget, guint accel_signal_id, GtkAccelGroup *accel_group, guint accel_key, GdkModifierType accel_mods, GtkAccelFlags accel_flags, GtkWidget *label_accel)
{
  gchar* txt_tmp = "";
  int i = 0;

  /*** Modificateur - Modifier */
  if (strstr (gtk_accelerator_name (accel_key, accel_mods), "<Shift>"))
    {
      txt_tmp = g_strconcat (txt_tmp, "Shft+", NULL);
      i = i + 7;
    }
  if (strstr (gtk_accelerator_name (accel_key, accel_mods), "<Control>"))
    {
      txt_tmp = g_strconcat (txt_tmp, "Ctl+", NULL);
      i = i + 9;
    }
  if (strstr (gtk_accelerator_name (accel_key, accel_mods), "<Alt>"))
    {
      txt_tmp = g_strconcat (txt_tmp, "Alt+", NULL);
      i = i + 5;
    }

  /*** Texte - Text */
  txt_tmp = g_strconcat (txt_tmp, gtk_accelerator_name (accel_key, accel_mods) + i, NULL);
  gtk_label_set_text (GTK_LABEL (label_accel), txt_tmp);
}

/**
 * gtdk_menu_item_remove_accelerator:
 * @widget: item menu
 * @accel_group: accelerator group
 * @accel_key: accelerator key
 * @accel_mods: acceleration modifier
 * @label_accel: label
 * 
 * fr: Supprimer le raccourcis de l'item de menu
 *
 * en: Removes the accelerator of item menu
 **/

void gtdk_menu_item_remove_accelerator (GtkWidget *widget, GtkAccelGroup *accel_group, guint accel_key, GdkModifierType accel_mods, GtkWidget *label_accel)
{
  gtk_label_set_text (GTK_LABEL (label_accel), (""));
}

/**
 * gtdk_menu_item_set_submenu:
 * @menuitem: item menu
 * @menu: sub menu
 * 
 * fr: Cr un sous-menu 
 *
 * en: Creates a submenu
 **/

void gtdk_menu_item_set_submenu (GtkMenuItem *menuitem, GtkWidget *menu)
{
  GtkWidget *tearoff;
  gtk_menu_item_set_submenu (menuitem, menu);
  tearoff = gtk_tearoff_menu_item_new();
  gtk_widget_show (tearoff);
  gtk_menu_append (GTK_MENU (menu), tearoff);
}

/*****************************************************************************/
/*** Types */
/*****************************************************************************/

/**
 * gtdk_anchor_parse:
 * @value: string
 * 
 * fr: Retourne le 'GtkAnchorType' correspondant  la chane de caractres
 *
 * en: Returns the 'GtkAnchorType' corresponding the string
 * 
 * Return value: anchor
 **/

GtkAnchorType gtdk_anchor_parse (gchar *value)
{
  if ((!value) || (!strcmp (value, "center")))
    return GTK_ANCHOR_CENTER;
  if (strstr (value, "north"))
    {
      if (!strcmp (value, "north"))
	return GTK_ANCHOR_NORTH;
      if (!strcmp (value, "north west"))
	return GTK_ANCHOR_NORTH_WEST;
      if (!strcmp (value, "north east"))
	return GTK_ANCHOR_NORTH_EAST;
    }
  if (strstr (value, "south"))
    {
      if (!strcmp (value, "south"))
	return GTK_ANCHOR_SOUTH;
      if (!strcmp (value, "south west"))
	return GTK_ANCHOR_SOUTH_WEST;
      if (!strcmp (value, "south east"))
	return GTK_ANCHOR_SOUTH_EAST;
    }
  if (!strcmp (value, "west"))
    return GTK_ANCHOR_WEST;
  if (!strcmp (value, "east"))
    return GTK_ANCHOR_EAST;
  return GTK_ANCHOR_CENTER;
}

/**
 * gtdk_justification_parse:
 * @value: string
 * 
 * fr: Retourne le 'GtkJustification' correspondant  la chane de caractres
 *
 * en: Returns the 'GtkJustification' corresponding the string
 * 
 * Return value: justification
 **/

GtkJustification gtdk_justification_parse (gchar *value)
{
  if (!value)
    return GTK_JUSTIFY_LEFT;
  if (!strcmp (value, "left"))
    return GTK_JUSTIFY_LEFT;
  if (!strcmp (value, "right"))
    return GTK_JUSTIFY_RIGHT;
  if (!strcmp (value, "center"))
    return GTK_JUSTIFY_CENTER;
  if (!strcmp (value, "fill"))
    return GTK_JUSTIFY_FILL;
  return GTK_JUSTIFY_LEFT;
}

/**
 * gtdk_linestyle_parse:
 * @value: string
 * 
 * fr: Retourne le 'GdkLineStyle' correspondant  la chane de caractres
 *
 * en: Returns the 'GdkLineStyle' corresponding the string
 * 
 * Return value: line style
 **/

GdkLineStyle gtdk_linestyle_parse (gchar *value)
{
  if (!value)
    return GDK_LINE_SOLID;
  if (!strcmp (value, "solid"))
    return GDK_LINE_SOLID;
  if (!strcmp (value, "dash"))
    return GDK_LINE_ON_OFF_DASH;
  if (!strcmp (value, "dash double"))
    return GDK_LINE_DOUBLE_DASH;
  return GDK_LINE_SOLID;
}

/**
 * gtdk_cap_parse:
 * @value: string
 * 
 * fr: Retourne le 'GdkCapStyle' correspondant  la chane de caractres
 *
 * en: Returns the 'GdkCapStyle' corresponding the string
 * 
 * Return value: cap style
 **/

GdkCapStyle gtdk_cap_parse (gchar *value)
{
  if (!value)
    return GDK_CAP_BUTT;
  if (!strcmp (value, "butt"))
    return GDK_CAP_BUTT;
  if (!strcmp (value, "not last"))
    return GDK_CAP_NOT_LAST;
  if (!strcmp (value, "round"))
    return GDK_CAP_ROUND;
  if (!strcmp (value, "projecting"))
    return GDK_CAP_PROJECTING;
  return GDK_CAP_BUTT;
}

/**
 * gtdk_join_parse:
 * @value: string
 * 
 * fr: Retourne le 'GdkJoinStyle' correspondant  la chane de caractres
 *
 * en: Returns the 'GdkJoinStyle' corresponding the string
 * 
 * Return value: join style
 **/

GdkJoinStyle gtdk_join_parse (gchar *value)
{
  if (!value)
    return GDK_JOIN_MITER;
  if (!strcmp (value, "miter"))
    return GDK_JOIN_MITER;
  if (!strcmp (value, "round"))
    return GDK_JOIN_ROUND;
  if (!strcmp (value, "bevel"))
    return GDK_JOIN_BEVEL;
  return GDK_JOIN_MITER;
}

/**
 * gtdk_selection_mode_parse:
 * @value: string
 * 
 * fr: Retourne le 'GtkSelectionMode' correspondant  la chane de caractres
 *
 * en: Returns the 'GtkSelectionMode' corresponding the string
 * 
 * Return value: selection mode
 **/

GtkSelectionMode gtdk_selection_mode_parse (gchar *value)
{
  if (!value)
    return GTK_SELECTION_SINGLE;
  if (!strcmp (value, "single"))
    return GTK_SELECTION_SINGLE;
  if (!strcmp (value, "browse"))
    return GTK_SELECTION_BROWSE;
  if (!strcmp (value, "multiple"))
    return GTK_SELECTION_MULTIPLE;
  if (!strcmp (value, "extended"))
    return GTK_SELECTION_EXTENDED;
  return GTK_SELECTION_SINGLE;
}

/*****************************************************************************/
/*** Couleurs - Colors */
/*****************************************************************************/

/**
 * gtdk_color_invert:
 * @color: color
 * 
 * fr: Retourne la couleur oppose
 *
 * en: Returns the opposite color
 * 
 * Return value: color
 **/

GdkColor gtdk_color_invert (GdkColor color)
{
  color.red = 65535-color.red;
  color.green = 65535-color.green;
  color.blue = 65535-color.blue;
  gdk_color_alloc (gtk_widget_get_default_colormap(), &color);
  return color;
}

/**
 * gtdk_color_theme:
 * @value: element[state]
 * 
 * fr: Retourne une couleur du thme courant
 *
 * en: Returns a color of current theme
 * 
 * Return value: color
 **/

GdkColor gtdk_color_theme (gchar *value)
{
  GdkColor color;
  if (!value)
    {
      color.pixel = 0;
      gdk_color_alloc (gtk_widget_get_default_colormap(), &color);
      return color;
    }
  if (strstr (value, "["))
    {

      /*** NORMAL */
      if (strstr (value, "normal"))
	{
	  if (!strcmp (value, "fg[normal]"))
	    return (TD_APP_PALETTE (TD_APP (APP)->palette)->window->style->fg[GTK_STATE_NORMAL]);
	  if (!strcmp (value, "bg[normal]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->bg[GTK_STATE_NORMAL]);
	  if (!strcmp (value, "base[normal]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->base[GTK_STATE_NORMAL]);
	  if (!strcmp (value, "text[normal]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->text[GTK_STATE_NORMAL]);
	  if (!strcmp (value, "light[normal]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->light[GTK_STATE_NORMAL]);
	  if (!strcmp (value, "dark[normal]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->dark[GTK_STATE_NORMAL]);
	  if (!strcmp (value, "mid[normal]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->mid[GTK_STATE_NORMAL]);
	}
      
      /*** INSENSITIVE */
      if (strstr (value, "insensitive"))
	{
	  if (!strcmp (value, "fg[insensitive]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->fg[GTK_STATE_INSENSITIVE]);
	  if (!strcmp (value, "bg[insensitive]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->bg[GTK_STATE_INSENSITIVE]);
	  if (!strcmp (value, "base[insensitive]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->base[GTK_STATE_INSENSITIVE]);
	  if (!strcmp (value, "text[insensitive]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->text[GTK_STATE_INSENSITIVE]);
	  if (!strcmp (value, "light[insensitive]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->light[GTK_STATE_INSENSITIVE]);
	  if (!strcmp (value, "dark[insensitive]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->dark[GTK_STATE_INSENSITIVE]);
	  if (!strcmp (value, "mid[insensitive]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->mid[GTK_STATE_INSENSITIVE]);
	}

      /*** PRELIGHT */
      if (strstr (value, "prelight"))
	{
	  if (!strcmp (value, "fg[prelight]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->fg[GTK_STATE_PRELIGHT]);
	  if (!strcmp (value, "bg[prelight]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->bg[GTK_STATE_PRELIGHT]);
	  if (!strcmp (value, "base[prelight]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->base[GTK_STATE_PRELIGHT]);
	  if (!strcmp (value, "text[prelight]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->text[GTK_STATE_PRELIGHT]);
	  if (!strcmp (value, "light[prelight]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->light[GTK_STATE_PRELIGHT]);
	  if (!strcmp (value, "dark[prelight]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->dark[GTK_STATE_PRELIGHT]);
	  if (!strcmp (value, "mid[prelight]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->mid[GTK_STATE_PRELIGHT]);
	}

      /*** ACTIVE */
      if (strstr (value, "active"))
	{
	  if (!strcmp (value, "fg[active]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->fg[GTK_STATE_ACTIVE]);
	  if (!strcmp (value, "bg[active]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->bg[GTK_STATE_ACTIVE]);
	  if (!strcmp (value, "base[active]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->base[GTK_STATE_ACTIVE]);
	  if (!strcmp (value, "text[active]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->text[GTK_STATE_ACTIVE]);
	  if (!strcmp (value, "light[active]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->light[GTK_STATE_ACTIVE]);
	  if (!strcmp (value, "dark[active]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->dark[GTK_STATE_ACTIVE]);
	  if (!strcmp (value, "mid[active]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->mid[GTK_STATE_ACTIVE]);
	}

      /*** SELECTED */
      if (strstr (value, "selected"))
	{
	  if (!strcmp (value, "fg[selected]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->fg[GTK_STATE_SELECTED]);
	  if (!strcmp (value, "bg[selected]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->bg[GTK_STATE_SELECTED]);
	  if (!strcmp (value, "base[selected]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->base[GTK_STATE_SELECTED]);
	  if (!strcmp (value, "text[selected]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->text[GTK_STATE_SELECTED]);
	  if (!strcmp (value, "light[selected]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->light[GTK_STATE_SELECTED]);
	  if (!strcmp (value, "dark[selected]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->dark[GTK_STATE_SELECTED]);
	  if (!strcmp (value, "mid[selected]"))
	    return (TD_APP_PALETTE (TD_APP(APP)->palette)->window->style->mid[GTK_STATE_SELECTED]);
	}
    }
  if (gdk_color_parse (value, &color))
    {
      gdk_color_alloc (gtk_widget_get_default_colormap(), &color);
      return color;
    }
  color.pixel = 0;
  gdk_color_alloc (gtk_widget_get_default_colormap(), &color);
  return color;
}

/**
 * gtdk_color_theme:
 * @value: value
 * 
 * fr: Retourne la couleur correspondant  la chane de caractres
 *
 * en: Returns the color corresponding the string
 * 
 * Return value: color
 **/

GdkColor gtdk_color_parse (gchar *value)
{
  GdkColor color;
  if (!value)
    {
      color.pixel = 0;
      gdk_color_alloc (gtk_widget_get_default_colormap(), &color);
      return color;
    }
  if (strstr (value, "invert."))
    return gtdk_color_invert (gtdk_color_theme (td_strsplit (value, NULL, 1)));
  return gtdk_color_theme (value);
}

/**
 * gtdk_cursor:
 * @cursor_source: xbm image
 * @cursor_mask: xbm image
 * 
 * fr: Retourne le curseur
 *
 * en: Returns the cursor
 * 
 * Return value: cursor
 **/

GdkCursor *gtdk_cursor (const gchar *cursor_source, const gchar *cursor_mask)
{
  GdkCursor *cursor;
  GdkPixmap *cursor_source_pixmap, *cursor_mask_pixmap;
  GdkColor cursor_fg = { 0, 0, 0, 0 };
  GdkColor cursor_bg = { 0, 65535, 65535, 65535 };
  cursor_source_pixmap = gdk_bitmap_create_from_data (NULL, cursor_source, 32, 32);
  cursor_mask_pixmap = gdk_bitmap_create_from_data (NULL, cursor_mask,	32, 32);
  cursor = gdk_cursor_new_from_pixmap (cursor_source_pixmap, cursor_mask_pixmap, &cursor_fg, &cursor_bg, 3, 2);
  gdk_pixmap_unref (cursor_source_pixmap);
  gdk_pixmap_unref (cursor_mask_pixmap);
  return cursor;
}

/*****************************************************************************/
/*** Cavenas - Canvas */
/*****************************************************************************/

/**
 * gtdk_canvas_clear:
 * @canvas: canvas widget
 * 
 * fr: Razage du cavenas
 *
 * en: Clear canvas
 **/

void gtdk_canvas_clear (GnomeCanvas *canvas)
{
  GnomeCanvasGroup *root = gnome_canvas_root (canvas);
  GnomeCanvasItem *item;
  item = g_list_nth_data (root->item_list, 0);
  while (item)
    {
      gtk_object_destroy (GTK_OBJECT (item));
      item = g_list_nth_data (root->item_list, 0);
    }
}

/**
 * gtdk_canvas_handle:
 * @group: canvas group
 * @x: x coordinate of center of handle
 * @y: y coordinate of center of handle
 * 
 * fr: Cre une poigne
 *
 * en: Creates a handle
 *
 * Return value: group
 **/

GnomeCanvasGroup *gtdk_canvas_handle (GnomeCanvasGroup *group, float x, float y)
{
  /* FIXME: Paramtrage de la gomtrie : +tards */
  GnomeCanvasGroup *ret;
  GnomeCanvasItem *frame;
  GnomeCanvasItem *line1;
  GnomeCanvasItem *line2;
  GnomeCanvasPoints *points1;
  GnomeCanvasPoints *points2;
  ret = GNOME_CANVAS_GROUP (gnome_canvas_item_new (group, gnome_canvas_group_get_type(),
						   "x", (double) x,
						   "y", (double) y, NULL));
  frame = gnome_canvas_item_new (ret, gnome_canvas_rect_get_type(),
				 "x1", (double) -4,
				 "y1", (double) -4,
				 "x2", (double) 4,
				 "y2", (double) 4,
				 "fill_color_gdk", &TD_FACE_HANDLE_FILL_COLOR,
				 "outline_color_gdk", &TD_FACE_HANDLE_LINE_COLOR,
				 "width_units", 1.0, NULL);
  gtk_object_set_user_data (GTK_OBJECT (frame), "handle");
  points1 = gnome_canvas_points_new (2);
  points1->coords[0] = -2;
  points1->coords[1] = 0;
  points1->coords[2] = +3;
  points1->coords[3] = 0;
  line1 = gnome_canvas_item_new (ret, gnome_canvas_line_get_type(),
				 "points", points1,
				 "fill_color_gdk", &TD_FACE_HANDLE_LINE_COLOR,
				 "width_units", 1.0, NULL);
  gtk_object_set_user_data (GTK_OBJECT (line1), "handle");
  gnome_canvas_points_free (points1);
  points2 = gnome_canvas_points_new (2);
  points2->coords[0] = 0;
  points2->coords[1] = -2;
  points2->coords[2] = 0;
  points2->coords[3] = 3;
  line2 = gnome_canvas_item_new (ret, gnome_canvas_line_get_type(),
				 "points", points2,
				 "fill_color_gdk", &TD_FACE_HANDLE_LINE_COLOR,
				 "width_units", 1.0, NULL);
  gtk_object_set_user_data (GTK_OBJECT (line2), "handle");
  gnome_canvas_points_free (points2);
  return ret;
}

/**
 * gtdk_canvas_handle_set_state:
 * @handle: canvas handle
 * @state: state
 * 
 * fr: Applique l'tat  la poigne
 *
 * en: Applys the state on handle
 **/

void gtdk_canvas_handle_set_state (GnomeCanvasGroup *handle, TdHandleState state)
{
  switch (state)
    {
    case TD_HANDLE_HIDE:
      gnome_canvas_item_hide (GNOME_CANVAS_ITEM (handle));
      break;
    case TD_HANDLE_CLOSE:
      gnome_canvas_item_show (GNOME_CANVAS_ITEM (handle));
      gnome_canvas_item_show (GNOME_CANVAS_ITEM (g_list_nth_data (handle->item_list, 2)));
      break;
    case TD_HANDLE_OPEN:
      gnome_canvas_item_show (GNOME_CANVAS_ITEM (handle));
      gnome_canvas_item_hide (GNOME_CANVAS_ITEM (g_list_nth_data (handle->item_list, 2)));
      break;
    default:
      break;
    }
}

/**
 * gtdk_canvas_handle_get_state:
 * @handle: canvas handle
 * 
 * fr: Retourne l'tat de la poigne
 *
 * en: Returns the state of handle
 *
 * Return value: handle state
 **/

TdHandleState gtdk_canvas_handle_get_state (GnomeCanvasGroup *handle)
{
  GnomeCanvasItem *item;
  if (GNOME_CANVAS_ITEM (g_list_nth_data (handle->item_list, 2))->object.flags & GNOME_CANVAS_ITEM_VISIBLE)
    return TD_HANDLE_CLOSE;
  if (GNOME_CANVAS_ITEM (g_list_nth_data (handle->item_list, 0))->object.flags & GNOME_CANVAS_ITEM_VISIBLE)
    return TD_HANDLE_OPEN;
  return TD_HANDLE_HIDE;
}

/**
 * gtdk_canvas_link_get_parent:
 * @canvas: canvas
 * @link: link
 * 
 * fr: Retourne le parent du lien
 *
 * en: Returns the parent of the link
 *
 * Return value: item
 **/

GnomeCanvasItem *gtdk_canvas_link_get_parent (GnomeCanvas *canvas, GnomeCanvasItem *link)
{
  GnomeCanvasItem *item;
  double x, y, dx, dy, length;
  double sin_theta, cos_theta;
  dx = gtdk_canvas_i2w_x (link, GNOME_CANVAS_LINE (link)->coords[0]) - gtdk_canvas_i2w_x (link, GNOME_CANVAS_LINE (link)->coords[2]);
  dy = gtdk_canvas_i2w_y (link, GNOME_CANVAS_LINE (link)->coords[1]) - gtdk_canvas_i2w_y (link, GNOME_CANVAS_LINE (link)->coords[3]);
  length = sqrt (dx * dx + dy * dy);
  if (length <= 0)
    sin_theta = cos_theta = 0.0;
  else 
    {
      cos_theta = dx / length;
      sin_theta = dy / length;
    }
  x = gtdk_canvas_i2w_x (link, GNOME_CANVAS_LINE (link)->coords[0]) + ceil (cos_theta);
  y = gtdk_canvas_i2w_y (link, GNOME_CANVAS_LINE (link)->coords[1]) + ceil (sin_theta);
  item = gnome_canvas_get_item_at (canvas, x, y);
  if (!item)
    return NULL;
  if (GNOME_IS_CANVAS_GROUP (item))
    return item;
  if ((!GNOME_IS_CANVAS_RE (item)) && (!GNOME_IS_CANVAS_LINE (item)) && (!GNOME_IS_CANVAS_TEXT (item)))
    if (GNOME_CANVAS_GROUP (item) == gnome_canvas_root (canvas))
      return item;
  return item->parent;
}

/**
 * gtdk_canvas_link_get_child:
 * @canvas: canvas
 * @link: link
 * 
 * fr: Retourne l'enfant du lien
 *
 * en: Returns the child of the link
 *
 * Return value: item
 **/

GnomeCanvasItem *gtdk_canvas_link_get_child (GnomeCanvas *canvas, GnomeCanvasItem *link)
{
  GnomeCanvasItem *item;
  double x, y, dx, dy, length;
  double sin_theta, cos_theta;
  dx = gtdk_canvas_i2w_x (link, GNOME_CANVAS_LINE (link)->coords[GNOME_CANVAS_LINE (link)->num_points*2-2]) - gtdk_canvas_i2w_x (link, GNOME_CANVAS_LINE (link)->coords[GNOME_CANVAS_LINE (link)->num_points*2-4]);
  dy = gtdk_canvas_i2w_y (link, GNOME_CANVAS_LINE (link)->coords[GNOME_CANVAS_LINE (link)->num_points*2-1]) - gtdk_canvas_i2w_y (link, GNOME_CANVAS_LINE (link)->coords[GNOME_CANVAS_LINE (link)->num_points*2-3]);
  length = sqrt (dx * dx + dy * dy);
  if (length <= 0)
    sin_theta = cos_theta = 0.0;
  else 
    {
      cos_theta = dx / length;
      sin_theta = dy / length;
    }
  /*** BIDOUILLE: le -3 - the -3 */
  x = gtdk_canvas_i2w_x (link, GNOME_CANVAS_LINE (link)->coords[GNOME_CANVAS_LINE (link)->num_points*2-2]) + ceil ((TD_FACE_LINK_ARROW[0]-TD_FACE_LINK_ARROW[1])*cos_theta);
  y = gtdk_canvas_i2w_y (link, GNOME_CANVAS_LINE (link)->coords[GNOME_CANVAS_LINE (link)->num_points*2-1]) + ceil ((TD_FACE_LINK_ARROW[0]-TD_FACE_LINK_ARROW[1])*sin_theta);
  item = gnome_canvas_get_item_at (canvas, x, y);
  if (!item)
    return NULL;
  if (GNOME_IS_CANVAS_GROUP (item))
    return item;
  if ((!GNOME_IS_CANVAS_RE (item)) && (!GNOME_IS_CANVAS_LINE (item)) && (!GNOME_IS_CANVAS_TEXT (item)))
    if (GNOME_CANVAS_GROUP (item) == gnome_canvas_root (canvas))
      return item;
  return item->parent;
}

/**
 * gtdk_canvas_arrow_x:
 * @item: item
 * 
 * fr: Retourne la dimension en x de la flche 
 *
 * en: Returns the x dimension of the arrow
 *
 * Return value: float
 **/

double gtdk_canvas_arrow_x (GnomeCanvasLine *item)
{
  double dx, dy, length;
  dx = gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (item), item->coords[item->num_points*2-2]) - gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (item), item->coords[item->num_points*2-4]);
  dy = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (item), item->coords[item->num_points*2-1]) - gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (item), item->coords[item->num_points*2-3]);
  length = sqrt (dx * dx + dy * dy);
  if (length <= 0)
    return (0);
  /*** BIDOUILLE: le -3 - the -3 */
  return (ceil ((TD_FACE_LINK_ARROW[0]-TD_FACE_LINK_ARROW[1]-3)*(dx/length)));
}

/**
 * gtdk_canvas_arrow_y:
 * @item: item
 * 
 * fr: Retourne la dimension en y de la flche 
 *
 * en: Returns the y dimension of the arrow
 *
 * Return value: float
 **/

double gtdk_canvas_arrow_y (GnomeCanvasLine *item)
{
  double dx, dy, length;
  dx = gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (item), item->coords[item->num_points*2-2]) - gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (item), item->coords[item->num_points*2-4]);
  dy = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (item), item->coords[item->num_points*2-1]) - gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (item), item->coords[item->num_points*2-3]);
  length = sqrt (dx * dx + dy * dy);
  if (length <= 0)
    return (0);
  /*** BIDOUILLE: le -3 - the -3 */
  return (ceil ((TD_FACE_LINK_ARROW[0]-TD_FACE_LINK_ARROW[1])*(dy/length)));
}

/**
 * gtdk_canvas_w2i_x:
 * @item: canvas item
 * @x: x coordinate
 * 
 * fr: Converti des coordonnes globales en coordonnes locales (item)
 *
 * en: Converts world coordinates into item pixel coordinates
 * 
 * Return value: x coordinate
 **/

double gtdk_canvas_w2i_x (GnomeCanvasItem *item, double x)
{
  double x1, y1;
  x1 = x;
  y1 = 0;
  gnome_canvas_item_w2i (item, &x1, &y1);
  return x1;
}

/**
 * gtdk_canvas_i2w_x:
 * @item: item
 * @x: x coordinate
 * 
 * fr: Converti des coordonnes locales (item) en coordonnes globales
 *
 * en: Converts item pixel coordinates into world coordinates
 * 
 * Return value: x coordinate
 **/

double gtdk_canvas_i2w_x (GnomeCanvasItem *item, double x)
{
  double x1, y1;
  x1 = x;
  y1 = 0;
  gnome_canvas_item_i2w (item, &x1, &y1);
  return x1;
}

/**
 * gtdk_canvas_i2w_y:
 * @item: item
 * @y: y coordinate
 * 
 * fr: Converti des coordonnes de l'item en coordonnes globales
 *
 * en: Converts item pixel coordinates into world coordinates
 * 
 * Return value: y coordinate
 **/

double gtdk_canvas_i2w_y (GnomeCanvasItem *item, double y)
{
  double x1, y1;
  x1 = 0;
  y1 = y;
  gnome_canvas_item_i2w (item, &x1, &y1);
  return y1;
}

/**
 * gtdk_canvas_i2ps_x:
 * @item: item
 * @x: x coordinate
 * 
 * fr: Converti des coordonnes de l'item en coordonnes pour feuille pstricks
 *
 * en: Converts item pixel coordinates into pstricks coordinates
 * 
 * Return value: x coordinate
 **/

double gtdk_canvas_i2ps_x (GnomeCanvasItem *item, double x)
{
  double x1, y1;
  x1 = x;
  y1 = 0;
  gnome_canvas_item_i2w (item, &x1, &y1);
  return x1*((double)TD_PS_WIDTH/(double)TD_PS_WIDTH_CANVAS);
}

/**
 * gtdk_canvas_i2ps_y:
 * @item: item
 * @y: y coordinate
 * 
 * fr: Converti des coordonnes de l'item en coordonnes pour feuille pstricks
 *
 * en: Converts item pixel coordinates into pstricks coordinates
 * 
 * Return value: y coordinate
 **/

double gtdk_canvas_i2ps_y (GnomeCanvasItem *item, double y)
{
  double x1, y1;
  x1 = 0;
  y1 = y;
  gnome_canvas_item_i2w (item, &x1, &y1);
  return TD_PS_HEIGHT-y1;
}

/**
 * gtdk_canvas_item_childs:
 * @root: root
 * 
 * fr: Retourne les enfants
 *
 * en: Returns the childs
 * 
 * Return value: list
 **/

GList *gtdk_canvas_item_childs (GnomeCanvasItem *root)
{
  GList *ret = NULL;
  int i = 0;
  GnomeCanvasItem *item = root;
  GnomeCanvasGroup *group = NULL;
  GnomeCanvasGroup *group_parent = NULL;
  while (item)
    {
      ret = g_list_append (ret, item);

      /*** Enfants - Childs */
      if (GNOME_IS_CANVAS_GROUP (item))
	{
	  group = GNOME_CANVAS_GROUP (item);
	  i=0;
	  item = g_list_nth_data (group->item_list, i);
	  continue;
	}

      /*** Frres - Brothers */
      if ((group) && (i<g_list_length (group->item_list)-1))
	{
	  i++;
	  item = g_list_nth_data (group->item_list, i);
	  continue;
	}

      /*** Parents */
      do
	{
	  if (group == GNOME_CANVAS_GROUP (root))
	    item = NULL;
	  else
	    {
	      group_parent = GNOME_CANVAS_GROUP (GNOME_CANVAS_ITEM (group)->parent);
	      if (g_list_index (group_parent->item_list, group)+1 == g_list_length (group_parent->item_list))
		group = group_parent;
	      else
		item = g_list_nth_data (group_parent->item_list, g_list_index (group_parent->item_list, group)+1);
	    }
	}
      while ((group == group_parent) && (item));
    }
  return ret;
}

/*****************************************************************************/
/*** Calendrier - Calendar */
/*****************************************************************************/

/**
 * gtdk_calendar_select_date:
 * @calendar: calendar
 * @date: x date
 * 
 * fr: Slection de la date dans le calendrier
 *
 * en: Select the date in the calendar
 **/

void gtdk_calendar_select_date (GtkCalendar *calendar, GDate *date)
{
  gtk_calendar_select_month (calendar, g_date_month (date)-1, g_date_year (date));
  gtk_calendar_select_day (calendar, g_date_day (date));
}

/**
 * gtdk_calendar_get_date:
 * @calendar: calendar
 * 
 * fr: Retourne la date courant du calendrier
 *
 * en: Returns the current date od calendar
 * 
 * Return value: date
 **/

GDate *gtdk_calendar_get_date (GtkCalendar *calendar)
{
  int year, month, day;
  gtk_calendar_get_date (calendar, &year, &month, &day);
  return (g_date_new_dmy (day, month+1, year));
}

/*****************************************************************************/
/*** Barre d'outils - Toolbar */
/*****************************************************************************/

/**
 * gtdk_toolbar_append_button:
 * @toolbar: toolbar
 * @text: label
 * @icon_file: file location of the icon
 * 
 * fr: Ajoute un boutton  la barre d'outils
 *
 * en: Adds a button to the toolbar
 * 
 * Return value: button
 **/

GtkWidget *gtdk_toolbar_append_button (GtkToolbar *toolbar, gchar *text, gchar *icon_file)
{
  GtkWidget *ret;
  ret = gtk_toolbar_append_element (toolbar, GTK_TOOLBAR_CHILD_BUTTON, NULL, text, text, NULL, gtdk_pixmap_file (icon_file), NULL, NULL);
  gtk_widget_show (ret);
  return ret;
}

/**
 * gtdk_toolbar_append_button_stock:
 * @toolbar: toolbar
 * @text: label
 * @window: window of toolbar
 * @icon: xpm image
 * 
 * fr: Ajoute un boutton  la barre d'outils
 *
 * en: Adds a button to the toolbar
 * 
 * Return value: button
 **/

GtkWidget *gtdk_toolbar_append_button_stock (GtkToolbar *toolbar, gchar *text, GtkWidget *window, gchar *icon)
{
  GtkWidget *ret;
  ret = gtk_toolbar_append_element (toolbar, GTK_TOOLBAR_CHILD_BUTTON, NULL, text, text, NULL, gnome_stock_pixmap_widget (window, icon), NULL, NULL);
  gtk_widget_show (ret);
  return ret;
}

/**
 * gtdk_toolbar_append_togglebutton:
 * @toolbar: toolbar
 * @text: label
 * @icon_file: file location of the icon
 * 
 * fr: Ajoute un boutton poussoir  la barre d'outils
 *
 * en: Adds a togglebutton to the toolbar
 * 
 * Return value: button
 **/

GtkWidget *gtdk_toolbar_append_togglebutton (GtkToolbar *toolbar, gchar *text, gchar *icon_file)
{
  GtkWidget *ret;
  ret = gtk_toolbar_append_element (toolbar, GTK_TOOLBAR_CHILD_TOGGLEBUTTON, NULL, text, text, NULL, gtdk_pixmap_file (icon_file), NULL, NULL);
  gtk_widget_show (ret);
  return ret;
}

/**
 * gtdk_toolbar_append_togglebutton_stock:
 * @toolbar: toolbar
 * @text: label
 * @window: window of toolbar
 * @icon: xpm image
 * 
 * fr: Ajoute un boutton poussoir  la barre d'outils
 *
 * en: Adds a togglebutton to the toolbar
 * 
 * Return value: button
 **/

GtkWidget *gtdk_toolbar_append_togglebutton_stock (GtkToolbar *toolbar, gchar *text, GtkWidget *window, gchar *icon)
{
  GtkWidget *ret;
  ret = gtk_toolbar_append_element (toolbar, GTK_TOOLBAR_CHILD_TOGGLEBUTTON, NULL, text, text, NULL, gnome_stock_pixmap_widget (window, icon), NULL, NULL);
  gtk_widget_show (ret);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (ret), FALSE);
  return ret;
}

/**
 * gtdk_toolbar_append_radiobutton:
 * @toolbar: toolbar
 * @sibling: radiobutton sibling
 * @text: label
 * @icon_file: file location of the icon
 * 
 * fr: Ajoute un boutton radio  la barre d'outils
 *
 * en: Adds a radiobutton to the toolbar
 * 
 * Return value: button
 **/

GtkWidget *gtdk_toolbar_append_radiobutton (GtkToolbar *toolbar, GtkWidget *sibling, gchar *text, gchar *icon_file)
{
  GtkWidget *ret;
  ret = gtk_toolbar_append_element (toolbar, GTK_TOOLBAR_CHILD_RADIOBUTTON, sibling, text, text, NULL, gtdk_pixmap_file (icon_file), NULL, NULL);
  gtk_widget_show (ret);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (ret), FALSE);
  return ret;
}

/**
 * gtdk_toolbar_append_radiobutton_stock:
 * @toolbar: toolbar
 * @sibling: radiobutton sibling
 * @text: label
 * @window: window of toolbar
 * @icon: xpm image
 * 
 * fr: Ajoute un boutton radio  la barre d'outils
 *
 * en: Adds a radiobutton to the toolbar
 * 
 * Return value: button
 **/

GtkWidget *gtdk_toolbar_append_radiobutton_stock (GtkToolbar *toolbar, GtkWidget *sibling, gchar *text, GtkWidget *window, gchar *icon)
{
  GtkWidget *ret;
  ret = gtk_toolbar_append_element (toolbar, GTK_TOOLBAR_CHILD_RADIOBUTTON, sibling, text, text, NULL, gnome_stock_pixmap_widget (window, icon), NULL, NULL);
  gtk_widget_show (ret);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (ret), FALSE);
  return ret;
}

/*****************************************************************************/
/*** Boutton - Button */
/*****************************************************************************/

/**
 * gtdk_button_href:
 * @name: name
 * @url: URL
 * 
 * fr: Retourne le bouton url
 *
 * en: Returns the url button
 * 
 * Return value: button
 **/

GtkWidget *gtdk_button_href (gchar *name, gchar *url)
{
  GtkWidget *ret;
  GtkWidget *label;
  gchar *pattern;
  if (!url)
    url = name;
  ret = gtk_button_new();
  pattern = g_strnfill (strlen (name), '_');
  label = gtk_label_new (name);
  gtk_widget_set_style (label, TD_STYLE_TEXT_URL);
  gtk_container_add (GTK_CONTAINER (ret), label);
  gtk_widget_show (label);
  gtk_label_set_pattern (GTK_LABEL (label), pattern);
  gtk_button_set_relief (GTK_BUTTON (ret), GTK_RELIEF_NONE);
  gtk_signal_connect (GTK_OBJECT (ret), "clicked", GTK_SIGNAL_FUNC (gtdk_button_href_clicked), url);
  return ret;
}

/**
 * gtdk_button_href_clicked:
 * @button: button
 * @url: url
 *
 * fr: Evnement 'clicked' du bouton url
 *
 * en: Event 'clicked' of url button
 **/

static void gtdk_button_href_clicked (GtkButton *button, gchar *url)
{
  td_browser (url);
}

/**
 * gtdk_button_color:
 * @widget_dest: entry widget for showing value
 * 
 * fr: Retourne le bouton  couleurs
 *
 * en: Returns the colors button
 * 
 * Return value: button
 **/

GtkWidget *gtdk_button_color (GtkWidget *widget_dest)
{
  static const GtkTargetEntry targets[] = { { "application/x-color", 0 } };
  GtkWidget *ret;
  GtkWidget *frame;
  GtkWidget *drawingarea;
  ret = gtk_button_new();
  gtk_container_set_border_width (GTK_CONTAINER (ret), 1);
  gtk_signal_connect (GTK_OBJECT (ret), "button_press_event", GTK_SIGNAL_FUNC (gtdk_button_color_clicked), NULL);
  frame = gtk_frame_new (NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_container_add (GTK_CONTAINER (ret), frame);
  gtk_widget_show (frame);
  drawingarea = gtk_drawing_area_new();
  gtk_widget_show (drawingarea);
  gtk_drawing_area_size (GTK_DRAWING_AREA (drawingarea), 20, 12);
  gtk_container_add (GTK_CONTAINER (frame), drawingarea);
  gtk_widget_show (drawingarea);
  gtk_object_set_user_data (GTK_OBJECT (drawingarea), "black");
  gtk_signal_connect (GTK_OBJECT (drawingarea), "expose_event", GTK_SIGNAL_FUNC (gtdk_button_color_expose_event), NULL);
  gtk_drag_dest_set (ret, GTK_DEST_DEFAULT_HIGHLIGHT | GTK_DEST_DEFAULT_MOTION | GTK_DEST_DEFAULT_DROP, TD_DROP_COLOR, 1, GDK_ACTION_COPY);
  gtk_drag_source_set (ret, GDK_BUTTON2_MASK, TD_DROP_COLOR, 1, GDK_ACTION_COPY | GDK_ACTION_MOVE);
  gtk_signal_connect (GTK_OBJECT (ret), "drag_data_received", GTK_SIGNAL_FUNC (gtdk_button_color_drop), widget_dest);
  return ret;
}

/**
 * gtdk_button_color_expose_event:
 * @drawingarea: drawingarea
 * @event: event
 *
 * fr: Evnement 'expose_event' du boutton  couleurs
 *
 * en: Event 'expose_event' of colors button
 **/

static void gtdk_button_color_expose_event (GtkWidget *drawingarea, GdkEventExpose *event)
{
  GdkWindow *window = drawingarea->window;
  GdkGC *gc;
  GdkColor color;
  gc = gdk_gc_new (window);
  color = gtdk_color_parse (gtk_object_get_user_data (GTK_OBJECT (drawingarea)));
  gdk_color_alloc (gtk_widget_get_default_colormap(), &color);
  gdk_gc_set_foreground (gc, &color);
  gdk_draw_rectangle (window, gc, TRUE, 0, 0, drawingarea->allocation.width, drawingarea->allocation.height);
  gdk_gc_destroy (gc);
}

/**
 * gtdk_button_color_clicked:
 * @button: button
 *
 * fr: Evnement 'clicked' du bouton  couleurs
 *
 * en: Event 'clicked' of colors button
 **/

static void gtdk_button_color_clicked (GtkButton *button)
{
  td_exec (td_app_custom_value ("external", "picker", "color"));
}

/**
 * gtdk_button_color_drop:
 * @button: button
 * @context: context of the drag'n'drop
 * @x: x coordinate of the drag'n'drop
 * @y: y coordinate of the drag'n'drop
 * @selection_data: color
 * @info: info (not used)
 * @time: time (not used)
 * @widget_dest: entry widget for showing value
 *
 * fr: Evnement 'drag_data_received' du bouton  couleurs
 *
 * en: Event 'drag_data_received' of colors button
 **/

static void gtdk_button_color_drop (GtkWidget *button, GdkDragContext *context, gint x, gint y, GtkSelectionData *selection_data, guint info, guint time, GtkWidget *widget_dest)
{
  guint8 *vals;
  if (selection_data->length < 0)
    return;
  if ((selection_data->format != 16) || (selection_data->length != 8))
    {
      td_app_message (_("External data"), _("External data : invalid color data"), TD_MSG_FAILED);
      return;
    }
  vals = (guint8*) selection_data->data;
  gtk_entry_set_text (GTK_ENTRY (widget_dest), g_strdup_printf ("#%.2x%.2x%.2x", vals[0], vals[2], vals[4]));
}

/**
 * gtdk_button_color_set:
 * @button: button
 * @color: color
 *
 * fr: Affecte la couleur au bouton  couleurs
 *
 * en: Allocates the color to colors button
 **/

void gtdk_button_color_set (GtkWidget *button, gchar *color)
{
  gtk_object_set_user_data (GTK_OBJECT (GTK_BIN (GTK_BIN (button)->child)->child), color);
  gtk_widget_queue_draw (GTK_BIN (GTK_BIN (button)->child)->child);
}

/**
 * gtdk_button_font:
 * 
 * fr: Retourne le bouton  polices de caractres
 *
 * en: Returns the fonts button
 * 
 * Return value: button
 **/

GtkWidget *gtdk_button_font (void)
{
  GtkWidget *ret;
  GtkWidget *arrow;
  ret = gtk_button_new();
  gtk_container_set_border_width (GTK_CONTAINER (ret), 1);
  gtk_signal_connect (GTK_OBJECT (ret), "button_press_event", GTK_SIGNAL_FUNC (gtdk_button_font_clicked), NULL);
  arrow = gtk_arrow_new (GTK_ARROW_RIGHT, GTK_SHADOW_OUT);
  gtk_widget_show (arrow);
  gtk_container_add (GTK_CONTAINER (ret), arrow);
  return ret;
}

/**
 * gtdk_button_font_clicked:
 * @button: button
 *
 * fr: Evnement 'clicked' du bouton  polices de caractres
 *
 * en: Event 'clicked' of fonts button
 **/

static void gtdk_button_font_clicked (GtkButton *button)
{
  td_exec (td_app_custom_value ("external", "picker", "font"));
}

/**
 * gtdk_font_family:
 * @value: valeur
 *
 * fr: Retourne la famille de la police de caractre
 *
 * en: Returns the familly of the font
 *
 * Return value: string
 **/

gchar *gtdk_font_family (gchar *value)
{
  GList *ret = NULL;
  gchar *value2;
  gchar *value_trash;
  if ((!value) || (!strstr (value, "-")))
    return NULL;
  value2 = g_strdup_printf ("%s", value);
  value_trash = strtok (value2, "-");
  return (g_strstrip (strtok (NULL, "-")));
}

/**
 * gtdk_font_size:
 * @value: valeur
 *
 * fr: Retourne la taille de la police de caractre
 *
 * en: Returns the size of the font
 *
 * Return value: string
 **/

gchar *gtdk_font_size (gchar *value)
{
  GList *ret = NULL;
  gchar *value2;
  gchar *value_trash;
  if ((!value) || (!strstr (value, "-")))
    return NULL;
  value2 = g_strdup_printf ("%s", value);
  value_trash = strtok (value2, "-");
  value_trash = strtok (NULL, "-");
  value_trash = strtok (NULL, "-");
  value_trash = strtok (NULL, "-");
  value_trash = strtok (NULL, "-");
  value_trash = strtok (NULL, "-");
  value_trash = strtok (NULL, "-");
  return (g_strstrip (strtok (NULL, "-")));
}

/*****************************************************************************/
/*** Souris - Mouse */
/*****************************************************************************/

/**
 * gtdk_mouse_event:
 * @event: mouse event
 * @type: type of mouse event
 *
 * fr: Retourne VRAI si l'evnement de la souris correspond au type
 *
 * en: Returns TRUE if the mouse event corresponds to the type
 *
 * Return value: result
 **/

gboolean gtdk_mouse_event (GdkEventButton *event, TdEventMouse type)
{
  /*** FIXME: Ajouter la config utilisateur : +tards - Add the user config : this night */ 
  switch (type)
    {
    case TD_EVENT_MOUSE_SELECT:
      if ((event->button == 1) && (!(event->state & GDK_SHIFT_MASK)) && (!(event->state & GDK_CONTROL_MASK)))
	return TRUE;
      break;
    case TD_EVENT_MOUSE_MENU_ITEM:
      if ((event->button == 3) && (!(event->state & GDK_SHIFT_MASK)) && (!(event->state & GDK_CONTROL_MASK)))
	return TRUE;
      break;
    case TD_EVENT_MOUSE_MOVE:
      if ((event->button == 1) && (event->state & GDK_SHIFT_MASK))
	return TRUE;
      break;
    case TD_EVENT_MOUSE_COPY:
      if ((event->button == 1) && (event->state & GDK_CONTROL_MASK))
	return TRUE;
      break;
    case TD_EVENT_MOUSE_RESIZE:
      if ((event->button == 3) && (event->state & GDK_SHIFT_MASK))
	return TRUE;
      break;
    case TD_EVENT_MOUSE_LINK:
      if ((event->button == 3) && (event->state & GDK_CONTROL_MASK))
	return TRUE;
      break;
    case TD_EVENT_MOUSE_MENU_MAIN:
      if (event->button == 2)
	return TRUE;
      break;
    default:
      break;
    }
  return FALSE;
}

/*****************************************************************************/
/*** Pixmap */
/*****************************************************************************/

/**
 * gtdk_pixmap_file:
 * @file: file
 * 
 * fr: Retourne l'image correspondant au fichier
 *
 * en: Returns the picture corresponding of the file
 * 
 * Return value: picture
 **/

GtkWidget *gtdk_pixmap_file (gchar *file)
{
  GtkWidget *ret;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  if (!strstr (file, "/"))
    file = g_strdup_printf ("%s/share/pixmaps/%s/%s", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, file);
  if (!td_file_exist (file))
    file = g_strdup_printf ("%s/share/pixmaps/%s/list_empty.xpm", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR);
  gdk_pixbuf_render_pixmap_and_mask (gdk_pixbuf_new_from_file (file), &pixmap, &mask, 127);
  ret = gtk_pixmap_new (pixmap, mask);
  gdk_pixmap_unref (pixmap);
  gdk_bitmap_unref (mask);
  return ret;
}
