/*****************************************************************************/
/* commons.h : Variables et fonctions communes
 * commons.h : Commons variables and commons functions
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manage
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <parser.h>
#include <tree.h>
/*  #include <libxml/parser.h> */
/*  #include <libxml/tree.h> */

/*****************************************************************************/
/*** Macros */
/*****************************************************************************/
#define XmlDoc xmlDoc
#define XmlNs xmlNs
#define XmlNode xmlNode
#define XmlAttribute xmlAttribute
#define XmlAttr xmlAttr
#define XmlChar xmlChar
#define BUFFER_SIZE 256

/*****************************************************************************/
/*** Enumration - Enumeration */
/*****************************************************************************/
typedef enum {
  TD_LIST_TYPE_ITEM, /*** Liste d'items - Items list */
  TD_LIST_TYPE_QUERY_STATIC, /*** Liste gnre par SQL mais statique - List generated by SQL but static */
  TD_LIST_TYPE_QUERY, /*** Liste gnre par SQL - List generated by SQL */
} TdListType;

typedef enum {
  TD_FACE_NORMAL, /*** Face normal */
  TD_FACE_PRELIGHT, /*** Face claire - Face prelighted */
  TD_FACE_SELECTED, /*** Face selectionne - Face Selected */
  TD_FACE_PARENT, /*** Face parent */
  TD_FACE_CHILD, /*** Face enfant - Face child */
} TdFace;

typedef enum {
  TD_DATE_FORMAT_EU, /*** Date au format europen - Date with European format */
  TD_DATE_FORMAT_US, /*** Date au format amricain  - Date with American format */
} TdDateFormat;

/*****************************************************************************/
/*** Configuration du tirer-lcher - Drag'n'drop configuration */
/*****************************************************************************/
static GtkTargetEntry TD_DRAG_TYPES [] = {
  { "plain/text", 0, 0 },
};
static GtkTargetEntry TD_DROP_TYPES [] = {
  { "plain/text", 0, 0 },
};
static GtkTargetEntry TD_DROP_COLOR [] = {
  { "application/x-color", 0, 0 },
};

static gint TD_N_DRAG_TYPES = sizeof (TD_DRAG_TYPES) / sizeof (TD_DRAG_TYPES [0]);
static gint TD_N_DROP_TYPES = sizeof (TD_DROP_TYPES) / sizeof (TD_DROP_TYPES [0]);

/*****************************************************************************/
/*** Variables globales - Globals variables */
/*****************************************************************************/

/*** Configuration */
gchar *TD_PACKAGE_PLUGINS_DIR;
gchar *TD_PACKAGE_VAR_DIR;
gchar *TD_PACKAGE_TMP_DIR;
GtkObject *APP;

/*** Personnalistion - Customize */
GtkObject *TD_CUSTOM_CURRENT;
gchar *TD_CUSTOM_FILE_CURRENT;
gchar *TD_CUSTOM_FILE_STARTUP;
GtkObject *TD_CUSTOM_GEOMETRY;
GList *TD_CUSTOM_GEOMETRY_QUEUE;
gboolean TD_CUSTOM_GEOMETRY_PLACEMENT;
TdDateFormat TD_CUSTOM_DATE_FORMAT;

/*** Greffons - Plug-ins */
void *PLUGINS_CORE[20];
void *PLUGINS_DATA[20];
void *PLUGINS_FILTER[10];
void *PLUGINS_CORE_MESSAGES;
void *PLUGINS_CORE_XTS;
void *PLUGINS_CORE_BOOKMARKS;
void *PLUGINS_CORE_DATABASE;

/*** Temporisation - Temporization */
int FLAG_DRAG_AUTOEXPAND_ID;
int FLAG_DRAG_AUTOEXPAND_TIME;
int FLAG_DRAG_ROW_OLD;
int FLAG_DRAG_AUTOEXPAND_ROW;
int DRAG_ROW;

int FLAG_ENTRY_CHANGED_ID;
int FLAG_ENTRY_CHANGED_TIME;
GtkWidget *FLAG_ENTRY_CHANGED_WIDGET_OLD;
GtkObject *FLAG_ENTRY_CHANGED_MOD_OLD;

/*** Node courante de la base de donnes - Current node of database */
int CURRENT_ID;
int CURRENT_ID_PARENT;
GList *CURRENT_ROW;
GList *CURRENT_FIELD;

/*** Drapeux internes - Internal flag */
gboolean TD_FLAG_ANTI_AUTOEXPAND;
gboolean TD_FLAG_NO_REFRESH_NODE;
gboolean TD_FLAG_NO_REFRESH_PALLETTE_MESSAGE;
gboolean TD_FLAG_DEBUG_MODE;

/*** Messages de dmarage - Starting message */
GList *START_MSG;

/*** Widget */
GtkWidget *WINDOW_FILE_SELECTION;
GtkWidget *WINDOW_DATE_SELECTION;

/*** Style de texte - Text style */
GtkStyle *TD_STYLE_TEXT_DEFAULT;
GtkStyle *TD_STYLE_TEXT_SELECTED;
GtkStyle *TD_STYLE_TEXT_URL;
TdDateFormat TD_DATE_FORMAT;

/*** Faces des donnes - Data faces */
GdkColor TD_FACE_NODE_LINE_COLOR[5];
double TD_FACE_NODE_LINE_WIDTH[5];
GdkLineStyle TD_FACE_NODE_LINE_STYLE[5];
GdkColor TD_FACE_NODE_FILL_COLOR[5];
GdkColor TD_FACE_NODE_TEXT_COLOR[5];
GdkColor TD_FACE_LINK_LINE_COLOR[5];
double TD_FACE_LINK_LINE_WIDTH[5];
GdkLineStyle TD_FACE_LINK_LINE_STYLE[5];
GdkCapStyle TD_FACE_LINK_LINE_CAP;
GdkJoinStyle TD_FACE_LINK_LINE_JOIN;
double TD_FACE_LINK_ARROW[3];

/*** Faces noyaux - Core faces */
GdkColor TD_FACE_HANDLE_LINE_COLOR;
double TD_FACE_HANDLE_LINE_WIDTH;
GdkLineStyle TD_FACE_HANDLE_LINE_STYLE;
GdkColor TD_FACE_HANDLE_FILL_COLOR;
GdkColor TD_FACE_TIMERULER_LINE_COLOR;
double TD_FACE_TIMERULER_LINE_WIDTH;
GdkLineStyle TD_FACE_TIMERULER_LINE_STYLE;
GdkColor TD_FACE_TIMERULER_TEXT_COLOR;

/*** PSTricks */
int TD_PS_HEIGHT_CANVAS;
int TD_PS_HEIGHT;
int TD_PS_WIDTH_CANVAS;
int TD_PS_WIDTH;

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
void td_init (void);
void td_exit (int ret);

/*****************************************************************************/
/*** Ok */
/*****************************************************************************/
void td_set_ok (GtkWidget *widget, gboolean *dialog_result);

/*****************************************************************************/
/*** Fonctions - Functions */
/*****************************************************************************/
gint td_func_comp (gconstpointer a, gconstpointer b);

/*****************************************************************************/
/*** Message */
/*****************************************************************************/
void td_message_create_window (gchar *message);
int td_question_create_window (gchar *question, gchar *title);
gchar *td_fileselector_create_window (gchar *title, gchar *file, gchar *extension, gboolean show);

/*****************************************************************************/
/*** Extension */
/*****************************************************************************/
gboolean td_system (gchar *command);
gchar *td_exec_alias (gchar *command);
int td_exec (gchar *command);
gboolean td_shell (gchar *command);
gpointer *td_dlsym (void *module, gchar *dir, gchar *file, gchar *symbol, gboolean warning);
GList *td_dataplugins_filelist (void);
GtkObject *td_dataplugins_list (void);

/*****************************************************************************/
/*** Fichier et URL - File and URL */
/*****************************************************************************/
gboolean td_file_exist (gchar *file);
gboolean td_file_backup (gchar *file);
void td_browser (gchar *url);
void td_editor_txt (gchar *file);
gboolean td_viewer_ps (gchar *file);

/*****************************************************************************/
/*** Date */
/*****************************************************************************/
void td_sleep (int ms);
GDate *td_date_current (void);
gchar *td_date_intl (gchar *format);
GDate *td_date_parse (gchar *date, gchar *format);
gchar *td_date_print (GDate *date, gchar *format);
gchar *td_date_month_name (int month, gboolean abbrev);
gchar *td_date_month (int month, int year, gchar *format);
gchar *td_date_week (int week, int year, gchar *format);
gchar *td_date_day_name (GDate *date, gboolean abbrev);
gchar *td_date_day (int day, int month, int year, gchar *format);
int td_date_period_day (GDate *lower, GDate *upper);
GDate *td_date_add_days (GDate *date, int days);
GDate *td_date_add_months (GDate *date, int months);
GDate *td_date_add_years (GDate *date, int years);

/*****************************************************************************/
/*** Chane de caractres - String */
/*****************************************************************************/
gchar *td_string_replace (gchar *source, gchar *before, gchar *after);
gchar *td_string_remove (gchar *source, gchar *string);
int td_atoi (gchar *value);
gchar *td_strsplit (gchar *string, gchar *delimiter, int index);
GList *td_strsplist (gchar *string, gchar *delimiter);
GString *td_string_file (gchar *file);

/*****************************************************************************/
/*** Flottant - Float */
/*****************************************************************************/
int td_floor (float value, int base);

/*****************************************************************************/
/*** Liste - List */
/*****************************************************************************/
TdListType td_list_type_parse (gchar *value);

/*****************************************************************************/
/*** XML */
/*****************************************************************************/
XmlNode *td_xml_check_children (XmlNode *cur, gchar *name);

/*****************************************************************************/
/*** Filtre - Filter */
/*****************************************************************************/
gchar *td_filter_custom_value (gchar *name, gchar *category, gchar *group, gchar *option);

/*****************************************************************************/
/*** Personnalisation et paramtrage - Customizing and parameters */
/*****************************************************************************/
gchar *td_custom_value (gchar *module, gchar *category, gchar *group, gchar *option);
static gchar *td_custom_value_real (gchar *category, gchar *group, gchar *option);
