/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : Filtre SVG
 * ToutDoux's plug-in : SVG filter
 * Copyright (c) 2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <math.h>

#include "main.h"

/*****************************************************************************/
/*** Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("SVG filter"),
		  "type", _("filter"),
		  "version", "1.0.1",
		  "authors", "Philippe Roy <ph_roy@toutdoux.org>",
		  "category1", _("core"),
		  "category2", _("filter"),
		  "category3", "svg",
		  "copyright", "Copyright (c) 2001 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"), NULL);
  return ret;
}

GtkObject *plugins_init (int mod_id)
{
  GtkObject *ret;
  ret = td_mod_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "gfx_svg",
		  "name_intl", _("SVG filter"),
		  "id", -1, NULL);
  td_mod_set_about (TD_MOD (ret), plugins_about_def());
  return ret;
}

void plugins_destroy (gpointer user_data)
{
}

/*****************************************************************************/
/*** Echelle du temps - Timeruler */
/*****************************************************************************/
GList *customize_timeruler (GtkObject *mod_child)
{
  int i;
  GList *ret = NULL;

  /*** Lignes - Lines */
  ret = g_list_append (ret, td_filter_custom_value ("gfx_svg", "timeruler", "line", "stroke")); /* 0 */
  ret = g_list_append (ret, td_filter_custom_value ("gfx_svg", "timeruler", "line", "stroke-width")); /* 1 */

  /*** Texte - Text */
  ret = g_list_append (ret, td_filter_custom_value ("gfx_svg", "timeruler", "text", "text color")); /* 2 */
  ret = g_list_append (ret, gtdk_font_family (td_filter_custom_value ("gfx_svg", "timeruler", "text", "text font"))); /* 3 */
  ret = g_list_append (ret, gtdk_font_size (td_filter_custom_value ("gfx_svg", "timeruler", "text", "text font"))); /* 4 */
  ret = g_list_append (ret, g_strdup_printf ("%d", gdk_string_height (gtk_widget_get_default_style()->font, "0"))); /* 5 */
  ret = g_list_append (ret, td_filter_custom_value ("gfx_svg", "timeruler", "text", "voffset")); /* 6 */

  /*** Vrification - Checking */
  for (i=0; i<g_list_length (ret); i++)
    if ((!(g_list_nth_data (ret, i))) || (!strcmp ("(null)", (gchar*) g_list_nth_data (ret, i))))
      return NULL;
  return ret;
}

void draw_timeruler (XmlDoc *doc, XmlNode *root_xml, GnomeCanvasGroup *root, GtkObject *mod_child)
{
  GnomeCanvasItem *item = NULL;
  XmlNode *group_xml;
  XmlNode *draw_xml;
  int id_item;
  GList *style;
  int i,j;
  gchar *txt_tmp;
  int height = GTK_WIDGET (TD_TIMERULER (TD_MOD_GANTT (mod_child)->timeruler)->widget)->allocation.height+2;
  int xoffset = -1;

  /*** Personnalisation - Customize */
  style = customize_timeruler (mod_child);
  if (!style)
    {
      td_app_message (_("Reading customize file"), NULL, TD_MSG_FAILED);
      xmlFreeDoc (doc);
      td_app_message (NULL, _("Exporting SVG file"), TD_MSG_END);
      return;
    }

  /*** Items */
  group_xml = xmlNewChild (root_xml, NULL, "g", NULL);
  for (i=0; i < g_list_length (GNOME_CANVAS_GROUP (root)->item_list); i++)
    {
      item = g_list_nth_data (GNOME_CANVAS_GROUP (root)->item_list, i);

      /*** canvas_line */
      if (GNOME_IS_CANVAS_LINE (item))
	{
	  draw_xml = xmlNewChild (group_xml, NULL, "path", NULL);
	  txt_tmp = g_strdup_printf ("M %.2f %.2f",
				     gtdk_canvas_i2w_x (item, GNOME_CANVAS_LINE (item)->coords[0])+xoffset,
				     gtdk_canvas_i2w_y (item, GNOME_CANVAS_LINE (item)->coords[1])-height);
	  for (j=2; j<GNOME_CANVAS_LINE (item)->num_points*2; j=j+2)
	    txt_tmp = g_strdup_printf ("%s L %.2f %.2f",
				       txt_tmp,
				       gtdk_canvas_i2w_x (item, GNOME_CANVAS_LINE (item)->coords[j])+xoffset,
				       gtdk_canvas_i2w_y (item, GNOME_CANVAS_LINE (item)->coords[j+1])-height);
	  xmlSetProp (draw_xml, "d", txt_tmp);
	  xmlSetProp (draw_xml, "style", g_strdup_printf ("stroke:#%06lx; stroke-width:%s; fill:none",
							  gtdk_color_parse (g_list_nth_data (style, 0)).pixel,
							  (gchar*) (g_list_nth_data (style, 1))));
	  continue;
	}

      /*** canvas_text */
      if (GNOME_IS_CANVAS_TEXT (item))
	{
	  draw_xml = xmlNewChild (group_xml, NULL, "text", xmlEncodeEntitiesReentrant (doc, GNOME_CANVAS_TEXT (item)->text));
	  xmlSetProp (draw_xml, "x", g_strdup_printf ("%.2f", gtdk_canvas_i2w_x (item, GNOME_CANVAS_TEXT (item)->x)+xoffset));
	  xmlSetProp (draw_xml, "y", g_strdup_printf ("%.2f", (gtdk_canvas_i2w_y (item, GNOME_CANVAS_TEXT (item)->y))-
						      (td_atoi (g_list_nth_data (style, 5)))+
						      (td_atoi (g_list_nth_data (style, 4))/10)+
						      (td_atoi (g_list_nth_data (style, 6)))-height));
	  xmlSetProp (draw_xml, "style", g_strdup_printf ("font-family:%s; font-size:%dpt; fill:#%06lx",
							  (gchar*) (g_list_nth_data (style, 3)),
							  td_atoi (g_list_nth_data (style, 4))/10,
							  gtdk_color_parse (g_list_nth_data (style, 2)).pixel));
	  continue;
	}
    }
}

/*****************************************************************************/
/*** Cavenas - Canvas  */
/*****************************************************************************/
GList *customize_canvas (GtkObject *mod_child)
{
  int i;
  GList *ret = NULL;

  /*** Node - Node */
  ret = g_list_append (ret, td_filter_custom_value ("gfx_svg", "node", "line", "stroke")); /* 0 */
  ret = g_list_append (ret, td_filter_custom_value ("gfx_svg", "node", "line", "stroke-width")); /* 1 */
  ret = g_list_append (ret, td_filter_custom_value ("gfx_svg", "node", "line", "stroke-dasharray")); /* 2 */
  ret = g_list_append (ret, td_filter_custom_value ("gfx_svg", "node", "fill", "fill")); /* 3 */
  ret = g_list_append (ret, td_filter_custom_value ("gfx_svg", "node", "text", "text color")); /* 4 */

  /*** Lien - Link */
  ret = g_list_append (ret, td_filter_custom_value ("gfx_svg", "link", "line", "stroke")); /* 5 */
  ret = g_list_append (ret, td_filter_custom_value ("gfx_svg", "link", "line", "stroke-width")); /* 6 */
  ret = g_list_append (ret, td_filter_custom_value ("gfx_svg", "link", "line", "stroke-dasharray")); /* 7 */
  ret = g_list_append (ret, td_filter_custom_value ("gfx_svg", "link", "line", "stroke-linecap")); /* 8 */
  ret = g_list_append (ret, td_filter_custom_value ("gfx_svg", "link", "line", "stroke-linejoin")); /* 9 */
  ret = g_list_append (ret, td_strsplit (td_filter_custom_value ("gfx_svg", "link", "line", "arrow"), NULL, 0)); /* 10 */
  ret = g_list_append (ret, td_strsplit (td_filter_custom_value ("gfx_svg", "link", "line", "arrow"), NULL, 1)); /* 11 */
  ret = g_list_append (ret, td_strsplit (td_filter_custom_value ("gfx_svg", "link", "line", "arrow"), NULL, 2)); /* 12 */

  /*** Poigne - Handle */
  ret = g_list_append (ret, td_filter_custom_value ("gfx_svg", "handle", "line", "stroke")); /* 13 */
  ret = g_list_append (ret, td_filter_custom_value ("gfx_svg", "handle", "line", "stroke-width")); /* 14 */

  /*** Police de catactre - Fonte */
  ret = g_list_append (ret, gtdk_font_family (td_filter_custom_value ("gfx_svg", "node", "text", "text font"))); /* 15 */
  ret = g_list_append (ret, gtdk_font_size (td_filter_custom_value ("gfx_svg", "node", "text", "text font"))); /* 16 */
  ret = g_list_append (ret, g_strdup_printf ("%d", gdk_string_height (gtk_widget_get_default_style()->font, "0"))); /* 17 */
  ret = g_list_append (ret, td_filter_custom_value ("gfx_svg", "node", "text", "voffset")); /* 18 */

  /*** Groupe - Group */
  ret = g_list_append (ret, td_filter_custom_value ("gfx_svg", "node", "group", "grouped")); /* 19 */
  ret = g_list_append (ret, td_filter_custom_value ("gfx_svg", "link", "group", "grouped")); /* 20 */
  ret = g_list_append (ret, td_filter_custom_value ("gfx_svg", "handle", "group", "grouped")); /* 21 */

  /*** Vrification - Checking */
  for (i=0; i<g_list_length (ret); i++)
    if ((!(g_list_nth_data (ret, i))) || (!strcmp ("(null)", (gchar*) g_list_nth_data (ret, i))))
      return NULL;
  return ret;
}

void draw_canvas (XmlDoc *doc, XmlNode *root_xml, GnomeCanvasGroup *root, GtkObject *mod_child)
{
  GnomeCanvasItem *item = NULL;
  GnomeCanvasItem *item_parent = NULL;
  XmlNode *group_xml;
  int id_item;
  GList *style;

  /*** Personnalisation - Customize */
  style = customize_canvas (mod_child);
  if (!style)
    {
      td_app_message (_("Reading customize file"), NULL, TD_MSG_FAILED);
      xmlFreeDoc (doc);
      td_app_message (NULL, _("Exporting SVG file"), TD_MSG_END);
      return;
    }

  /*** Nodes */
  td_app_message (g_strdup_printf ("%s...", _("Writing SVG file")), NULL, TD_MSG_MESSAGE);
  group_xml = xmlNewChild (root_xml, NULL, "g", NULL);
  id_item = 0;
  item_parent = GNOME_CANVAS_ITEM (root);
  item = g_list_nth_data (GNOME_CANVAS_GROUP (item_parent)->item_list, id_item);
  while (item)
    {

      /*** Groupe - Group */
      if (GNOME_IS_CANVAS_GROUP (item))
	{
	  id_item = 0;
	  item_parent = item;
	  item = g_list_nth_data (GNOME_CANVAS_GROUP (item_parent)->item_list, id_item);
	  continue;
	}

      /*** Item */
      draw_canvas_item (doc, group_xml, item, style, mod_child);

      /*** Suivant - Next */
      id_item++;
      if (id_item < g_list_length (GNOME_CANVAS_GROUP (item_parent)->item_list))
	{
	  item = g_list_nth_data (GNOME_CANVAS_GROUP (item_parent)->item_list, id_item);
	  continue;
	}

      /*** Parent */
      if (GNOME_CANVAS_GROUP (item_parent) == root)
	{
	  item = NULL;
	  continue;
	}
      do
	{
	  if (!item_parent->parent)
	    {
	      item_parent = NULL;
	      continue;
	    }
	  id_item = g_list_index (GNOME_CANVAS_GROUP (item_parent->parent)->item_list, item_parent)+1;
	  item_parent = item_parent->parent;
	  item = g_list_nth_data (GNOME_CANVAS_GROUP (item_parent)->item_list, id_item);
	}
      while ((item_parent) && (!item));
    }
}

void draw_canvas_item (XmlDoc *doc, XmlNode *root_xml, GnomeCanvasItem *item, GList *style, GtkObject *mod_child)
{
  /*** THANKS: fonction avec une grosse partie crite par - function with a big piece written by
       Fichier - File: libgnomeui/gnome-canvas-line.c
       Copyright : Copyright (C) 1998 The Free Software Foundation
       Auteur - Author: Federico Mena <federico@nuclecu.unam.mx> */

  XmlNode *draw_xml;
  gchar *txt_tmp;
  double poly[10];
  double dx, dy, length;
  double sin_theta, cos_theta, tmp;
  double frac_height;
  double vx, vy;
  int i;

  /* Visibilit - Visiblity */
  if (!(item->object.flags & GNOME_CANVAS_ITEM_VISIBLE))
    return;
  if (!(item->parent->object.flags & GNOME_CANVAS_ITEM_VISIBLE))
    return;

  /*** Poigne - Handle */
  if ((gtk_object_get_user_data (GTK_OBJECT (item))) && (strstr (gtk_object_get_user_data (GTK_OBJECT (item)), "handle")))
    {
      /*** canvas_line */
      if (GNOME_IS_CANVAS_LINE (item))
	{
	  draw_xml = xmlNewChild (root_xml, NULL, "path", NULL);
	  txt_tmp = g_strdup_printf ("M %.2f %.2f",
				     gtdk_canvas_i2w_x (item, GNOME_CANVAS_LINE (item)->coords[0]),
				     gtdk_canvas_i2w_y (item, GNOME_CANVAS_LINE (item)->coords[1]));
	  for (i = 2; i < GNOME_CANVAS_LINE (item)->num_points*2; i=i+2)
	    txt_tmp = g_strdup_printf ("%s L %.2f %.2f", 
				       txt_tmp, 
				       gtdk_canvas_i2w_x (item, GNOME_CANVAS_LINE (item)->coords[i]),
				       gtdk_canvas_i2w_y (item, GNOME_CANVAS_LINE (item)->coords[i+1]));
	  xmlSetProp (draw_xml, "d", txt_tmp);
	  xmlSetProp (draw_xml, "style", g_strdup_printf ("stroke:#%06lx; stroke-width:%s; fill:none", 
							  gtdk_color_parse (g_list_nth_data (style, 13)).pixel,
							  (gchar*) (g_list_nth_data (style, 14))));
	  return;
	}

      /*** canvas_rect */
      if (GNOME_IS_CANVAS_RECT (item))
	{
	  draw_xml = xmlNewChild (root_xml, NULL, "rect", NULL);
	  xmlSetProp (draw_xml, "x", g_strdup_printf ("%.2f", gtdk_canvas_i2w_x (item, GNOME_CANVAS_RE (item)->x1)));
	  xmlSetProp (draw_xml, "y", g_strdup_printf ("%.2f", gtdk_canvas_i2w_y (item, GNOME_CANVAS_RE (item)->y1)));
	  xmlSetProp (draw_xml, "width", g_strdup_printf ("%.2f", gtdk_canvas_i2w_x (item, GNOME_CANVAS_RE (item)->x2) - gtdk_canvas_i2w_x (item, GNOME_CANVAS_RE (item)->x1)));
	  xmlSetProp (draw_xml, "height", g_strdup_printf ("%.2f", gtdk_canvas_i2w_y (item, GNOME_CANVAS_RE (item)->y2) - gtdk_canvas_i2w_y (item, GNOME_CANVAS_RE (item)->y1)));
	  xmlSetProp (draw_xml, "style", g_strdup_printf ("stroke:#%06lx; stroke-width:1; fill:none", gtdk_color_parse (g_list_nth_data (style, 0)).pixel));
	  return;
	}
    }
  
  /*** Node */

  /*** canvas_line */
  if (GNOME_IS_CANVAS_LINE (item))
    {

      /*** Reste de manipulation - Manipulation tempory item */
      if (!strcmp ((gchar*) gtk_object_get_user_data (GTK_OBJECT (item)), "link"))
	return;

      /*** Ligne - Line */
      draw_xml = xmlNewChild (root_xml, NULL, "path", NULL);
      txt_tmp = g_strdup_printf ("M %.2f %.2f", 
				 gtdk_canvas_i2w_x (item, GNOME_CANVAS_LINE (item)->coords[0]), 
				 gtdk_canvas_i2w_y (item, GNOME_CANVAS_LINE (item)->coords[1]));
      for (i = 2; i < GNOME_CANVAS_LINE (item)->num_points*2; i=i+2)
	txt_tmp = g_strdup_printf ("%s L %.2f %.2f",  txt_tmp, 
				   gtdk_canvas_i2w_x (item, GNOME_CANVAS_LINE (item)->coords[i]), 
				   gtdk_canvas_i2w_y (item, GNOME_CANVAS_LINE (item)->coords[i+1]));
      xmlSetProp (draw_xml, "d", txt_tmp);
      xmlSetProp (draw_xml, "style", g_strdup_printf ("stroke:#%06lx; stroke-width:%s; stroke-dasharray:%s; stroke-linecap:%s; stroke-linejoin:%s; fill:none",
						  gtdk_color_parse (g_list_nth_data (style, 5)).pixel,
						  (gchar*) (g_list_nth_data (style, 6)),
						  (gchar*) (g_list_nth_data (style, 7)),
						  (gchar*) (g_list_nth_data (style, 8)),
						  (gchar*) (g_list_nth_data (style, 9))));

      /*** Flche - Arrow */
      frac_height = (GNOME_CANVAS_LINE (item)->width / 2.0) / td_atoi (g_list_nth_data (style, 12));
      draw_xml = xmlNewChild (root_xml, NULL, "path", NULL);
      poly[0] = gtdk_canvas_i2w_x (item, GNOME_CANVAS_LINE (item)->coords[GNOME_CANVAS_LINE (item)->num_points*2-2]);
      poly[1] = gtdk_canvas_i2w_y (item, GNOME_CANVAS_LINE (item)->coords[GNOME_CANVAS_LINE (item)->num_points*2-1]);
      dx = poly[0] - gtdk_canvas_i2w_x (item, GNOME_CANVAS_LINE (item)->coords[GNOME_CANVAS_LINE (item)->num_points*2-4]);
      dy = poly[1] - gtdk_canvas_i2w_y (item, GNOME_CANVAS_LINE (item)->coords[GNOME_CANVAS_LINE (item)->num_points*2-3]);
      length = sqrt (dx * dx + dy * dy);
      if (length <= 0)
	sin_theta = cos_theta = 0.0;
      else 
	{
	  sin_theta = dy / length;
	  cos_theta = dx / length;
	}
      poly[0] = gtdk_canvas_i2w_x (item, GNOME_CANVAS_LINE (item)->coords[GNOME_CANVAS_LINE (item)->num_points*2-2])+((td_atoi (g_list_nth_data (style, 10))/2)*cos_theta);
      poly[1] = gtdk_canvas_i2w_y (item, GNOME_CANVAS_LINE (item)->coords[GNOME_CANVAS_LINE (item)->num_points*2-1])+((td_atoi (g_list_nth_data (style, 10))/2)*sin_theta);
      vx = poly[0] - td_atoi (g_list_nth_data (style, 10)) * cos_theta;
      vy = poly[1] - td_atoi (g_list_nth_data (style, 10)) * sin_theta;
      tmp = td_atoi (g_list_nth_data (style, 12)) * sin_theta;
      poly[2] = poly[0] - (td_atoi (g_list_nth_data (style, 10)) - td_atoi (g_list_nth_data (style, 11))) * cos_theta + tmp;
      poly[8] = poly[2] - 2.0 * tmp;
      tmp = td_atoi (g_list_nth_data (style, 12)) * cos_theta;
      poly[3] = poly[1] - (td_atoi (g_list_nth_data (style, 10)) - td_atoi (g_list_nth_data (style, 11))) * sin_theta - tmp;
      poly[9] = poly[3] + 2.0 * tmp;
      poly[4] = poly[2] * frac_height + vx * (1.0 - frac_height);
      poly[5] = poly[3] * frac_height + vy * (1.0 - frac_height);
      poly[6] = poly[8] * frac_height + vx * (1.0 - frac_height);
      poly[7] = poly[9] * frac_height + vy * (1.0 - frac_height);
      xmlSetProp (draw_xml, "d", g_strdup_printf ("M %.2f %.2f L %.2f %.2f L %.2f %.2f L %.2f %.2f L %.2f %.2f z", poly[0], poly[1], poly[2], poly[3], poly[4], poly[5], poly[6], poly[7], poly[8], poly[9]));
      xmlSetProp (draw_xml, "style", g_strdup_printf ("stroke:#%06lx; fill:#%06lx",
						      gtdk_color_parse (g_list_nth_data (style, 5)).pixel, 
						      gtdk_color_parse (g_list_nth_data (style, 5)).pixel));
      return;
    }

  /*** canvas_rect */
  if (GNOME_IS_CANVAS_RECT (item))
    {
      draw_xml = xmlNewChild (root_xml, NULL, "rect", NULL);
      xmlSetProp (draw_xml, "x", g_strdup_printf ("%.2f", gtdk_canvas_i2w_x (item, GNOME_CANVAS_RE (item)->x1)));
      xmlSetProp (draw_xml, "y", g_strdup_printf ("%.2f", gtdk_canvas_i2w_y (item, GNOME_CANVAS_RE (item)->y1)));
      xmlSetProp (draw_xml, "width", g_strdup_printf ("%.2f", gtdk_canvas_i2w_x (item, GNOME_CANVAS_RE (item)->x2) - gtdk_canvas_i2w_x (item, GNOME_CANVAS_RE (item)->x1)));
      xmlSetProp (draw_xml, "height", g_strdup_printf ("%.2f", gtdk_canvas_i2w_y (item, GNOME_CANVAS_RE (item)->y2) - gtdk_canvas_i2w_y (item, GNOME_CANVAS_RE (item)->y1)));
      xmlSetProp (draw_xml, "style", g_strdup_printf ("stroke:#%06lx; stroke-width:%s; stroke-dasharray:%s; fill:#%06lx",
						      gtdk_color_parse (g_list_nth_data (style, 0)).pixel,
						      (gchar*) (g_list_nth_data (style, 1)),
						      (gchar*) (g_list_nth_data (style, 2)),
						      gtdk_color_parse (g_list_nth_data (style, 3)).pixel));
      return;
    }

  /*** canvas_text */
  if (GNOME_IS_CANVAS_TEXT (item))
    {
      draw_xml = xmlNewChild (root_xml, NULL, "text", xmlEncodeEntitiesReentrant (doc, GNOME_CANVAS_TEXT (item)->text));
      xmlSetProp (draw_xml, "x", g_strdup_printf ("%.2f", gtdk_canvas_i2w_x (item, GNOME_CANVAS_TEXT (item)->x)));
      if (TD_IS_MOD_CANVAS (mod_child)) /*** mod_canvas */
	{
	  xmlSetProp (draw_xml, "y", g_strdup_printf ("%.2f", (gtdk_canvas_i2w_y (item, GNOME_CANVAS_TEXT (item)->y))-
						      (td_atoi (g_list_nth_data (style, 17)))+
						      (td_atoi (g_list_nth_data (style, 16))/10)));
	  xmlSetProp (draw_xml, "style", g_strdup_printf ("text-anchor:middle; font-family:%s; font-size:%dpt; fill:#%06lx",
							  (gchar*) (g_list_nth_data (style, 15)),
							  td_atoi (g_list_nth_data (style, 16))/10,
							  gtdk_color_parse (g_list_nth_data (style, 4)).pixel));
	}
      else 
	if (TD_IS_MOD_GANTT (mod_child)) /*** mod_gantt */
	  {
	    xmlSetProp (draw_xml, "y", g_strdup_printf ("%.2f", (gtdk_canvas_i2w_y (item, GNOME_CANVAS_TEXT (item)->y))-
							(td_atoi (g_list_nth_data (style, 17)))+
							(td_atoi (g_list_nth_data (style, 16))/10)+
							(td_atoi (g_list_nth_data (style, 18)))));
	    xmlSetProp (draw_xml, "style", g_strdup_printf ("font-family:%s; font-size:%dpt; fill:#%06lx",
							    (gchar*) (g_list_nth_data (style, 15)),
							    td_atoi (g_list_nth_data (style, 16))/10,
							    gtdk_color_parse (g_list_nth_data (style, 4)).pixel));
	  }
      return;
    }
}

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/
gboolean plugins_export (GtkObject *mod, gchar *file)
{
  GnomeCanvasGroup *root = NULL;
  FILE *fp;
  GtkObject *mod_child;
  XmlDoc *doc;
  XmlNs *ns;
  XmlNode *node_xml;
  XmlNode *node_xml_root;
  int i;
  gchar *title;
  gboolean bool_tmp;
  td_app_message (NULL, _("Exporting SVG file"), TD_MSG_BEGIN);

  /*** Vrification des modules - Checking module */
  mod_child = g_list_nth_data (TD_MOD (mod)->child, 0); /* FIXME: limit  l'ain : +tards */
  if (TD_IS_MOD_CANVAS (mod_child)) /*** mod_canvas */
    root = gnome_canvas_root (GNOME_CANVAS (TD_MOD_CANVAS (mod_child)->widget_data));
  else
    if (TD_IS_MOD_GANTT (mod_child)) /*** mod_gantt */
      root = gnome_canvas_root (GNOME_CANVAS (TD_MOD_GANTT (mod_child)->widget_data));
  if (!root)
    {
      td_app_message (_("Reading module"), g_strdup_printf (_("Reading module : module '%s' unreadable for this export"), TD_MOD (mod)->name), TD_MSG_FAILED);
      td_app_message (NULL, _("Exporting SVG file"), TD_MSG_END);
      return FALSE;
    }

  /*** Vrif de la prsence du fichier - Checking the presence of file */
  fp = fopen (file, "w");
  if (!fp)
    {
      td_app_message (_("Opening file"), NULL, TD_MSG_FAILED);
      td_app_message (NULL, _("Exporting SVG file"), TD_MSG_END);
      return FALSE;
    }
  fclose (fp);

  /*** Go ! */
  doc = xmlNewDoc ("1.0");
  doc->standalone = FALSE;
  xmlCreateIntSubset (doc, "svg", td_filter_custom_value ("gfx_svg", "document", "dtd", "name"), td_filter_custom_value ("gfx_svg", "document", "dtd", "url"));
  doc->xmlRootNode = xmlNewDocNode (doc, NULL, "svg", NULL);
  node_xml_root = doc->xmlRootNode;
  xmlSetProp (node_xml_root, "width", td_filter_custom_value ("gfx_svg", "picture", "size", "width"));
  xmlSetProp (node_xml_root, "height", td_filter_custom_value ("gfx_svg", "picture", "size", "height"));
  /* xmlSetProp (node, "viewBox", "0 0 1000 1000"); */
  title = td_app_custom_value ("filter", "general", "title");
  title = td_string_replace (title, "$file", TD_DB_CONNECT (TD_APP(APP)->connect)->name);
  title = td_string_replace (title, "$module", TD_MOD (mod)->name_intl);
  node_xml = xmlNewChild (node_xml_root, NULL, "title", title);
  node_xml = xmlNewChild (node_xml_root, NULL, "desc", td_app_custom_value ("filter", "general", "description"));

  /*** Styles */
  /* FIXME: problme avec sketch : +tards */
  /* <style type="text/css"><![CDATA[ */
  /*     .Border { fill:none; stroke:blue; stroke-width:1 } */
  /*     .Connect { fill:none; stroke:#888888; stroke-width:2 } */
  /*     .SamplePath { fill:none; stroke:red; stroke-width:5 } */
  /*     .EndPoint { fill:none; stroke:#888888; stroke-width:2 } */
  /*     .CtlPoint { fill:#888888; stroke:none } */
  /*     .AutoCtlPoint { fill:none; stroke:blue; stroke-width:4 } */
  /*     .Label { font-size:22; font-family:Verdana } */
  /*   ]]></style> */

  /*** Marques - Markers */
  /* FIXME: problme avec sketch : +tards */
  /*  </def> */
  /*  <marker id="Triangle" */
  /*        viewBox="0 0 10 10" refX="0" refY="5"  */
  /*        markerUnits="strokeWidth" */
  /*        markerWidth="4" markerHeight="3" */
  /*        orient="auto"> */
  /*  <path d="M 0 0 L 10 5 L 0 10 z" /> */
  /*  </marker> */
  /*  </defs> */

  /*** Cadre - Frame */
  if (TD_IS_MOD_GANTT (mod_child)) /*** mod_gantt */
    draw_timeruler (doc, node_xml_root, gnome_canvas_root (GNOME_CANVAS (TD_TIMERULER (TD_MOD_GANTT (mod_child)->timeruler)->widget)), mod_child);

  /*** Cavenas - Canvas */
  draw_canvas (doc, node_xml_root, root, mod_child);

  /*** Enregistrement - Writing */
  if (xmlSaveFile (file, doc) < 0)
    {
      td_app_message (_("Writing file"), NULL, TD_MSG_FAILED);
      xmlFreeDoc (doc);
      td_app_message (NULL, _("Exporting SVG file"), TD_MSG_END);
      return FALSE;
    }
  xmlFreeDoc (doc);
  td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Exporting SVG file"), file), TD_MSG_DONE);
  td_app_message (NULL, _("Exporting SVG file"), TD_MSG_END);
  return TRUE;
}
