/*****************************************************************************/
/* main.h : Donnes globales et fentre principale
 * main.h : Global data and main window
 *
 *
 * Greffon ToutDoux : Filtre PSTricks
 * ToutDoux's plug-in : PSTricks filter
 * Copyright (c) 2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#include <toutdoux.h>

/*****************************************************************************/
/*** Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void);
GtkObject *plugins_init (int mod_id);
void plugins_destroy (gpointer user_data);
gchar *unit (gchar* value);

/*****************************************************************************/
/*** Document */
/*****************************************************************************/
void definition_document (FILE *fp, GtkObject *mod);
void draw_document (FILE *fp, GtkObject *mod_child);

/*****************************************************************************/
/*** Image - Picture */
/*****************************************************************************/
void draw_picture (FILE *fp, GtkObject *mod_child);

/*****************************************************************************/
/*** Cadre - Frame */
/*****************************************************************************/
void definition_frame (FILE *fp);
void definition_timeruler (FILE *fp);
void draw_timeruler (FILE *fp, GtkObject *mod);

/*****************************************************************************/
/*** Cavenas - Canvas  */
/*****************************************************************************/
void definition_canvas (FILE *fp);
void draw_canvas (FILE *fp, GtkObject *mod_child, GnomeCanvasGroup *root);
void draw_canvas_item (FILE *fp, GtkObject *mod_child, GnomeCanvasItem *item);

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/
gboolean plugins_export (GtkObject *mod, gchar *file);

/*****************************************************************************/
/*** Impression - Printing */
/*****************************************************************************/
gboolean plugins_print (GtkObject *mod, gchar *file);


