/*****************************************************************************/
/* main.h : Donnes globales et fentre principale
 * main.h : Global data and main window
 *
 *
 * Greffon ToutDoux : gantt : Diagramme GANTT
 * ToutDoux's plug-in : gantt : GANTT diagram
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#include <toutdoux.h>

/*****************************************************************************/
/*** Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void);
GtkObject *plugins_init (int mod_id, gchar *mod_name);
void plugins_refresh (GtkObject *mod, GtkObject *mod_gantt);
void plugins_symbol_def (GtkObject *mod_gantt);

/*****************************************************************************/
/*** Node haut niveau - Node high level */
/*****************************************************************************/
void add_link (GtkObject *mod_gantt, GnomeCanvasItem *parent, GnomeCanvasItem *node, int parent_id, int node_id);
void remove_link (GtkObject *mod_gantt);
GnomeCanvasGroup *add_node (GtkObject *mod_gantt, GnomeCanvasGroup *item_parent, GnomeCanvasGroup *item_sibling, GList *row);
void update_node (GtkObject *mod_gantt, GnomeCanvasGroup *item);
void remove_node (GtkObject *mod_gantt, GnomeCanvasGroup *item);

/*****************************************************************************/
/* Node bas niveau - Node low level */
/*****************************************************************************/
void expand_node (GnomeCanvasGroup *node, GtkObject *mod_gantt);
void collapse_node (GnomeCanvasGroup *node, GtkObject *mod_gantt);
void link_setup (GtkObject *mod_gantt, GnomeCanvasItem *item);
void link_event (GnomeCanvasItem *item, GdkEvent *event, GtkObject *mod_gantt);
void handle_setup (GtkObject *mod_gantt, GnomeCanvasGroup *handle);
void handle_event (GnomeCanvasGroup *handle, GdkEvent *event, GtkObject *mod_gantt);
void node_setup (GtkObject *mod_gantt, GnomeCanvasItem *item);
void node_event (GnomeCanvasItem *item, GdkEvent *event, GtkObject *mod_gantt);
int dnd_copy (GtkObject *mod_gantt, int drag_id, int id_parent, int id_sibling);
void draw_links (GtkObject *mod_gantt, GnomeCanvasItem *node, int id_node);
void draw_dnd_line (GtkObject *mod_gantt, int item_x, int item_y);
GList *data_node (GtkObject *mod_gantt, int node_id);
GtkObject *data_node_parent (GtkObject *mod_gantt, int node_id);

/*****************************************************************************/
/*** Etablis - Benchs */
/*****************************************************************************/
void plugins_bench_refresh (GtkObject *mod, GtkObject *mod_gantt);
void plugins_etabliste_refresh (GtkObject *mod, GtkObject *mod_gantt);
void plugins_bench_action (GtkObject *mod, gchar *value, gchar *table_field, int bench_id);
void plugins_etabliste_action (GtkObject *mod, gchar *value, gchar *table_field, int etabliste_id);

/*****************************************************************************/
/*** Menu */
/*****************************************************************************/
void menu_def (GtkObject *mod);
void plugins_menu_refresh (GtkObject *mod, GtkObject *mod_gantt);
void plugins_menu_action (GtkObject *mod, int menu_id);
void plugins_menu_link_action (GtkObject *mod, int menu_id);
