/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : Arbre
 * ToutDoux's plug-in : Tree
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "main.h"

/*****************************************************************************/
/*** Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("Tree"),
		  "type", _("view"),
		  "version", "1.0.2",
		  "authors", "Philippe Roy <ph_roy@toutdoux.org>",
		  "category1", _("general"),
		  "category2", _("view"),
		  "category3", _("tree"),
		  "copyright", "Copyright (c) 2000-2001 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"),
		  "icon", "icon_tree.xpm", NULL);
  return ret;
}

GtkObject *plugins_init (int mod_id, gchar *mod_name)
{
  GtkObject *mod;
  GtkObject *child;

  /*** Module */
  mod = td_mod_new();
  if (!mod_name)
    mod_name = _("Tree"),
  gtk_object_set (GTK_OBJECT (mod),
		  "name", "tree",
		  "name_intl", mod_name,
		  "id", mod_id,
		  "fields", "*", NULL);
  td_mod_set_about (TD_MOD (mod), plugins_about_def());

  /*** Dfinitions - Definitions */
  child = td_mod_tree_new();
  gtk_object_set (GTK_OBJECT (child),
		  "name", "tree",
		  "name_intl", _("Tree"),
		  "reorderable", TRUE,
		  "table", "item",
		  "table_tree", "item_tree", NULL);
  td_mod_add_child (TD_MOD (mod), child);
  menu_def (mod);

  /*** Cration - Create */
  td_mod_create (TD_MOD (mod));
  return mod;
}

/*****************************************************************************/
/*** Etabli - Bench */
/*****************************************************************************/
void plugins_bench_refresh (GtkObject *mod, GtkObject *mod_tree)
{
  td_database_set_current (g_strdup_printf ("SELECT %s FROM item WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
}

void plugins_etabliste_refresh (GtkObject *mod, GtkObject *mod_canvas)
{
}

void plugins_bench_action (GtkObject *mod, gchar *value, gchar *table_field, int bench_id)
{
  TD_FLAG_NO_REFRESH_NODE = TRUE;
  if (td_database_command (g_strdup_printf ("UPDATE item SET %s = %s WHERE td_id = %d;", table_field, td_database_adaptvalue (value, "text"), CURRENT_ID)))
    {
      td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 0)));
    }
  TD_FLAG_NO_REFRESH_NODE = FALSE;
}

void plugins_etabliste_action (GtkObject *mod, gchar *value, gchar *table_field, int etabliste_id)
{
}

/*****************************************************************************/
/*** Fonction - Functions */
/*****************************************************************************/
void plugins_function_action (GtkObject *mod)
{
  TD_FLAG_NO_REFRESH_NODE = TRUE;
  td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)));
  td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 0)));
  TD_FLAG_NO_REFRESH_NODE = FALSE;
}

/*****************************************************************************/
/*** Menu */
/*****************************************************************************/
void menu_def (GtkObject *mod)
{
  GtkObject *menu[6];

  /*** Crer - Create */
  menu[0] = td_mod_menu_new();
  gtk_object_set (GTK_OBJECT (menu[0]), 
		  "label", _("Create"),
		  "icon", "list_new.xpm",
		  "query_visible", "TD_CURRENT (null);", NULL);
  td_mod_add_menu (TD_MOD (mod), menu[0]);

  menu[1] = td_mod_menu_new();
  gtk_object_set (GTK_OBJECT (menu[1]), 
		  "label", _("Create"),
		  "icon", "list_new.xpm",
		  "query_visible", "TD_CURRENT td_id;", NULL);
  td_mod_add_menu (TD_MOD (mod), menu[1]);

  menu[2] = td_mod_menu_new();
  gtk_object_set (GTK_OBJECT (menu[2]), 
		  "label", _("Insert-Create"),
		  "icon", "list_empty.xpm",
		  "query_visible", "TD_CURRENT td_id;", NULL);
  td_mod_add_menu (TD_MOD (mod), menu[2]);
  td_mod_add_menu (TD_MOD (mod), td_mod_menu_new());

  /*** Supprimer - Remove */
  menu[4] = td_mod_menu_new();
  gtk_object_set (GTK_OBJECT (menu[4]), 
		  "label", _("Remove"),
		  "icon", "list_trash.xpm", 
		  "query_visible", "TD_CURRENT td_id;", NULL);
  td_mod_add_menu (TD_MOD (mod), menu[4]);

  menu[5] = td_mod_menu_new();
  gtk_object_set (GTK_OBJECT (menu[5]), 
		  "query_visible", "TD_CURRENT td_id;", NULL);
  td_mod_add_menu (TD_MOD (mod), menu[5]);
}

void plugins_menu_refresh (GtkObject *mod, GtkObject *mod_tree)
{
  td_database_set_current (g_strdup_printf ("SELECT %s FROM item WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
}

void plugins_menu_action (GtkObject *mod, int menu_id)
{
  GtkCTreeNode *node;
  TdModTree *mod_tree;
  GList *row;
  int id_sibling;
  int id_parent;
  mod_tree = TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0));

  /*** Action */
  switch (menu_id)
    {
    
    case 0:
      td_database_insert (g_strdup_printf ("INSERT INTO %s (td_obso) VALUES ('f');", mod_tree->table), mod_tree->table);
      row = td_database_row (g_strdup_printf ("SELECT %s FROM %s WHERE td_id = %d;", TD_MOD (mod)->fields, mod_tree->table, CURRENT_ID));
      node = td_mod_tree_add_node (mod_tree, NULL, NULL, row);
      td_database_command (g_strdup_printf ("UPDATE %s SET td_id_sibling = %d WHERE (td_id_parent = 0) AND (td_id_sibling = 0);", mod_tree->table_tree, CURRENT_ID));
      td_database_insert (g_strdup_printf ("INSERT INTO %s (td_id, td_id_parent, td_id_sibling) VALUES (%d, 0, 0);", mod_tree->table_tree, CURRENT_ID), mod_tree->table_tree);
      break;

    case 1:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert (g_strdup_printf ("INSERT INTO %s (td_obso) VALUES ('f');", mod_tree->table), mod_tree->table);
      row = td_database_row (g_strdup_printf ("SELECT %s FROM %s WHERE td_id = %d;", TD_MOD (mod)->fields, mod_tree->table, CURRENT_ID));
      node = td_mod_tree_add_node (mod_tree, mod_tree->selected, NULL, row);
      gtk_ctree_expand (GTK_CTREE (mod_tree->widget_data), mod_tree->selected);
      td_database_command (g_strdup_printf ("UPDATE %s SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", mod_tree->table_tree, CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO %s (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", mod_tree->table_tree, CURRENT_ID, CURRENT_ID_PARENT), mod_tree->table_tree);
      break;

    case 2:
      id_sibling = CURRENT_ID;
      id_parent = atoi (td_database_value (g_strdup_printf ("SELECT td_id_parent FROM %s WHERE td_id = %d;", mod_tree->table_tree, id_sibling)));
      td_database_insert (g_strdup_printf ("INSERT INTO %s (td_obso) VALUES ('f');", mod_tree->table), mod_tree->table);
      row = td_database_row (g_strdup_printf ("SELECT %s FROM %s WHERE td_id = %d;", TD_MOD (mod)->fields, mod_tree->table, CURRENT_ID));
      node = td_mod_tree_add_node (mod_tree, GTK_CTREE_ROW (mod_tree->selected)->parent, mod_tree->selected, row);
      td_database_command (g_strdup_printf ("UPDATE %s SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = %d);", mod_tree->table_tree, CURRENT_ID, id_parent, id_sibling));
      td_database_insert (g_strdup_printf ("INSERT INTO %s (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, %d);", mod_tree->table_tree, CURRENT_ID, id_parent, id_sibling), mod_tree->table_tree);
      break;

    case 4:
      id_sibling = atoi (td_database_value (g_strdup_printf ("SELECT td_id_sibling FROM %s WHERE td_id = %d;", mod_tree->table_tree, CURRENT_ID)));
      id_parent = atoi (td_database_value (g_strdup_printf ("SELECT td_id_parent FROM %s WHERE td_id = %d;", mod_tree->table_tree, CURRENT_ID)));
      td_database_command (g_strdup_printf ("UPDATE %s SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = %d);", mod_tree->table_tree, id_sibling, CURRENT_ID_PARENT, CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM %s WHERE td_id IN (SELECT td_id FROM item_tree WHERE td_id_parent = %d);", mod_tree->table, CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM %s WHERE td_id = %d;", mod_tree->table_tree, CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM %s WHERE td_id_parent = %d;", mod_tree->table_tree, CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM %s WHERE td_id = %d;", mod_tree->table, CURRENT_ID));
      gtk_ctree_remove_node (GTK_CTREE (mod_tree->widget_data), mod_tree->selected);
      CURRENT_ID = 0;
      CURRENT_ROW = NULL;
      mod_tree->selected = NULL;
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 0)));
      break;
    default:
      break;
    }
}

void plugins_menu_link_action (GtkObject *mod, int menu_id)
{
}
