/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : Rseau
 * ToutDoux's plug-in : Network
 * Copyright (c) 2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "main.h"

/*****************************************************************************/
/* Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("Network"),
		  "type", _("view"),
		  "version", "1.0.2",
		  "authors", "Philippe Roy <ph_roy@toutdoux.org>",
		  "category1", _("general"),
		  "category2", _("view"),
		  "category3", _("network"),
		  "copyright", "Copyright (c) 2001 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"),
		  "icon", "icon_network.xpm", NULL);
  return ret;
}

GtkObject *plugins_init (int mod_id, gchar *mod_name)
{
  GtkObject *mod;
  GtkObject *canvas;

  /*** Module */
  mod = td_mod_new();
  if (!mod_name)
    mod_name = _("Network");
  gtk_object_set (GTK_OBJECT (mod),
		  "name", "network",
		  "name_intl", mod_name,
		  "id", mod_id,
		  "fields", "name, td_id, td_obso, td_x, td_y", NULL);
  td_mod_set_about (TD_MOD (mod), plugins_about_def());

  /*** Dfinitions - Definitions */
  canvas = td_mod_canvas_new();
  gtk_object_set (GTK_OBJECT (canvas), 
		  "name", "network",
		  "name_intl", _("Network"),
		  "reorderable", TRUE,
		  "customize", TRUE,
		  "table", "item",
		  "table_net", "item_net",
		  "column_oid", 1, NULL);
  td_mod_add_child (TD_MOD (mod), canvas);
  menu_def (mod);

  /*** Cration - Create */
  td_mod_create (TD_MOD (mod));
  return mod;
}

/*****************************************************************************/
/*** Node */
/*****************************************************************************/
void plugins_refresh (GtkObject *mod, GtkObject *mod_canvas)
{
  GtkObject *datatable;
  int i;

  /*** Nodes */
  datatable = td_database_select (g_strdup_printf ("SELECT %s FROM %s;", TD_MOD (mod)->fields, TD_MOD_CANVAS (mod_canvas)->table));
  for (i=0; i<g_list_length (TD_DB_DATATABLE (datatable)->item); i++)
    add_node (mod_canvas, g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i));

  /*** Liens - Links */
  datatable = td_database_select (g_strdup_printf ("SELECT b.td_id, b.td_x, b.td_y, c.td_id, c.td_x, c.td_y FROM %s a, %s b, %s c WHERE b.td_id=a.td_id_parent AND c.td_id=a.td_id;", 
						   TD_MOD_CANVAS (mod_canvas)->table_net, TD_MOD_CANVAS (mod_canvas)->table, TD_MOD_CANVAS (mod_canvas)->table));
  for (i=0; i<g_list_length (TD_DB_DATATABLE (datatable)->item); i++)
    add_link (mod_canvas, g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i));
}

void plugins_symbol_def (GtkObject *mod_canvas)
{
}

/*****************************************************************************/
/*** Node haut niveau - Node high level */
/*****************************************************************************/
void add_link (GtkObject *mod_canvas, GList *row)
{
  GnomeCanvasGroup *root;
  GnomeCanvasItem *line;
  GnomeCanvasItem *node;
  GnomeCanvasItem *node2;
  GnomeCanvasPoints *points;
  root = gnome_canvas_root (GNOME_CANVAS (TD_MOD_CANVAS (mod_canvas)->widget_data));

  /*** Ligne - Line */
  points = gnome_canvas_points_new (2);
  points->coords[0] = atoi (g_list_nth_data (row, 1));
  points->coords[1] = atoi (g_list_nth_data (row, 2));
  points->coords[2] = atoi (g_list_nth_data (row, 4));
  points->coords[3] = atoi (g_list_nth_data (row, 5));
  node = gnome_canvas_get_item_at (GNOME_CANVAS (TD_MOD_CANVAS (mod_canvas)->widget_data), points->coords[1], points->coords[2]);
  node2 = gnome_canvas_get_item_at (GNOME_CANVAS (TD_MOD_CANVAS (mod_canvas)->widget_data), points->coords[4], points->coords[5]);
  line = gnome_canvas_item_new (root, gnome_canvas_line_get_type(),
				"points", points,
				"fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_NORMAL],
				"width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_NORMAL],
				"line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_NORMAL],
				"cap_style", TD_FACE_LINK_LINE_CAP,
				"join_style", TD_FACE_LINK_LINE_JOIN,
				"last_arrowhead", TRUE,
				"arrow_shape_a", TD_FACE_LINK_ARROW[0],
				"arrow_shape_b", TD_FACE_LINK_ARROW[0]-TD_FACE_LINK_ARROW[1],
				"arrow_shape_c", TD_FACE_LINK_ARROW[2], NULL);
  gtk_object_set_user_data (GTK_OBJECT (line), g_strdup_printf ("%d,%d",
								atoi (g_list_nth_data (row, 0)),
								atoi (g_list_nth_data (row, 3))));
  gnome_canvas_item_lower_to_bottom (line);
  td_mod_canvas_draw_link (mod_canvas, line, node, node2);
  link_setup (mod_canvas, GNOME_CANVAS_ITEM (line));
  gnome_canvas_points_free (points);
}

void remove_link (GtkObject *mod_canvas)
{
  int i;
  for (i=0; i<g_list_length (TD_MOD_CANVAS (mod_canvas)->selected_link_parent); i++)
    gtk_object_destroy (GTK_OBJECT (g_list_nth_data (TD_MOD_CANVAS (mod_canvas)->selected_link_parent, i)));
  for (i=0; i<g_list_length (TD_MOD_CANVAS (mod_canvas)->selected_link_child); i++)
    gtk_object_destroy (GTK_OBJECT (g_list_nth_data (TD_MOD_CANVAS (mod_canvas)->selected_link_child, i)));
  TD_MOD_CANVAS (mod_canvas)->selected_link_parent = NULL;
  TD_MOD_CANVAS (mod_canvas)->selected_link_child = NULL;
  CURRENT_ID = 0;
  CURRENT_ID_PARENT = 0;
}

void add_node (GtkObject *mod_canvas, GList *row)
{
  GnomeCanvasGroup *root;
  GnomeCanvasGroup *group;
  GnomeCanvasItem *line;
  GnomeCanvasPoints *points;
  GList *row_parent;
  GtkObject *draw[2];
  gchar *txt_tmp;
  int x, y;
  root = gnome_canvas_root (GNOME_CANVAS (TD_MOD_CANVAS (mod_canvas)->widget_data));

  /*** Action */
  x = atoi (g_list_nth_data (row, 3));
  y = atoi (g_list_nth_data (row, 4));
  group = GNOME_CANVAS_GROUP (gnome_canvas_item_new (root, gnome_canvas_group_get_type(), "x", (double) x, "y", (double) y, NULL));
  node_setup (mod_canvas, GNOME_CANVAS_ITEM (group));
  gtk_object_set_user_data (GTK_OBJECT (group), g_list_nth_data (row, TD_MOD_CANVAS (mod_canvas)->column_oid));

  /*** Cadre - Frame */
  txt_tmp = g_list_nth_data (row, 0);
  node_setup (mod_canvas, GNOME_CANVAS_ITEM (group));
  gnome_canvas_item_new (group, gnome_canvas_rect_get_type(),
			 "x1", (double) -10-gdk_string_width (gtk_widget_get_default_style()->font, txt_tmp)/2,
			 "y1", (double) -10-gdk_string_height (gtk_widget_get_default_style()->font, txt_tmp)/2,
			 "x2", (double) 10+gdk_string_width (gtk_widget_get_default_style()->font, txt_tmp)/2,
			 "y2", (double) 10+(gdk_string_height (gtk_widget_get_default_style()->font, txt_tmp)/2),
			 "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_NORMAL],
			 "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_NORMAL],
			 "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_NORMAL], NULL);

  /*** Nom - Name */
  gnome_canvas_item_new (group, gnome_canvas_text_get_type(),
			 "text", txt_tmp,
			 "x", (double) 0,
			 "y", (double) 0,
			 "font_gdk", gtk_widget_get_default_style()->font,
			 "justification", GTK_JUSTIFY_CENTER,
			 "anchor", GTK_ANCHOR_CENTER,
			 "fill_color_gdk", &TD_FACE_NODE_TEXT_COLOR[TD_FACE_NORMAL], NULL);
}

void update_node (GtkObject *mod_canvas)
{
  GList *row;
  gchar *txt_tmp;
  row = td_database_row (g_strdup_printf ("SELECT name FROM %s WHERE td_id = %d;", TD_MOD_CANVAS (mod_canvas)->table, CURRENT_ID));

  /*** Cadre - Frame */
  txt_tmp = g_list_nth_data (row, 0);
  gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (TD_MOD_CANVAS (mod_canvas)->selected)->item_list, 0),
			 "x1", (double) -10-gdk_string_width (gtk_widget_get_default_style()->font, txt_tmp)/2,
			 "y1", (double) -10-gdk_string_height (gtk_widget_get_default_style()->font, txt_tmp)/2,
			 "x2", (double) 10+gdk_string_width (gtk_widget_get_default_style()->font, txt_tmp)/2,
			 "y2", (double) 10+(gdk_string_height (gtk_widget_get_default_style()->font, txt_tmp)/2), NULL);

  /*** Nom - Name */
  gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (TD_MOD_CANVAS (mod_canvas)->selected)->item_list, 1), "text", txt_tmp, NULL);
}

void remove_node (GtkObject *mod_canvas, GnomeCanvasGroup *item)
{
  if (item == TD_MOD_CANVAS (mod_canvas)->selected)
    {
      CURRENT_ID = 0;
      CURRENT_ID_PARENT = 0;
      CURRENT_ROW = NULL;
      TD_MOD_CANVAS (mod_canvas)->selected = NULL;
    }
  gtk_object_destroy (GTK_OBJECT (item));
}

/*****************************************************************************/
/*** Node bas niveau - Node low level */
/*****************************************************************************/
void link_setup (GtkObject *mod_canvas, GnomeCanvasItem *item)
{
  gtk_signal_connect (GTK_OBJECT (item), "event", GTK_SIGNAL_FUNC (link_event), mod_canvas);
}

void link_event (GnomeCanvasItem *item, GdkEvent *event, GtkObject *mod_canvas)
{
  gboolean bool_tmp;
  int i;
  switch (event->type) 
    {
    case GDK_ENTER_NOTIFY:
      gnome_canvas_item_set (item, 
			     "fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_PRELIGHT],
			     "width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_PRELIGHT],
			     "line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_PRELIGHT], NULL);
      break;
    case GDK_LEAVE_NOTIFY:
      bool_tmp = FALSE;
      for (i=0; i<g_list_length (TD_MOD_CANVAS (mod_canvas)->selected_link_parent); i++)
	if (g_list_nth_data (TD_MOD_CANVAS (mod_canvas)->selected_link_parent, i) == item)
	  {

	    /*** Selectionn - Selected */
	    if (!TD_MOD_CANVAS (mod_canvas)->selected)
	      gnome_canvas_item_set (item,
				     "fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_SELECTED],
				     "width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_SELECTED],
				     "line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_SELECTED], NULL);

	    /*** Parent */
	    else
	      gnome_canvas_item_set (item,
				     "fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_PARENT],
				     "width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_PARENT],
				     "line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_PARENT], NULL);
	    bool_tmp = TRUE;
	    break;
	  }

      /*** Enfant - Child */
      if (!bool_tmp)
	for (i=0; i<g_list_length (TD_MOD_CANVAS (mod_canvas)->selected_link_child); i++)
	  if (g_list_nth_data (TD_MOD_CANVAS (mod_canvas)->selected_link_child, i) == item)
	    {
	      gnome_canvas_item_set (item,
				     "fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_CHILD],
				     "width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_CHILD],
				     "line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_CHILD], NULL);
	      bool_tmp = TRUE;
	      break;
	    }

      /*** Normal */
      if (!bool_tmp)
	gnome_canvas_item_set (item,
			       "fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_NORMAL],
			       "width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_NORMAL],
			       "line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_NORMAL], NULL);
      break;
    default:
      break;
    }
}

void node_setup (GtkObject *mod_canvas, GnomeCanvasItem *item)
{
  gtk_signal_connect (GTK_OBJECT (item), "event", GTK_SIGNAL_FUNC (node_event), mod_canvas);
}

void node_event (GnomeCanvasItem *item, GdkEvent *event, GtkObject *mod_canvas)
{
  GdkEventButton *bevent;
  GnomeCanvasGroup *root;
  GnomeCanvasItem *node;
  GnomeCanvasItem *node2;
  GnomeCanvasItem *line;
  GList *row;
  GList *row_parent;
  GnomeCanvasPoints *points;
  GdkCursor *fleur;
  double new_x, new_y, item_x, item_y, x, y;
  int i, cx, cy;
  GdkCursor *cursor;
  int delta_x, delta_y;
  gchar *txt_tmp;
  gboolean bool_tmp;
  item_x = event->button.x;
  item_y = event->button.y;
  gnome_canvas_item_w2i (item->parent, &item_x, &item_y);
  bevent = (GdkEventButton*) event;
  root = gnome_canvas_root (GNOME_CANVAS (TD_MOD_CANVAS (mod_canvas)->widget_data));
  switch (event->type) 
    {

      /*** Eclairage - Prelight */
    case GDK_ENTER_NOTIFY:
      if (GNOME_IS_CANVAS_GROUP (item))
	{
  	  gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 0), 
				 "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_PRELIGHT],
				 "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_PRELIGHT],
				 "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_PRELIGHT], NULL);
 	  gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 1), "fill_color_gdk", &TD_FACE_NODE_TEXT_COLOR[TD_FACE_PRELIGHT], NULL);
	}
      break;
    case GDK_LEAVE_NOTIFY:
      if (TD_MOD_CANVAS (mod_canvas)->selected)
	{

	  /*** Selectionn - Selected */
	  bool_tmp = FALSE;
	  if (GNOME_CANVAS_ITEM (TD_MOD_CANVAS (mod_canvas)->selected) == item)
	    {
	      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 0),
				     "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_SELECTED],
				     "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_SELECTED],
				     "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_SELECTED], NULL);
	      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 1), "fill_color_gdk", &TD_FACE_NODE_TEXT_COLOR[TD_FACE_SELECTED], NULL);
	      bool_tmp = TRUE;
	      break;
	    }

	  /*** Parent */
	  if (bool_tmp)
	    break;
	  for (i=0; i<g_list_length (TD_MOD_CANVAS (mod_canvas)->selected_parent); i++)
	    if (g_list_nth_data (TD_MOD_CANVAS (mod_canvas)->selected_parent, i) == item)
	      {
		gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 0),
				       "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_PARENT],
				       "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_PARENT],
				       "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_PARENT], NULL);
		gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 1), "fill_color_gdk", &TD_FACE_NODE_TEXT_COLOR[TD_FACE_PARENT], NULL);
		bool_tmp = TRUE;
		break;
	      }

	  /*** Enfant - Child */
	  if (bool_tmp)
	    break;
	  for (i=0; i<g_list_length (TD_MOD_CANVAS (mod_canvas)->selected_child); i++)
	    if (g_list_nth_data (TD_MOD_CANVAS (mod_canvas)->selected_child, i) == item)
	      {
		gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 0),
				       "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_CHILD],
				       "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_CHILD],
				       "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_CHILD], NULL);
		gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 1), "fill_color_gdk", &TD_FACE_NODE_TEXT_COLOR[TD_FACE_CHILD], NULL);
		bool_tmp = TRUE;
		break;
	      }

	  /*** Normal */
	  if (bool_tmp)
	    break;
	  gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 0),
				 "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_NORMAL],
				 "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_NORMAL],
				 "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_NORMAL], NULL);
	  gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 1), "fill_color_gdk", &TD_FACE_NODE_TEXT_COLOR[TD_FACE_NORMAL], NULL);
	}

      /*** Normal */
      else
	gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 0),
			       "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_NORMAL],
			       "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_NORMAL],
			       "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_NORMAL], NULL);
      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (item)->item_list, 1), "fill_color_gdk", &TD_FACE_NODE_TEXT_COLOR[TD_FACE_NORMAL], NULL);
      break;

      /*** Selection */
    case GDK_BUTTON_PRESS:

      /*** Dplacement de la node - Node moving */
      if ((gtdk_mouse_event (bevent, TD_EVENT_MOUSE_SELECT)) && (GNOME_IS_CANVAS_GROUP (item)))
	{
	  TD_MOD_CANVAS (mod_canvas)->dragging_x = item_x;
	  TD_MOD_CANVAS (mod_canvas)->dragging_y = item_y;
	  TD_MOD_CANVAS (mod_canvas)->init_x = item_x;
	  TD_MOD_CANVAS (mod_canvas)->init_y = item_y;
	  TD_MOD_CANVAS (mod_canvas)->dragging = 1;
	}

      /*** Liaison - Link */
      else
	if ((gtdk_mouse_event (bevent, TD_EVENT_MOUSE_LINK)) && (GNOME_IS_CANVAS_GROUP (item)))
	  {
	    cursor = gtdk_cursor (TD_STOCK_CURSOR_PENCIL, TD_STOCK_CURSOR_PENCIL_MASK);
	    gnome_canvas_item_grab (item, GDK_POINTER_MOTION_MASK | GDK_BUTTON_RELEASE_MASK, cursor, event->button.time);
	    gdk_cursor_destroy (cursor);
	    TD_MOD_CANVAS (mod_canvas)->dragging_x = item_x;
	    TD_MOD_CANVAS (mod_canvas)->dragging_y = item_y;
	    TD_MOD_CANVAS (mod_canvas)->dragging = 2;
	    points = gnome_canvas_points_new (2);
	    points->coords[0] = item_x;
	    points->coords[1] = item_y;
	    points->coords[2] = item_x;
	    points->coords[3] = item_y;
	    TD_MOD_CANVAS (mod_canvas)->link = gnome_canvas_item_new (root, gnome_canvas_line_get_type(),
								      "points", points,
								      "fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_NORMAL],
								      "width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_NORMAL],
								      "line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_NORMAL], NULL);
	    gtk_object_set_user_data (GTK_OBJECT (TD_MOD_CANVAS (mod_canvas)->link), "link");
	    gnome_canvas_points_free (points);
	  }
      break;

      /*** Dplacement - Move */
    case GDK_MOTION_NOTIFY:
      switch (TD_MOD_CANVAS (mod_canvas)->dragging)
	{
	
	  /*** Dplacement - Move */
	case 1:
	  if ((TD_MOD_CANVAS (mod_canvas)->init_x == TD_MOD_CANVAS (mod_canvas)->dragging_x) &&
	      (TD_MOD_CANVAS (mod_canvas)->init_y == TD_MOD_CANVAS (mod_canvas)->dragging_y))
	    {
	      cursor = gtdk_cursor (TD_STOCK_CURSOR_MOVE, TD_STOCK_CURSOR_MOVE_MASK);
	      gnome_canvas_item_grab (item, GDK_POINTER_MOTION_MASK | GDK_BUTTON_RELEASE_MASK, cursor, event->button.time);
	      gdk_cursor_destroy (cursor);
	    }
	  new_x = item_x;
	  new_y = item_y;
	  gnome_canvas_item_move (item, new_x - TD_MOD_CANVAS (mod_canvas)->dragging_x, new_y - TD_MOD_CANVAS (mod_canvas)->dragging_y);
	  for (i=0; i<g_list_length (TD_MOD_CANVAS (mod_canvas)->selected_link_parent); i++)
	    td_mod_canvas_draw_link (mod_canvas, g_list_nth_data (TD_MOD_CANVAS (mod_canvas)->selected_link_parent, i), NULL, item);
	  for (i=0; i<g_list_length (TD_MOD_CANVAS (mod_canvas)->selected_link_child); i++)
	    td_mod_canvas_draw_link (mod_canvas, g_list_nth_data (TD_MOD_CANVAS (mod_canvas)->selected_link_child, i), item, NULL);
	  TD_MOD_CANVAS (mod_canvas)->dragging_x = new_x;
	  TD_MOD_CANVAS (mod_canvas)->dragging_y = new_y;
	  break;

	  /*** Liaison - Link */
	case 2:
	  new_x = item_x;
	  new_y = item_y;
	  points = gnome_canvas_points_new (2);
	  points->coords[0] = GNOME_CANVAS_LINE (TD_MOD_CANVAS (mod_canvas)->link)->coords[0];
	  points->coords[1] = GNOME_CANVAS_LINE (TD_MOD_CANVAS (mod_canvas)->link)->coords[1];
	  points->coords[2] = new_x;
	  points->coords[3] = new_y;
	  gnome_canvas_item_set (TD_MOD_CANVAS (mod_canvas)->link, "points", points, NULL);
	  gnome_canvas_points_free (points);
	  break;
	}
      break;

      /*** Application */
    case GDK_BUTTON_RELEASE:
      gnome_canvas_item_ungrab (item, event->button.time);
      switch (TD_MOD_CANVAS (mod_canvas)->dragging)
	{

	  /*** Dplacement de la node - Node moving */
	case 1:
	  delta_x = TD_MOD_CANVAS (mod_canvas)->dragging_x-TD_MOD_CANVAS (mod_canvas)->init_x;
	  delta_y = TD_MOD_CANVAS (mod_canvas)->dragging_y-TD_MOD_CANVAS (mod_canvas)->init_y;
	  td_database_command (g_strdup_printf ("UPDATE item SET td_x = %d, td_y = %d WHERE td_id = %d;",
						(int) atoi (td_database_current ("TD_CURRENT td_x;"))+delta_x,
						(int) atoi (td_database_current ("TD_CURRENT td_y;"))+delta_y, CURRENT_ID));
	  td_mod_modified (g_list_nth_data (TD_APP (APP)->mod_data, TD_MOD_CANVAS (mod_canvas)->id));
	  TD_MOD_CANVAS (mod_canvas)->dragging = FALSE;
	  break;

	  /*** Liaison - Link */
	case 2:

	  /*** Shunt */
	  gtk_object_destroy (GTK_OBJECT (TD_MOD_CANVAS (mod_canvas)->link));
	  TD_MOD_CANVAS (mod_canvas)->link = NULL;
	  node = item;
	  node2 = gnome_canvas_get_item_at (GNOME_CANVAS (TD_MOD_CANVAS (mod_canvas)->widget_data), item_x, item_y);
	  if ((!node2) || (GNOME_IS_CANVAS_LINE (node2)) || (GNOME_CANVAS_GROUP (node2->parent) == gnome_canvas_root (GNOME_CANVAS (TD_MOD_CANVAS (mod_canvas)->widget_data))))
	    {
	      TD_MOD_CANVAS (mod_canvas)->dragging = FALSE;
	      break;
	    }
	  node2 = node2->parent;
	  CURRENT_ID_PARENT = CURRENT_ID;
	  CURRENT_ID = atoi (gtk_object_get_user_data (GTK_OBJECT (node2)));
	  if (CURRENT_ID == CURRENT_ID_PARENT)
	    {
	      TD_MOD_CANVAS (mod_canvas)->dragging = FALSE;
	      break;
	    }
	  if ((td_database_value (g_strdup_printf ("SELECT td_id FROM %s WHERE td_id = %d AND td_id_parent = %d;", TD_MOD_CANVAS (mod_canvas)->table_net, CURRENT_ID, CURRENT_ID_PARENT))) ||
	      (td_database_value (g_strdup_printf ("SELECT td_id FROM %s WHERE td_id = %d AND td_id_parent = %d;", TD_MOD_CANVAS (mod_canvas)->table_net, CURRENT_ID_PARENT, CURRENT_ID))))
	    {
	      TD_MOD_CANVAS (mod_canvas)->dragging = FALSE;
	      break;
	    }

	  /*** Ligne - Line */
	  td_database_insert (g_strdup_printf ("INSERT INTO item_net (td_id, td_id_parent) VALUES (%d, %d);", CURRENT_ID, CURRENT_ID_PARENT), "item_net");
	  td_mod_modified (g_list_nth_data (TD_APP (APP)->mod_data, TD_MOD_CANVAS (mod_canvas)->id));
	  row = td_database_row (g_strdup_printf ("SELECT a.td_id, a.td_x, a.td_y, b.td_id, b.td_x, b.td_y FROM item a, item b WHERE a.td_id=%d AND b.td_id=%d;", CURRENT_ID_PARENT, CURRENT_ID));
	  add_link (GTK_OBJECT (mod_canvas), row);
	  TD_MOD_CANVAS (mod_canvas)->dragging = FALSE;
	  break;
	}
      break;
    default:
      break;
    }
}

/*****************************************************************************/
/*** Etablis - Benchs */
/*****************************************************************************/
void plugins_bench_refresh (GtkObject *mod, GtkObject *mod_canvas)
{
  td_database_set_current (g_strdup_printf ("SELECT %s FROM item WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
}

void plugins_etabliste_refresh (GtkObject *mod, GtkObject *mod_canvas)
{
}

void plugins_bench_action (GtkObject *mod, gchar *value, gchar *table_field, int bench_id)
{
  TD_FLAG_NO_REFRESH_NODE = TRUE;
  switch (bench_id)
    {
    case 0:
      td_database_command (g_strdup_printf ("UPDATE item SET name = %s WHERE td_id = %d;", td_database_adaptvalue (value, "text"), CURRENT_ID));
      update_node (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 0)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 0)));
      break;
    default:
      break;
    }
  TD_FLAG_NO_REFRESH_NODE = FALSE;
}

void plugins_etabliste_action (GtkObject *mod, gchar *value, gchar *table_field, int etabliste_id)
{
}

/*****************************************************************************/
/*** Fonction - Function */
/*****************************************************************************/
void plugins_function_action (GtkObject *mod)
{
  TD_FLAG_NO_REFRESH_NODE = TRUE;
  td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)));
  td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 0)));
  TD_FLAG_NO_REFRESH_NODE = FALSE;
}

/*****************************************************************************/
/*** Menu */
/*****************************************************************************/
void menu_def (GtkObject *mod)
{
  GtkObject *menu[5];
  GtkObject *menu_link[1];

  /*** Crer - Create */
  menu[0] = td_mod_menu_new();
  gtk_object_set (GTK_OBJECT (menu[0]),
		  "label", _("Create"),
		  "icon", "list_new.xpm",
		  "query_visible", "TD_CURRENT (null);", NULL);
  td_mod_add_menu (TD_MOD (mod), menu[0]);

  menu[1] = td_mod_menu_new();
  gtk_object_set (GTK_OBJECT (menu[1]),
		  "label", _("Create linked"),
		  "icon", "list_new.xpm",
		  "query_visible", "TD_CURRENT td_id;", NULL);
  td_mod_add_menu (TD_MOD (mod), menu[1]);
  td_mod_add_menu (TD_MOD (mod), td_mod_menu_new());

  /*** Supprimer - Remove */
  menu[3] = td_mod_menu_new();
  gtk_object_set (GTK_OBJECT (menu[3]),
		  "label", _("Remove"),
		  "icon", "list_trash.xpm",
		  "query_visible", "TD_CURRENT td_id;", NULL);
  td_mod_add_menu (TD_MOD (mod), menu[3]);

  menu[4] = td_mod_menu_new();
  gtk_object_set (GTK_OBJECT (menu[4]), "query_visible", "TD_CURRENT td_id;", NULL);
  td_mod_add_menu (TD_MOD (mod), menu[4]);

  /*** Menu des liens : Supprimer - Links menu : remove */
  menu_link[0] = td_mod_menu_new();
  gtk_object_set (GTK_OBJECT (menu_link[0]), 
		  "label", _("Remove"),
		  "icon", "list_trash.xpm", NULL);
  td_mod_add_menu_link (TD_MOD (mod), menu_link[0]);
  td_mod_add_menu_link (TD_MOD (mod), td_mod_menu_new());
}

void plugins_menu_refresh (GtkObject *mod, GtkObject *mod_canvas)
{
  td_database_set_current (g_strdup_printf ("SELECT %s FROM item WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
}

void plugins_menu_action (GtkObject *mod, int menu_id)
{
  GList *row;
  TdModCanvas *mod_canvas;
  int id_sibling;
  int id_parent;
  mod_canvas = TD_MOD_CANVAS (g_list_nth_data (TD_MOD (mod)->child, 0));
  switch (menu_id)
    {
    case 0:
      td_database_insert (g_strdup_printf ("INSERT INTO item (td_x, td_y) VALUES (%d, %d);", (int) TD_MOD_CANVAS (mod_canvas)->init_x, (int) TD_MOD_CANVAS (mod_canvas)->init_y), "item");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM item WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      add_node (GTK_OBJECT (mod_canvas), row);
      break;
      
    case 1:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert (g_strdup_printf ("INSERT INTO item (td_x, td_y) VALUES (%d, %d);", (int) TD_MOD_CANVAS (mod_canvas)->init_x, (int) TD_MOD_CANVAS (mod_canvas)->init_y), "item");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM item WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      add_node (GTK_OBJECT (mod_canvas), row);
      td_database_insert (g_strdup_printf ("INSERT INTO item_net (td_id, td_id_parent) VALUES (%d, %d);", CURRENT_ID, CURRENT_ID_PARENT), "item_net");
      row = td_database_row (g_strdup_printf ("SELECT b.td_id, b.td_x, b.td_y, c.td_id, c.td_x, c.td_y FROM item_net a, item b, item c WHERE b.td_id=%d AND c.td_id=%d;", CURRENT_ID, CURRENT_ID_PARENT));
      add_link (GTK_OBJECT (mod_canvas), row);
      break;

    case 3:
      td_database_command (g_strdup_printf ("DELETE FROM item_net WHERE td_id = %d;", CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM item_net WHERE td_id_parent = %d;", CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM item WHERE td_id = %d;", CURRENT_ID));
      remove_node (GTK_OBJECT (mod_canvas), GNOME_CANVAS_GROUP (mod_canvas->selected));
      remove_link (GTK_OBJECT (mod_canvas));
      break;
    default:
      break;
    }
}

void plugins_menu_link_action (GtkObject *mod, int menu_id)
{
  TdModCanvas *mod_canvas;
  mod_canvas = TD_MOD_CANVAS (g_list_nth_data (TD_MOD (mod)->child, 0));
  td_database_command (g_strdup_printf ("DELETE FROM item_net WHERE td_id = %d AND td_id_parent = %d;", CURRENT_ID, CURRENT_ID_PARENT));
  remove_link (GTK_OBJECT (mod_canvas));
}
