/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : requte
 * ToutDoux's plug-in : query
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <toutdoux.h>

#include "main.h"

/*****************************************************************************/
/*** Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("SQL console"),
		  "type", _("tool"),
		  "version", "1.0.1",
		  "authors", "Philippe Roy <ph_roy@toutdoux.org>",
		  "category1", _("core"),
		  "category2", _("tool"),
		  "category3", _("sql console"),
		  "copyright", "Copyright (c) 2000-2001 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"), NULL);
  return ret;
}

GtkObject *mod_def (void)
{
  GtkObject *ret;

  GtkObject *box;
  GtkWidget *vpaned1;
  GtkWidget *text;
  GtkWidget *scrolledwindow;
  GtkWidget *ctree;
  GtkWidget *label;
  GtkObject *stree;

  GtkWidget *toolbar;
  GtkWidget *radiobutton1;
  GtkWidget *radiobutton2;
  GtkWidget *button1;
  GtkWidget *button2;

  /*** Module */
  ret = td_mod_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "sql_console",
		  "name_intl", _("SQL console"),
		  "id", -1, NULL);
  td_mod_set_about (TD_MOD (ret), plugins_about_def());

  /*** Barre d'outils - Tools barr */
  toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_widget_show (toolbar);
  td_mod_set_window_toolbar (TD_MOD (ret), toolbar);
  radiobutton1 = gtdk_toolbar_append_radiobutton (GTK_TOOLBAR (toolbar), NULL, _("Query"), "button_console.xpm");
  gtk_signal_connect (GTK_OBJECT (radiobutton1), "clicked", GTK_SIGNAL_FUNC (radiobutton1_clicked), ret);
  radiobutton2 = gtdk_toolbar_append_radiobutton (GTK_TOOLBAR (toolbar), radiobutton1, _("History"), "button_clock.xpm");
  gtk_signal_connect (GTK_OBJECT (radiobutton2), "clicked", GTK_SIGNAL_FUNC (radiobutton2_clicked), ret);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  button1 = gtdk_toolbar_append_button (GTK_TOOLBAR (toolbar), _("Execute"), "button_ok.xpm");
  gtk_signal_connect_object (GTK_OBJECT (button1), "clicked", GTK_SIGNAL_FUNC (execute), GTK_OBJECT (ret));
  button2 = gtdk_toolbar_append_button (GTK_TOOLBAR (toolbar), _("Close"), "button_close.xpm");
  gtk_signal_connect_object (GTK_OBJECT (button2), "clicked", GTK_SIGNAL_FUNC (td_mod_destroy), GTK_OBJECT (ret));

  /*** Requte - Query */
  box = td_mod_box_new();
  gtk_object_set (GTK_OBJECT (box), "name", _("SQL console"), NULL);
  td_mod_add_child (TD_MOD (ret), box);
  vpaned1 = gtk_vpaned_new();
  gtk_paned_set_handle_size (GTK_PANED (vpaned1), 9);
  gtk_paned_set_gutter_size (GTK_PANED (vpaned1), 11);
  gtk_widget_show (vpaned1);
  td_mod_box_set_widget (TD_MOD_BOX (box), vpaned1);
  gtdk_paned_save_defaultconf ("sql_console", 100);
  text = gtk_text_new (NULL, NULL);
  gtk_text_set_editable (GTK_TEXT (text), TRUE);
  gtk_widget_show (text);
  gtk_paned_pack1 (GTK_PANED (vpaned1), text, TRUE, TRUE);
  gtk_signal_connect (GTK_OBJECT (text), "key_press_event", GTK_SIGNAL_FUNC (text_key_press_event), ret);
  td_mod_box_set_widget_focus (TD_MOD_BOX (box), text);
  label = gtk_label_new (NULL);
  gtk_widget_hide (label);
  gtk_paned_pack2 (GTK_PANED (vpaned1), label, TRUE, TRUE);

  /*** Historique - History */
  stree = td_mod_stree_new();
  gtk_object_set (GTK_OBJECT (stree), 
		  "name", _("History"),
		  "name_parent", "sql_console", NULL);
  td_mod_add_child (TD_MOD (ret), stree);
  return ret;
}

void plugins_init (void)
{
  int i, j;
  GtkObject *flower;
  GtkObject *flower2 = NULL;
  GtkObject *mod;
  gboolean bool_tmp;
  gchar* txt_tmp1;
  gchar* txt_tmp2;

  /*** Module */
  mod = mod_def();
  td_mod_create (TD_MOD (mod));
  td_mod_show (TD_MOD (mod));

  /*** Historique - History */
  td_app_message (NULL, _("Loading history"), TD_MSG_BEGIN);
  flower = td_flower_new();
  gtk_object_set (GTK_OBJECT (flower), "root", "history", "branch", "query", NULL);
  td_flower_add_branch_attribut (TD_FLOWER (flower), "text");
  if (td_flower_load_file (TD_FLOWER (flower), g_strdup_printf ("%s/sql_history.xml", TD_PACKAGE_VAR_DIR)))
    {

      /* Doublon - Double */
      flower2 = td_flower_new();
      gtk_object_set (GTK_OBJECT (flower2), "root", "history", "branch", "query", NULL);
      td_flower_add_branch_attribut (TD_FLOWER (flower2), "text");
      for (i=0; i<g_list_length (TD_FLOWER (flower)->items_value); i++)
	{
	  bool_tmp = TRUE;
	  for (j=0; j<g_list_length (TD_FLOWER (flower2)->items_value); j++)
	    if (!strcmp (g_strstrip (g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 0)), g_strstrip (g_list_nth_data (g_list_nth_data (TD_FLOWER (flower2)->items_value, j), 0))))
	      {
		bool_tmp = FALSE;
		break;
	      }
	  if (bool_tmp)
	    td_flower_add_item (TD_FLOWER (flower2), g_list_nth_data (TD_FLOWER (flower)->items_value, i), 0);
	  if (i > 100)
	    break;
	}
      td_mod_stree_load_flower (TD_MOD_STREE (g_list_nth_data (TD_MOD (mod)->child, 1)), flower2);
    }
  td_flower_destroy (TD_FLOWER (flower));
  td_flower_destroy (TD_FLOWER (flower2));
  td_app_message (NULL, _("Loading history"), TD_MSG_END);
  gtk_signal_connect (GTK_OBJECT (TD_MOD_STREE (g_list_nth_data (TD_MOD (mod)->child, 1))->widget_data), "select_child", GTK_SIGNAL_FUNC (history_select_child), mod);
  gtk_signal_connect (GTK_OBJECT (TD_MOD_STREE (g_list_nth_data (TD_MOD (mod)->child, 1))->widget_data), "button_press_event", GTK_SIGNAL_FUNC (history_button_press_event), mod);
}

void plugins_destroy (gpointer user_data)
{
}

/*****************************************************************************/
/*** Barre d'outils - Tools barr */
/*****************************************************************************/
void radiobutton1_clicked (GtkRadioButton *radiobutton, GtkObject *mod)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->window_notebook), 0);
}
void radiobutton2_clicked (GtkRadioButton *radiobutton, GtkObject *mod)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->window_notebook), 1);
}

/*****************************************************************************/
/*** Commande - Command */
/*****************************************************************************/
void text_key_press_event (GtkWidget *widget, GdkEventKey *event, GtkObject *mod)
{
  if (event->keyval == GDK_Return)
    execute (mod);
}

void history_select_child (GtkTree *tree, GtkWidget *widget, GtkObject *mod)
{
  gchar *txt_tmp;
  gtk_label_get (GTK_LABEL (g_list_nth_data (gtk_container_children (GTK_CONTAINER (g_list_nth_data (gtk_container_children (GTK_CONTAINER (widget)), 0))), 0)), &txt_tmp);
  gtk_editable_delete_text (GTK_EDITABLE (GTK_PANED (TD_MOD_BOX (g_list_nth_data (TD_MOD (mod)->child, 0))->widget)->child1), 0, -1);
  gtk_text_insert (GTK_TEXT (GTK_PANED (TD_MOD_BOX (g_list_nth_data (TD_MOD (mod)->child, 0))->widget)->child1), NULL, NULL, NULL, txt_tmp,-1);
}

void history_button_press_event (GtkWidget *widget, GdkEventButton *event, GtkObject *mod)
{
  if (event->type == GDK_2BUTTON_PRESS)
    {
      execute (mod);
      gtk_button_clicked (g_list_nth_data (gtk_container_children (GTK_CONTAINER (TD_MOD (mod)->window_toolbar)), 0));
    }
}

gboolean execute (GtkObject *mod)
{
  GtkObject *flower;
  GtkCTreeNode *node;
  GtkWidget *node_history = NULL;
  GList *label = NULL;
  gchar *txt[50];
  GtkWidget *vpaned1;
  GtkWidget *text;
  GtkWidget *scrolledwindow;
  GtkWidget *ctree;
  gchar *query;
  GtkObject *datatable;
  TdModStree *mod_stree;
  GList *field;
  int i, j;
  gchar *txt_tmp;
  gchar *file;
  vpaned1 = TD_MOD_BOX (g_list_nth_data (TD_MOD (mod)->child, 0))->widget;
  text = GTK_PANED (vpaned1)->child1;
  mod_stree = TD_MOD_STREE (g_list_nth_data (TD_MOD (mod)->child, 1));

  /*** Requte - Query */
  query = g_strstrip (gtk_editable_get_chars (GTK_EDITABLE (text), 0, -1));
  gtk_text_set_point (GTK_TEXT (text), strlen (query));
  td_app_message (NULL, _("Executing SQL query"), TD_MSG_BEGIN);
  td_app_message (g_strdup_printf ("%s '%s'", _("Executing SQL query"), query), NULL, TD_MSG_MESSAGE);
  if ((strstr (query, "select")) || (strstr (query, "SELECT")))
    {
      /*** Tableau - Array */
      datatable = td_database_select (query);
      if (GTK_IS_LABEL (GTK_PANED (vpaned1)->child2))
	gtdk_paned_load_conf ("sql_console", vpaned1);
      if (GTK_PANED (vpaned1)->child2)
	gtk_widget_destroy (GTK_WIDGET (GTK_PANED (vpaned1)->child2));
      if (!datatable)
	{
	  td_app_message (NULL, _("Executing SQL query"), TD_MSG_END);
	  return FALSE;
	}
      field = td_database_field (query);
      scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
      gtk_widget_show (scrolledwindow);
      gtk_paned_pack2 (GTK_PANED (vpaned1), scrolledwindow, TRUE, TRUE);
      gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
      ctree = gtk_ctree_new (g_list_length (field), 0);
      gtk_ctree_set_expander_style (GTK_CTREE (ctree), GTK_CTREE_EXPANDER_NONE);
      gtk_ctree_set_line_style (GTK_CTREE (ctree), GTK_CTREE_LINES_NONE);
      gtdk_clist_adjustheight (GTK_CLIST (ctree));
      gtk_widget_show (ctree);
      gtk_container_add (GTK_CONTAINER (scrolledwindow), ctree);
      gtk_clist_column_titles_show (GTK_CLIST (ctree));
      td_mod_box_set_widget_data (TD_MOD_BOX (g_list_nth_data (TD_MOD (mod)->child, 0)), ctree);
      gtk_signal_connect (GTK_OBJECT (ctree), "button_press_event", GTK_SIGNAL_FUNC (td_mod_box_button_press), TD_MOD_BOX (g_list_nth_data (TD_MOD (mod)->child, 0)));

      /*** Rsultat - Result */
      for (i=0; i<g_list_length (field); i++)
	gtdk_clist_title (GTK_CLIST (ctree), i, g_list_nth_data (field, i), -1, GTK_JUSTIFY_LEFT);
      for (i=0; i<g_list_length (TD_DB_DATATABLE (datatable)->item); i++)
	{
	  for (j=0; j<g_list_length (field); j++)
	    txt[j] = (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i), j);
	  node = gtk_ctree_insert_node (GTK_CTREE (ctree), NULL, NULL, txt, 5, NULL, NULL, NULL, NULL, FALSE, FALSE);
	}
    }
  else
    td_database_command (query);
  td_app_message (NULL, _("Executing SQL query"), TD_MSG_END);

  /*** Historique - History */
  /* FIXME: requete sur plusieurs lignes : + tards */
  node_history = gtk_tree_item_new();
  gtk_widget_show (node_history);
  td_mod_stree_item_set_label (node_history, query, mod_stree, 0);
  gtk_tree_insert (GTK_TREE (mod_stree->widget_data), node_history, 0);

  /*** Doublon - Double */
  for (i=1; i<g_list_length (gtk_container_children (GTK_CONTAINER (mod_stree->widget_data))); i++)
    {
      gtk_label_get (GTK_LABEL (g_list_nth_data (gtk_container_children (GTK_CONTAINER (g_list_nth_data (gtk_container_children (GTK_CONTAINER (g_list_nth_data (gtk_container_children (GTK_CONTAINER (mod_stree->widget_data)), i))), 0))), 0)), &txt_tmp);
      if (!strcmp (txt_tmp, query))
	gtk_tree_remove_item (GTK_TREE (mod_stree->widget_data), g_list_nth_data (gtk_container_children (GTK_CONTAINER (mod_stree->widget_data)), i));
    }

  /*** Enregistrer - Saving */
  flower = td_flower_new();
  gtk_object_set (GTK_OBJECT (flower), "root", "history", "branch", "query", NULL);
  td_flower_add_branch_attribut (TD_FLOWER (flower), "text");
  for (i=0; i<g_list_length (gtk_container_children (GTK_CONTAINER (mod_stree->widget_data))); i++)
    {
      gtk_label_get (GTK_LABEL (g_list_nth_data (gtk_container_children (GTK_CONTAINER (g_list_nth_data (gtk_container_children (GTK_CONTAINER (g_list_nth_data (gtk_container_children (GTK_CONTAINER (mod_stree->widget_data)), i))), 0))), 0)), &txt_tmp);
      td_flower_add_item (TD_FLOWER (flower), td_strsplist (txt_tmp, "(null)"), 0);
    }
  file = g_strdup_printf ("%s/sql_history.xml", TD_PACKAGE_VAR_DIR);
  if (!td_flower_save_file (TD_FLOWER (flower), file))
    td_app_message (NULL, g_strdup_printf (_("Saving history '%s'"), file), TD_MSG_FAILED);
  else
    td_app_message (NULL, g_strdup_printf (_("Saving history '%s'"), file), TD_MSG_DONE);
  return TRUE;
}


