/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : traduction des anciens fichier
 * ToutDoux's plug-in : old file's translation 
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <toutdoux.h>

#include "main.h"


/*****************************************************************************/
/*** Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("Old file hopla/1.0.4"),
		  "type", _("old file"),
		  "version", "1.0.1",
		  "authors", "Philippe Roy <ph_roy@toutdoux.org>",
		  "help", _("Translator for old format"),
		  "category1", _("core"),
		  "category2", _("file"),
		  "category3", _("oldformat"),
		  "copyright", "Copyright (c) 2000-2001 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"),
		  "web", "(null)", NULL);
  return ret;
}

void plugins_init (void)
{
}

void plugins_destroy (void)
{
}

gboolean plugins_translate (gchar *file)
{
  gchar *txt_tmp;
  int system_verif;
  GtkObject *base1;
  GtkObject *base2;

  /*** Sauvegarde - Backup */
  td_app_message (NULL, _("Translating old file (hopla/1.0.4)"), TD_MSG_BEGIN);
  txt_tmp = g_strdup_printf ("cp %s %s.bak", file, file);
  system_verif = system (txt_tmp);
  txt_tmp = g_strdup_printf ("Creating backup file : command 'cp %s %s.bak'", file, file);
  if (system_verif)
    {
      td_app_message (_("Creating backup file"), txt_tmp, TD_MSG_FAILED);
      td_app_message (NULL, _("Translating old file (hopla/1.0.4)"), TD_MSG_END);
      return FALSE;
    }
  td_app_message (_("Creating backup file"), txt_tmp, TD_MSG_DONE);

  /*** Lecture - Reading */
  base1 = base_load_hopla (file);
  if (!base1)
    {
      td_app_message (_("Reading old file"), NULL, TD_MSG_FAILED);
      td_app_message (NULL, _("Translating old file (hopla/1.0.4)"), TD_MSG_END);
      return FALSE;
    }
  td_app_message (NULL, _("Reading old file"), TD_MSG_DONE);
  base2 = td_db_base_load (g_strdup_printf ("%s/share/%s/templates/%s/%s.td", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, _("en"), _("tasks")));
  if (!base2)
    {
      td_app_message (_("Reading template"), NULL, TD_MSG_FAILED);
      td_app_message (NULL, _("Translating old file (hopla/1.0.4)"), TD_MSG_END);
      return FALSE;
    }
  td_app_message (_("Reading template"), NULL, TD_MSG_DONE);

  /*** Go ! */
  translate (base1, base2);
  td_db_base_save (TD_DB_BASE (base2), file);
  td_app_message (NULL, _("Translating old file"), TD_MSG_DONE);
  td_app_message (NULL, _("Translating old file (hopla/1.0.4)"), TD_MSG_END);
  return TRUE;
}

void translate (GtkObject *base1, GtkObject *base2)
{
  int i;
  gchar *txt_tmp;
  TdDbDatatable *datatable1 = NULL;
  GtkObject *datatable2 = NULL;
  GtkObject *datatable3 = NULL;
  GList *item1 = NULL;
  GList *item2 = NULL;
  GList *item3 = NULL;
  datatable1 = (TdDbDatatable*) g_list_nth_data (TD_DB_BASE (base1)->datatable, 0);

  /*** Initialisation - Initialization */
  datatable2 = td_db_datatable_new();
  gtk_object_set (GTK_OBJECT (datatable2), "table", "task", NULL);
  td_db_base_add_datatable (TD_DB_BASE (base2), datatable2);

  datatable3 = td_db_datatable_new();
  gtk_object_set (GTK_OBJECT (datatable3), "table", "task_tree", NULL);
  td_db_base_add_datatable (TD_DB_BASE (base2), datatable3);

  /*** Go ! */
  for (i=0; i<g_list_length (TD_DB_DATATABLE (datatable1)->item); i++)
    {
      item1 = g_list_nth_data (datatable1->item, i);
      item2 = NULL;
      item3 = NULL;

      /* name */
      item2 = g_list_append (item2, g_list_nth_data (item1, 0));

      /* version */
      item2 = g_list_append (item2, g_list_nth_data (item1, 1));

      /* status */
      if (!strcmp ("t", (gchar*) g_list_nth_data (item1, 4))) /* construction */
	item2 = g_list_append (item2, _("finished"));
      else
	{
	  if (!strcmp ("t", (gchar*) g_list_nth_data (item1, 3))) /* design */
	    item2 = g_list_append (item2, _("in progress"));
	  else
	    {
	      if (!strcmp ("t", (gchar*) g_list_nth_data (item1, 2))) /* planned */
		item2 = g_list_append (item2, _("planned"));
	      else
		item2 = g_list_append (item2, _("not planned"));
	    }
	}

      /* size */
      item2 = g_list_append (item2, _("medium"));

      /* priority */
      item2 = g_list_append (item2, _("medium"));

      /* responsible */
      item2 = g_list_append (item2, "");

      /* td_id */
      txt_tmp = g_strdup_printf ("%d", -1* atoi ((gchar*) g_list_nth_data (item1, 5)));
      item2 = g_list_append (item2, txt_tmp);
      item3 = g_list_append (item3, txt_tmp);

      /* td_id_parent */
      txt_tmp = g_strdup_printf ("%d", -1* atoi ((gchar*) g_list_nth_data (item1, 6)));
      item3 = g_list_append (item3, txt_tmp);

      /* td_id_sibling */
      txt_tmp = g_strdup_printf ("%d", -1* atoi ((gchar*) g_list_nth_data (item1, 7)));
      item3 = g_list_append (item3, txt_tmp);

      /* td_obso */
      item2 = g_list_append (item2, "f");
	
      td_db_datatable_add_item (TD_DB_DATATABLE (datatable2), item2);
      td_db_datatable_add_item (TD_DB_DATATABLE (datatable3), item3);
    }
}

/*      <table name="task" comment=""> */

/*          <field name="name" comment=""> */
/*          <field name="version" comment=""> */
/*          <field name="status" comment=""> */
/*          <field name="size" comment=""> */
/*          <field name="priority" comment=""> */
/*          <field name="responsible" comment=""> */
/*          <field name="td_id" comment=""> */
/*          <field name="td_obso" comment=""> */

/*      <table name="task_tree" comment=""> */
/*          <field name="td_id" comment=""> */
/*          <field name="td_id_parent" comment=""> */
/*          <field name="td_id_sibling" comment=""> */


/*      <table name="actions" comment="(bud)"> */
/*          <field name="name" comment="(bud)" key="0"> */
/*          <field name="version" comment="(bud)" key="0"> */
/*          <field name="planned" comment="(bud)" key="0"> */
/*          <field name="design" comment="(bud)" key="0"> */
/*          <field name="construction" comment="(bud)" key="0"> */
/*          <field name="hopla_id" comment="(bud)" key="1"> */
/*          <field name="hopla_id_parent" comment="(bud)" key="0"> */
/*          <field name="hopla_id_buddy" comment="(bud)" key="0"> */
/*          <field name="hopla_obso" comment="(bud)" key="0"> */


/*****************************************************************************/
/*** Fichier */
/*****************************************************************************/
GtkObject *base_load_hopla (gchar *file)
{
  GtkObject *ret;
  GtkObject *mod;
  XmlDoc *doc;
  XmlNs *ns;
  XmlNode *cur;

  /*** Vrif du contenu du fichier - Check the file content */
  doc = xmlParseFile (file);
  if (!doc)
    {
      td_app_message (NULL, g_strdup_printf (_("Parsing XML file '%s' : doc == NULL"), file), TD_MSG_FAILED);
      return (NULL);
    }	
  cur = xmlDocGetRootElement (doc);
  if (!cur)
    {
      td_app_message (NULL, g_strdup_printf (_("Parsing XML file '%s' : cur == NULL"), file), TD_MSG_FAILED);
      xmlFreeDoc (doc);
      return (NULL);
    }
  ns = xmlSearchNsByHref (doc, cur, "hopla/1.0.4");
  if (!ns)
    {
      td_app_message (NULL, g_strdup_printf (_("Parsing XML file '%s' : ns == NULL"), file), TD_MSG_FAILED);
      xmlFreeDoc (doc);
      return (NULL);
    }

  /*** Donnes - Data */
  ret = td_db_base_new();
  cur = xmlDocGetRootElement (doc)->xmlChildrenNode->next->next->xmlChildrenNode;
  while (cur)
    {
      if (!strcmp (cur->name, "datatable"))
	td_db_base_add_datatable (TD_DB_BASE (ret), td_db_datatable_load (doc, ns, cur));
      cur = cur->next;
    }
  xmlFreeDoc (doc);
  return (ret);
}
