/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : personnalisation
 * ToutDoux's plug-in : customize
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <dlfcn.h>
#include <toutdoux.h>

#include "main.h"


/*****************************************************************************/
/*** Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("Customize"),
		  "type", _("help"),
		  "version", "1.0.1",
		  "authors", "Philippe Roy <ph_roy@toutdoux.org>",
		  "category1", _("core"),
		  "category2", _("help"),
		  "category3", _("customize"),
		  "copyright", "Copyright (c) 2000-2001 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"), NULL);
  return ret;
}

GtkObject *mod_def (GtkObject *mod)
{
  GtkObject *ret;
  GtkObject *box[2];

  GtkWidget *hbox1;
  GtkWidget *label_tree;
  GtkWidget *scrolledwindow1;
  GtkWidget *vseparator1;
  GtkWidget *viewport;
  GtkWidget *custom_box0;

  GtkWidget *scrolledwindow2;
  GtkWidget *ctree;
  GtkWidget *label;

  GtkWidget *toolbar;
  GtkWidget *radiobutton1;
  GtkWidget *radiobutton2;
  GtkWidget *button1;
  GtkWidget *button2;
  GtkWidget *button3;
  GtkWidget *button4;
  GtkWidget *button5;
  gchar *txt_tmp;
  gboolean bool_tmp;
  int i, j, k, m;

  /*** Module */
  ret = td_mod_new();
  if (strcmp (TD_MOD (mod)->name_intl, "(null)"))
    gtk_object_set (GTK_OBJECT (ret), 
		    "name", "customize",
		    "name_intl", g_strdup_printf ("%s : %s", TD_MOD (mod)->name_intl, _("Customize")), NULL);
  else
    gtk_object_set (GTK_OBJECT (ret), 
		    "name", "customize",
		    "name_intl", _("Customize"), NULL);
  td_mod_set_about (TD_MOD (ret), plugins_about_def());

  /*** Barre d'outils - Tools barr */
  toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_widget_show (toolbar);
  td_mod_set_window_toolbar (TD_MOD (ret), toolbar);
  radiobutton1 = gtdk_toolbar_append_radiobutton (GTK_TOOLBAR (toolbar), NULL, _("Browser"), "button_customize.xpm");
  gtk_signal_connect (GTK_OBJECT (radiobutton1), "clicked", GTK_SIGNAL_FUNC (radiobutton1_clicked), ret);
  radiobutton2 = gtdk_toolbar_append_radiobutton (GTK_TOOLBAR (toolbar), radiobutton1, _("List"), "button_tree.xpm");
  gtk_signal_connect (GTK_OBJECT (radiobutton2), "clicked", GTK_SIGNAL_FUNC (radiobutton2_clicked), ret);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  button1 = gtdk_toolbar_append_button_stock (GTK_TOOLBAR (toolbar), _("Reset to standard"), TD_MOD (ret)->window, GNOME_STOCK_PIXMAP_CLEAR);
  gtk_signal_connect_object (GTK_OBJECT (button1), "clicked", GTK_SIGNAL_FUNC (reset_standard), GTK_OBJECT (mod));
  button2 = gtdk_toolbar_append_button_stock (GTK_TOOLBAR (toolbar), _("Reset to saved"), TD_MOD (ret)->window, GNOME_STOCK_PIXMAP_REVERT);
  gtk_signal_connect_object (GTK_OBJECT (button2), "clicked", GTK_SIGNAL_FUNC (reset_saved), GTK_OBJECT (mod));
  button3 = gtdk_toolbar_append_button_stock (GTK_TOOLBAR (toolbar), _("Save for future sessions"), TD_MOD (ret)->window, GNOME_STOCK_PIXMAP_SAVE);
  gtk_signal_connect_object (GTK_OBJECT (button3), "clicked", GTK_SIGNAL_FUNC (save), GTK_OBJECT (mod));
  button4 = gtdk_toolbar_append_button (GTK_TOOLBAR (toolbar), _("Save and open with text editor"), "button_editor.xpm");
  gtk_signal_connect_object (GTK_OBJECT (button4), "clicked", GTK_SIGNAL_FUNC (editor), GTK_OBJECT (mod));
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  button5 = gtdk_toolbar_append_button (GTK_TOOLBAR (toolbar), _("Close"), "button_close.xpm");
  gtk_signal_connect_object (GTK_OBJECT (button5), "clicked", GTK_SIGNAL_FUNC (td_mod_hide), GTK_OBJECT (ret));

  /*** Navigateur - Browser */
  box[0] = td_mod_box_new();
  gtk_object_set (GTK_OBJECT (box[0]), "name", _("Browser"), NULL);
  td_mod_add_child (TD_MOD (ret), box[0]);
  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox1);
  td_mod_box_set_widget (TD_MOD_BOX (box[0]), hbox1);
  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (hbox1), scrolledwindow1, FALSE, FALSE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
  TD_MOD (mod)->custom_tree = gtk_ctree_new (2, 0);
  if (TD_FLAG_DEBUG_MODE)
    gtk_clist_column_titles_show (GTK_CLIST (TD_MOD (mod)->custom_tree));
  gtk_widget_show (TD_MOD (mod)->custom_tree);
  gtdk_clist_adjustheight (GTK_CLIST (TD_MOD (mod)->custom_tree));
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), TD_MOD (mod)->custom_tree);
  gtdk_clist_title (GTK_CLIST (TD_MOD (mod)->custom_tree), 0, _("Category"), -1, GTK_JUSTIFY_CENTER);
  gtdk_clist_title (GTK_CLIST (TD_MOD (mod)->custom_tree), 1, "#", -2, GTK_JUSTIFY_LEFT);
  gtk_clist_set_column_width (GTK_CLIST (TD_MOD (mod)->custom_tree), 0, gtdk_ctree_optimal_column_width (GTK_CTREE (TD_MOD (mod)->custom_tree), 1));
  vseparator1 = gtk_vseparator_new();
  gtk_widget_show (vseparator1);
  gtk_box_pack_start (GTK_BOX (hbox1), vseparator1, FALSE, TRUE, 0);
  viewport = gtk_viewport_new (NULL, NULL);
  gtk_widget_show (viewport);
  gtk_box_pack_start (GTK_BOX (hbox1), viewport, TRUE, TRUE, 0);
  TD_MOD (mod)->custom_notebook = gtk_notebook_new();
  gtk_widget_show (TD_MOD (mod)->custom_notebook);
  if (!TD_FLAG_DEBUG_MODE)
    gtk_notebook_set_show_tabs (GTK_NOTEBOOK (TD_MOD (mod)->custom_notebook), FALSE);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (TD_MOD (mod)->custom_notebook), FALSE);
  gtk_container_add (GTK_CONTAINER (viewport), TD_MOD (mod)->custom_notebook);
  custom_box0 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (GTK_WIDGET (custom_box0));
  gtk_container_add (GTK_CONTAINER (TD_MOD (mod)->custom_notebook), GTK_WIDGET (custom_box0));
  gtk_signal_connect (GTK_OBJECT (TD_MOD (mod)->custom_tree), "button_press_event", GTK_SIGNAL_FUNC (browser_press), GTK_OBJECT (TD_MOD (mod)->custom_notebook));
  gtk_signal_connect (GTK_OBJECT (TD_MOD (mod)->custom_tree), "tree_expand", GTK_SIGNAL_FUNC (gtdk_ctree_expand), scrolledwindow1);

  /*** Liste - List */
  box[1] = td_mod_box_new();
  gtk_object_set (GTK_OBJECT (box[1]), "name", _("List"), NULL);
  td_mod_add_child (TD_MOD (ret), box[1]);
  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow2);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  td_mod_box_set_widget (TD_MOD_BOX (box[1]), scrolledwindow2);
  ctree = gtk_ctree_new (5, 0);
  gtdk_clist_adjustheight (GTK_CLIST (ctree));
  gtk_widget_show (ctree);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), ctree);
  gtk_widget_set_usize (ctree, 0, -2);
  gtk_clist_column_titles_show (GTK_CLIST (ctree));
  td_mod_box_set_widget_data (TD_MOD_BOX (box[1]), ctree);
  gtdk_clist_title (GTK_CLIST (ctree), 0, "name", -1, GTK_JUSTIFY_LEFT);
  gtdk_clist_title (GTK_CLIST (ctree), 1, "name_intl", -1, GTK_JUSTIFY_LEFT);
  gtdk_clist_title (GTK_CLIST (ctree), 2, "value", -1, GTK_JUSTIFY_LEFT);
  gtdk_clist_title (GTK_CLIST (ctree), 3, "widget", -1, GTK_JUSTIFY_LEFT);
  gtdk_clist_title (GTK_CLIST (ctree), 4, "type", -1, GTK_JUSTIFY_LEFT);
  gtk_signal_connect (GTK_OBJECT (ctree), "button_press_event", GTK_SIGNAL_FUNC (td_mod_box_button_press), box[1]);
  return ret;
}

void plugins_init (void)
{
}

void plugins_destroy (gpointer user_data)
{
}

void plugins_create (GtkObject *mod)
{
  TD_MOD (mod)->custom_browser = mod_def (mod);
  td_mod_create (TD_MOD (TD_MOD (mod)->custom_browser));
  load_file (mod, NULL);
}

void radiobutton1_clicked (GtkRadioButton *radiobutton, GtkObject *mod)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->window_notebook), 0);
}

void radiobutton2_clicked (GtkRadioButton *radiobutton, GtkObject *mod)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->window_notebook), 1);
}

void editor (GtkObject *mod)
{
  if (save (mod))
    td_editor_txt (g_strdup_printf ("%s/customize/%s.xml", TD_PACKAGE_VAR_DIR, TD_MOD (mod)->name));
}

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/
void reset_standard (GtkObject *mod)
{
  if (td_file_exist (g_strdup_printf("%s/share/%s/%s/customize-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, TD_MOD (mod)->name, _("en"))))
    load_file (mod, g_strdup_printf("%s/share/%s/%s/customize-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, TD_MOD (mod)->name, _("en")));
  else
    load_file (mod, g_strdup_printf("%s/share/%s/%s/customize-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, TD_MOD (mod)->name, "en"));
}

void reset_saved (GtkObject *mod)
{
  load_file (mod, g_strdup_printf ("%s/customize/%s.xml", TD_PACKAGE_VAR_DIR, TD_MOD (mod)->name));
}

gboolean load_file (GtkObject *mod, gchar* file)
{
  GtkObject *flower;
  gboolean list_ajusted = FALSE;
  GList *node_list = NULL;
  gchar *menu_width = NULL;
  gchar *menu_width2 = NULL;
  GList *menu_list = NULL;
  GList *predef_list = NULL;
  GList *predef2_list = NULL;
  gchar *txt[5];
  gchar *seleted_value = NULL;
  GtkCTreeNode *node_browser;
  gchar *txt2[2];
  int i, j;
  int k = -1;
  int l = -1;
  GtkWidget *custom_box0;
  GtkWidget *custom_box = NULL;
  GtkWidget *custom_scrolledwindow = NULL;
  GtkWidget *custom_viewport = NULL;
  GtkWidget *custom_box2 = NULL;
  GtkWidget *group_frame = NULL;
  GtkWidget *box_tmp = NULL;
  GtkWidget *vbox_tmp = NULL;
  GtkWidget *hbox_tmp = NULL;
  GtkWidget *group_table = NULL;
  GtkWidget *option_line_box = NULL;
  GtkWidget *option_label = NULL;
  GtkWidget *option_label_left = NULL;
  GtkWidget *option_widget = NULL;
  GtkWidget *option_menu = NULL;
  GtkWidget *color_widget;
  GtkWidget *font_widget;
  td_app_message (NULL, _("Loading customize"), TD_MSG_BEGIN);
  td_app_message (g_strdup_printf ("%s...", _("Loading customize")), NULL, TD_MSG_MESSAGE);

  /*** Fichier - File */
  flower = td_flower_new();
  gtk_object_set (GTK_OBJECT (flower),
		  "root", "customize", 
		  "branch", "category",
		  "petal", "group",
		  "foliole", "option",
		  "stomate", "predef",
		  "mode_type", TRUE, NULL);
  td_flower_add_branch_attribut (TD_FLOWER (flower), "name");
  td_flower_add_branch_attribut (TD_FLOWER (flower), "name_intl");
  td_flower_add_petal_attribut (TD_FLOWER (flower), "name");
  td_flower_add_petal_attribut (TD_FLOWER (flower), "name_intl");
  td_flower_add_petal_attribut (TD_FLOWER (flower), "list_ajusted");
  td_flower_add_foliole_attribut (TD_FLOWER (flower), "name");
  td_flower_add_foliole_attribut (TD_FLOWER (flower), "name_intl");
  td_flower_add_foliole_attribut (TD_FLOWER (flower), "value");
  td_flower_add_foliole_attribut (TD_FLOWER (flower), "widget");
  td_flower_add_stomate_attribut (TD_FLOWER (flower), "name_intl");
  td_flower_add_stomate_attribut (TD_FLOWER (flower), "value");
  if (!file)
    {
      file = g_strdup_printf ("%s/customize/%s.xml", TD_PACKAGE_VAR_DIR, TD_MOD (mod)->name);
      if (!td_file_exist (file))
	{
	  file = g_strdup_printf ("%s/share/%s/%s/customize-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, TD_MOD (mod)->name, _("en"));
	  if (!td_file_exist (file))
	    {
	      file = g_strdup_printf("%s/share/%s/%s/customize-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, TD_MOD (mod)->name, "en");
	      if (!file)
		{
		  td_app_message (NULL, g_strdup_printf (_("Opening standard support file '%s'"), file), TD_MSG_FAILED);
		  td_app_message (NULL, _("Loading customize"), TD_MSG_END);
		  return FALSE;
		}
	    }
	}
    }
  if (!td_flower_load_file (TD_FLOWER (flower), file))
    {
      td_app_message (NULL, g_strdup_printf (_("Opening support file '%s'"), file), TD_MSG_FAILED);
      td_app_message (NULL, _("Loading customize"), TD_MSG_END);
      return FALSE;
    }
  td_app_message (NULL, g_strdup_printf (_("Opening support file '%s'"), file), TD_MSG_DONE);

  /*** Arbre - Tree */
  gtdk_ctree_clear (GTK_CTREE (TD_MOD (mod)->custom_tree));
  gtk_container_foreach (GTK_CONTAINER (TD_MOD (mod)->custom_notebook), (GtkCallback) gtk_widget_destroy, NULL);
  custom_box0 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (GTK_WIDGET (custom_box0));
  gtk_container_add (GTK_CONTAINER (TD_MOD (mod)->custom_notebook), GTK_WIDGET (custom_box0));
  TD_MOD (mod)->custom_widget = NULL;
  gtdk_ctree_clear (GTK_CTREE (GTK_BIN (TD_MOD_BOX (g_list_nth_data (TD_MOD (TD_MOD (mod)->custom_browser)->child, 1))->widget)->child));

  /*** Valeurs - Values */
  for (i=0; i<g_list_length (TD_FLOWER (flower)->items_value); i++)
    {
      txt[0] = g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 0);

      /*** Catgorie - Category */
      if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 0)
	{
	  txt[1] = g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 1);
	  txt[2] = "";
	  txt[3] = "";
	  txt[4] = "category";
	  k++;
	  txt2[0] = txt[1];
	  txt2[1] = g_strdup_printf ("%d", k+1);
	  node_browser = gtk_ctree_insert_node (GTK_CTREE (TD_MOD (mod)->custom_tree), NULL, NULL, txt2, 5, NULL, NULL, NULL, NULL, FALSE, FALSE);
	  custom_box = gtk_vbox_new (FALSE, 0);
	  gtk_widget_show (custom_box);
	  gtk_container_add (GTK_CONTAINER (TD_MOD (mod)->custom_notebook), custom_box);
	  gtdk_vbox_title (txt[1], custom_box);
	  custom_scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
	  gtk_widget_show (custom_scrolledwindow);
	  gtk_box_pack_start (GTK_BOX (custom_box), custom_scrolledwindow, TRUE, TRUE, 0);
	  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (custom_scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	  custom_viewport = gtk_viewport_new (NULL, NULL);
	  gtk_viewport_set_shadow_type (GTK_VIEWPORT (custom_viewport), GTK_SHADOW_NONE);
	  gtk_widget_show (custom_viewport);
	  gtk_container_add (GTK_CONTAINER (custom_scrolledwindow), custom_viewport);
	  custom_box2 = gtk_vbox_new (FALSE, 0);
	  gtk_widget_show (custom_box2);
	  gtk_container_add (GTK_CONTAINER (custom_viewport), custom_box2);
	}

      /*** Groupe - Group */
      if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 1)
	{
	  txt[1] = g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 1);
	  txt[2] = g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 2);
	  if (!strcmp (txt[2], "yes"))
	    list_ajusted = TRUE;
	  else
	    list_ajusted = FALSE;
	  txt[3] = "";
	  txt[4] = "group";
	  group_frame = gtk_frame_new (txt[1]);
	  gtk_widget_show (group_frame);
  	  gtk_container_set_border_width (GTK_CONTAINER (group_frame), 5);
	  gtk_box_pack_start (GTK_BOX (custom_box2), group_frame, FALSE, TRUE, 0);
	  group_table = gtk_table_new (20, 2, FALSE); /* FIXME: Table dynamique  : + tards */
	  gtk_widget_show (group_table);
	  gtk_container_set_border_width (GTK_CONTAINER (group_table), 5);
	  gtk_container_add (GTK_CONTAINER (group_frame), group_table);
	  l = -1;
	  menu_width = NULL;
	  menu_width2 = NULL;
	  menu_list = NULL;
	}

      /*** Option */
      if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 2)
	{
	  txt[1] = g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 1);
	  txt[2] = g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 2);
	  txt[3] = g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 3);
	  txt[4] = "option";

	  /*** Entre - Entry */
	  option_widget = gtk_entry_new();
	  gtk_widget_set_usize (option_widget, 50, -2);
	  gtk_entry_set_text (GTK_ENTRY (option_widget), txt[2]);
	  td_mod_add_custom_widget (TD_MOD (mod), option_widget);

	  /*** Widget */
	  l++;
  	  hbox_tmp = gtk_hbox_new (FALSE, 0);
  	  gtk_widget_show (hbox_tmp);
      	  gtk_table_attach (GTK_TABLE (group_table), hbox_tmp, 0, 1, l, l+1, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	  option_label_left = gtk_label_new ("");
	  gtk_box_pack_start (GTK_BOX (hbox_tmp), option_label_left, TRUE, TRUE, 0);
	  gtk_widget_show (option_label_left);
	  option_label = gtk_label_new (g_strdup_printf ("%s:", txt[1]));
  	  gtk_widget_show (option_label);
    	  gtk_misc_set_padding (GTK_MISC (option_label), 5, 0);
	  /*  gtk_label_set_line_wrap (GTK_LABEL (option_label), TRUE); */
	  gtk_box_pack_start (GTK_BOX (hbox_tmp), option_label, FALSE, FALSE, 0);
	  if (strstr (txt[3], "+"))
	    {
	      vbox_tmp = gtk_vbox_new (FALSE, 0);
	      gtk_table_attach (GTK_TABLE (group_table), vbox_tmp, 1, 2, l, l+1, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	      gtk_widget_show (vbox_tmp);
	      box_tmp = gtk_hbox_new (FALSE, 0);
	      gtk_box_pack_start (GTK_BOX (vbox_tmp), box_tmp, TRUE, TRUE, 0);
	      gtk_widget_show (box_tmp);
	      gtk_widget_show (option_widget);
	      gtk_box_pack_start (GTK_BOX (box_tmp), option_widget, TRUE, TRUE, 0);
	    }
	  else
	    {
	      box_tmp = gtk_hbox_new (FALSE, 0);
	      gtk_table_attach (GTK_TABLE (group_table), box_tmp, 1, 2, l, l+1, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	      gtk_widget_show (box_tmp);
	      gtk_widget_show (option_widget);
	      gtk_box_pack_start (GTK_BOX (box_tmp), option_widget, TRUE, TRUE, 0);
	    }

	  /*** Couleur - Color */
	  if (!strcmp (txt[3], "color"))
	    {
	      color_widget = gtdk_button_color (option_widget);
	      gtk_widget_show (color_widget);
	      gtk_box_pack_start (GTK_BOX (box_tmp), color_widget, FALSE, FALSE, 2);
	      gtk_signal_connect (GTK_OBJECT (option_widget), "changed", GTK_SIGNAL_FUNC (option_color_updated), color_widget);
	    }

	  /*** Police de caractres - Fonts */
	  if (!strcmp (txt[3], "font"))
	    {
	      font_widget = gtdk_button_font();
	      gtk_widget_show (font_widget);
	      gtk_box_pack_start (GTK_BOX (box_tmp), font_widget, FALSE, FALSE, 2);
	    }

	  /*** Liste - List */
	  option_menu = gtk_option_menu_new();
	  gtk_widget_hide (option_menu);
	  if (strstr (txt[3], "+"))
	    gtk_box_pack_start (GTK_BOX (vbox_tmp), option_menu, FALSE, FALSE, 2);
	  else
	    gtk_box_pack_start (GTK_BOX (box_tmp), option_menu, FALSE, FALSE, 2);
	  predef_list = NULL;
	  predef2_list = NULL;
	  menu_list = g_list_append (menu_list, option_menu);

	  /*** Valeur - Value */
	  gtk_entry_set_text (GTK_ENTRY (option_widget), txt[2]);
	  seleted_value = txt[2];
	}

      /*** Valeurs prdfinis - Predefined values */
      if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 3)
	{
	  gtk_widget_show (option_menu);
	  txt[1] = "";
	  txt[2] = g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 1);
	  txt[3] = "";
	  txt[4] = "predef";
	  predef_list = g_list_append (predef_list, g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 1));
	  predef2_list = g_list_append (predef2_list, g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 0));
	  gtdk_option_menu_set_strings_extended (option_menu, predef_list, predef2_list, seleted_value, option_widget);

	  /*** Ajustement des listes - List ajustment */
	  if (list_ajusted)
	    {
	      if ((!menu_width) || (strlen (txt[2])>strlen (menu_width)))
 		menu_width = txt[2];
	      if ((!menu_width2) || (strlen (td_string_remove (txt[0], _("(default value)")))>strlen (menu_width2)))
  		menu_width2 = td_string_remove (txt[0], _("(default value)"));
	      if ((GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i+1)) != 2) &&
		  (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i+1)) != 3))
		for (j=0; j<g_list_length (menu_list); j++)
		  gtk_widget_set_usize (GTK_WIDGET (g_list_nth_data (menu_list, j)), 
					gdk_string_width (gtk_widget_get_default_style()->font, menu_width)+
					10+
					gdk_string_width (gtk_widget_get_default_style()->font, menu_width2)+39, -1);
	    }
	}

      /*** Node */
      if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 0)
	{
	  node_list = g_list_append (node_list, gtk_ctree_insert_node (GTK_CTREE (GTK_BIN (TD_MOD_BOX (g_list_nth_data (TD_MOD (TD_MOD (mod)->custom_browser)->child, 1))->widget)->child), NULL, NULL, txt, 5, NULL, NULL, NULL, NULL, FALSE, FALSE));
	  continue;
	}
      j = 1;
      while (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i-j)) != GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i))-1)
	j++;
      node_list = g_list_append (node_list, gtk_ctree_insert_node (GTK_CTREE (GTK_BIN (TD_MOD_BOX (g_list_nth_data (TD_MOD (TD_MOD (mod)->custom_browser)->child, 1))->widget)->child), g_list_nth_data (node_list, i-j), NULL, txt, 5, NULL, NULL, NULL, NULL, FALSE, FALSE));
    }
  gtk_clist_set_column_width (GTK_CLIST (TD_MOD (mod)->custom_tree), 0, gtdk_ctree_optimal_column_width (GTK_CTREE (TD_MOD (mod)->custom_tree), 0));
  td_app_message (NULL, _("Loading customize"), TD_MSG_DONE);
  td_app_message (NULL, _("Loading customize"), TD_MSG_END);
  td_flower_destroy (TD_FLOWER (flower));
  return TRUE;
}

void option_color_updated (GtkWidget *entry, GtkWidget *color)
{
  gtdk_button_color_set (color, gtk_entry_get_text (GTK_ENTRY (entry)));
}

gboolean save (GtkObject *mod)
{
  GtkObject *flower;
  GtkObject *flower2;
  gchar *file;
  GList *node_list = NULL;
  GList *list_tmp;
  gchar *txt[5];
  FILE *fp;
  XmlDoc *doc;
  XmlNs *ns;
  XmlNode *tree;
  XmlNode *item_category = NULL;
  XmlNode *item_group = NULL;
  XmlNode *item_option = NULL;
  XmlNode *item_predef = NULL;
  int i, j;
  int k = -1;
  td_app_message (NULL, _("Saving customize"), TD_MSG_BEGIN);

  /*** Fichier - File */
  flower = td_flower_new();
  gtk_object_set (GTK_OBJECT (flower),
		  "root", "customize", 
		  "branch", "category",
		  "petal", "group",
		  "foliole", "option",
		  "stomate", "predef",
		  "mode_type", TRUE, NULL);
  td_flower_add_branch_attribut (TD_FLOWER (flower), "name");
  td_flower_add_branch_attribut (TD_FLOWER (flower), "name_intl");
  td_flower_add_petal_attribut (TD_FLOWER (flower), "name");
  td_flower_add_petal_attribut (TD_FLOWER (flower), "name_intl");
  td_flower_add_petal_attribut (TD_FLOWER (flower), "list_ajusted");
  td_flower_add_foliole_attribut (TD_FLOWER (flower), "name");
  td_flower_add_foliole_attribut (TD_FLOWER (flower), "name_intl");
  td_flower_add_foliole_attribut (TD_FLOWER (flower), "value");
  td_flower_add_foliole_attribut (TD_FLOWER (flower), "widget");
  td_flower_add_stomate_attribut (TD_FLOWER (flower), "name_intl");
  td_flower_add_stomate_attribut (TD_FLOWER (flower), "value");
  flower2 = td_flower_new();
  gtk_object_set (GTK_OBJECT (flower2),
		  "root", "customize", 
		  "branch", "category",
		  "petal", "group",
		  "foliole", "option",
		  "stomate", "predef",
		  "mode_type", TRUE, NULL);
  td_flower_add_branch_attribut (TD_FLOWER (flower2), "name");
  td_flower_add_branch_attribut (TD_FLOWER (flower2), "name_intl");
  td_flower_add_petal_attribut (TD_FLOWER (flower2), "name");
  td_flower_add_petal_attribut (TD_FLOWER (flower2), "name_intl");
  td_flower_add_petal_attribut (TD_FLOWER (flower2), "list_ajusted");
  td_flower_add_foliole_attribut (TD_FLOWER (flower2), "name");
  td_flower_add_foliole_attribut (TD_FLOWER (flower2), "name_intl");
  td_flower_add_foliole_attribut (TD_FLOWER (flower2), "value");
  td_flower_add_foliole_attribut (TD_FLOWER (flower2), "widget");
  td_flower_add_stomate_attribut (TD_FLOWER (flower2), "name_intl");
  td_flower_add_stomate_attribut (TD_FLOWER (flower2), "value");

  /*** Valeurs - Values */
  if (!td_flower_load_file (TD_FLOWER (flower), g_strdup_printf("%s/share/%s/%s/customize-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, TD_MOD (mod)->name, _("en"))))
    if (!td_flower_load_file (TD_FLOWER (flower), g_strdup_printf("%s/share/%s/%s/customize-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, TD_MOD (mod)->name, "en")))
      {
	td_app_message (NULL, _("Opening standard support file"), TD_MSG_FAILED);
	td_app_message (NULL, _("Saving customize"), TD_MSG_END);
	return FALSE;
      }
  gtdk_ctree_clear (GTK_CTREE (GTK_BIN (TD_MOD_BOX (g_list_nth_data (TD_MOD (TD_MOD (mod)->custom_browser)->child, 1))->widget)->child));
  for (i=0; i<g_list_length (TD_FLOWER (flower)->items_value); i++)
    {
      list_tmp = NULL;
      txt[0] = g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 0);
      list_tmp = g_list_append (list_tmp, txt[0]);

      /*** Catgorie - Category */
      if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 0)
	{
	  txt[1] = g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 1);
	  txt[2] = "";
	  txt[3] = "";
	  txt[4] = "category";
	  list_tmp = g_list_append (list_tmp, txt[1]);
	}

      /*** Groupe - Group */
      if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 1)
	{
	  txt[1] = g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 1);
	  txt[2] = g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 2);
	  txt[3] = "";
	  txt[4] = "group";
	  list_tmp = g_list_append (list_tmp, txt[1]);
	  list_tmp = g_list_append (list_tmp, txt[2]);
	}

      /*** Option */
      if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 2)
	{
	  k++;
	  txt[1] = g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 1);
	  txt[2] = g_strdup_printf ("%s", gtk_entry_get_text (GTK_ENTRY (g_list_nth_data (TD_MOD (mod)->custom_widget, k))));
	  txt[3] = g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 3);
	  txt[4] = "option";
	  list_tmp = g_list_append (list_tmp, txt[1]);
	  list_tmp = g_list_append (list_tmp, txt[2]);
	  list_tmp = g_list_append (list_tmp, txt[3]);
	}

      /*** Valeurs prdfinis - Predefined values */
      if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 3)
	{
	  txt[1] = "";
	  txt[2] = g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 1);
	  txt[3] = "";
	  txt[4] = "predef";
	  list_tmp = g_list_append (list_tmp, txt[2]);
	}
      td_flower_add_item (TD_FLOWER (flower2), list_tmp, GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)));

      /*** Arbre - Tree */
      if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 0)
	{
	  node_list = g_list_append (node_list, gtk_ctree_insert_node (GTK_CTREE (GTK_BIN (TD_MOD_BOX (g_list_nth_data (TD_MOD (TD_MOD (mod)->custom_browser)->child, 1))->widget)->child), NULL, NULL, txt, 5, NULL, NULL, NULL, NULL, FALSE, FALSE));
	  continue;
	}
      j = 1;
      while (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i-j)) != GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i))-1)
	j++;
      node_list = g_list_append (node_list, gtk_ctree_insert_node (GTK_CTREE (GTK_BIN (TD_MOD_BOX (g_list_nth_data (TD_MOD (TD_MOD (mod)->custom_browser)->child, 1))->widget)->child), g_list_nth_data (node_list, i-j), NULL, txt, 5, NULL, NULL, NULL, NULL, FALSE, FALSE));
    }

  /*** Enregistrer - Save */
  file = g_strdup_printf ("%s/customize/%s.xml", TD_PACKAGE_VAR_DIR, TD_MOD (mod)->name);
  if (!td_flower_save_file (TD_FLOWER (flower2), file))
    td_app_message (NULL, g_strdup_printf (_("Saving customize '%s'"), file), TD_MSG_FAILED);
  else
    td_app_message (NULL, g_strdup_printf (_("Saving customize '%s'"), file), TD_MSG_DONE);
  td_app_message (NULL, _("Saving customize"), TD_MSG_END);
  td_flower_destroy (TD_FLOWER (flower));
  td_flower_destroy (TD_FLOWER (flower2));
  return TRUE;
}

/*****************************************************************************/
/*** Navigateur - Browser */
/*****************************************************************************/
gboolean browser_press (GtkWidget *widget, GdkEvent *event, GtkWidget *notebook)
{
  GtkCTreeNode *node;
  GdkEventButton *bevent;
  gint row, column;
  gchar *txt_tmp;
  int i;
  bevent = (GdkEventButton *) event;
  gtk_clist_get_selection_info (GTK_CLIST (widget), bevent->x, bevent->y, &row, &column);
  row = gtdk_clist_correction (GTK_CLIST (widget), row, bevent->y);
  if (row < 0)
    {
      gtk_notebook_set_page (GTK_NOTEBOOK (notebook), 0);
      gtk_clist_unselect_all (GTK_CLIST (widget));
      return TRUE;
    }
  node = gtk_ctree_node_nth (GTK_CTREE (widget), row);
  gtk_ctree_node_get_text (GTK_CTREE (widget), node, 1, &txt_tmp);
  if (!strcmp (txt_tmp, "(null)"))
    {
      gtk_notebook_set_page (GTK_NOTEBOOK (notebook), 0);
      return TRUE;
    }
  gtk_notebook_set_page (GTK_NOTEBOOK (notebook), atoi (txt_tmp));
  return TRUE;
}
