/*****************************************************************************/
/* main.h : Donnes globales et fentre principale
 * main.h : Global data and main window
 *
 *
 * Greffon ToutDoux : Signets
 * ToutDoux's plug-in : Bookmarks
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#include <toutdoux.h>

/*****************************************************************************/
/*** Variables globales - Global variables */
/*****************************************************************************/
GtkObject *mod_main;
GtkObject *base_start;
GtkWidget *menu_favorites;
GtkWidget *menu_templates;
GtkWidget *menu_commands;
GtkWidget *menu_history;
GtkObject *datatable_history;

/*****************************************************************************/
/*** Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void);
GtkObject *plugins_init (int mod_id);

/*****************************************************************************/
/*** Enfant - Child */
/*****************************************************************************/
void child_def (GtkObject *mod);

/*****************************************************************************/
/*** Barre d'outils - Tools barr */
/*****************************************************************************/
void radiobutton1_clicked (GtkRadioButton *radiobutton, gpointer *user_data);
void radiobutton2_clicked (GtkRadioButton *radiobutton, gpointer *user_data);
void radiobutton3_clicked (GtkRadioButton *radiobutton, gpointer *user_data);
void radiobutton4_clicked (GtkRadioButton *radiobutton, gpointer *user_data);
void editor (GtkObject *mod);

/*****************************************************************************/
/*** Etablis - Benchs */
/*****************************************************************************/
void bench_def (GtkObject *mod);
void plugins_bench_refresh (GtkObject *mod, GtkObject *mod_tree);
void plugins_etabliste_refresh (GtkObject *mod, GtkObject *mod_tree);
void plugins_bench_action (GtkObject *mod, gchar *value, gchar *table_field, int bench_id);
void plugins_etabliste_action (GtkObject *mod, gchar *value, gchar *table_field, int etabliste_id);

/*****************************************************************************/
/*** Menu */
/*****************************************************************************/
void menu_def (GtkObject *mod);
void plugins_menu_refresh (GtkObject *mod, GtkObject *mod_tree);
void plugins_menu_action (GtkObject *mod, int menu_id);

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/
gboolean save (GtkObject *mod);
void reset_standard (GtkObject *mod);
void reset_saved (GtkObject *mod);
void load_file (GtkObject *mod, gchar* file);

/*****************************************************************************/
/*** Application */
/*****************************************************************************/
void plugins_start (TdApp *app);
void plugins_save_history (void);
GtkObject *remove_history (GtkObject *datatable_history_0);
void plugins_add_history (GtkObject *connect);
void plugins_add_recents (GtkObject *connect);
void plugins_menu_def_favorites (GtkWidget *menuitem_main, GtkAccelGroup *accel_group);
void plugins_menu_def_templates (GtkWidget *menuitem_main, GtkAccelGroup *accel_group);
void plugins_menu_def_commands (GtkWidget *menuitem_main, GtkAccelGroup *accel_group, GtkObject *mod);
void plugins_menu_def_history (GtkWidget *menuitem_main, GtkAccelGroup *accel_group);
void plugins_menu_def (GtkObject *datatable, GtkObject *datatable_tree, GtkWidget *menu_main, GtkObject *mod);
gboolean menu_template_activate (GtkWidget *menuitem, GList *data);
gboolean menu_file_activate (GtkWidget *menuitem, GList *data);
void menu_command_activate (GtkWidget *menuitem, GList *data);

