/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : Signets
 * ToutDoux's plug-in : Bookmarks
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <fcntl.h>
#include <dlfcn.h>
#include <dirent.h>
#include <sys/stat.h>

#include "main.h"

/*****************************************************************************/
/*** Variables globales - Global variables */
/*****************************************************************************/
GtkObject *mod_main;
GtkObject *base_start;
GtkWidget *menu_favorites;
GtkWidget *menu_templates;
GtkWidget *menu_commands;
GtkWidget *menu_history;
GtkObject *datatable_history;

/*****************************************************************************/
/*** Module */
/*****************************************************************************/
static GnomeUIInfo menu_empty_uiinfo[] =
{
  GNOMEUIINFO_END 
};

GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("Bookmarks"),
		  "type", _("help"),
		  "version", "1.0.1",
		  "authors", "Philippe Roy <ph_roy@toutdoux.org>",
		  "help", _("Edit bookmarks : favorites, templates, import-export and history"),
		  "category1", _("core"),
		  "category2", _("help"),
		  "category3", _("bookmarks"),
		  "copyright", "Copyright (c) 2000-2001 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"),
		  "web", "(null)", NULL);
  return ret;
}

GtkObject *plugins_init (int mod_id)
{
  GtkObject *flower_interfaces;
  GtkObject *flower_filters;
  GtkObject *structure;
  GtkObject *modules_list;
  GtkObject *modules_tables;
  gchar *txt_tmp;
  gboolean already_loaded;
  int i;
  int j = 0;

  /*** Module */
  mod_main = td_mod_new();
  gtk_object_set (GTK_OBJECT (mod_main),
		  "name", "help_bookmarks",
		  "name_intl", _("Bookmarks"),
		  "group", _("Help"),
		  "id", mod_id,
		  "fields", "*", NULL);
  td_mod_set_about (TD_MOD (mod_main), plugins_about_def());

  /*** Structure */
  already_loaded = FALSE;
  structure = td_db_base_load (g_strdup_printf ("%s/share/%s/help_bookmarks/tables.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR));
  for (i=0; i < g_list_length (TD_DB_BASE (structure)->table); i++)
    if (!td_database_table_create (g_list_nth_data (TD_DB_BASE (structure)->table, i)))
      {
	if (TD_DB_CONNECT (TD_APP (APP)->connect)->type != TD_CONNECT_TYPE_RECOVERY)
	  td_app_message (_("Loading file"), _("Loading file : Local database's schema not complete"), TD_MSG_STOP);
	else
	  already_loaded = TRUE;
      }
  if (!already_loaded)
    for (i=0; i < g_list_length (TD_DB_BASE (structure)->datatable); i++)
      if (!td_database_table_copy_in (g_list_nth_data (TD_DB_BASE (structure)->datatable, i)))
	td_app_message (_("Loading file"), _("Loading file : Local database's datatables not complete"), TD_MSG_STOP);

  /*** Interfaces */
  if (!already_loaded)
    {
      flower_interfaces = td_flower_new();
      gtk_object_set (GTK_OBJECT (flower_interfaces), "root", "interfaces", "branch", "interface", NULL);
      td_flower_add_branch_attribut (TD_FLOWER (flower_interfaces), "name");
      td_flower_add_branch_attribut (TD_FLOWER (flower_interfaces), "directory");
      td_flower_add_branch_attribut (TD_FLOWER (flower_interfaces), "file");
      td_flower_add_branch_attribut (TD_FLOWER (flower_interfaces), "symbol");
      if (td_flower_load_file (TD_FLOWER (flower_interfaces), g_strdup_printf ("%s/share/%s/interfaces.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR)))
	td_app_message (NULL, g_strdup_printf (_("Loading file '%s'"), g_strdup_printf ("%s/share/%s/interfaces.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR)), TD_MSG_DONE);
      else
	td_app_message (_("Loading file"), g_strdup_printf (_("Loading file '%s'"), g_strdup_printf ("%s/share/%s/interfaces.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR)), TD_MSG_FAILED);
      for (i=0; i<g_list_length (TD_FLOWER (flower_interfaces)->items_value); i++)
	td_database_insert (g_strdup_printf ("INSERT INTO td_bookmarks_predef (type, value) VALUES ('interface', %s);", 
					     td_database_adaptvalue ((gchar*) g_list_nth_data (g_list_nth_data (TD_FLOWER (flower_interfaces)->items_value, i), 0), "text")), "td_bookmarks_predef");
      td_flower_destroy (TD_FLOWER (flower_interfaces));
    }

  /*** Filtres - Filters */
  if (!already_loaded)
    {
      flower_filters = td_flower_new();
      gtk_object_set (GTK_OBJECT (flower_filters),
		      "root", "filters", 
		      "branch", "filter",
		      "petal", "mode", NULL);
      td_flower_add_branch_attribut (TD_FLOWER (flower_filters), "name");
      td_flower_add_branch_attribut (TD_FLOWER (flower_filters), "directory");
      td_flower_add_branch_attribut (TD_FLOWER (flower_filters), "file");
      td_flower_add_petal_attribut (TD_FLOWER (flower_filters), "name");
      td_flower_add_petal_attribut (TD_FLOWER (flower_filters), "symbol");
      if (td_flower_load_file (TD_FLOWER (flower_filters), g_strdup_printf ("%s/share/%s/filters.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR)))
	td_app_message (NULL, g_strdup_printf (_("Loading file '%s'"), g_strdup_printf ("%s/share/%s/filters.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR)), TD_MSG_DONE);
      else
	td_app_message (_("Loading file"), g_strdup_printf (_("Loading file '%s'"), g_strdup_printf ("%s/share/%s/filters.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR)), TD_MSG_FAILED);
      for (i=0; i<g_list_length (TD_FLOWER (flower_filters)->items_value); i++)
	if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower_filters)->items_level, i)) == 0)
	  {
	    j = i;
	    td_database_insert (g_strdup_printf ("INSERT INTO td_bookmarks_predef (type, value) VALUES ('filter', %s);",
						 td_database_adaptvalue ((gchar*) g_list_nth_data (g_list_nth_data (TD_FLOWER (flower_filters)->items_value, i), 0), "text")), "td_bookmarks_predef");
	  }
	else
	  td_database_insert (g_strdup_printf ("INSERT INTO td_bookmarks_predef (type, parent, value) VALUES ('mode', %s, %s);",
					       td_database_adaptvalue ((gchar*) g_list_nth_data (g_list_nth_data (TD_FLOWER (flower_filters)->items_value, j), 0), "text"),
					       td_database_adaptvalue ((gchar*) g_list_nth_data (g_list_nth_data (TD_FLOWER (flower_filters)->items_value, i), 0), "text")), "td_bookmarks_predef");
      td_flower_destroy (TD_FLOWER (flower_filters));
    }

  /*** Dfinitions - Definitions */
  child_def (mod_main);
  bench_def (mod_main);
  menu_def (mod_main);

  /*** Cration - Creating */
  td_mod_create (TD_MOD (mod_main));
  reset_saved (mod_main);
  return mod_main;
}

/*****************************************************************************/
/*** Enfant - Child */
/*****************************************************************************/
void child_def (GtkObject *mod)
{
  GtkObject *child[4];
  GtkObject *icon0[5];
  GtkObject *icon1[3];
  GtkObject *icon2[4];
  GtkObject *icon3[3];

  GtkWidget *toolbar;
  GtkWidget *toolbar_icon;
  GtkWidget *radiobutton1;
  GtkWidget *radiobutton2;
  GtkWidget *radiobutton3;
  GtkWidget *radiobutton4;
  GtkWidget *button1;
  GtkWidget *button2;
  GtkWidget *button3;
  GtkWidget *button4;
  GtkWidget *button5;

  /*** Barre d'outils - Tools barr */
  toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_widget_show (toolbar);
  td_mod_set_window_toolbar (TD_MOD (mod_main), toolbar);
  radiobutton1 = gtdk_toolbar_append_radiobutton (GTK_TOOLBAR (toolbar), NULL, _("Favorites"), "button_favorites2.xpm");
  gtk_signal_connect (GTK_OBJECT (radiobutton1), "clicked", GTK_SIGNAL_FUNC (radiobutton1_clicked), NULL);
  radiobutton2 = gtdk_toolbar_append_radiobutton (GTK_TOOLBAR (toolbar), radiobutton1, _("Templates"), "button_build.xpm");
  gtk_signal_connect (GTK_OBJECT (radiobutton2), "clicked", GTK_SIGNAL_FUNC (radiobutton2_clicked), NULL);
  radiobutton3 = gtdk_toolbar_append_radiobutton (GTK_TOOLBAR (toolbar), radiobutton2, _("Import-Export"), "button_import_export.xpm");
  gtk_signal_connect (GTK_OBJECT (radiobutton3), "clicked", GTK_SIGNAL_FUNC (radiobutton3_clicked), NULL);
  radiobutton4 = gtdk_toolbar_append_radiobutton (GTK_TOOLBAR (toolbar), radiobutton3, _("History"), "button_clock.xpm");
  gtk_signal_connect (GTK_OBJECT (radiobutton4), "clicked", GTK_SIGNAL_FUNC (radiobutton4_clicked), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  button1 = gtdk_toolbar_append_button_stock (GTK_TOOLBAR (toolbar), _("Reset to standard"), TD_MOD (mod_main)->window, GNOME_STOCK_PIXMAP_CLEAR);
  gtk_signal_connect_object (GTK_OBJECT (button1), "clicked", GTK_SIGNAL_FUNC (reset_standard), GTK_OBJECT (mod));
  button2 = gtdk_toolbar_append_button_stock (GTK_TOOLBAR (toolbar), _("Reset to saved"), TD_MOD (mod_main)->window, GNOME_STOCK_PIXMAP_REVERT);
  gtk_signal_connect_object (GTK_OBJECT (button2), "clicked", GTK_SIGNAL_FUNC (reset_saved), GTK_OBJECT (mod));
  button3 = gtdk_toolbar_append_button_stock (GTK_TOOLBAR (toolbar), _("Save for future sessions"), TD_MOD (mod_main)->window, GNOME_STOCK_PIXMAP_SAVE);
  gtk_signal_connect_object (GTK_OBJECT (button3), "clicked", GTK_SIGNAL_FUNC (save), GTK_OBJECT (mod));
  button4 = gtdk_toolbar_append_button (GTK_TOOLBAR (toolbar), _("Save and open with text editor"), "button_editor.xpm");
  gtk_signal_connect_object (GTK_OBJECT (button4), "clicked", GTK_SIGNAL_FUNC (editor), GTK_OBJECT (mod));
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  button5 = gtdk_toolbar_append_button (GTK_TOOLBAR (toolbar), _("Close"), "button_close.xpm");
  gtk_signal_connect_object (GTK_OBJECT (button5), "clicked", GTK_SIGNAL_FUNC (td_mod_hide), GTK_OBJECT (mod_main));

  /*** Favoris - Favotites */
  child[0] = td_mod_tree_new();
  gtk_object_set (GTK_OBJECT (child[0]),
		  "name", "favorites",
		  "name_intl", _("Favorites"),
		  "reorderable", TRUE,
		  "customize", TRUE,
		  "table", "td_favorites",
		  "table_tree", "td_favorites_tree",
		  "column_oid", 10, NULL);
  td_mod_add_child (TD_MOD (mod), child[0]);

  icon0[0] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon0[0]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_NEW,
		  "pixmap2", (gchar*) TD_STOCK_LIST_NEW,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'file');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[0]), icon0[0]);

  icon0[1] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon0[1]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_DIRECTORY,
		  "pixmap2", (gchar*) TD_STOCK_LIST_DIRECTORY,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'directory');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[0]), icon0[1]);

  icon0[2] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon0[2]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_FOLDER,
		  "pixmap2", (gchar*) TD_STOCK_LIST_FOLDER,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'folder');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[0]), icon0[2]);

  icon0[3] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon0[3]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_URL,
		  "pixmap2", (gchar*) TD_STOCK_LIST_URL,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'url');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[0]), icon0[3]);

  icon0[4] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon0[4]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_DATABASE,
		  "pixmap2", (gchar*) TD_STOCK_LIST_DATABASE,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'database');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[0]), icon0[4]);

  /*** Gabarits - Template */
  child[1] = td_mod_tree_new();
  gtk_object_set (GTK_OBJECT (child[1]),
		  "name", "templates",
		  "name_intl", _("Templates"),
		  "reorderable", TRUE,
		  "customize", TRUE,
		  "table", "td_templates",
		  "table_tree", "td_templates_tree",
		  "column_oid", 3, NULL);
  td_mod_add_child (TD_MOD (mod), child[1]);

  icon1[0] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon1[0]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_NEW,
		  "pixmap2", (gchar*) TD_STOCK_LIST_NEW,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'file');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[1]), icon1[0]);

  icon1[1] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon1[1]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_DIRECTORY,
		  "pixmap2", (gchar*) TD_STOCK_LIST_DIRECTORY,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'directory');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[1]), icon1[1]);

  icon1[2] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon1[2]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_FOLDER,
		  "pixmap2", (gchar*) TD_STOCK_LIST_FOLDER,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'folder');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[1]), icon1[2]);

  /*** Commandes - Commands */
  child[2] = td_mod_tree_new();
  gtk_object_set (GTK_OBJECT (child[2]), 
		  "name", "commands",
		  "name_intl", _("Commands"),
		  "reorderable", TRUE,
		  "customize", TRUE,
		  "table", "td_commands",
		  "table_tree", "td_commands_tree",
		  "column_oid", 6, NULL);
  td_mod_add_child (TD_MOD (mod), child[2]);

  icon2[0] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon2[0]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_FOLDER,
		  "pixmap2", (gchar*) TD_STOCK_LIST_FOLDER,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'folder');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[2]), icon2[0]);

  icon2[1] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon2[1]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_CUSTOMIZE,
		  "pixmap2", (gchar*) TD_STOCK_LIST_CUSTOMIZE,
		  "query_visible", "TD_CURRENT td_id WHERE (mode = 'customize');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[2]), icon2[1]);

  icon2[2] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon2[2]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_PRINT,
		  "pixmap2", (gchar*) TD_STOCK_LIST_PRINT,
		  "query_visible", "TD_CURRENT td_id WHERE (mode = 'print');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[2]), icon2[2]);

  icon2[3] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon2[3]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_IMPORT_EXPORT,
		  "pixmap2", (gchar*) TD_STOCK_LIST_IMPORT_EXPORT,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'command');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[2]), icon2[3]);

  /*** Historique - History */
  child[3] = td_mod_tree_new();
  gtk_object_set (GTK_OBJECT (child[3]),
		  "name", "history",
		  "name_intl", _("History"),
		  "reorderable", TRUE,
		  "customize", TRUE,
		  "table", "td_history",
		  "table_tree", "td_history_tree",
		  "column_oid", 10, NULL);
  td_mod_add_child (TD_MOD (mod), child[3]);

  icon3[0] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon3[0]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_NEW,
		  "pixmap2", (gchar*) TD_STOCK_LIST_NEW,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'file');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[3]), icon3[0]);

  icon3[1] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon3[1]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_URL,
		  "pixmap2", (gchar*) TD_STOCK_LIST_URL,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'url');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[3]), icon3[1]);

  icon3[2] = td_mod_tree_icon_new();
  gtk_object_set (GTK_OBJECT (icon3[2]),
		  "pixmap1", (gchar*) TD_STOCK_LIST_DATABASE,
		  "pixmap2", (gchar*) TD_STOCK_LIST_DATABASE,
		  "query_visible", "TD_CURRENT td_id WHERE (type = 'database');", NULL);
  td_mod_tree_add_icon (TD_MOD_TREE (child[3]), icon3[2]);
}

/*****************************************************************************/
/*** Barre d'outils - Tools barr */
/*****************************************************************************/

void radiobutton1_clicked (GtkRadioButton *radiobutton, gpointer *user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod_main)->window_notebook), 0);
}

void radiobutton2_clicked (GtkRadioButton *radiobutton, gpointer *user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod_main)->window_notebook), 1);
}

void radiobutton3_clicked (GtkRadioButton *radiobutton, gpointer *user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod_main)->window_notebook), 2);
}

void radiobutton4_clicked (GtkRadioButton *radiobutton, gpointer *user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod_main)->window_notebook), 3);
}

void editor (GtkObject *mod)
{
  if (save (mod))
    td_editor_txt (g_strdup_printf ("%s/bookmarks.xml", TD_PACKAGE_VAR_DIR));
}

/*****************************************************************************/
/*** Etablis - Benchs */
/*****************************************************************************/
void bench_def (GtkObject *mod)
{
  GtkObject *bench0[9];
  GtkObject *bench1[2];
  GtkObject *bench2[5];
  GtkWidget *prop_widget[4];

  /*** Favoris - Favorites */
  bench0[0] = td_mod_bench_new(); /* 0 */
  gtk_object_set (GTK_OBJECT (bench0[0]), "name", _("Name"), NULL);
  td_mod_bench_set_widget (TD_MOD_BENCH (bench0[0]), gtk_entry_new(), NULL);
  td_mod_add_bench (TD_MOD (mod), bench0[0]);

  bench0[1] = td_mod_bench_new(); /* 1 */
  gtk_object_set (GTK_OBJECT (bench0[1]), 
		  "name", _("Interface"),
		  "list_query", "SELECT value FROM td_bookmarks_predef WHERE type = 'interface';",
		  "list_type", "bench list query", NULL);
  td_mod_bench_set_widget (TD_MOD_BENCH (bench0[1]), gtk_entry_new(), NULL);
  td_mod_add_bench (TD_MOD (mod), bench0[1]);

  bench0[2] = td_mod_bench_new(); /* 2 */
  gtk_object_set (GTK_OBJECT (bench0[2]), "name", _("Host"), NULL);
  td_mod_bench_set_widget (TD_MOD_BENCH (bench0[2]), gtk_entry_new(), NULL);
  td_mod_add_bench (TD_MOD (mod), bench0[2]);

  bench0[3] = td_mod_bench_new(); /* 3 */
  gtk_object_set (GTK_OBJECT (bench0[3]), "name", _("Port"), NULL);
  td_mod_bench_set_widget (TD_MOD_BENCH (bench0[3]), gtk_entry_new(), NULL);
  td_mod_add_bench (TD_MOD (mod), bench0[3]);

  bench0[4] = td_mod_bench_new(); /* 4 */
  gtk_object_set (GTK_OBJECT (bench0[4]), "name", _("Base"), NULL);
  td_mod_bench_set_widget (TD_MOD_BENCH (bench0[4]), gtk_entry_new(), NULL);
  td_mod_add_bench (TD_MOD (mod), bench0[4]);

  bench0[5] = td_mod_bench_new(); /* 5 */
  gtk_object_set (GTK_OBJECT (bench0[5]), "name", _("User"), NULL);
  td_mod_bench_set_widget (TD_MOD_BENCH (bench0[5]), gtk_entry_new(), NULL);
  td_mod_add_bench (TD_MOD (mod), bench0[5]);

  bench0[6] = td_mod_bench_new(); /* 6 */
  gtk_object_set (GTK_OBJECT (bench0[6]), "name", _("Password"), NULL);
  td_mod_bench_set_widget (TD_MOD_BENCH (bench0[6]), gtk_entry_new(), NULL);
  td_mod_add_bench (TD_MOD (mod), bench0[6]);

  bench0[7] = td_mod_bench_new(); /* 7 */
  gtk_object_set (GTK_OBJECT (bench0[7]), "name", _("Template"), NULL);
  prop_widget[0] = gtdk_entry_file_selector (_("Select directory/file"), g_get_home_dir(), NULL);
  td_mod_bench_set_widget (TD_MOD_BENCH (bench0[7]),
			      g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget[0])), 0),
			      prop_widget[0]);
  td_mod_add_bench (TD_MOD (mod), bench0[7]);

  bench0[8] = td_mod_bench_new(); /* 8 */
  gtk_object_set (GTK_OBJECT (bench0[8]), "name", _("Location"), NULL);
  prop_widget[1] = gtdk_entry_file_selector (_("Select directory/file"), g_get_home_dir(), NULL);
  td_mod_bench_set_widget (TD_MOD_BENCH (bench0[8]),
			      g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget[1])), 0),
			      prop_widget[1]);
  td_mod_add_bench (TD_MOD (mod), bench0[8]);

  /*** Gabarits - Templates */
  bench1[0] = td_mod_bench_new(); /* 9 */
  gtk_object_set (GTK_OBJECT (bench1[0]), "name", _("Name"), NULL);
  td_mod_bench_set_widget (TD_MOD_BENCH (bench1[0]), gtk_entry_new(), NULL);
  td_mod_add_bench (TD_MOD (mod), bench1[0]);

  bench1[1] = td_mod_bench_new(); /* 10 */
  gtk_object_set (GTK_OBJECT (bench1[1]), "name", _("Location"), NULL);
  prop_widget[2] = gtdk_entry_file_selector (_("Select directory/file"), g_get_home_dir(), NULL);
  td_mod_bench_set_widget (TD_MOD_BENCH (bench1[1]),
			      g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget[2])), 0),
			      prop_widget[2]);
  td_mod_add_bench (TD_MOD (mod), bench1[1]);

  /*** Commandes - Commands */
  bench2[0] = td_mod_bench_new(); /* 11 */
  gtk_object_set (GTK_OBJECT (bench2[0]), "name", _("Name"), NULL);
  td_mod_bench_set_widget (TD_MOD_BENCH (bench2[0]), gtk_entry_new(), NULL);
  td_mod_add_bench (TD_MOD (mod), bench2[0]);

  bench2[1] = td_mod_bench_new(); /* 12 */
  gtk_object_set (GTK_OBJECT (bench2[1]), "name", _("Location"), NULL);
  prop_widget[3] = gtdk_entry_file_selector (_("Select directory/file"), g_get_home_dir(), NULL);
  td_mod_bench_set_widget (TD_MOD_BENCH (bench2[1]),
			      g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget[3])), 0),
			      prop_widget[3]);
  td_mod_add_bench (TD_MOD (mod), bench2[1]);

  bench2[2] = td_mod_bench_new(); /* 13 */
  gtk_object_set (GTK_OBJECT (bench2[2]), "name", _("Command"), NULL);
  td_mod_bench_set_widget (TD_MOD_BENCH (bench2[2]), gtk_entry_new(), NULL);
  td_mod_add_bench (TD_MOD (mod), bench2[2]);

  bench2[3] = td_mod_bench_new(); /* 14 */
  gtk_object_set (GTK_OBJECT (bench2[3]),
		  "name", _("Format"),
  		  "list_query", "SELECT value FROM td_bookmarks_predef WHERE type = 'filter';",
		  "list_type", "bench list query", NULL);
  td_mod_bench_set_widget (TD_MOD_BENCH (bench2[3]), gtk_entry_new(), NULL);
  td_mod_add_bench (TD_MOD (mod), bench2[3]);

  bench2[4] = td_mod_bench_new(); /* 15 */
  gtk_object_set (GTK_OBJECT (bench2[4]),
		  "name", _("Mode"),
		  "list_query", "(null)",
		  "list_type", "bench list query", NULL);
  td_mod_bench_set_widget (TD_MOD_BENCH (bench2[4]), gtk_entry_new(), NULL);
  td_mod_add_bench (TD_MOD (mod), bench2[4]);
}

void plugins_bench_refresh (GtkObject *mod, GtkObject *mod_tree)
{
  int i;
  GtkCTreeNode *node;
  GtkCTreeNode *node_module;
  GtkCTreeNode *node_table;

  /*** Recherche du module enfant - Searchin module's child */
  for (i=0; i<g_list_length (TD_MOD (mod_main)->child); i++)
    if (mod_tree == g_list_nth_data (TD_MOD (mod_main)->child, i))
      break;

  /*** Go ! */
  switch (i)
    {

      /*** Favoris - Favorites */
    case 0:
      td_database_set_current (g_strdup_printf ("SELECT %s FROM td_favorites WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 0)),
		      "query_refresh", "TD_CURRENT name;",
		      "query_visible", "TD_CURRENT td_id WHERE NOT (type = 'separator');", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 1)),
		      "query_refresh", "TD_CURRENT interface;",
		      "query_visible", "TD_CURRENT td_id WHERE (type = 'database');", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 2)),
		      "query_refresh", "TD_CURRENT host;",
		      "query_visible", "TD_CURRENT td_id WHERE (type = 'database');", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 3)),
		      "query_refresh", "TD_CURRENT port;",
		      "query_visible", "TD_CURRENT td_id WHERE (type = 'database');", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 4)),
		      "query_refresh", "TD_CURRENT base;",
		      "query_visible", g_strdup_printf ("SELECT td_id FROM td_favorites WHERE ((type = 'database') OR (type = 'url')) AND (td_id = %d);", CURRENT_ID), NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 5)),
		      "query_refresh", "TD_CURRENT uuser;",
		      "query_visible", "TD_CURRENT td_id WHERE (type = 'database');", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 6)),
		      "query_refresh", "TD_CURRENT password;",
		      "query_visible", "TD_CURRENT td_id WHERE (type = 'database');", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 7)),
		      "query_refresh", "TD_CURRENT template;",
		      "query_visible", "TD_CURRENT td_id WHERE (type = 'database');", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 8)),
		      "query_refresh", "TD_CURRENT location;",
		      "query_visible", g_strdup_printf ("SELECT td_id FROM td_favorites WHERE ((type = 'directory') OR (type = 'file') OR (type = 'url')) AND (td_id = %d);", CURRENT_ID), NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 9)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 10)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 11)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 12)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 13)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 14)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 15)), "query_visible", "(null)", NULL);
      break;

      /*** Gabarits - Templates */
    case 1:
      td_database_set_current (g_strdup_printf ("SELECT %s FROM td_templates WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 0)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 1)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 2)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 3)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 4)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 5)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 6)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 7)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 8)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 9)),
		      "query_refresh", "TD_CURRENT name;",
		      "query_visible", "TD_CURRENT td_id WHERE NOT (type = 'separator');", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 10)),
		      "query_refresh", "TD_CURRENT location;",
		      "query_visible", "TD_CURRENT td_id WHERE (type = 'file');", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 11)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 12)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 13)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 14)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 15)), "query_visible", "(null)", NULL);
      break;

      /*** Commandes - Commands */
    case 2:
      td_database_set_current (g_strdup_printf ("SELECT %s FROM td_commands WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 0)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 1)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 2)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 3)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 4)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 5)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 6)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 7)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 8)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 9)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 10)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 11)),
		      "query_refresh", "TD_CURRENT name;",
		      "query_visible", "TD_CURRENT td_id WHERE NOT (type = 'separator');", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 12)),
		      "query_refresh", "TD_CURRENT location;",
		      "query_visible", "TD_CURRENT td_id WHERE (type = 'command');", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 13)),
		      "query_refresh", "TD_CURRENT command;",
		      "query_visible", "TD_CURRENT td_id WHERE (type = 'command');", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 14)),
		      "query_refresh", "TD_CURRENT format;",
		      "query_visible", "TD_CURRENT td_id WHERE (type = 'command');", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 15)),
		      "query_refresh", "TD_CURRENT mode;",
		      "query_visible", "TD_CURRENT td_id WHERE (type = 'command');",
		      "list_query", g_strdup_printf ("SELECT value FROM td_bookmarks_predef WHERE (type = 'mode') AND (parent = '%s');", td_database_value ("TD_CURRENT format;")), NULL);
      break;

      /*** Historique - History */
    case 3:
      td_database_set_current (g_strdup_printf ("SELECT %s FROM td_history WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 0)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 1)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 2)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 3)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 4)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 5)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 6)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 7)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 8)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 9)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 10)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 11)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 12)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 13)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 14)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->bench, 15)), "query_visible", "(null)", NULL);
      break;
    default:
      break;
    }
}

void plugins_etabliste_refresh (GtkObject *mod, GtkObject *mod_tree)
{
}

void plugins_bench_action (GtkObject *mod, gchar *value, gchar *table_field, int bench_id)
{
  TD_FLAG_NO_REFRESH_NODE = TRUE;
  switch (bench_id)
    {

      /*** Favoris - Favorites */
    case 0:
      td_database_command (g_strdup_printf ("UPDATE td_favorites SET name = %s WHERE td_id = %d;", td_database_adaptvalue (value, "text"), CURRENT_ID));
      td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 0)));
      break;
    case 1:
      td_database_command (g_strdup_printf ("UPDATE td_favorites SET interface = %s WHERE td_id = %d;", td_database_adaptvalue (value, "text"), CURRENT_ID));
      td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 0)));
      break;
    case 2:
      td_database_command (g_strdup_printf ("UPDATE td_favorites SET host = %s WHERE td_id = %d;", td_database_adaptvalue (value, "text"), CURRENT_ID));
      td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 0)));
      break;
    case 3:
      td_database_command (g_strdup_printf ("UPDATE td_favorites SET port = %s WHERE td_id = %d;", td_database_adaptvalue (value, "text"), CURRENT_ID));
      td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 0)));
      break;
    case 4:
      td_database_command (g_strdup_printf ("UPDATE td_favorites SET base = %s WHERE td_id = %d;", td_database_adaptvalue (value, "text"), CURRENT_ID));
      td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 0)));
      break;
    case 5:
      td_database_command (g_strdup_printf ("UPDATE td_favorites SET uuser = %s WHERE td_id = %d;", td_database_adaptvalue (value, "text"), CURRENT_ID));
      td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 0)));
      break;
    case 6:
      td_database_command (g_strdup_printf ("UPDATE td_favorites SET password = %s WHERE td_id = %d;", td_database_adaptvalue (value, "text"), CURRENT_ID));
      td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 0)));
      break;
    case 7:
      td_database_command (g_strdup_printf ("UPDATE td_favorites SET template = %s WHERE td_id = %d;", td_database_adaptvalue (value, "text"), CURRENT_ID));
      td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 0)));
      break;
    case 8:
      td_database_command (g_strdup_printf ("UPDATE td_favorites SET location = %s WHERE td_id = %d;", td_database_adaptvalue (value, "text"), CURRENT_ID));
      td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 0)));
      break;

      /*** Gabarits - Templates */
    case 9:
      td_database_command (g_strdup_printf ("UPDATE td_templates SET name = %s WHERE td_id = %d;", td_database_adaptvalue (value, "text"), CURRENT_ID));
      td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 1)));
      break;
    case 10:
      td_database_command (g_strdup_printf ("UPDATE td_templates SET location = %s WHERE td_id = %d;", td_database_adaptvalue (value, "text"), CURRENT_ID));
      td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 1)));
      break;

      /*** Commandes - Commands */
    case 11:
      td_database_command (g_strdup_printf ("UPDATE td_commands SET name = %s WHERE td_id = %d;", td_database_adaptvalue (value, "text"), CURRENT_ID));
      td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 2)));
      break;
    case 12:
      td_database_command (g_strdup_printf ("UPDATE td_commands SET location = %s WHERE td_id = %d;", td_database_adaptvalue (value, "text"), CURRENT_ID));
      td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 2)));
      break;
    case 13:
      td_database_command (g_strdup_printf ("UPDATE td_commands SET command = %s WHERE td_id = %d;", td_database_adaptvalue (value, "text"), CURRENT_ID));
      td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 2)));
      break;
    case 14:
      td_database_command (g_strdup_printf ("UPDATE td_commands SET format = %s WHERE td_id = %d;", td_database_adaptvalue (value, "text"), CURRENT_ID));
      td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 2)));
      break;
    case 15:
      td_database_command (g_strdup_printf ("UPDATE td_commands SET mode = %s WHERE td_id = %d;", td_database_adaptvalue (value, "text"), CURRENT_ID));
      td_mod_tree_update_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2)));
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 2)));
      break;
    default:
      break;
    }
  TD_FLAG_NO_REFRESH_NODE = FALSE;
}

void plugins_etabliste_action (GtkObject *mod, gchar *value, gchar *table_field, int etabliste_id)
{
}

/*****************************************************************************/
/*** Menu */
/*****************************************************************************/
void menu_def (GtkObject *mod)
{
  GtkObject *menu0[9];
  GtkObject *menu1[6];
  GtkObject *menu2[6];

  /*** Favoris - Favorites */
  menu0[0] = td_mod_menu_new(); /* 0 */
  gtk_object_set (GTK_OBJECT (menu0[0]), 
		  "label", _("Create folder"), 
		  "icon", "list_folder.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu0[0]);

  menu0[1] = td_mod_menu_new(); /* 1 */
  gtk_object_set (GTK_OBJECT (menu0[1]), "label", _("Create separator"), NULL);
  td_mod_add_menu (TD_MOD (mod), menu0[1]);

  td_mod_add_menu (TD_MOD (mod), td_mod_menu_new()); /* 2 */

  menu0[3] = td_mod_menu_new(); /* 3 */
  gtk_object_set (GTK_OBJECT (menu0[3]), 
		  "label", _("Add file"), 
		  "icon", "list_new.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu0[3]);

  menu0[4] = td_mod_menu_new(); /* 4 */
  gtk_object_set (GTK_OBJECT (menu0[4]), 
		  "label", _("Add directory"), 
		  "icon", "list_directory.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu0[4]);

  menu0[5] = td_mod_menu_new(); /* 5 */
  gtk_object_set (GTK_OBJECT (menu0[5]), 
		  "label", _("Add url"), 
		  "icon", "list_url.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu0[5]);

  menu0[6] = td_mod_menu_new(); /* 6 */
  gtk_object_set (GTK_OBJECT (menu0[6]), 
		  "label", _("Add database"), 
		  "icon", "list_database.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu0[6]);

  td_mod_add_menu (TD_MOD (mod), td_mod_menu_new()); /* 7 */

  menu0[8] = td_mod_menu_new(); /* 8 */
  gtk_object_set (GTK_OBJECT (menu0[8]), 
		  "label", _("Remove"), 
		  "icon", "list_trash.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu0[8]);

  /*** Gabarits - Templates */
  menu1[0] = td_mod_menu_new(); /* 9 */
  gtk_object_set (GTK_OBJECT (menu1[0]), 
		  "label", _("Create folder"), 
		  "icon", "list_folder.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu1[0]);

  menu1[1] = td_mod_menu_new(); /* 10 */
  gtk_object_set (GTK_OBJECT (menu1[1]), "label", _("Create separator"), NULL);
  td_mod_add_menu (TD_MOD (mod), menu1[1]);

  td_mod_add_menu (TD_MOD (mod), td_mod_menu_new()); /* 11 */

  menu1[3] = td_mod_menu_new(); /* 12 */
  gtk_object_set (GTK_OBJECT (menu1[3]), 
		  "label", _("Add template"), 
		  "icon", "list_new.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu1[3]);

  td_mod_add_menu (TD_MOD (mod), td_mod_menu_new()); /* 13 */

  menu1[5] = td_mod_menu_new(); /* 14 */
  gtk_object_set (GTK_OBJECT (menu1[5]), 
		  "label", _("Remove"), 
		  "icon", "list_trash.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu1[5]);

  /*** Commandes - Commands */
  menu2[0] = td_mod_menu_new(); /* 15 */
  gtk_object_set (GTK_OBJECT (menu2[0]), 
		  "label", _("Create folder"), 
		  "icon", "list_folder.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu2[0]);

  menu2[1] = td_mod_menu_new(); /* 16 */
  gtk_object_set (GTK_OBJECT (menu2[1]), "label", _("Create separator"), NULL);
  td_mod_add_menu (TD_MOD (mod), menu2[1]);

  td_mod_add_menu (TD_MOD (mod), td_mod_menu_new()); /* 17 */

  menu2[3] = td_mod_menu_new(); /* 18 */
  gtk_object_set (GTK_OBJECT (menu2[3]), 
		  "label", _("Add command"), 
		  "icon", "list_import_export.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu2[3]);

  td_mod_add_menu (TD_MOD (mod), td_mod_menu_new()); /* 19 */

  menu2[5] = td_mod_menu_new(); /* 20 */
  gtk_object_set (GTK_OBJECT (menu2[5]), 
		  "label", _("Remove"), 
		  "icon", "list_trash.xpm", NULL);
  td_mod_add_menu (TD_MOD (mod), menu2[5]);

  td_mod_add_menu (TD_MOD (mod), td_mod_menu_new()); /* 21 */
}

void plugins_menu_refresh (GtkObject *mod, GtkObject *mod_tree)
{
  int i;

  /*** Recherche du module enfant - Searching module's child */
  for (i=0; i<g_list_length (TD_MOD (mod_main)->child); i++)
    if (mod_tree == g_list_nth_data (TD_MOD (mod_main)->child, i))
      break;

  /*** Go ! */
  switch (i)
    {

      /*** Favoris - Favotites */
    case 0:
      td_database_set_current (g_strdup_printf ("SELECT %s FROM td_favorites WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 0)), "query_visible", "TD_CURRENT (*);", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 1)), "query_visible", "TD_CURRENT (*);", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 2)), "query_visible", "TD_CURRENT (*);", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 3)), "query_visible", "TD_CURRENT (*);", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 4)), "query_visible", "TD_CURRENT (*);", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 5)), "query_visible", "TD_CURRENT (*);", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 6)), "query_visible", "TD_CURRENT (*);", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 7)), "query_visible", "TD_CURRENT td_id;", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 8)), "query_visible", "TD_CURRENT td_id;", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 9)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 10)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 11)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 12)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 13)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 14)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 15)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 16)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 17)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 18)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 19)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 20)), "query_visible", "(null)", NULL);
      break;

      /*** Gabarits - Templates */
    case 1:
      td_database_set_current (g_strdup_printf ("SELECT %s FROM td_templates WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 0)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 1)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 2)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 3)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 4)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 5)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 6)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 7)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 8)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 9)), "query_visible", "TD_CURRENT (*);", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 10)), "query_visible", "TD_CURRENT (*);", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 11)), "query_visible", "TD_CURRENT (*);", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 12)), "query_visible", "TD_CURRENT (*);", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 13)), "query_visible", "TD_CURRENT td_id;", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 14)), "query_visible", "TD_CURRENT td_id;", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 15)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 16)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 17)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 18)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 19)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 20)), "query_visible", "(null)", NULL);
      break;

      /* Commandes - Commands */
    case 2:
      td_database_set_current (g_strdup_printf ("SELECT %s FROM td_commands WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 0)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 1)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 2)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 3)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 4)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 5)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 6)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 7)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 8)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 9)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 10)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 11)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 12)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 13)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 14)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 15)), "query_visible", "TD_CURRENT (*);", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 16)), "query_visible", "TD_CURRENT (*);", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 17)), "query_visible", "TD_CURRENT (*);", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 18)), "query_visible", "TD_CURRENT (*);", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 19)), "query_visible", "TD_CURRENT td_id;", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 20)), "query_visible", "TD_CURRENT td_id;", NULL);
      break;

      /*** Historique - History */
    case 3:
      td_database_set_current (g_strdup_printf ("SELECT %s FROM td_history WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 0)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 1)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 2)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 3)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 4)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 5)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 6)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 7)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 8)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 9)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 10)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 11)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 12)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 13)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 14)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 15)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 16)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 17)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 18)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 19)), "query_visible", "(null)", NULL);
      gtk_object_set (GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->menu, 20)), "query_visible", "(null)", NULL);
      break;
    default:
      break;
    }
}

void plugins_menu_action (GtkObject *mod, int menu_id)
{
  GtkCTreeNode *node;
  GList *row;
  int id_sibling;
  int id_parent;
  switch (menu_id)
    {

      /*** Favoris - Favorites */
    case 0:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert ("INSERT INTO td_favorites (type) VALUES ('folder');", "td_favorites");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_favorites WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected, NULL, row);
      td_database_command (g_strdup_printf ("UPDATE td_favorites_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_favorites_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_favorites_tree");
      if (CURRENT_ID_PARENT > 0)
	gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected);
      break;

    case 1:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert ("INSERT INTO td_favorites (name, type) VALUES ('----------', 'separator');", "td_favorites");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_favorites WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected, NULL, row);
      if (CURRENT_ID_PARENT > 0)
	gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected);
      td_database_command (g_strdup_printf ("UPDATE td_favorites_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_favorites_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_favorites_tree");
      break;

    case 3:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert ("INSERT INTO td_favorites (type) VALUES ('file');", "td_favorites");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_favorites WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected, NULL, row);
      if (CURRENT_ID_PARENT > 0)
	gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected);
      td_database_command (g_strdup_printf ("UPDATE td_favorites_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_favorites_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_favorites_tree");
      break;

    case 4:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert ("INSERT INTO td_favorites (type) VALUES ('directory');", "td_favorites");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_favorites WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected, NULL, row);
      if (CURRENT_ID_PARENT > 0)
	gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected);
      td_database_command (g_strdup_printf ("UPDATE td_favorites_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_favorites_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_favorites_tree");
      break;

    case 5:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert ("INSERT INTO td_favorites (type) VALUES ('url');", "td_favorites");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_favorites WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected, NULL, row);
      if (CURRENT_ID_PARENT > 0)
	gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected);
      td_database_command (g_strdup_printf ("UPDATE td_favorites_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_favorites_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_favorites_tree");
      break;

    case 6:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert ("INSERT INTO td_favorites (type) VALUES ('database');", "td_favorites");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_favorites WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected, NULL, row);
      if (CURRENT_ID_PARENT > 0)
	gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected);
      td_database_command (g_strdup_printf ("UPDATE td_favorites_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_favorites_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_favorites_tree");
      break;

    case 8:
      id_sibling = atoi (td_database_value (g_strdup_printf ("SELECT td_id_sibling FROM td_favorites_tree WHERE td_id = %d;", CURRENT_ID)));
      id_parent = atoi (td_database_value (g_strdup_printf ("SELECT td_id_parent FROM td_favorites_tree WHERE td_id = %d;", CURRENT_ID)));
      td_database_command (g_strdup_printf ("UPDATE td_favorites_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = %d);", id_sibling, CURRENT_ID_PARENT, CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM td_favorites WHERE td_id IN (SELECT td_id FROM td_favorites_tree WHERE td_id_parent = %d);", CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM td_favorites_tree WHERE td_id = %d;", CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM td_favorites_tree WHERE td_id_parent = %d;", CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM td_favorites WHERE td_id = %d;", CURRENT_ID));
      gtk_ctree_remove_node (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected);
      CURRENT_ID = -1;
      CURRENT_ROW = NULL;
      TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected = NULL;
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 0)));
      break;

      /*** Gabarits - Templates */
    case 9:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert ("INSERT INTO td_templates (type) VALUES ('folder');", "td_templates");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_templates WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected, NULL, row);
      if (CURRENT_ID_PARENT > 0)
	gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected);
      td_database_command (g_strdup_printf ("UPDATE td_templates_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_templates_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_templates_tree");
      break;

    case 10:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert ("INSERT INTO td_templates (name, type) VALUES ('----------', 'separator');", "td_templates");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_templates WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected, NULL, row);
      if (CURRENT_ID_PARENT > 0)
	gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected);
      td_database_command (g_strdup_printf ("UPDATE td_templates_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_templates_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_templates_tree");
      break;

    case 12:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert ("INSERT INTO td_templates (type) VALUES ('file');", "td_templates");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_templates WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected, NULL, row);
      if (CURRENT_ID_PARENT > 0)
	gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected);
      td_database_command (g_strdup_printf ("UPDATE td_templates_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_templates_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_templates_tree");
      break;

    case 14:
      id_sibling = atoi (td_database_value (g_strdup_printf ("SELECT td_id_sibling FROM td_templates_tree WHERE td_id = %d;", CURRENT_ID)));
      id_parent = atoi (td_database_value (g_strdup_printf ("SELECT td_id_parent FROM td_templates_tree WHERE td_id = %d;", CURRENT_ID)));
      td_database_command (g_strdup_printf ("UPDATE td_templates_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = %d);", id_sibling, CURRENT_ID_PARENT, CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM td_templates WHERE td_id IN (SELECT td_id FROM td_templates_tree WHERE td_id_parent = %d);", CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM td_templates_tree WHERE td_id = %d;", CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM td_templates_tree WHERE td_id_parent = %d;", CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM td_templates WHERE td_id = %d;", CURRENT_ID));
      gtk_ctree_remove_node (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected);
      CURRENT_ID = 0;
      CURRENT_ROW = NULL;
      TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected = NULL;
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 1)));
      break;

      /*** Commandes - Commands */
    case 15:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert ("INSERT INTO td_commands (type) VALUES ('folder');", "td_commands");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_commands WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2))->selected, NULL, row);
      if (CURRENT_ID_PARENT > 0)
	gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2))->selected);
      td_database_command (g_strdup_printf ("UPDATE td_commands_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_commands_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_commands_tree");
      break;

    case 16:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert ("INSERT INTO td_commands (name, type) VALUES ('----------', 'separator');", "td_commands");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_commands WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2))->selected, NULL, row);
      if (CURRENT_ID_PARENT > 0)
	gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2))->selected);
      td_database_command (g_strdup_printf ("UPDATE td_commands_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_commands_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_commands_tree");
      break;

    case 18:
      CURRENT_ID_PARENT = CURRENT_ID;
      td_database_insert ("INSERT INTO td_commands (type) VALUES ('command');", "td_commands");
      row = td_database_row (g_strdup_printf ("SELECT %s FROM td_commands WHERE td_id = %d;", TD_MOD (mod)->fields, CURRENT_ID));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2))->selected, NULL, row);
      if (CURRENT_ID_PARENT > 0)
	gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2))->selected);
      td_database_command (g_strdup_printf ("UPDATE td_commands_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = 0);", CURRENT_ID, CURRENT_ID_PARENT));
      td_database_insert (g_strdup_printf ("INSERT INTO td_commands_tree (td_id, td_id_parent, td_id_sibling) VALUES (%d, %d, 0);", CURRENT_ID, CURRENT_ID_PARENT), "td_commands_tree");
      break;

    case 20:
      id_sibling = atoi (td_database_value (g_strdup_printf ("SELECT td_id_sibling FROM td_commands_tree WHERE td_id = %d;", CURRENT_ID)));
      id_parent = atoi (td_database_value (g_strdup_printf ("SELECT td_id_parent FROM td_commands_tree WHERE td_id = %d;", CURRENT_ID)));
      td_database_command (g_strdup_printf ("UPDATE td_commands_tree SET td_id_sibling = %d WHERE (td_id_parent = %d) AND (td_id_sibling = %d);", id_sibling, CURRENT_ID_PARENT, CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM td_commands WHERE td_id IN (SELECT td_id FROM td_commands_tree WHERE td_id_parent = %d);", CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM td_commands_tree WHERE td_id = %d;", CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM td_commands_tree WHERE td_id_parent = %d;", CURRENT_ID));
      td_database_command (g_strdup_printf ("DELETE FROM td_commands WHERE td_id = %d;", CURRENT_ID));
      gtk_ctree_remove_node (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2))->selected);
      CURRENT_ID = 0;
      CURRENT_ROW = NULL;
      TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2))->selected = NULL;
      td_mod_refresh_bench (TD_MOD (mod), GTK_OBJECT (g_list_nth_data (TD_MOD (mod)->child, 2)));
      break;
    default:
      break;
    }
}

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/
gboolean save (GtkObject *mod)
{
  GtkObject *base;
  gchar *file = g_strdup_printf ("%s/bookmarks.xml", TD_PACKAGE_VAR_DIR);
  td_app_message (NULL, _("Saving bookmarks"), TD_MSG_BEGIN);

  /*** Fichier - File */
  base = td_db_base_new();
  td_db_base_add_datatable (TD_DB_BASE (base), td_database_select ("SELECT * FROM td_favorites ORDER BY td_id;"));
  td_db_datatable_set_table (g_list_nth_data (TD_DB_BASE (base)->datatable, 0), "td_favorites");
  td_db_base_add_datatable (TD_DB_BASE (base), td_database_select ("SELECT * FROM td_favorites_tree ORDER BY td_id;"));
  td_db_datatable_set_table (g_list_nth_data (TD_DB_BASE (base)->datatable, 1), "td_favorites_tree");
  td_db_base_add_datatable (TD_DB_BASE (base), td_database_select ("SELECT * FROM td_templates ORDER BY td_id;"));
  td_db_datatable_set_table (g_list_nth_data (TD_DB_BASE (base)->datatable, 2), "td_templates");
  td_db_base_add_datatable (TD_DB_BASE (base), td_database_select ("SELECT * FROM td_templates_tree ORDER BY td_id;"));
  td_db_datatable_set_table (g_list_nth_data (TD_DB_BASE (base)->datatable, 3), "td_templates_tree");
  td_db_base_add_datatable (TD_DB_BASE (base), td_database_select ("SELECT * FROM td_commands ORDER BY td_id;"));
  td_db_datatable_set_table (g_list_nth_data (TD_DB_BASE (base)->datatable, 4), "td_commands");
  td_db_base_add_datatable (TD_DB_BASE (base), td_database_select ("SELECT * FROM td_commands_tree ORDER BY td_id;"));
  td_db_datatable_set_table (g_list_nth_data (TD_DB_BASE (base)->datatable, 5), "td_commands_tree");
  td_db_base_add_datatable (TD_DB_BASE (base), td_database_select ("SELECT * FROM td_history ORDER BY td_id;"));
  td_db_datatable_set_table (g_list_nth_data (TD_DB_BASE (base)->datatable, 6), "td_history");
  td_db_base_add_datatable (TD_DB_BASE (base), td_database_select ("SELECT * FROM td_history_tree ORDER BY td_id;"));
  td_db_datatable_set_table (g_list_nth_data (TD_DB_BASE (base)->datatable, 7), "td_history_tree");
  if (!td_db_base_save (TD_DB_BASE (base), file))
    td_app_message (NULL, g_strdup_printf (_("Saving support file '%s'"), file), TD_MSG_FAILED);
  else
    td_app_message (NULL, g_strdup_printf (_("Saving support file '%s'"), file), TD_MSG_DONE);
  base_start = td_db_base_load (file);
  td_app_message (NULL, _("Saving bookmarks"), TD_MSG_END);
  return TRUE;
}

void reset_standard (GtkObject *mod)
{
  if (td_file_exist (g_strdup_printf ("%s/share/%s/%s/bookmarks-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, TD_MOD (mod)->name, _("en"))))
    load_file (mod, g_strdup_printf ("%s/share/%s/%s/bookmarks-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, TD_MOD (mod)->name, _("en")));
  else
    load_file (mod, g_strdup_printf ("%s/share/%s/%s/bookmarks-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, TD_MOD (mod)->name, "en"));
}

void reset_saved (GtkObject *mod)
{
  if (td_file_exist (g_strdup_printf ("%s/bookmarks.xml", TD_PACKAGE_VAR_DIR)))
    load_file (mod, g_strdup_printf ("%s/bookmarks.xml", TD_PACKAGE_VAR_DIR));
  else
    reset_standard (mod);
}

void load_file (GtkObject *mod, gchar* file)
{
  GtkObject *base;
  int i;
  td_app_message (NULL, _("Loading bookmarks"), TD_MSG_BEGIN);

  /*** Fichier - File */
  td_database_command ("DELETE FROM td_favorites;");
  td_database_command ("DELETE FROM td_favorites_tree;");
  td_database_command ("DELETE FROM td_templates;");
  td_database_command ("DELETE FROM td_templates_tree;");
  td_database_command ("DELETE FROM td_commands;");
  td_database_command ("DELETE FROM td_commands_tree;");
  td_database_command ("DELETE FROM td_history;");
  td_database_command ("DELETE FROM td_history_tree;");
  base = td_db_base_load (file);
  for (i=0; i < g_list_length (TD_DB_BASE (base)->datatable); i++)
    if (!td_database_table_copy_in (g_list_nth_data (TD_DB_BASE (base)->datatable, i)))
      td_app_message (NULL, g_strdup_printf (_("Loading support file '%s'"), file), TD_MSG_FAILED);

  /*** Arbre - Tree */
  td_mod_tree_refresh (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)));
  td_mod_tree_refresh (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)));
  td_mod_tree_refresh (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2)));
  td_mod_tree_refresh (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 3)));
  td_app_message (NULL, g_strdup_printf (_("Loading support file '%s'"), file), TD_MSG_DONE);
  td_app_message (NULL, _("Loading bookmarks"), TD_MSG_END);
}

/*****************************************************************************/
/*** Application */
/*****************************************************************************/
void plugins_start (TdApp *app)
{
  GtkObject *base;
  gchar *file;
  int i, j;
  td_app_message (NULL, _("Loading bookmarks"), TD_MSG_BEGIN);
  if (td_file_exist (g_strdup_printf ("%s/bookmarks.xml", TD_PACKAGE_VAR_DIR)))
    file = g_strdup_printf ("%s/bookmarks.xml", TD_PACKAGE_VAR_DIR);
  else
    if (td_file_exist (g_strdup_printf ("%s/share/%s/help_bookmarks/bookmarks-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, _("en"))))
      file = g_strdup_printf ("%s/share/%s/help_bookmarks/bookmarks-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, _("en"));
    else
      file = g_strdup_printf ("%s/share/%s/help_bookmarks/bookmarks-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, "en");
  base_start = td_db_base_load (file);
  datatable_history = remove_history (g_list_nth_data (TD_DB_BASE (base_start)->datatable, 6));
  td_db_datatable_set_table (TD_DB_DATATABLE (datatable_history), "td_history");
  td_app_message (NULL, g_strdup_printf (_("Loading support file '%s'"), file), TD_MSG_DONE);
  td_app_message (NULL, _("Loading bookmarks"), TD_MSG_END);
}

void plugins_save_history (void)
{
  GtkObject *base;
  GtkObject *datatable_history_tree;
  gchar *file = g_strdup_printf ("%s/bookmarks.xml", TD_PACKAGE_VAR_DIR);
  int i;
  GList *data;
  td_app_message (NULL, _("Saving bookmarks"), TD_MSG_BEGIN);

  /*** Base */
  base = td_db_base_new();
  td_db_base_add_datatable (TD_DB_BASE (base), g_list_nth_data (TD_DB_BASE (base_start)->datatable, 0));
  td_db_datatable_set_table (g_list_nth_data (TD_DB_BASE (base)->datatable, 0), "td_favorites");
  td_db_base_add_datatable (TD_DB_BASE (base), g_list_nth_data (TD_DB_BASE (base_start)->datatable, 1));
  td_db_datatable_set_table (g_list_nth_data (TD_DB_BASE (base)->datatable, 1), "td_favorites_tree");
  td_db_base_add_datatable (TD_DB_BASE (base), g_list_nth_data (TD_DB_BASE (base_start)->datatable, 2));
  td_db_datatable_set_table (g_list_nth_data (TD_DB_BASE (base)->datatable, 2), "td_templates");
  td_db_base_add_datatable (TD_DB_BASE (base), g_list_nth_data (TD_DB_BASE (base_start)->datatable, 3));
  td_db_datatable_set_table (g_list_nth_data (TD_DB_BASE (base)->datatable, 3), "td_templates_tree");
  td_db_base_add_datatable (TD_DB_BASE (base), g_list_nth_data (TD_DB_BASE (base_start)->datatable, 4));
  td_db_datatable_set_table (g_list_nth_data (TD_DB_BASE (base)->datatable, 4), "td_commands");
  td_db_base_add_datatable (TD_DB_BASE (base), g_list_nth_data (TD_DB_BASE (base_start)->datatable, 5));
  td_db_datatable_set_table (g_list_nth_data (TD_DB_BASE (base)->datatable, 5), "td_commands_tree");
  td_db_base_add_datatable (TD_DB_BASE (base), datatable_history);
  datatable_history_tree = td_db_datatable_new();
  td_db_datatable_set_table (TD_DB_DATATABLE (datatable_history_tree), "td_history_tree");
  for (i=0; i<g_list_length (TD_DB_DATATABLE (datatable_history)->item); i++)
    {
      data = NULL;
      data = g_list_append (data, g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_history)->item, i), 10));
      data = g_list_append (data, "0");
      if (i == g_list_length (TD_DB_DATATABLE (datatable_history)->item)-1)
	data = g_list_append (data, "0");
      else
	data = g_list_append (data, g_strdup_printf ("%d", i+2));
      td_db_datatable_add_item (TD_DB_DATATABLE (datatable_history_tree), data);
    }
  td_db_base_add_datatable (TD_DB_BASE (base), datatable_history_tree);

  /*** Fichier - File */
  if (!td_db_base_save (TD_DB_BASE (base), file))
    td_app_message (NULL, g_strdup_printf (_("Saving support file '%s'"), file), TD_MSG_FAILED);
  else
    td_app_message (NULL, g_strdup_printf (_("Saving support file '%s'"), file), TD_MSG_DONE);
  base_start = td_db_base_load (file);
  td_app_message (NULL, _("Saving bookmarks"), TD_MSG_END);
}

GtkObject *remove_history (GtkObject *datatable_history_0)
{
  GtkObject *datatable_history_1;
  GtkObject *datatable_history_2;
  GtkObject *datatable_history_3;
  GList *item_tmp;
  int fp = 0;
  int i, j, k;

  /*** Doublons - Doubles */
  datatable_history_1 = td_db_datatable_new();
  for (i=0; i<g_list_length (TD_DB_DATATABLE (datatable_history_0)->item); i++)
    for (j=0; j<g_list_length (TD_DB_DATATABLE (datatable_history_0)->item); j++)
      if (!strcmp ((gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_history_0)->item, i), 0), 
		   (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_history_0)->item, j), 0)))
	{
	  if (i==j)
	    {
	      td_db_datatable_add_item (TD_DB_DATATABLE (datatable_history_1), g_list_nth_data (TD_DB_DATATABLE (datatable_history_0)->item, i));
	      break;
	    }
	  else
	    break;
	}

  /* Obsoltes - Obsoleted */
  datatable_history_2 = td_db_datatable_new();
  for (i=0; i<g_list_length (TD_DB_DATATABLE (datatable_history_1)->item); i++)
    if (!strcmp ((gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_history_1)->item, i), 9), "file"))
      {
	fp = open (g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_history_1)->item, i), 8), O_RDONLY);
	if (fp != -1)
	  {
	    td_db_datatable_add_item (TD_DB_DATATABLE (datatable_history_2), g_list_nth_data (TD_DB_DATATABLE (datatable_history_1)->item, i));
	    close (fp);
	  }
      }
    else
      td_db_datatable_add_item (TD_DB_DATATABLE (datatable_history_2), g_list_nth_data (TD_DB_DATATABLE (datatable_history_1)->item, i));

  /* 10 maxi et renumrotation - 10 maxi and recounting */
  /* FIXME: la renumrotation n'a pas l'air de fonctionner : +tards */ 
  datatable_history_3 = td_db_datatable_new();
  if (g_list_length (TD_DB_DATATABLE (datatable_history_2)->item) > 10)
    k = 10;
  else
    k = g_list_length (TD_DB_DATATABLE (datatable_history_2)->item);
  for (i=0; i<k; i++)
    {
      item_tmp = NULL;
      for (j=0; j<g_list_length (g_list_nth_data (TD_DB_DATATABLE (datatable_history_2)->item, i))-2; j++)
	item_tmp = g_list_append (item_tmp, g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_history_2)->item, i), j));
      item_tmp = g_list_append (item_tmp, g_strdup_printf ("%d", i+1));
      item_tmp = g_list_append (item_tmp, "f");
      td_db_datatable_add_item (TD_DB_DATATABLE (datatable_history_3), item_tmp);
    }
  return datatable_history_3;
}

void plugins_add_history (GtkObject *connect)
{
  GList *data = NULL;

  /*** Valeurs - Values */
  if (connect)
    {
      data = g_list_append (data, (gchar*) TD_DB_CONNECT (connect)->name);
      
      /*** Interface */
      if (TD_DB_CONNECT (connect)->interface)
	data = g_list_append (data, (gchar*) TD_DB_CONNECT (connect)->interface);
      else
	data = g_list_append (data, "");

      /*** Hte - Host */
      if (TD_DB_CONNECT (connect)->host)
	data = g_list_append (data, (gchar*) TD_DB_CONNECT (connect)->host);
      else
	data = g_list_append (data, "");

      /*** Port */
      if (TD_DB_CONNECT (connect)->port)
	data = g_list_append (data, (gchar*) TD_DB_CONNECT (connect)->port);
      else
	data = g_list_append (data, "");

      /*** Base */
      if (TD_DB_CONNECT (connect)->base)
	data = g_list_append (data, (gchar*) TD_DB_CONNECT (connect)->base);
      else
	data = g_list_append (data, "");

      /*** Utilisateur - User */
      if (TD_DB_CONNECT (connect)->user)
	data = g_list_append (data, (gchar*) TD_DB_CONNECT (connect)->user);
      else
	data = g_list_append (data, "");
      if (TD_DB_CONNECT (connect)->password)
	data = g_list_append (data, (gchar*) TD_DB_CONNECT(connect)->password);
      else
	data = g_list_append (data, "");

      /*** Gabarit - Template */
      if (TD_DB_CONNECT (connect)->template)
	data = g_list_append (data, (gchar*) TD_DB_CONNECT (connect)->template);
      else
	data = g_list_append (data, "");

      /*** Fichier - File */
      if (TD_DB_CONNECT (connect)->file)
	data = g_list_append (data, (gchar*) TD_DB_CONNECT (connect)->file);
      else
	data = g_list_append (data, "");
      
      /*** Type */
      if (TD_DB_CONNECT (connect)->type == TD_CONNECT_TYPE_RECOVERY)
	data = g_list_append (data, "file");
      else
	data = g_list_append (data, (gchar*) td_db_connect_print_type (TD_DB_CONNECT (connect)->type));
      data = g_list_append (data, g_strdup_printf ("%d", g_list_length (TD_DB_DATATABLE (datatable_history)->item)+1));
      data = g_list_append (data, "f");
      td_db_datatable_add_item (TD_DB_DATATABLE (datatable_history), data);
    }

  /*** Menu */
  gtk_menu_item_remove_submenu (GTK_MENU_ITEM (TD_APP (APP)->menu_history));
  menu_history = NULL;
  datatable_history = remove_history (datatable_history);
  td_db_datatable_set_table (TD_DB_DATATABLE (datatable_history), "td_history");
  plugins_menu_def_history (GTK_WIDGET (TD_APP (APP)->menu_history), TD_APP (APP)->accel_group);
}

void plugins_menu_def_favorites (GtkWidget *menuitem_main, GtkAccelGroup *accel_group)
{
  menu_favorites = gtk_menu_new();
  gtk_widget_show (menu_favorites);
  gtdk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_main), menu_favorites);
  plugins_menu_def (g_list_nth_data (TD_DB_BASE (base_start)->datatable, 0), g_list_nth_data (TD_DB_BASE (base_start)->datatable, 1), menu_favorites, NULL);
}

void plugins_menu_def_templates (GtkWidget *menuitem_main, GtkAccelGroup *accel_group)
{
  GtkWidget *menuitem[3];

  /*** Menu */
  menu_templates = gtk_menu_new();
  gtk_widget_show (menu_templates);
  gtdk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_main), menu_templates);

  /*** Item */
  menuitem[0] = gtdk_menu_item_accel_new (_("Create template"), NULL, "list_build.xpm", accel_group, GDK_N, GDK_MOD1_MASK);
  gtk_signal_connect (GTK_OBJECT (menuitem[0]), "activate", GTK_SIGNAL_FUNC (td_db_connect_close), NULL);
  gtk_menu_append (GTK_MENU (menu_templates), menuitem[0]);
  menuitem[1] = gtdk_menu_item_new (_("Open template..."), NULL, "list_open.xpm");
  gtk_signal_connect (GTK_OBJECT (menuitem[1]), "activate", GTK_SIGNAL_FUNC (td_db_connect_load), NULL);
  gtk_menu_append (GTK_MENU (menu_templates), menuitem[1]);
  menuitem[2] = gtdk_menu_item_new (NULL, NULL, NULL);
  gtk_menu_append (GTK_MENU (menu_templates), menuitem[2]);
  plugins_menu_def (g_list_nth_data (TD_DB_BASE (base_start)->datatable, 2), g_list_nth_data (TD_DB_BASE (base_start)->datatable, 3), menu_templates, NULL);
}

void plugins_menu_def_commands (GtkWidget *menuitem_main, GtkAccelGroup *accel_group, GtkObject *mod)
{
  menu_commands = gtk_menu_new();
  gtk_widget_show (menu_commands);
  gtdk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_main), menu_commands);
  plugins_menu_def (g_list_nth_data (TD_DB_BASE (base_start)->datatable, 4), g_list_nth_data (TD_DB_BASE (base_start)->datatable, 5), menu_commands, mod);
}

void plugins_menu_def_history (GtkWidget *menuitem_main, GtkAccelGroup *accel_group)
{
  GtkWidget *menuitem[3];
  int i, j;

  /*** Menu */
  menu_history = gtk_menu_new();
  gtk_widget_show (menu_history);
  gtdk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_main), menu_history);

  /*** Item */
  menuitem[0] = gtdk_menu_item_accel_new (_("Open file..."), NULL, "list_open.xpm", accel_group, 0xFFC0, 0);
  gtk_signal_connect (GTK_OBJECT (menuitem[0]), "activate", GTK_SIGNAL_FUNC (td_db_connect_load), NULL);
  gtk_menu_append (GTK_MENU (menu_history), menuitem[0]);
  menuitem[1] = gtdk_menu_item_new (_("Open URL..."), NULL, "list_url.xpm");
  gtk_signal_connect (GTK_OBJECT (menuitem[1]), "activate", GTK_SIGNAL_FUNC (td_db_connect_load), NULL);
  gtk_menu_append (GTK_MENU (menu_history), menuitem[1]);
  menuitem[2] = gtdk_menu_item_new (NULL, NULL, NULL);
  gtk_menu_append (GTK_MENU (menu_history), menuitem[2]);
  plugins_menu_def (datatable_history, NULL, menu_history, NULL);
}

void plugins_menu_def (GtkObject *datatable, GtkObject *datatable_tree, GtkWidget *menu_main, GtkObject *mod)
{
  GtkWidget *menu[50]; /* FIXME: utiliser les listes : + tards */
  GtkWidget *menu_item[50]; /* FIXME: utiliser les listes : + tards */
  GtkObject *flower_filters = NULL;
  int i, j, k, m;
  GList *data;
  GList *data2;
  gchar *type;
  int id;
  gchar *id_parent;
  gchar *id_sibling;
  GtkObject *datatable2 = NULL;
  GtkObject *datatable2_tree = NULL;
  GtkObject *datatable3 = NULL;
  GtkObject *datatable3_tree = NULL;
  GtkObject *datatable4 = NULL;
  GtkObject *datatable4_tree = NULL;
  gboolean bool_tmp;

  /*** Go ! */
  datatable2 = td_db_datatable_new();
  datatable3 = td_db_datatable_new();
  datatable4 = td_db_datatable_new();
  gtk_object_set (GTK_OBJECT (datatable4), "table", TD_DB_DATATABLE (datatable)->table, NULL);

  /*** Tri - Sort */
  if (datatable_tree)
    {
      datatable2_tree = td_db_datatable_new();
      datatable3_tree = td_db_datatable_new();
      datatable4_tree = td_db_datatable_new();

      /*** Tri des tables en fonction du niveau - Sorting tables by level */
      for (i=0; i<g_list_length (TD_DB_DATATABLE (datatable_tree)->item); i++)
	if (!strcmp ((gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_tree)->item, i), 1), "0"))
	  {
	    td_db_datatable_add_item (TD_DB_DATATABLE (datatable2), g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i));
	    td_db_datatable_add_item (TD_DB_DATATABLE (datatable2_tree), g_list_nth_data (TD_DB_DATATABLE (datatable_tree)->item, i));
	  }
      j = 0;
      id_parent = (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable2_tree)->item, j), 0);
      while (id_parent)
	{
	  bool_tmp = FALSE;
	  for (i=0; i<g_list_length (TD_DB_DATATABLE (datatable_tree)->item); i++)
	    if (!strcmp ((gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable_tree)->item, i), 1), id_parent))
	      {
		td_db_datatable_add_item (TD_DB_DATATABLE (datatable2), g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i));
		td_db_datatable_add_item (TD_DB_DATATABLE (datatable2_tree), g_list_nth_data (TD_DB_DATATABLE (datatable_tree)->item, i));
		bool_tmp = TRUE;
	      }
	  j++;
	  id_parent = (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable2_tree)->item, j), 0);
	}

      /*** Tri des tables en fonction des frres - Sorting tables by brothers */
      for (i=0; i<g_list_length (TD_DB_DATATABLE (datatable2_tree)->item); i)
	{

	  /*** Constitution du lot - Batch making */
	  id_parent = (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable2_tree)->item, i), 1);
	  j = 0;
	  while ((i<g_list_length (TD_DB_DATATABLE (datatable2_tree)->item)) &&
		 (!strcmp ((gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable2_tree)->item, i), 1), id_parent)))
	    {
	      j++;
	      i++;
	    }

	  /*** Traitement du lot - Batch traitment */
	  id_sibling = "0";
	  bool_tmp = FALSE;
	  for (k=i-j; k<i; k++)
	    if (!strcmp ((gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable2_tree)->item, k), 2), id_sibling))
	      {
		id_sibling = (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable2_tree)->item, k), 0);
		td_db_datatable_add_item (TD_DB_DATATABLE (datatable3), g_list_nth_data (TD_DB_DATATABLE (datatable2)->item, k));
		td_db_datatable_add_item (TD_DB_DATATABLE (datatable3_tree), g_list_nth_data (TD_DB_DATATABLE (datatable2_tree)->item, k));
		bool_tmp = TRUE;
		break;
	      }
	  while (bool_tmp)
	    {
	      bool_tmp = FALSE;
	      for (k=i-j; k<i; k++)
		if (!strcmp ((gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable2_tree)->item, k), 2), id_sibling))
		  {
		    id_sibling = (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable2_tree)->item, k), 0);
		    td_db_datatable_add_item (TD_DB_DATATABLE (datatable3), g_list_nth_data (TD_DB_DATATABLE (datatable2)->item, k));
		    td_db_datatable_add_item (TD_DB_DATATABLE (datatable3_tree), g_list_nth_data (TD_DB_DATATABLE (datatable2_tree)->item, k));
		    bool_tmp = TRUE;
		    break;
		  }
	    }

	  /*** Inversion du lot - Invert batch */
	  for (k=i-1; k>i-j-1; k--)
	    {
	      td_db_datatable_add_item (TD_DB_DATATABLE (datatable4), g_list_nth_data (TD_DB_DATATABLE (datatable3)->item, k));
	      td_db_datatable_add_item (TD_DB_DATATABLE (datatable4_tree), g_list_nth_data (TD_DB_DATATABLE (datatable3_tree)->item, k));
	    }
	}
    }
  else
    for (i=0; i<g_list_length (TD_DB_DATATABLE (datatable)->item); i++)
      td_db_datatable_add_item (TD_DB_DATATABLE (datatable4), g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i));

  /*** Interfaces *//* FIXME: + tards - this night */ 

  /*** Filtres - Filters */
  if (!strcmp (TD_DB_DATATABLE (datatable4)->table, "td_commands"))
    {
      flower_filters = td_flower_new();
      gtk_object_set (GTK_OBJECT (flower_filters),
		      "root", "filters", 
		      "branch", "filter",
		      "petal", "mode", NULL);
      td_flower_add_branch_attribut (TD_FLOWER (flower_filters), "name");
      td_flower_add_branch_attribut (TD_FLOWER (flower_filters), "directory");
      td_flower_add_branch_attribut (TD_FLOWER (flower_filters), "file");
      td_flower_add_petal_attribut (TD_FLOWER (flower_filters), "name");
      td_flower_add_petal_attribut (TD_FLOWER (flower_filters), "symbol");
      if (td_flower_load_file (TD_FLOWER (flower_filters), g_strdup_printf ("%s/share/%s/filters.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR)))
	td_app_message (NULL, g_strdup_printf (_("Loading file '%s'"), g_strdup_printf ("%s/share/%s/filters.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR)), TD_MSG_DONE);
      else
	td_app_message (_("Loading file"), g_strdup_printf (_("Loading file '%s'"), g_strdup_printf ("%s/share/%s/filters.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR)), TD_MSG_FAILED);
    }

  /*** Menu */
  for (i=0; i<g_list_length (TD_DB_DATATABLE (datatable4)->item); i++)
    {
      data = g_list_nth_data (TD_DB_DATATABLE (datatable4)->item, i);
      type = g_list_nth_data (data, g_list_length (data)-3);
      if (!strcmp (type, "recovery"))
	type = "file";
      id = -1;
      if ((datatable4_tree) && (atoi (g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable4_tree)->item, i), 1)) !=0))
	{
	  bool_tmp = FALSE;
	  j = g_list_length (g_list_nth_data (TD_DB_DATATABLE (datatable4)->item, 0))-2;
	  for (id=0; id<g_list_length (TD_DB_DATATABLE (datatable4)->item); id++)
	    if (atoi (g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable4_tree)->item, i), 1)) ==
		atoi (g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable4)->item, id), j)))
	      {
		bool_tmp = TRUE;
		break;
	      }
	  if (!bool_tmp)
	    id = -1;
	}

      /*** Dossier - Folder */
      if (!strcmp (type, "folder"))
	{
	  menu_item[i] = gtdk_menu_item_new (g_strdup_printf ("%s", (gchar*) g_list_nth_data (data, 0)), NULL, "list_folder.xpm");
	  if (id < 0)
	    gtk_menu_append (GTK_MENU (menu_main), menu_item[i]);
	  else
	    gtk_menu_append (GTK_MENU (menu[id]), menu_item[i]);
	  menu[i] = gtk_menu_new();
	  gtk_widget_show (menu[i]);
	  gtdk_menu_item_set_submenu (GTK_MENU_ITEM (menu_item[i]), menu[i]);
	  continue;
	}

      /*** Sparateur - Separator */
      if (!strcmp (type, "separator"))
	{
	  menu_item[i] = gtdk_menu_item_new (NULL, NULL, NULL);
	  if (id < 0)
	    gtk_menu_append (GTK_MENU (menu_main), menu_item[i]);
	  else
	    gtk_menu_append (GTK_MENU (menu[id]), menu_item[i]);
	  continue;
	}

      /*** Fichier, url, base de donnes - File, url, database */
      if (!strcmp (type, "file"))
	menu_item[i] = gtdk_menu_item_new (g_strdup_printf ("%s", (gchar*) g_list_nth_data (data, 0)), NULL, "list_new.xpm");
      if (!strcmp (type, "directory"))
	menu_item[i] = gtdk_menu_item_new (g_strdup_printf ("%s", (gchar*) g_list_nth_data (data, 0)), NULL, "list_directory.xpm");
      if (!strcmp (type, "url"))
	menu_item[i] = gtdk_menu_item_new (g_strdup_printf ("%s", (gchar*) g_list_nth_data (data, 0)), NULL, "list_url.xpm");
      if (!strcmp (type, "database"))
	menu_item[i] = gtdk_menu_item_new (g_strdup_printf ("%s", (gchar*) g_list_nth_data (data, 0)), NULL, "list_database.xpm");

      /*** Commande - Command */
      if (!strcmp (type, "command"))
	{
	  if (!strcmp (g_list_nth_data (data, 4), "customize"))
	    menu_item[i] = gtdk_menu_item_new (g_strdup_printf ("%s", (gchar*) g_list_nth_data (data, 0)), NULL, "list_customize.xpm");
	  else
	    if (!strcmp (g_list_nth_data (data, 4), "print"))
	      menu_item[i] = gtdk_menu_item_new (g_strdup_printf ("%s", (gchar*) g_list_nth_data (data, 0)), NULL, "list_print.xpm");
	    else
	      if (strstr (g_list_nth_data (data, 2), "$editor"))
		menu_item[i] = gtdk_menu_item_new (g_strdup_printf ("%s", (gchar*) g_list_nth_data (data, 0)), NULL, "list_editor.xpm");
	      else
		menu_item[i] = gtdk_menu_item_new (g_strdup_printf ("%s", (gchar*) g_list_nth_data (data, 0)), NULL, "list_import_export.xpm");
	}
      if (id < 0)
	{
	  gtk_menu_append (GTK_MENU (menu_main), menu_item[i]);
	  if (!strcmp (TD_DB_DATATABLE (datatable4)->table, "td_history"))
	    TD_CUSTOM_FILE_STARTUP = (gchar*) g_list_nth_data (data, 8);
	}
      else
	gtk_menu_append (GTK_MENU (menu[id]), menu_item[i]);

      /*** Fichier - File */
      if ((!strcmp (TD_DB_DATATABLE (datatable4)->table, "td_favorites")) ||
	  (!strcmp (TD_DB_DATATABLE (datatable4)->table, "td_history")))
	{
	  gtk_signal_connect (GTK_OBJECT (menu_item[i]), "activate", GTK_SIGNAL_FUNC (menu_file_activate), data);
	  continue;
	}
      if (!strcmp (TD_DB_DATATABLE (datatable4)->table, "td_templates"))
	{
	  gtk_signal_connect (GTK_OBJECT (menu_item[i]), "activate", GTK_SIGNAL_FUNC (menu_template_activate), data);
	  continue;
	}

      /*** Filtres - Filters */
      if (!strcmp (TD_DB_DATATABLE (datatable4)->table, "td_commands"))
	{
	  data2 = NULL;
	  data2 = g_list_append (data2, mod); /*** 0: Module */
	  data2 = g_list_append (data2, g_list_nth_data (data, 1)); /*** 1: Fichier - File */
	  data2 = g_list_append (data2, g_list_nth_data (data, 2)); /*** 2: Commande - Command */
	  data2 = g_list_append (data2, g_list_nth_data (data, 4)); /*** 3: Mode */

	  /* Recherche du greffon du filtre */
	  bool_tmp = FALSE;
	  for (j=0; j<g_list_length (TD_FLOWER (flower_filters)->items_value); j++)
	    if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower_filters)->items_level, j)) == 0)
	      if (!strcmp ((gchar*) g_list_nth_data (data, 3), (gchar*) g_list_nth_data (g_list_nth_data (TD_FLOWER (flower_filters)->items_value, j), 0)))
		{
		  bool_tmp = TRUE;
		  break;
		}
	  if (!bool_tmp)
	    {
	      td_app_message (NULL, g_strdup_printf (_("Loading bookmarks : export format '%s' not find"), (gchar*) g_list_nth_data (data, 3)), TD_MSG_FAILED);
	      continue;
	    }
	  data2 = g_list_append (data2, (gchar*) g_list_nth_data (g_list_nth_data (TD_FLOWER (flower_filters)->items_value, j), 2)); /*** 4: Greffons - Plug-ins */
	  data2 = g_list_append (data2, (gchar*) g_list_nth_data (g_list_nth_data (TD_FLOWER (flower_filters)->items_value, j), 1)); /*** 5: Rpertoire - Directory */
	  data2 = g_list_append (data2, (gchar*) g_list_nth_data (g_list_nth_data (TD_FLOWER (flower_filters)->items_value, j), 0)); /*** 6: Nom - Name */
	  if (!strcmp (g_list_nth_data (data, 4), "customize"))
	    {
	      gtk_signal_connect (GTK_OBJECT (menu_item[i]), "activate", GTK_SIGNAL_FUNC (menu_command_activate), data2);
	      continue;
	    }

	  /*** Recherche du symbole du filtre - Searching filter's symbol */
	  bool_tmp = FALSE;
	  for (j=j+1; j<g_list_length (TD_FLOWER (flower_filters)->items_value); j++)
	    if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower_filters)->items_level, j)) == 1)
	      {
		if (!strcmp ((gchar*) g_list_nth_data (data, 4), (gchar*) g_list_nth_data (g_list_nth_data (TD_FLOWER (flower_filters)->items_value, j), 0)))
		  {
		    bool_tmp = TRUE;
		    break;
		  }
	      }
	    else
	      {
		bool_tmp = FALSE;
		break;
	      }
	  if (!bool_tmp)
	    {
	      td_app_message (NULL, g_strdup_printf (_("Loading bookmarks : export format '%s' mode '%s' not find"), (gchar*) g_list_nth_data (data, 3), (gchar*) g_list_nth_data (data, 4)), TD_MSG_FAILED);
	      continue;
	    }
	  data2 = g_list_append (data2, (gchar*) g_list_nth_data (g_list_nth_data (TD_FLOWER (flower_filters)->items_value, j), 1)); /*** 7: Symbole - Symbol */
	  gtk_signal_connect (GTK_OBJECT (menu_item[i]), "activate", GTK_SIGNAL_FUNC (menu_command_activate), data2);
	  continue;
	}
    }
  if (flower_filters)
    td_flower_destroy (TD_FLOWER (flower_filters));
}

gboolean menu_template_activate (GtkWidget *menuitem, GList *data)
{
  GtkObject *connect;
  gchar *txt_tmp;
  td_app_message (NULL, _("Loading"), TD_MSG_BEGIN);

  /*** Fichier - File */
  connect = td_db_connect_new();
  if (!strcmp ((gchar*) g_list_nth_data (data, 2), "file"))
    gtk_object_set (GTK_OBJECT (connect), 
		    "name", _("New"),
		    "file", (gchar*) g_list_nth_data (data, 1), NULL);
  td_db_connect_set_type (TD_DB_CONNECT (connect), TD_CONNECT_TYPE_TEMPLATE);

  /*** Rpertoire - Directory */
  if (!strcmp ((gchar*) g_list_nth_data (data, 2), "directory"))
    {
      txt_tmp = g_strdup_printf ("%s", td_fileselector_create_window (_("Load template"), g_list_nth_data (data, 1), NULL, TRUE));
      if ((!txt_tmp) || (!strcmp (txt_tmp, "(null)")))
	{
	  txt_tmp = td_fileselector_create_window (NULL, NULL, NULL, FALSE);
	  td_app_message (NULL, _("Loading"), TD_MSG_END);
	  return TRUE;
	}
      gtk_object_set (GTK_OBJECT (connect), 
		      "name", txt_tmp,
		      "file", txt_tmp, NULL);
      td_db_connect_set_type (TD_DB_CONNECT (connect), TD_CONNECT_TYPE_TEMPLATE);
      txt_tmp = td_fileselector_create_window (NULL, NULL, NULL, FALSE);
    }

  /*** Chargement - Load */
  td_db_connect_load (NULL, connect);
  td_app_message (NULL, _("Loading"), TD_MSG_END);
  return TRUE;
}

gboolean menu_file_activate (GtkWidget *menuitem, GList *data)
{
  GtkObject *connect;
  gboolean (*symbol)();
  gboolean (*symbol2)();
  gchar *txt_tmp;
  td_app_message (NULL, _("Loading"), TD_MSG_BEGIN);

  /*** Base de donnes - Database */
  connect = td_db_connect_new();
  if (!strcmp ((gchar*) g_list_nth_data (data, 9), "database"))
    {
      gtk_object_set (GTK_OBJECT (connect), 
		      "name", (gchar*) g_list_nth_data (data, 0),
		      "interface", (gchar*) g_list_nth_data (data, 1),
		      "host", (gchar*) g_list_nth_data (data, 2),
		      "port", (gchar*) g_list_nth_data (data, 3),
		      "base", (gchar*) g_list_nth_data (data, 4),
		      "user", (gchar*) g_list_nth_data (data, 5),
		      "password", (gchar*) g_list_nth_data (data, 6),
		      "template", (gchar*) g_list_nth_data (data, 7),
		      "file", g_strdup_printf ("%s/database.td", TD_PACKAGE_TMP_DIR), NULL);
      td_db_connect_set_type (TD_DB_CONNECT (connect), TD_CONNECT_TYPE_DATABASE);
      td_app_message (g_strdup_printf ("%s...", _("Loading database")), NULL, TD_MSG_MESSAGE);
      (gpointer*) symbol = td_app_mod_core_symbol (NULL, NULL, "libcommunication_db.so", "plugins_load_database", TRUE);
      if (!symbol (connect))
	{
	  (gpointer*) symbol2 = td_app_mod_core_symbol (NULL, NULL, "libmessages.so", "plugins_load", TRUE);
	  symbol2 (g_strdup_printf ("%s/log.xml", TD_PACKAGE_TMP_DIR));
	  td_app_message (NULL, _("Loading"), TD_MSG_END);
	  return FALSE;
	}
      (gpointer*) symbol2 = td_app_mod_core_symbol (NULL, NULL, "libmessages.so", "plugins_load", TRUE);
      symbol2 (g_strdup_printf ("%s/log.xml", TD_PACKAGE_TMP_DIR));
    }

  /*** Fichier - File */
  if (!strcmp ((gchar*) g_list_nth_data (data, 9), "file"))
    {
      gtk_object_set (GTK_OBJECT (connect),
		      "name", (gchar*) g_list_nth_data (data, 0),
		      "file", (gchar*) g_list_nth_data (data, 8), NULL);
      td_db_connect_set_type (TD_DB_CONNECT (connect), TD_CONNECT_TYPE_FILE);
    }

  /*** URL */
  if (!strcmp ((gchar*) g_list_nth_data (data, 9), "url"))
    {
      gtk_object_set (GTK_OBJECT (connect),
		      "name", (gchar*) g_list_nth_data (data, 0),
		      "base", (gchar*) g_list_nth_data (data, 4),
		      "file", g_strdup_printf ("%s/url.td", TD_PACKAGE_TMP_DIR), NULL);
      td_db_connect_set_type (TD_DB_CONNECT (connect), TD_CONNECT_TYPE_URL);
      td_app_message (g_strdup_printf ("%s...", _("Loading URL")), NULL, TD_MSG_MESSAGE);
      (gpointer*) symbol = td_app_mod_core_symbol (NULL, NULL, "libcommunication_url.so", "plugins_load_url", TRUE);
      if (!symbol ((gchar*) g_list_nth_data (data, 4)))
	{
	  td_app_message (NULL, _("Loading"), TD_MSG_END);
	  return TRUE;
	}
    }

  /*** Rpertoire - Directory */
  if (!strcmp ((gchar*) g_list_nth_data (data, 9), "directory"))
    {
      txt_tmp = g_strdup_printf ("%s", td_fileselector_create_window (_("Load file"), TD_DB_CONNECT (connect)->base, NULL, TRUE));
      if ((!txt_tmp) || (!strcmp (txt_tmp, "(null)")))
	{
	  txt_tmp = td_fileselector_create_window (NULL, NULL, NULL, FALSE);
	  td_app_message (NULL, _("Loading"), TD_MSG_END);
	  return TRUE;
	}
      gtk_object_set (GTK_OBJECT (connect),
		      "name", txt_tmp,
		      "file", txt_tmp, NULL);
      td_db_connect_set_type (TD_DB_CONNECT (connect), TD_CONNECT_TYPE_FILE);
      txt_tmp = td_fileselector_create_window (NULL, NULL, NULL, FALSE);
    }

  /*** Chargement - Load */
  td_db_connect_load (NULL, connect);
  td_app_message (NULL, _("Loading"), TD_MSG_END);
  return TRUE;
}

void menu_command_activate (GtkWidget *menuitem, GList *data)
{
  gboolean (*symbol)();
  gchar *file;
  int i;
  gboolean bool_tmp;

  /*** g_list_nth_data (data, 0) module */
  /*** g_list_nth_data (data, 1) fichier - file */
  /*** g_list_nth_data (data, 2) commande - command */
  /*** g_list_nth_data (data, 3) mode */
  /*** g_list_nth_data (data, 4) greffons - plug-ins */
  /*** g_list_nth_data (data, 5) rpertoire - directory */
  /*** g_list_nth_data (data, 6) nom international - intantional name */
  /*** g_list_nth_data (data, 7) symbole - symbol */

  /*** Module */
  if (!td_app_add_mod_filter (NULL, NULL, g_list_nth_data (data, 4), g_list_nth_data (data, 5), g_list_nth_data (data, 6)))
    return;
  bool_tmp = FALSE;
  for (i=0; i<g_list_length (TD_APP (APP)->mod_filter); i++)
    if (!strcmp (g_list_nth_data (data, 5), TD_MOD (g_list_nth_data (TD_APP (APP)->mod_filter, i))->name))
      {
	bool_tmp = TRUE;
	break;
      }
  if (!bool_tmp)
    return;

  /*** Personnalisation - Customize */
  if (!strcmp (g_list_nth_data (data, 3), "customize"))
    {
      td_mod_custom_show (g_list_nth_data (TD_APP (APP)->mod_filter, i));
      return;
    }

  /*** Symbole - Symbol */
  (gpointer*) symbol = dlsym (PLUGINS_FILTER[i], g_list_nth_data (data, 7));
  if (!symbol)
    return;

  /*** Impression - Print */
  if (!strcmp (g_list_nth_data (data, 3), "print"))
    {
      symbol (g_list_nth_data (data, 0), NULL);
      return;
    }

  /*** Fichier - File */
  if (!strlen (g_strstrip (g_list_nth_data (data, 1))))
    {
      file = g_strdup_printf ("%s", td_fileselector_create_window (_("Choose file"), NULL, NULL, TRUE));
      if ((!file) || (!strcmp (file, "(null)")))
	{
	  td_fileselector_create_window (NULL, NULL, NULL, FALSE);
	  return;
	}
      td_fileselector_create_window (NULL, NULL, NULL, FALSE);
    }
  else
    file = g_list_nth_data (data, 1);
  file = td_string_replace (file, "~", g_get_home_dir());

  /*** Filtre - Filter */
  if (!symbol (g_list_nth_data (data, 0), file))
    return;

  /*** Commande - Command */
  if (strlen (g_strstrip (g_list_nth_data (data, 2))))
    {
      td_app_message (NULL, _("Executing external command"), TD_MSG_BEGIN);
      td_app_message (g_strdup_printf ("%s...", _("Executing external command")), NULL, TD_MSG_MESSAGE);
      td_exec ((gchar*) g_list_nth_data (data, 2));
      td_app_message (NULL, _("Executing external command"), TD_MSG_END);
    }
}
