/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : Interface PostgreSQL
 * ToutDoux's plug-in : PostgreSQL interface
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "main.h"

/*****************************************************************************/
/*** Variables globales - Global variables */
/*****************************************************************************/
PGconn *connect_postgresql;
FILE *log_postgresql;
gchar *file_log;
gchar *local_database_name;

/*****************************************************************************/
/*** Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("PostgreSQL interface"),
		  "type", _("database"),
		  "version", "1.0.1",
		  "authors", "Philippe Roy <ph_roy@toutdoux.org>",
		  "category1", _("core"),
		  "category2", _("database"),
		  "category3", "postgresql",
		  "copyright", "Copyright (c) 2000-2001 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"), NULL);
  return ret;
}

void plugins_init (void)
{
}

void plugins_destroy (gpointer user_data)
{
}

/*****************************************************************************/
/*** Base */
/*****************************************************************************/
gboolean plugins_base_login (gchar *name)
{
  /*** Connection - Login */
  local_database_name = name;
  connect_postgresql = PQconnectdb (g_strdup_printf ("dbname='%s'", local_database_name));
  if (PQstatus (connect_postgresql) == CONNECTION_BAD)
    {
      td_app_message (_("Login to local database"), g_strdup_printf ("%s : PostgreSQL : '%s'", _("Login to local database"), local_database_name), TD_MSG_FAILED);
      return FALSE;
    }
  td_app_message (NULL, g_strdup_printf ("%s : PostgreSQL : '%s'", _("Login to local database"), local_database_name), TD_MSG_DONE);

  /*** Fichier traceur - Tracer file */
  if (!TD_FLAG_DEBUG_MODE)
    return TRUE;
  file_log = g_strdup_printf ("%s/postgresql.log", TD_PACKAGE_TMP_DIR);
  if ((log_postgresql = fopen (file_log, "w")) == NULL)
    {
      td_app_message (_("Login to local database"), g_strdup_printf ("%s '%s'", _("Opening postgresql log"), file_log), TD_MSG_FAILED);
      return FALSE;
    }
  PQtrace (connect_postgresql, log_postgresql);
  td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Opening postgresql log"), file_log), TD_MSG_DONE);
  return TRUE;
}

gboolean plugins_base_logout (void)
{
  /*** Fichier traceur - Tracer file */
  if (log_postgresql)
    {
      PQuntrace (connect_postgresql);
      fclose (log_postgresql);
    }
  if (!TD_FLAG_DEBUG_MODE)
    remove (g_strdup_printf ("%s/postgresql.log", TD_PACKAGE_TMP_DIR));

  /*** Dconnection - Logout */
  PQfinish (connect_postgresql);
  td_app_message (_("Logout to local database"), g_strdup_printf ("%s : PostgreSQL : '%s'", _("Logout to local database"), local_database_name), TD_MSG_DONE);
  return TRUE;
}

gboolean plugins_base_create (gchar *name)
{
  if (!td_system (g_strdup_printf ("createdb %s", name)))
    {
      td_system (g_strdup_printf ("dropdb %s", name));
      if (!td_system (g_strdup_printf ("createdb %s", name)))
	{
	  td_app_message (_("Creating local database"), g_strdup_printf ("%s : PostgreSQL : '%s'", _("Creating local database"), name), TD_MSG_FAILED);
	  return FALSE;
	}
    }
  td_app_message (NULL, g_strdup_printf ("%s : PostgreSQL : '%s'", _("Creating local database"), name), TD_MSG_DONE);
  return TRUE;
}

gboolean plugins_base_drop (gchar *name)
{
  if (!td_system (g_strdup_printf ("dropdb %s", name)))
    {
      td_app_message (_("Dropping local database"), g_strdup_printf ("%s : PostgreSQL : '%s'", _("Dropping local database"), name), TD_MSG_FAILED);
      return FALSE;
    }
  td_app_message (NULL, g_strdup_printf ("%s : PostgreSQL : '%s'", _("Dropping local database"), name), TD_MSG_DONE);
  return TRUE;
}

gboolean plugins_base_raz (void)
{
  PGresult *result;
  PGresult *result2;
  int i;

  /* Tables */
  result = query_result (g_strdup_printf ("SELECT relname FROM pg_class WHERE (relkind ='r') AND (relname !~ 'pg_');"));
  if (!result)
    return FALSE;
  for (i = 0; i < PQntuples (result); i++)
    if (!plugins_command (g_strdup_printf ("DROP TABLE %s;", PQgetvalue (result, i, 0))))
      return FALSE;

  /* Index */
  result = query_result (g_strdup_printf ("SELECT relname FROM pg_class WHERE (relkind ='i') AND (relname !~ 'pg_');"));
  if (!result)
    return FALSE;
  for (i = 0; i < PQntuples (result); i++)
    if (!plugins_command (g_strdup_printf ("DROP INDEX %s;", PQgetvalue (result, i, 0))))
      return FALSE;

  /* Squences */
  result = query_result (g_strdup_printf ("SELECT relname FROM pg_class WHERE (relkind ='S') AND (relname !~ 'pg_');"));
  if (!result)
    return FALSE;
  for (i = 0; i < PQntuples (result); i++)
    if (!plugins_command (g_strdup_printf ("DROP SEQUENCE %s;", PQgetvalue (result, i, 0))))
      return FALSE;
  PQclear (result);
  return TRUE;
}


/*****************************************************************************/
/*** Tables */
/*****************************************************************************/
gboolean plugins_table_create (GtkObject *table)
{
  PGresult *result;
  TdField *field;
  gchar *query;
  gchar *type = NULL;
  int i,j;

  /*** Table */
  query = g_strdup_printf ("CREATE TABLE %s (", TD_DB_TABLE (table)->name);
  for (i=0; i<g_list_length (TD_DB_TABLE (table)->field); i++)
    {

      /*** Champs - Field */
      field = (TdField*) g_list_nth_data (TD_DB_TABLE (table)->field, i);
      query = g_strdup_printf ("%s%s", query, field->name);

      /*** Proprits - Properties */
      for (j=0; j<g_list_length (field->property_name); j++)
	{

	  /*** Type */
	  if (!strcmp ("type", (gchar*) g_list_nth_data (field->property_name, j)))
	    {
	      type = g_list_nth_data (field->property_value, j);
	      if (!strcmp ("blob", (gchar*) g_list_nth_data (field->property_value, j)))
		query = g_strdup_printf ("%s text", query);
	      if (strcmp ("blob", (gchar*) g_list_nth_data (field->property_value, j)))
		query = g_strdup_printf ("%s %s", query, (gchar*) g_list_nth_data (field->property_value, j));
	    }

	  /*** Contrainte - Constraint */
	  if (!strcmp ("constraint", (gchar*) g_list_nth_data (field->property_name, j)))
	    {
	      if (!strcmp ("not null", (gchar*) g_list_nth_data (field->property_value, j)))
		query = g_strdup_printf ("%s NOT NULL", query);
	      if (!strcmp ("unique", (gchar*) g_list_nth_data (field->property_value, j)))
		query = g_strdup_printf ("%s UNIQUE", query);
	      if (!strcmp ("primary key", (gchar*) g_list_nth_data (field->property_value, j)))
		query = g_strdup_printf ("%s PRIMARY KEY", query);
	    }

	  /*** Valeur par dfaut - Default value */
	  if (!strcmp ("default", (gchar*) g_list_nth_data (field->property_name, j)))
	    query = g_strdup_printf ("%s DEFAULT %s", query, td_database_adaptvalue (g_list_nth_data (field->property_value, j), type));
	}
      if (i != g_list_length (TD_DB_TABLE (table)->field)-1)
	query = g_strdup_printf ("%s, ", query);
    }
  query = g_strdup_printf ("%s);", query);
  if (!plugins_command (query))
    return FALSE;

  /*** Squence *_td_id_seq - Sequence *_td_id_seq */
  result = query_result (g_strdup_printf ("SELECT relname FROM pg_class WHERE relname ='%s_td_id_seq';", TD_DB_TABLE (table)->name));
  if (!result)
    return FALSE;
  if (PQntuples (result) == 0)
    {
      PQclear (result);
      return TRUE;
    }
  PQclear (result);

  /*** Rgles - Rules */
  for (i=0; i<g_list_length (TD_DB_TABLE (table)->rule); i++)
    if (!plugins_rule_create (g_list_nth_data (TD_DB_TABLE (table)->rule, i)))
      return FALSE;

  /*** Fonctions - Functions */
  for (i=0; i<g_list_length (TD_DB_TABLE (table)->function); i++)
    if (!plugins_function_create (g_list_nth_data (TD_DB_TABLE (table)->function, i)))
      return FALSE;
  return TRUE;
}

gboolean plugins_table_exist (gchar* table)
{
  PGresult *result;
  result = query_result (g_strdup_printf ("SELECT relname FROM pg_class WHERE relname ='%s';", table));
  if (!result)
    return FALSE;
  if (PQntuples (result) > 0)
    {
      PQclear (result);
      return TRUE;
    }
  PQclear (result);
  return FALSE;
}

gboolean plugins_table_drop (GtkObject *table)
{
  int i;

  /*** Table */
  if (!plugins_command (g_strdup_printf ("DROP TABLE %s;", TD_DB_TABLE (table)->name)))
    return FALSE;

  /*** Rgles - Rules */
  for (i=0; i<g_list_length (TD_DB_TABLE (table)->rule); i++)
    if (!plugins_rule_drop (g_list_nth_data (TD_DB_TABLE (table)->rule, i)))
      return FALSE;

  /*** Fonctions - Functions */
  for (i=0; i<g_list_length (TD_DB_TABLE (table)->function); i++)
    if (!plugins_function_drop (g_list_nth_data (TD_DB_TABLE (table)->function, i)))
      return FALSE;
  return TRUE;
}

gboolean plugins_table_copy_in (GtkObject *datatable)
{
  int i, j;
  GList data;
  GtkObject *mod_child;
  PGresult *result;
  gchar *txt_tmp;
  gchar *query;
  gchar *query2;
  gchar *query3;

  /*** Go ! */
  query = g_strdup_printf ("COPY %s FROM stdin;", TD_DB_DATATABLE (datatable)->table);
  td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Executing in local database query"), query), TD_MSG_BEGIN);
  if (!PQexec (connect_postgresql, g_strdup_printf ("COPY %s FROM stdin;", TD_DB_DATATABLE (datatable)->table)))
    {
      td_app_message (NULL, g_strdup_printf ("%s '%s' : %s", _("Executing in local database query"), query, PQerrorMessage (connect_postgresql)), TD_MSG_FAILED);
      td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Executing in local database query"), query), TD_MSG_END);
      return FALSE;
    }

  /*** Valeurs - Values */
  for (i=0; i<g_list_length (TD_DB_DATATABLE (datatable)->item); i++)
    {
      txt_tmp = "";
      for (j=0; j<g_list_length (g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i)); j++)
	{
	  if (j != g_list_length (g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i))-1)
	    txt_tmp = g_strdup_printf ("%s%s\t", txt_tmp, (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i), j));
	  else
	    txt_tmp = g_strdup_printf ("%s%s\n", txt_tmp, (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i), j));
	}
      PQputline (connect_postgresql, txt_tmp);
    }
  PQputline (connect_postgresql, "\\.\n");
  PQendcopy (connect_postgresql);
  td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Executing in local database query"), query), TD_MSG_SQL);

  /*** Squence *_td_id_seq - Sequence *_td_id_seq */
  query2 = g_strdup_printf ("SELECT relname FROM pg_class WHERE relname ='%s_td_id_seq';", TD_DB_DATATABLE (datatable)->table);
  result = query_result (query2);
  if (!result)
    {
      td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Executing in local database query"), query), TD_MSG_END);
      return FALSE;
    }
  if (PQntuples (result) == 0)
    {
      PQclear (result);
      td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Executing in local database query"), query), TD_MSG_END);
      return TRUE;
    }
  query3 = g_strdup_printf ("SELECT setval('%s_td_id_seq', (SELECT max(td_id) FROM %s));", TD_DB_DATATABLE (datatable)->table, TD_DB_DATATABLE (datatable)->table);
  if (!PQexec (connect_postgresql, query3))
    {
      td_app_message (NULL, g_strdup_printf ("%s '%s' : %s", _("Executing in local database query"), query3, PQerrorMessage (connect_postgresql)), TD_MSG_FAILED);
      td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Executing in local database query"), query), TD_MSG_END);
      return FALSE;
    }
  PQclear (result);
  td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Executing in local database query"), query3), TD_MSG_SQL);
  td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Executing in local database query"), query), TD_MSG_END);
  return TRUE;
}

/*****************************************************************************/
/*** Requte - Query */
/*****************************************************************************/
gboolean plugins_command (char *query)
{
  PGresult *result;
  result = PQexec (connect_postgresql, query);
  if (PQresultStatus (result) != PGRES_COMMAND_OK)
    {
      td_app_message (NULL, g_strdup_printf ("%s '%s' : %s", _("Executing in local database query"), query, PQerrorMessage (connect_postgresql)), TD_MSG_FAILED);
      return FALSE;
    }
  PQclear (result);
  td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Executing in local database query"), query), TD_MSG_SQL);
  return TRUE;
}

gboolean plugins_insert (char *query, gchar *table)
{
  PGresult *result;
  PGresult *result2;

  /*** Requte - Query */
  result = PQexec (connect_postgresql, query);
  if (PQresultStatus (result) != PGRES_COMMAND_OK)
    {
      td_app_message (NULL, g_strdup_printf ("%s '%s' : %s", _("Executing in local database query"), query, PQerrorMessage (connect_postgresql)), TD_MSG_FAILED);
      return FALSE;
    }

  /* CURRENT_ID */
  result2 = query_result (g_strdup_printf ("SELECT relname FROM pg_class WHERE relname ='%s_td_id_seq';", table));
  if (!result)
    return TRUE;
  if (PQntuples (result2) == 0)
    {
      PQclear (result);
      PQclear (result2);
      td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Executing in local database query"), query), TD_MSG_SQL);
      return TRUE;
    }
  CURRENT_ID = atoi (plugins_value (g_strdup_printf ("SELECT last_value FROM %s_td_id_seq;", table)));
  PQclear (result);
  PQclear (result2);
  td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Executing in local database query"), query), TD_MSG_SQL);
  return TRUE;
}

PGresult *query_result (char *query)
{
  PGresult *result;

  /*** Requte - Query */
  result = PQexec (connect_postgresql, query);
  if ((PQresultStatus (result) == PGRES_NONFATAL_ERROR) ||
      (PQresultStatus (result) == PGRES_FATAL_ERROR))
    {
      td_app_message (NULL, g_strdup_printf ("%s '%s' : %s", _("Executing in local database query"), query, PQerrorMessage (connect_postgresql)), TD_MSG_FAILED);
      return NULL;
    }
  td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Executing in local database query"), query), TD_MSG_SQL);
  return result;
}

GtkObject *plugins_select (gchar *query)
{
  GtkObject *ret;
  PGresult *result;
  GList *data = NULL;
  int i, j;

  /*** Requte - Query */
  result = query_result (query);
  if (!result)
    return NULL;

  /*** Donnes - Data */
  ret = td_db_datatable_new();
  for (i = 0; i < PQntuples (result); i++)
    {
      data = NULL;
      for (j = 0; j < PQnfields (result); j++)
	data = g_list_append (data, g_strdup_printf ("%s", PQgetvalue (result, i, j)));
      td_db_datatable_add_item (TD_DB_DATATABLE (ret), data);
    }
  PQclear (result);
  return ret;
}

GList *plugins_field (gchar *query)
{
  GList *ret = NULL;
  PGresult *result;
  int i;

  /*** Requte - Query */
  result = query_result (query);
  if (!result)
    return NULL;

  /*** Champs - Field */
  for (i = 0; i < PQnfields (result); i++)
    ret = g_list_append (ret, g_strdup_printf ("%s", PQfname (result, i)));
  PQclear (result);
  return ret;
}

GList *plugins_row (gchar *query)
{
  GList *ret = NULL;
  PGresult *result;
  int i;

  /*** Requte - Query */
  result = query_result (query);
  if (!result)
    return NULL;

  /*** Ligne - Row */
  for (i = 0; i < PQnfields (result); i++)
    ret = g_list_append (ret, g_strdup_printf ("%s", PQgetvalue (result, 0, i)));
  PQclear (result);
  return ret;
}

GList *plugins_column (gchar *query)
{
  GList *ret = NULL;
  PGresult *result;
  int i;

  /*** Requte - Query */
  result = query_result (query);
  if (!result)
    return NULL;

  /*** Colonne - Column */
  for (i = 0; i < PQntuples (result); i++)
    ret = g_list_append (ret, g_strdup_printf ("%s", PQgetvalue (result, i, 0)));
  PQclear (result);
  return ret;
}

gchar *plugins_value (gchar *query)
{
  PGresult *result;
  gchar *ret;

  /*** Requte - Query */
  result = query_result (query);
  if (!result)
    return NULL;
  if (!PQntuples (result))
    {
      PQclear (result);
      return NULL;
    }
  ret = g_strdup_printf ("%s", PQgetvalue (result, 0, 0));
  PQclear (result);
  return ret;
}

gboolean plugins_set_current (gchar *query)
{
  PGresult *result;
  int i;
  CURRENT_FIELD = NULL;
  CURRENT_ROW = NULL;

  /*** Requte - Query */
  result = query_result (query);
  if (!result)
    return FALSE;
  
  /*** Champs et donnes - Fields and data */
  if (!PQntuples (result))
    {
      CURRENT_FIELD = NULL;
      CURRENT_ROW = NULL;
      PQclear (result);
      return TRUE;
    }
  for (i = 0; i < PQnfields (result); i++)
    {
      CURRENT_FIELD = g_list_append (CURRENT_FIELD, g_strdup_printf ("%s", PQfname (result, i)));
      CURRENT_ROW = g_list_append (CURRENT_ROW, g_strdup_printf ("%s", PQgetvalue (result, 0, i)));
    }
  PQclear (result);
  return TRUE;
}

/*****************************************************************************/
/*** Rgles - Rules */
/*****************************************************************************/

gboolean plugins_rule_create (GtkObject *rule)
{
  gchar *txt_tmp;
  if (!plugins_command (g_strdup_printf ("CREATE RULE %s AS ON %s TO %s DO %s;",
					 TD_RULE (rule)->name, td_rule_property_value (TD_RULE (rule), "event"),
					 td_rule_property_value (TD_RULE (rule), "table"), td_rule_property_value (TD_RULE (rule), "action query"))))
    return FALSE;
  return TRUE;
}

gboolean plugins_rule_drop (GtkObject *rule)
{
  if (!plugins_command (g_strdup_printf ("DROP RULE %s;", TD_RULE (rule)->name)))
    return FALSE;
  return TRUE;
}

/*****************************************************************************/
/*** Fonctions - Function */
/*****************************************************************************/

gboolean plugins_function_create (GtkObject *function)
{
  /* FIXME: +tards - this night */
  return TRUE;
}

gboolean plugins_function_drop (GtkObject *function)
{
  /* FIXME: +tards - this night */
  return TRUE;
}
