/*****************************************************************************/
/* main.h : Donnes globales et fentre principale
 * main.h : Global data and main window
 *
 *
 * Greffon ToutDoux : Interface MySQL
 * ToutDoux's plug-in : MySQL interface
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#include <toutdoux.h>
#include <mysql.h>

/*****************************************************************************/
/*** Variables globales - Global variables */
/*****************************************************************************/
MYSQL mysql;
gchar *local_database_name;

/*****************************************************************************/
/*** Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void);
void plugins_init (void);
void plugins_destroy (gpointer user_data);

/*****************************************************************************/
/*** Base */
/*****************************************************************************/
gboolean plugins_base_login (gchar *name);
gboolean plugins_base_logout (void);
gboolean plugins_base_create (gchar *name);
gboolean plugins_base_drop (gchar *name);
gboolean plugins_base_raz (void);

/*****************************************************************************/
/*** Tables */
/*****************************************************************************/
gboolean plugins_table_create (GtkObject *table);
gboolean plugins_table_exist (gchar* table);
gboolean plugins_table_drop (GtkObject *table);
gboolean plugins_table_copy_in (GtkObject *datatable);

/*****************************************************************************/
/*** Requte - Query */
/*****************************************************************************/
gboolean plugins_command (char *query);
MYSQL_RES *query_result (char *query);
GtkObject *plugins_select (gchar* query);
GList *plugins_field (gchar* query);
GList *plugins_row (gchar* query);
GList *plugins_column (gchar* query);
gchar *plugins_value (gchar* query);
gboolean plugins_set_current (gchar* query);

/*****************************************************************************/
/*** Rgles - Rules */
/*****************************************************************************/
gboolean plugins_rule_create (GtkObject *rule);
gboolean plugins_rule_drop (GtkObject *rule);

/*****************************************************************************/
/*** Fonctions - Functions */
/*****************************************************************************/
gboolean plugins_function_create (GtkObject *function);
gboolean plugins_function_drop (GtkObject *function);
