/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : Interface MySQL
 * ToutDoux's plug-in : MySQL interface
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "main.h"

/*****************************************************************************/
/*** Variables globales - Global variables */
/*****************************************************************************/
MYSQL connect_mysql;
gchar *local_database_name;

/*****************************************************************************/
/*** Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("MySQL interface"),
		  "type", _("database"),
		  "version", "1.0.1",
		  "authors", "Philippe Roy <ph_roy@toutdoux.org>",
		  "category1", _("core"),
		  "category2", _("database"),
		  "category3", "mysql",
		  "copyright", "Copyright (c) 2000-2001 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"), NULL);
  return ret;
}

void plugins_init (void)
{
}

void plugins_destroy (gpointer user_data)
{
}

/*****************************************************************************/
/*** Base */
/*****************************************************************************/
gboolean plugins_base_login (gchar *name)
{
  local_database_name = name;
  mysql_init (&connect_mysql);
  mysql_options (&connect_mysql, MYSQL_READ_DEFAULT_GROUP, name);
  if (!mysql_real_connect (&connect_mysql, NULL, NULL, NULL, name, 0, NULL, 0))
    {
      td_app_message (NULL, g_strdup_printf ("%s : MySQL : '%s'", _("Login to local database"), local_database_name), TD_MSG_FAILED);
      return FALSE;
    }
  td_app_message (NULL, g_strdup_printf ("%s : MySQL : '%s'", _("Login to local database"), local_database_name), TD_MSG_DONE);
  return TRUE;
}

gboolean plugins_base_logout (void)
{
  mysql_close (&connect_mysql);
  td_app_message (NULL, g_strdup_printf ("%s : MySQL : '%s'", _("Login to local database"), local_database_name), TD_MSG_DONE);
  return TRUE;
}

gboolean plugins_base_create (gchar *name)
{
  if (!td_system (g_strdup_printf ("mysqladmin create %s", name)))
    {
      td_system (g_strdup_printf ("mysqladmin drop %s", name));
      if (!td_system (g_strdup_printf ("mysqladmin create %s", name)))
	{
	  td_app_message (_("Creating local database"), g_strdup_printf ("%s : MySQL : '%s'", _("Creating local database"), name), TD_MSG_FAILED);
	  return FALSE;
	}
    }
  td_app_message (NULL, g_strdup_printf ("%s : MySQL : '%s'", _("Creating local database"), name), TD_MSG_DONE);
  return TRUE;
}

gboolean plugins_base_drop (gchar *name)
{
  if (!td_system (g_strdup_printf ("mysqladmin drop %s", name)))
    {
      td_app_message (_("Dropping local database"), g_strdup_printf ("%s : MySQL : '%s'", _("Dropping local database"), name), TD_MSG_FAILED);
      return FALSE;
    }
  td_app_message (NULL, g_strdup_printf ("%s : MySQL : '%s'", _("Dropping local database"), name), TD_MSG_DONE);
  return TRUE;
}

gboolean plugins_base_raz (void)
{
/*    if (!td_system (g_strdup_printf ("dropdb %s", name))) */
/*      { */
/*        td_app_message (_("Dropping local database"), g_strdup_printf ("%s : PostgreSQL : '%s'", _("Dropping local database"), name), TD_MSG_FAILED); */
/*        return FALSE; */
/*      } */
/*    td_app_message (NULL, g_strdup_printf ("%s : PostgreSQL : '%s'", _("Dropping local database"), name), TD_MSG_DONE); */
  return TRUE;
}

/*****************************************************************************/
/*** Tables */
/*****************************************************************************/
gboolean plugins_table_create (GtkObject *table)
{
  TdDbTableField *field;
  gchar *query;
  gchar *type = NULL;
  int i,j;

  /*** Table */
  query = g_strdup_printf ("CREATE TABLE %s (", TD_DB_TABLE (table)->name);

  /*** Champs - Fields */
  for (i=0; i<g_list_length (TD_DB_TABLE (table)->field); i++)
    {
      field = (TdDbTableField*) g_list_nth_data (TD_DB_TABLE (table)->field, i);
      query = g_strdup_printf ("%s%s", query, field->name);

      /* Proprits des champs - Field properties */
      for (j=0; j<g_list_length (field->property_name); j++)
	{
	  /*** type */
	  if (!strcmp ("type", g_list_nth_data (field->property_name, j)))
	    {
	      type = g_list_nth_data (field->property_value, j);
	      if (!strcmp ("bool", g_list_nth_data (field->property_value, j)))
		query = g_strdup_printf ("%s ENUM ('f', 't')", query);
	      if (!strcmp ("serial", g_list_nth_data (field->property_value, j)))
		query = g_strdup_printf ("%s int4 AUTO_INCREMENT", query);
	      if ((strcmp ("serial", g_list_nth_data (field->property_value, j))) &&
		  (strcmp ("bool", g_list_nth_data (field->property_value, j))))
		query = g_strdup_printf ("%s %s", query, (gchar*) g_list_nth_data (field->property_value, j));
	    }

	  /*** type option */
	  if (!strcmp ("type option", g_list_nth_data (field->property_name, j)))
	    {
	      if (!strcmp ("unsigned", g_list_nth_data (field->property_value, j)))
		query = g_strdup_printf ("%s UNSIGNED", query);
	      if (!strcmp ("zero fill", g_list_nth_data (field->property_value, j)))
		query = g_strdup_printf ("%s ZEROFILL", query);
	      if (!strcmp ("binary", g_list_nth_data (field->property_value, j)))
		query = g_strdup_printf ("%s BINARY", query);
	    }

	  /*** constraint */
	  if (!strcmp ("constraint", g_list_nth_data (field->property_name, j)))
	    {
	      if (!strcmp ("not null", g_list_nth_data (field->property_value, j)))
		query = g_strdup_printf ("%s NOT NULL", query);
	      if (!strcmp ("unique", g_list_nth_data (field->property_value, j)))
		query = g_strdup_printf ("%s UNIQUE", query);
	      if (!strcmp ("primary key", g_list_nth_data (field->property_value, j)))
		query = g_strdup_printf ("%s PRIMARY KEY", query);
	    }

	  /*** default */
	  if (!strcmp ("default", g_list_nth_data (field->property_name, j)))
	    query = g_strdup_printf ("%s DEFAULT %s", query, td_database_adaptvalue (g_list_nth_data (field->property_value, j), type));
	}
      if (i != g_list_length (TD_DB_TABLE (table)->field)-1)
	query = g_strdup_printf ("%s, ", query);
    }
  query = g_strdup_printf ("%s);", query);

  /*** Go ! */
  if (!plugins_command (query))
    return FALSE;
  return TRUE;
}

gboolean plugins_table_exist (gchar* table)
{
  MYSQL_RES *result;
  result = mysql_list_tables (&connect_mysql, table);
  if (!result)
    return FALSE;
  if (mysql_num_rows (result) > 0)
    {
      mysql_free_result (result);
      return TRUE;
    }
  mysql_free_result (result);
  return FALSE;
}

gboolean plugins_table_drop (GtkObject *table)
{
  if (!plugins_command (g_strdup_printf ("DROP TABLE %s;", TD_DB_TABLE (table)->name)))
    return FALSE;
  return TRUE;
}

gboolean plugins_table_copy_in (GtkObject *datatable)
{
  int i, j;
  FILE *fp;
  gchar *file = g_strdup_printf ("%s/mysql.csv", TD_PACKAGE_TMP_DIR);
  gchar *query;

  /*** Fichier - File */
  /* FIELDS TERMINATED BY '\t' ENCLOSED BY '' ESCAPED BY '\\' LINES TERMINATED BY '\n' */
  query = g_strdup_printf ("LOAD DATA LOCAL INFILE '%s' INTO TABLE %s", file, TD_DB_DATATABLE (datatable)->table);
  td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Executing in local database query"), query), TD_MSG_BEGIN);
  if ((fp = fopen (file, "w")) == NULL)
    {
      td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Saving csv file"), file), TD_MSG_FAILED);
      td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Executing in local database query"), query), TD_MSG_END);
      return FALSE;
    }
  for (i=0; i<g_list_length (TD_DB_DATATABLE (datatable)->item); i++)
    {
      for (j=0; j<g_list_length (g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i)); j++)
	fprintf (fp, "%s\t", (gchar*) g_list_nth_data (g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i), j));
      fprintf (fp, "\n");
    }
  fclose (fp);
  td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Saving csv file"), file), TD_MSG_DONE);

  /*** Requte - Query */
  if (!plugins_command (query))
    {
      td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Executing in local database query"), query), TD_MSG_FAILED);
      td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Executing in local database query"), query), TD_MSG_END);
      return FALSE;
    }
  if (!TD_APP (APP)->mode_debug)
    remove (file);
  td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Executing in local database query"), query), TD_MSG_DONE);
  td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Executing in local database query"), query), TD_MSG_END);
  return TRUE;
}

/*****************************************************************************/
/*** Requte - Query */
/*****************************************************************************/
gboolean plugins_command (char *query)
{
  /*** Requte - Query */
  if (mysql_query (&connect_mysql, query) == -1)
    {
      td_app_message (NULL, g_strdup_printf ("%s '%s' : %s", _("Executing in local database query"), query, mysql_error (&connect_mysql)), TD_MSG_FAILED);
      return FALSE;
    }
  td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Executing in local database query"), query), TD_MSG_SQL);
  return TRUE;
}

gboolean plugins_insert (char *query, gchar *table)
{
  /*** Requte - Query */
  if (mysql_query (&connect_mysql, query) == -1)
    {
      td_app_message (NULL, g_strdup_printf ("%s '%s' : %s", _("Executing in local database query"), query, mysql_error (&connect_mysql)), TD_MSG_FAILED);
      return FALSE;
    }

  /*** CURRENT_ID */
  CURRENT_ID = mysql_insert_id (&connect_mysql);
  td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Executing in local database query"), query), TD_MSG_SQL);
  return TRUE;
}

MYSQL_RES *query_result (char *query)
{
  MYSQL_RES *result;

  /*** Requte - Query */
  if (mysql_query (&connect_mysql, query) == -1)
    {
      td_app_message (NULL, g_strdup_printf ("%s '%s' : %s", _("Executing in local database query"), query, mysql_error (&connect_mysql)), TD_MSG_FAILED);
      return NULL;
    }
  result = mysql_store_result (&connect_mysql);
  if (!result)
    {
      td_app_message (NULL, g_strdup_printf ("%s '%s' : %s", _("Executing in local database query"), query, mysql_error (&connect_mysql)), TD_MSG_FAILED);
      return NULL;
    }
  td_app_message (NULL, g_strdup_printf ("%s '%s'", _("Executing in local database query"), query), TD_MSG_SQL);
  return result;
}

GtkObject *plugins_select (gchar* query)
{
  GtkObject *ret;
  MYSQL_RES *result;
  MYSQL_ROW row;
  GList *data = NULL;
  int num_fields;
  int i;

  /*** Requte - Query */
  result = query_result (query);
  if (!result)
    return NULL;

  /*** Donnes - Data */
  ret = td_db_datatable_new();
  num_fields = mysql_num_fields (result);
  while ((row = mysql_fetch_row (result)))
    {
      data = NULL;
      for (i = 0; i < num_fields; i++)
	data = g_list_append (data, g_strdup_printf ("%s", row[i]));
      td_db_datatable_add_item (TD_DB_DATATABLE (ret), data);
    }
  mysql_free_result (result);
  return ret;
}

GList *plugins_field (gchar* query)
{
  GList *ret = NULL;
  MYSQL_RES *result;
  MYSQL_FIELD *fields;
  int i;

  /*** Requte - Query */
  result = query_result (query);
  if (!result)
    return NULL;

  /*** Champs - Field */
  fields = mysql_fetch_fields (result);
  for (i = 0; i < mysql_num_fields (result); i++)
    ret = g_list_append (ret, g_strdup_printf ("%s", fields[i].name));
  mysql_free_result (result);
  return ret;
}

GList *plugins_row (gchar* query)
{
  GList *ret = NULL;
  MYSQL_RES *result;
  MYSQL_ROW row;
  int num_fields;
  int i;

  /*** Requte - Query */
  result = query_result (query);
  if (!result)
    return NULL;

  /*** Donnes - Data */
  num_fields = mysql_num_fields (result);
  row = mysql_fetch_row (result);
  for (i = 0; i < num_fields; i++)
    ret = g_list_append (ret, g_strdup_printf ("%s", row[i]));
  mysql_free_result (result);
  return ret;
}

GList *plugins_column (gchar* query)
{
  GList *ret = NULL;
  MYSQL_RES *result;
  MYSQL_ROW row;

  /*** Requte - Query */
  result = query_result (query);
  if (!result)
    return NULL;

  /*** Donnes - Data */
  while ((row = mysql_fetch_row (result)))
    ret = g_list_append (ret, g_strdup_printf ("%s", row[0]));
  mysql_free_result (result);
  return ret;
}

gchar *plugins_value (gchar* query)
{
  gchar *ret;
  MYSQL_RES *result;
  MYSQL_ROW row;

  /*** Requte - Query */
  result = query_result (query);
  if (!result)
    return NULL;

  /*** Donnes - Data */
  row = mysql_fetch_row (result);
  if (!row)
    {
      mysql_free_result (result);
      return NULL;
    }
  ret = g_strdup_printf ("%s", g_strdup_printf ("%s", row[0]));
  mysql_free_result (result);
  return ret;
}

gboolean plugins_set_current (gchar* query)
{
  MYSQL_RES *result;
  MYSQL_FIELD *fields;
  MYSQL_ROW row;
  int num_fields;
  int i;
  CURRENT_FIELD = NULL;
  CURRENT_ROW = NULL;

  /*** Requte - Query */
  result = query_result (query);
  if (!result)
    return FALSE;

  /*** Champs - Fields */
  fields = mysql_fetch_fields (result);
  for (i = 0; i < mysql_num_fields (result); i++)
    CURRENT_FIELD = g_list_append (CURRENT_FIELD, g_strdup_printf ("%s", fields[i].name));

  /*** Donnes - Data */
  num_fields = mysql_num_fields (result);
  row = mysql_fetch_row (result);
  for (i = 0; i < num_fields; i++)
    CURRENT_ROW = g_list_append (CURRENT_ROW, g_strdup_printf ("%s", row[i]));
  mysql_free_result (result);
  return TRUE;
}

/*****************************************************************************/
/*** Rgles - Rules */
/*****************************************************************************/
gboolean plugins_rule_create (GtkObject *rule)
{
  /* FIXME: + tards - this night */
  td_app_message (NULL, _("Rules not works with MySQL"), TD_MSG_FAILED);
  return TRUE;
}

gboolean plugins_rule_drop (GtkObject *rule)
{
  /* FIXME: + tards - this night */
  td_app_message (NULL, _("Rules not works with MySQL"), TD_MSG_FAILED);
  return TRUE;
}

/*****************************************************************************/
/*** Fonctions - Functions */
/*****************************************************************************/
gboolean plugins_function_create (GtkObject *function)
{
  /* FIXME: + tards - this night */
  td_app_message (NULL, _("Functions not works with MySQL"), TD_MSG_FAILED);
  return TRUE;
}

gboolean plugins_function_drop (GtkObject *function)
{
  /* FIXME: + tards - this night */
  td_app_message (NULL, _("Functions not works with MySQL"), TD_MSG_FAILED);
  return TRUE;
}
