/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : Communication avec un URL
 * ToutDoux's plug-in : URL communication
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <toutdoux.h>

#include "main.h"

/*****************************************************************************/
/*** Variables globales - Global variables */
/*****************************************************************************/
GtkObject *mod;
gboolean selection;
gboolean quit;
GtkWidget *entry;

/*****************************************************************************/
/*** Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("URL communication"),
		  "type", _("communication"),
		  "version", "1.0.1",
		  "authors", "Philippe Roy <ph_roy@toutdoux.org>",
		  "help", _("GNU Wget frontend"),
		  "category1", _("core"),
		  "category2", _("communication"),
		  "category3", _("url"),
		  "copyright", "Copyright (c) 2000-2001 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"),
		  "web", "(null)", NULL);
  return ret;
}

GtkObject *mod_def (void)
{
  GtkObject *ret;

  GtkObject *box;
  GtkWidget *text;
  GtkObject *stree;

  GtkWidget *toolbar;
  GtkWidget *radiobutton1;
  GtkWidget *radiobutton2;
  GtkWidget *button1;

  /*** Module */
  ret = td_mod_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "url_communication",
		  "name_intl", _("URL communication"), NULL);
  td_mod_set_about (TD_MOD (ret), plugins_about_def());

  /*** Barre d'outils - Tools barr */
  toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_widget_show (toolbar);
  td_mod_set_window_toolbar (TD_MOD (ret), toolbar);
  radiobutton1 = gtdk_toolbar_append_radiobutton (GTK_TOOLBAR (toolbar), NULL, _("Address"), "button_url.xpm");
  gtk_signal_connect (GTK_OBJECT (radiobutton1), "clicked", GTK_SIGNAL_FUNC (radiobutton1_clicked), NULL);
  radiobutton2 = gtdk_toolbar_append_radiobutton (GTK_TOOLBAR (toolbar), radiobutton1, _("History"), "button_clock.xpm");
  gtk_signal_connect (GTK_OBJECT (radiobutton2), "clicked", GTK_SIGNAL_FUNC (radiobutton2_clicked), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  button1 = gtdk_toolbar_append_button (GTK_TOOLBAR (toolbar), _("Close"), "button_close.xpm");
  gtk_signal_connect_object (GTK_OBJECT (button1), "clicked", GTK_SIGNAL_FUNC (td_mod_hide), ret);

  /*** Requte - Query */
  box = td_mod_box_new();
  gtk_object_set (GTK_OBJECT (box), "name", _("URL address"), NULL);
  td_mod_add_child (TD_MOD (ret), box);
  text = gtk_text_new (NULL, NULL);
  gtk_text_set_editable (GTK_TEXT (text), TRUE);
  gtk_widget_show (text);
  td_mod_box_set_widget (TD_MOD_BOX (box), text);
  td_mod_box_set_widget_focus (TD_MOD_BOX (box), text);
  gtk_signal_connect (GTK_OBJECT (text), "key_press_event", GTK_SIGNAL_FUNC (text_key_press_event), NULL);

  /*** Historique - History */
  stree = td_mod_stree_new();
  gtk_object_set (GTK_OBJECT (stree), 
		  "name", _("History"),
		  "name_parent", "url_communication", NULL);
  td_mod_add_child (TD_MOD (ret), stree);
  return ret;
}

void plugins_init (void)
{
}

gchar *plugins_show (void)
{
  int i, j;
  GtkObject *flower;
  GtkObject *flower2;
  gboolean bool_tmp;
  GtkWidget *node_history = NULL;
  gchar *txt_tmp;
  gchar *address;
  TdModStree *mod_stree;

  /*** Fentre - Window */
  if (!mod)
    {
      mod = mod_def();
      td_mod_create (TD_MOD (mod));

      /*** Historique - History */
      td_app_message (NULL, _("Loading history"), TD_MSG_BEGIN);
      flower = td_flower_new();
      gtk_object_set (GTK_OBJECT (flower), "root", "history", "branch", "address", NULL);
      td_flower_add_branch_attribut (TD_FLOWER (flower), "text");
      if (td_flower_load_file (TD_FLOWER (flower), g_strdup_printf ("%s/url_history.xml", TD_PACKAGE_VAR_DIR)))
	{
	  
	  /*** Doublon - Double */
	  flower2 = td_flower_new();
	  gtk_object_set (GTK_OBJECT (flower2), "root", "history", "branch", "address", NULL);
	  td_flower_add_branch_attribut (TD_FLOWER (flower2), "text");
	  for (i=0; i<g_list_length (TD_FLOWER (flower)->items_value); i++)
	    {
	      bool_tmp = TRUE;
	      for (j=0; j<g_list_length (TD_FLOWER (flower2)->items_value); j++)
		if (!strcmp (g_strstrip (g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 0)), g_strstrip (g_list_nth_data (g_list_nth_data (TD_FLOWER (flower2)->items_value, j), 0))))
		  {
		    bool_tmp = FALSE;
		    break;
		  }
	      if (bool_tmp)
		td_flower_add_item (TD_FLOWER (flower2), g_list_nth_data (TD_FLOWER (flower)->items_value, i), 0);
	      if (i > 100)
		break;
	    }
	  td_mod_stree_load_flower (TD_MOD_STREE (g_list_nth_data (TD_MOD (mod)->child, 1)), flower2);
	  td_flower_destroy (TD_FLOWER (flower2));
	}
      td_app_message (NULL, _("Loading history"), TD_MSG_END);
      gtk_signal_connect (GTK_OBJECT (TD_MOD_STREE (g_list_nth_data (TD_MOD (mod)->child, 1))->widget_data), "select_child", GTK_SIGNAL_FUNC (history_select_child), mod);
      gtk_signal_connect (GTK_OBJECT (TD_MOD_STREE (g_list_nth_data (TD_MOD (mod)->child, 1))->widget_data), "button_press_event", GTK_SIGNAL_FUNC (history_button_press_event), mod);
      td_flower_destroy (TD_FLOWER (flower));
    }

  /*** Slection - Selection */
  selection = FALSE;
  quit = FALSE;
  td_mod_show (TD_MOD (mod));
  do
    gtk_main();
  while ((!selection) && (!quit));
  if (selection)
    {
      address = g_strstrip (gtk_editable_get_chars (GTK_EDITABLE (TD_MOD_BOX (g_list_nth_data (TD_MOD (mod)->child, 0))->widget), 0, -1));
      mod_stree = TD_MOD_STREE (g_list_nth_data (TD_MOD (mod)->child, 1));

      /*** Historique - History */
      /* FIXME: adresse sur plusieurs lignes : + tards */
      node_history = gtk_tree_item_new();
      gtk_widget_show (node_history);
      td_mod_stree_item_set_label (node_history, address, mod_stree, 0);
      gtk_tree_insert (GTK_TREE (mod_stree->widget_data), node_history, 0);

      /*** Doublon - Double */
      for (i=1; i<g_list_length (gtk_container_children (GTK_CONTAINER (mod_stree->widget_data))); i++)
	{
	  gtk_label_get (GTK_LABEL (g_list_nth_data (gtk_container_children (GTK_CONTAINER (g_list_nth_data (gtk_container_children (GTK_CONTAINER (g_list_nth_data (gtk_container_children (GTK_CONTAINER (mod_stree->widget_data)), i))), 0))), 0)), &txt_tmp);
	  if (!strcmp (txt_tmp, address))
	    gtk_tree_remove_item (GTK_TREE (mod_stree->widget_data), g_list_nth_data (gtk_container_children (GTK_CONTAINER (mod_stree->widget_data)), i));
	}
      td_mod_hide (TD_MOD (mod));
      return (address);
    }
  td_mod_hide (TD_MOD (mod));
  return NULL;
}

void plugins_hide (void)
{
}

void plugins_destroy (gpointer user_data)
{
  int i;
  GtkObject *flower;
  TdModStree *mod_stree;
  gchar *txt_tmp;
  gchar *file;

  /*** Historique - History */
  if (mod)
    {
      mod_stree = TD_MOD_STREE (g_list_nth_data (TD_MOD (mod)->child, 1));
      flower = td_flower_new();
      gtk_object_set (GTK_OBJECT (flower), "root", "history", "branch", "address", NULL);
      td_flower_add_branch_attribut (TD_FLOWER (flower), "text");
      for (i=0; i<g_list_length (gtk_container_children (GTK_CONTAINER (mod_stree->widget_data))); i++)
	{
	  gtk_label_get (GTK_LABEL (g_list_nth_data (gtk_container_children (GTK_CONTAINER (g_list_nth_data (gtk_container_children (GTK_CONTAINER (g_list_nth_data (gtk_container_children (GTK_CONTAINER (mod_stree->widget_data)), i))), 0))), 0)), &txt_tmp);
	  td_flower_add_item (TD_FLOWER (flower), td_strsplist (txt_tmp, "(null)"), 0);
	}
      file = g_strdup_printf ("%s/url_history.xml", TD_PACKAGE_VAR_DIR);
      if (!td_flower_save_file (TD_FLOWER (flower), file))
	td_app_message (NULL, g_strdup_printf (_("Saving history '%s'"), file), TD_MSG_FAILED);
      else
	td_app_message (NULL, g_strdup_printf (_("Saving history '%s'"), file), TD_MSG_DONE);
      td_mod_destroy (TD_MOD (mod));
      td_flower_destroy (TD_FLOWER (flower));
    }
}

void radiobutton1_clicked (GtkRadioButton *radiobutton, gpointer user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->window_notebook), 0);
}
void radiobutton2_clicked (GtkRadioButton *radiobutton, gpointer user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->window_notebook), 1);
}

/*****************************************************************************/
/*** Commande - Command */
/*****************************************************************************/
void text_key_press_event (GtkWidget *widget, GdkEventKey *event, gpointer user_data)
{
  if (event->keyval == GDK_Return)
    td_set_ok (NULL, &selection);
}

void history_select_child (GtkTree *tree, GtkWidget *widget, gpointer user_data)
{
  gchar *txt_tmp;
  gtk_label_get (GTK_LABEL (g_list_nth_data (gtk_container_children (GTK_CONTAINER (g_list_nth_data (gtk_container_children (GTK_CONTAINER (widget)), 0))), 0)), &txt_tmp);
  gtk_editable_delete_text (GTK_EDITABLE (TD_MOD_BOX (g_list_nth_data (TD_MOD (mod)->child, 0))->widget), 0, -1);
  gtk_text_insert (GTK_TEXT (TD_MOD_BOX (g_list_nth_data (TD_MOD (mod)->child, 0))->widget), NULL, NULL, NULL, txt_tmp,-1);
}

void history_button_press_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
  if (event->type == GDK_2BUTTON_PRESS)
    td_set_ok (NULL, &selection);
}

/*****************************************************************************/
/*** Wget */
/*****************************************************************************/
gboolean plugins_load_url (gchar *url)
{
  struct stat stat_tmp;
  char txt_ligne_tmp[500];
  FILE *fp2;
  gchar *txt_url;
  gchar *size_txt;
  float size_total;
  float size_current = 0;
  gchar *file_log = g_strdup_printf ("%s/wget.log", TD_PACKAGE_TMP_DIR);
  gchar *file_tmp = g_strdup_printf ("%s/url.td", TD_PACKAGE_TMP_DIR);

  /*** Taille du fichier - File size */
  if (!td_system (g_strdup_printf ("wget -o %s --spider %s", file_log, url)))
    {
      td_app_message (_("Retrieving url"), _("Retrieving url : wget or url not find"), TD_MSG_FAILED);
      td_app_message (NULL, _("Retrieving url"), TD_MSG_END);
      return FALSE;
    }
  if ((fp2 = fopen (file_log, "r")) == NULL)
    {
      td_app_message (_("Retrieving url"), _("Reading wget log"), TD_MSG_FAILED);
      td_app_message (NULL, _("Retrieving url"), TD_MSG_END);
      return FALSE;
    }
  fgets (txt_ligne_tmp,500,fp2);
  fgets (txt_ligne_tmp,500,fp2);
  fgets (txt_ligne_tmp,500,fp2);
  fgets (txt_ligne_tmp,500,fp2);
  fgets (txt_ligne_tmp,500,fp2);
  size_txt = strtok (txt_ligne_tmp," ");
  size_txt = strtok (NULL," ");
  size_total = (atoi (g_strdup_printf ("%s", (gchar*)size_txt))*1000);
  fclose (fp2);
  if (!TD_FLAG_DEBUG_MODE)
    remove (file_log);

  /*** Go ! */
  gtk_progress_set_activity_mode (GTK_PROGRESS (TD_APP_PALETTE (TD_APP (APP)->palette)->progressbar), FALSE);
  td_app_palette_progressbar_init (TD_APP_PALETTE (TD_APP (APP)->palette), _("Open URL..."));
  remove (file_tmp);
  if (!td_exec (g_strdup_printf ("wget -O %s %s", file_tmp, url)))
    {
      td_app_message (_("Retrieving url"), _("Loading URL failed"), TD_MSG_FAILED);
      td_app_message (NULL, _("Retrieving url"), TD_MSG_END);
      return FALSE;
    }
  while (size_current < size_total)
    {
      if (stat (file_tmp, &stat_tmp) != -1)
	{
	  size_current = stat_tmp.st_size;
	  td_app_palette_progressbar_update (TD_APP_PALETTE (TD_APP (APP)->palette), (size_current/size_total));
	}
      sleep (1);
    }
  td_app_palette_progressbar_hide (TD_APP_PALETTE (TD_APP (APP)->palette));
  td_app_message (NULL, _("Retrieving url"), TD_MSG_DONE);
  td_app_message (NULL, _("Retrieving url"), TD_MSG_END);
  return TRUE;
}
