/*****************************************************************************/
/* configuration.c : Configuration utilisateur
 * configuration.c : User configuration
 *
 *
 * TouxDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <fcntl.h>
#include <dirent.h>
#include <sys/stat.h>
#include <toutdoux.h>

#include "main.h"
#include "configuration.h"

/**
 * configuration_file:
 * 
 * fr: Configuration des fichiers
 *
 * en: Files configuration
 **/

gboolean configuration_file (void)
{
  DIR *cur_repertoire;
  gchar *txt_tmp;

  /*** Rpertoires - Directory */
  cur_repertoire = opendir (g_strdup_printf ("%s/.%s", g_get_home_dir(), TD_PACKAGE_DIR));
  if (cur_repertoire)
    {
      closedir (cur_repertoire);
      return TRUE;
    }
  td_app_message (NULL, _("Installation"), TD_MSG_BEGIN);
  if (mkdir (g_strdup_printf ("%s/.%s", g_get_home_dir(), TD_PACKAGE_DIR), S_IRWXU))
    {
      td_app_message (NULL, _("Creating user's directory"), TD_MSG_FAILED);
      td_app_message (NULL, _("Installation"), TD_MSG_END);
      return FALSE;
    }
  cur_repertoire = opendir (g_strdup_printf("%s/.%s/tmp", g_get_home_dir(), TD_PACKAGE_DIR));
  if (mkdir (g_strdup_printf ("%s/.%s/tmp", g_get_home_dir(), TD_PACKAGE_DIR), S_IRWXU))
    {
      td_app_message (NULL, _("Creating user's directory of tempory file"), TD_MSG_FAILED);
      td_app_message (NULL, _("Installation"), TD_MSG_END);
      return FALSE;
    }
  cur_repertoire = opendir (g_strdup_printf("%s/.%s/customize", g_get_home_dir(), TD_PACKAGE_DIR));
  if (mkdir (g_strdup_printf ("%s/.%s/customize", g_get_home_dir(), TD_PACKAGE_DIR), S_IRWXU))
    {
      td_app_message (NULL, _("Creating user's directory of customizing file"), TD_MSG_FAILED);
      td_app_message (NULL, _("Installation"), TD_MSG_END);
      return FALSE;
    }

  /*** Fichier de configuration - Custom file */
  if (!td_file_exist (g_strdup_printf ("%s/.%s/customize/app.xml", g_get_home_dir(), TD_PACKAGE_DIR)))
    {
      if (td_file_exist (g_strdup_printf ("%s/share/%s/app/customize-%s.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, _("en"))))
	txt_tmp = g_strdup_printf ("cp %s/share/%s/app/customize-%s.xml %s/.%s/customize/app.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, _("en"), g_get_home_dir(), TD_PACKAGE_DIR);
      else
	txt_tmp = g_strdup_printf ("cp %s/share/%s/app/customize-%s.xml %s/.%s/customize/app.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, "en", g_get_home_dir(), TD_PACKAGE_DIR);
      if (!td_system (txt_tmp))
	{
	  td_app_message (NULL, _("Copying file config"), TD_MSG_FAILED);
	  td_app_message (NULL, _("Installation"), TD_MSG_END);
	  return FALSE;
	}
    }
  td_app_message (NULL, _("Installation"), TD_MSG_END);
  return TRUE;
}

/**
 * configuration_general:
 * 
 * fr: Configuration gnrale
 *
 * en: General configuration
 **/

void configuration_general (void)
{
  /*** Base de donnes - database */
  FLAG_ENTRY_CHANGED_TIME = atoi (td_app_custom_value ("database", "delay", "delay between sql backend and gui"));

  /*** Interface */
  FLAG_DRAG_AUTOEXPAND_TIME = atoi (td_app_custom_value ("interface", "delay", "delay for expanding tree's node"));
  if (!strcmp (td_app_custom_value ("interface", "windows", "placement"), "toutdoux"))
    TD_CUSTOM_GEOMETRY_PLACEMENT = TRUE;
  else
    TD_CUSTOM_GEOMETRY_PLACEMENT = FALSE;

  /*** Localisation - Localization */
  if (!strcmp (td_app_custom_value ("localization", "date", "format"), "day/month/year"))
    TD_CUSTOM_DATE_FORMAT = TD_DATE_FORMAT_EU;
  else
    TD_CUSTOM_DATE_FORMAT = TD_DATE_FORMAT_US;
}


/**
 * configuration_face:
 * 
 * fr: Configuration des faces
 *
 * en: Faces configuration
 **/

void configuration_face (void)
{
  GtkWidget *label;
  GtkStyle *rcstyle;

  /*** Style de texte - Text style */
  label = gtk_label_new ("");
  rcstyle = gtk_rc_get_style (label);
  gtk_widget_set_default_style (rcstyle);
  gtk_widget_destroy (label);
  if (rcstyle == NULL)
    rcstyle = gtk_style_new();
  TD_STYLE_TEXT_DEFAULT = gtk_style_copy (rcstyle);
  TD_STYLE_TEXT_SELECTED = gtk_style_copy (rcstyle);
  TD_STYLE_TEXT_URL = gtk_style_copy (rcstyle);
  TD_STYLE_TEXT_DEFAULT->fg[0] = gtdk_color_parse (td_app_custom_value ("interface", "color", "default value"));
  TD_STYLE_TEXT_SELECTED->fg[0] = gtdk_color_parse (td_app_custom_value ("interface", "color", "selected value"));
  TD_STYLE_TEXT_URL->fg[0] = gtdk_color_parse (td_app_custom_value ("interface", "color", "url"));

  /*** Node cran - Node screen */
  TD_FACE_NODE_LINE_COLOR[TD_FACE_NORMAL] = gtdk_color_parse (td_app_custom_value ("face data", "node", "outline color normal"));
  TD_FACE_NODE_LINE_COLOR[TD_FACE_PRELIGHT] = gtdk_color_parse (td_app_custom_value ("face data", "node", "outline color prelight"));
  TD_FACE_NODE_LINE_COLOR[TD_FACE_SELECTED] = gtdk_color_parse (td_app_custom_value ("face data", "node", "outline color selected"));
  TD_FACE_NODE_LINE_COLOR[TD_FACE_PARENT] = gtdk_color_parse (td_app_custom_value ("face data", "node", "outline color parent"));
  TD_FACE_NODE_LINE_COLOR[TD_FACE_CHILD] = gtdk_color_parse (td_app_custom_value ("face data", "node", "outline color child"));

  TD_FACE_NODE_LINE_STYLE[TD_FACE_NORMAL] = gtdk_linestyle_parse (td_strsplit (td_app_custom_value ("face data", "node", "outline style normal"), NULL, 0));
  TD_FACE_NODE_LINE_STYLE[TD_FACE_PRELIGHT] = gtdk_linestyle_parse (td_strsplit (td_app_custom_value ("face data", "node", "outline style prelight"), NULL, 0));
  TD_FACE_NODE_LINE_STYLE[TD_FACE_SELECTED] = gtdk_linestyle_parse (td_strsplit (td_app_custom_value ("face data", "node", "outline style selected"), NULL, 0));
  TD_FACE_NODE_LINE_STYLE[TD_FACE_PARENT] = gtdk_linestyle_parse (td_strsplit (td_app_custom_value ("face data", "node", "outline style parent"), NULL, 0));
  TD_FACE_NODE_LINE_STYLE[TD_FACE_CHILD] = gtdk_linestyle_parse (td_strsplit (td_app_custom_value ("face data", "node", "outline style child"), NULL, 0));

  TD_FACE_NODE_LINE_WIDTH[TD_FACE_NORMAL] = (double) td_atoi (td_strsplit (td_app_custom_value ("face data", "node", "outline style normal"), NULL, 1));
  TD_FACE_NODE_LINE_WIDTH[TD_FACE_PRELIGHT] = (double) td_atoi (td_strsplit (td_app_custom_value ("face data", "node", "outline style prelight"), NULL, 1));
  TD_FACE_NODE_LINE_WIDTH[TD_FACE_SELECTED] = (double) td_atoi (td_strsplit (td_app_custom_value ("face data", "node", "outline style selected"), NULL, 1));
  TD_FACE_NODE_LINE_WIDTH[TD_FACE_PARENT] = (double) td_atoi (td_strsplit (td_app_custom_value ("face data", "node", "outline style parent"), NULL, 1));
  TD_FACE_NODE_LINE_WIDTH[TD_FACE_CHILD] = (double) td_atoi (td_strsplit (td_app_custom_value ("face data", "node", "outline style child"), NULL, 1));

  TD_FACE_NODE_FILL_COLOR[TD_FACE_NORMAL] = gtdk_color_parse (td_app_custom_value ("face data", "node", "fill color normal"));
  TD_FACE_NODE_FILL_COLOR[TD_FACE_PRELIGHT] = gtdk_color_parse (td_app_custom_value ("face data", "node", "fill color prelight"));
  TD_FACE_NODE_FILL_COLOR[TD_FACE_SELECTED] = gtdk_color_parse (td_app_custom_value ("face data", "node", "fill color selected"));
  TD_FACE_NODE_FILL_COLOR[TD_FACE_PARENT] = gtdk_color_parse (td_app_custom_value ("face data", "node", "fill color parent"));
  TD_FACE_NODE_FILL_COLOR[TD_FACE_CHILD] = gtdk_color_parse (td_app_custom_value ("face data", "node", "fill color child"));

  TD_FACE_NODE_TEXT_COLOR[TD_FACE_NORMAL] = gtdk_color_parse (td_app_custom_value ("face data", "node", "text color normal"));
  TD_FACE_NODE_TEXT_COLOR[TD_FACE_PRELIGHT] = gtdk_color_parse (td_app_custom_value ("face data", "node", "text color prelight"));
  TD_FACE_NODE_TEXT_COLOR[TD_FACE_SELECTED] = gtdk_color_parse (td_app_custom_value ("face data", "node", "text color selected"));
  TD_FACE_NODE_TEXT_COLOR[TD_FACE_PARENT] = gtdk_color_parse (td_app_custom_value ("face data", "node", "text color parent"));
  TD_FACE_NODE_TEXT_COLOR[TD_FACE_CHILD] = gtdk_color_parse (td_app_custom_value ("face data", "node", "text color child"));

  /*** Lien cran - Link screen */
  TD_FACE_LINK_LINE_COLOR[TD_FACE_NORMAL] = gtdk_color_parse (td_app_custom_value ("face data", "link", "color normal"));
  TD_FACE_LINK_LINE_COLOR[TD_FACE_PRELIGHT] = gtdk_color_parse (td_app_custom_value ("face data", "link", "color prelight"));
  TD_FACE_LINK_LINE_COLOR[TD_FACE_SELECTED] = gtdk_color_parse (td_app_custom_value ("face data", "link", "color selected"));
  TD_FACE_LINK_LINE_COLOR[TD_FACE_PARENT] = gtdk_color_parse (td_app_custom_value ("face data", "link", "color parent"));
  TD_FACE_LINK_LINE_COLOR[TD_FACE_CHILD] = gtdk_color_parse (td_app_custom_value ("face data", "link", "color child"));

  TD_FACE_LINK_LINE_STYLE[TD_FACE_NORMAL] = gtdk_linestyle_parse (td_strsplit (td_app_custom_value ("face data", "link", "style normal"), NULL, 0));
  TD_FACE_LINK_LINE_STYLE[TD_FACE_PRELIGHT] = gtdk_linestyle_parse (td_strsplit (td_app_custom_value ("face data", "link", "style prelight"), NULL, 0));
  TD_FACE_LINK_LINE_STYLE[TD_FACE_SELECTED] = gtdk_linestyle_parse (td_strsplit (td_app_custom_value ("face data", "link", "style selected"), NULL, 0));
  TD_FACE_LINK_LINE_STYLE[TD_FACE_PARENT] = gtdk_linestyle_parse (td_strsplit (td_app_custom_value ("face data", "link", "style parent"), NULL, 0));
  TD_FACE_LINK_LINE_STYLE[TD_FACE_CHILD] = gtdk_linestyle_parse (td_strsplit (td_app_custom_value ("face data", "link", "style child"), NULL, 0));

  TD_FACE_LINK_LINE_WIDTH[TD_FACE_NORMAL] = (double) td_atoi (td_strsplit (td_app_custom_value ("face data", "link", "style normal"), NULL, 1));
  TD_FACE_LINK_LINE_WIDTH[TD_FACE_PRELIGHT] = (double) td_atoi (td_strsplit (td_app_custom_value ("face data", "link", "style prelight"), NULL, 1));
  TD_FACE_LINK_LINE_WIDTH[TD_FACE_SELECTED] = (double) td_atoi (td_strsplit (td_app_custom_value ("face data", "link", "style selected"), NULL, 1));
  TD_FACE_LINK_LINE_WIDTH[TD_FACE_PARENT] = (double) td_atoi (td_strsplit (td_app_custom_value ("face data", "link", "style parent"), NULL, 1));
  TD_FACE_LINK_LINE_WIDTH[TD_FACE_CHILD] = (double) td_atoi (td_strsplit (td_app_custom_value ("face data", "link", "style child"), NULL, 1));

  TD_FACE_LINK_LINE_CAP = gtdk_cap_parse (td_app_custom_value ("face data", "link", "cap"));
  TD_FACE_LINK_LINE_JOIN = gtdk_join_parse (td_app_custom_value ("face data", "link", "join"));

  TD_FACE_LINK_ARROW[0] = (double) td_atoi (td_strsplit (td_app_custom_value ("face data", "link", "arrow"), NULL, 0));
  TD_FACE_LINK_ARROW[1] = (double) td_atoi (td_strsplit (td_app_custom_value ("face data", "link", "arrow"), NULL, 1));
  TD_FACE_LINK_ARROW[2] = (double) td_atoi (td_strsplit (td_app_custom_value ("face data", "link", "arrow"), NULL, 2));

  /*** Poigne - Handle */
  TD_FACE_HANDLE_LINE_COLOR = gtdk_color_parse (td_app_custom_value ("face core", "handle", "line color"));
  TD_FACE_HANDLE_LINE_STYLE = gtdk_linestyle_parse (td_strsplit (td_app_custom_value ("face core", "handle", "line style"), NULL, 0));
  TD_FACE_HANDLE_LINE_WIDTH = (double) td_atoi (td_strsplit (td_app_custom_value ("face core", "handle", "line style"), NULL, 1));
  TD_FACE_HANDLE_FILL_COLOR = gtdk_color_parse (td_app_custom_value ("face data", "node", "fill color normal"));

  /*** Rgle du temps - Timeruler */
  TD_FACE_TIMERULER_LINE_COLOR = gtdk_color_parse (td_app_custom_value ("face core", "timeruler", "line color"));
  TD_FACE_TIMERULER_LINE_STYLE = gtdk_linestyle_parse (td_strsplit (td_app_custom_value ("face core", "timeruler", "line style"), NULL, 0));
  TD_FACE_TIMERULER_LINE_WIDTH = (double) td_atoi (td_strsplit (td_app_custom_value ("face core", "timeruler", "line style"), NULL, 1));
  TD_FACE_TIMERULER_TEXT_COLOR = gtdk_color_parse (td_app_custom_value ("face core", "timeruler", "text color"));
}

/*****************************************************************************/
/*** Correction */
/* FIXME: dprci - deprecated : + tards */ 
/*****************************************************************************/
gboolean correction (void)
{
  int system_verif;
  gchar *txt_tmp;

  /* Correction bug du fichier XML des signets de la version 1.2.5 */
  txt_tmp = g_strdup_printf ("%s/.%s/bookmarks.xml", g_get_home_dir(), TD_PACKAGE_DIR);
  if (td_file_exist (txt_tmp))
    {
      txt_tmp = g_strdup_printf ("grep '<item field0=\"1\" field1=\"0\" field2=\"1\"/>' %s", txt_tmp);
      system_verif = system (txt_tmp);

      /* Appliquer le correctif */
      if (system_verif == 0)
	{
	  td_app_message (NULL, _("Correction"), TD_MSG_BEGIN);

	  /* Sauvegarde */
	  txt_tmp = g_strdup_printf ("mv %s/.%s/bookmarks.xml %s/.%s/bookmarks.xml.bak", g_get_home_dir(), TD_PACKAGE_DIR, g_get_home_dir(), TD_PACKAGE_DIR);
	  if (!td_system (txt_tmp))
	    {
	      td_app_message (_("Copying bookmarks"), NULL, TD_MSG_FAILED);
	      td_app_message (NULL, _("Correction"), TD_MSG_END);
	      return FALSE;
	    }

	  /* Go ! */
	  if (td_file_exist (g_strdup_printf ("%s/share/%s/help_bookmarks/%s/bookmarks.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, _("en"))))
	    txt_tmp = g_strdup_printf ("cp %s/share/%s/help_bookmarks/%s/bookmarks.xml %s/.%s/bookmarks.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, _("en"), g_get_home_dir(), TD_PACKAGE_DIR);
	  else
	    txt_tmp = g_strdup_printf ("cp %s/share/%s/help_bookmarks/%s/bookmarks.xml %s/.%s/bookmarks.xml", TD_PACKAGE_DATA_DIR, TD_PACKAGE_DIR, "en", g_get_home_dir(), TD_PACKAGE_DIR);
	  if (!td_system (txt_tmp))
	    {
	      td_app_message (_("Copying bookmarks"), NULL, TD_MSG_FAILED);
	      td_app_message (NULL, _("Correction"), TD_MSG_END);
	      return FALSE;
	    }
	  td_app_message (NULL, _("Correction"), TD_MSG_END);
	}
    }
  return TRUE;
}
