/* rygel-dtcp-cleartext-request.c generated by valac 0.30.0.3-b11d, the Vala compiler
 * generated from rygel-dtcp-cleartext-request.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include <rygel-core.h>
#include <gio/gio.h>


#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;
typedef struct _RygelHTTPSeekRequestPrivate RygelHTTPSeekRequestPrivate;

#define RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST (rygel_dtcp_cleartext_request_get_type ())
#define RYGEL_DTCP_CLEARTEXT_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequest))
#define RYGEL_DTCP_CLEARTEXT_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequestClass))
#define RYGEL_IS_DTCP_CLEARTEXT_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST))
#define RYGEL_IS_DTCP_CLEARTEXT_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST))
#define RYGEL_DTCP_CLEARTEXT_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequestClass))

typedef struct _RygelDTCPCleartextRequest RygelDTCPCleartextRequest;
typedef struct _RygelDTCPCleartextRequestClass RygelDTCPCleartextRequestClass;
typedef struct _RygelDTCPCleartextRequestPrivate RygelDTCPCleartextRequestPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;

#define RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER (rygel_http_media_resource_handler_get_type ())
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandler))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))

typedef struct _RygelHTTPMediaResourceHandler RygelHTTPMediaResourceHandler;
typedef struct _RygelHTTPMediaResourceHandlerClass RygelHTTPMediaResourceHandlerClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelHTTPMediaResourceHandlerPrivate RygelHTTPMediaResourceHandlerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelHTTPSeekRequest {
	GObject parent_instance;
	RygelHTTPSeekRequestPrivate * priv;
};

struct _RygelHTTPSeekRequestClass {
	GObjectClass parent_class;
};

struct _RygelDTCPCleartextRequest {
	RygelHTTPSeekRequest parent_instance;
	RygelDTCPCleartextRequestPrivate * priv;
};

struct _RygelDTCPCleartextRequestClass {
	RygelHTTPSeekRequestClass parent_class;
};

struct _RygelDTCPCleartextRequestPrivate {
	gint64 _start_byte;
	gint64 _end_byte;
	gint64 _range_length;
	gint64 _total_size;
};

typedef enum  {
	RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekRequestError;
#define RYGEL_HTTP_SEEK_REQUEST_ERROR rygel_http_seek_request_error_quark ()
typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelHTTPSeekRequest* seek;
	RygelPlaySpeedRequest* speed_request;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

struct _RygelHTTPGetHandler {
	GObject parent_instance;
	RygelHTTPGetHandlerPrivate * priv;
};

struct _RygelHTTPGetHandlerClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
	gchar* (*get_default_transfer_mode) (RygelHTTPGetHandler* self);
	gboolean (*supports_transfer_mode) (RygelHTTPGetHandler* self, const gchar* mode);
	gint64 (*get_resource_size) (RygelHTTPGetHandler* self);
	gint64 (*get_resource_duration) (RygelHTTPGetHandler* self);
	gboolean (*supports_byte_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_time_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_playspeed) (RygelHTTPGetHandler* self);
	RygelHTTPResponse* (*render_body) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
};

struct _RygelHTTPMediaResourceHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPMediaResourceHandlerPrivate * priv;
	RygelMediaResource* media_resource;
};

struct _RygelHTTPMediaResourceHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};


static gpointer rygel_dtcp_cleartext_request_parent_class = NULL;

GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_dtcp_cleartext_request_get_type (void) G_GNUC_CONST;
#define RYGEL_DTCP_CLEARTEXT_REQUEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequestPrivate))
enum  {
	RYGEL_DTCP_CLEARTEXT_REQUEST_DUMMY_PROPERTY,
	RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE,
	RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE,
	RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH,
	RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE
};
#define RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER "Range.dtcp.com"
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_request_error_quark (void);
GQuark rygel_http_request_error_quark (void);
RygelDTCPCleartextRequest* rygel_dtcp_cleartext_request_new (RygelHTTPGet* request, GError** error);
RygelDTCPCleartextRequest* rygel_dtcp_cleartext_request_construct (GType object_type, RygelHTTPGet* request, GError** error);
RygelHTTPSeekRequest* rygel_http_seek_request_construct (GType object_type);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
GType rygel_http_media_resource_handler_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GType rygel_http_response_get_type (void) G_GNUC_CONST;
gint64 rygel_media_resource_get_cleartext_size (RygelMediaResource* self);
#define RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED ((gint64) -1)
static void rygel_dtcp_cleartext_request_set_start_byte (RygelDTCPCleartextRequest* self, gint64 value);
static void rygel_dtcp_cleartext_request_set_end_byte (RygelDTCPCleartextRequest* self, gint64 value);
static void rygel_dtcp_cleartext_request_set_range_length (RygelDTCPCleartextRequest* self, gint64 value);
static void rygel_dtcp_cleartext_request_set_total_size (RygelDTCPCleartextRequest* self, gint64 value);
gboolean rygel_dtcp_cleartext_request_supported (RygelHTTPGet* request);
gboolean rygel_media_resource_is_cleartext_range_support_enabled (RygelMediaResource* self);
gboolean rygel_dtcp_cleartext_request_requested (RygelHTTPGet* request);
gint64 rygel_dtcp_cleartext_request_get_start_byte (RygelDTCPCleartextRequest* self);
gint64 rygel_dtcp_cleartext_request_get_end_byte (RygelDTCPCleartextRequest* self);
gint64 rygel_dtcp_cleartext_request_get_range_length (RygelDTCPCleartextRequest* self);
gint64 rygel_dtcp_cleartext_request_get_total_size (RygelDTCPCleartextRequest* self);
static void rygel_dtcp_cleartext_request_finalize (GObject* obj);
static void _vala_rygel_dtcp_cleartext_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_dtcp_cleartext_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gboolean int64_try_parse (const gchar* str, gint64* _result_) {
	gint64 _vala_result = 0LL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	_tmp2_ = g_ascii_strtoll (_tmp0_, &_tmp1_, (guint) 0);
	endptr = _tmp1_;
	_vala_result = _tmp2_;
	_tmp3_ = endptr;
	_tmp4_ = str;
	_tmp5_ = str;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


RygelDTCPCleartextRequest* rygel_dtcp_cleartext_request_construct (GType object_type, RygelHTTPGet* request, GError** error) {
	RygelDTCPCleartextRequest * self = NULL;
	gint64 start = 0LL;
	gint64 end = 0LL;
	gint64 total_size = 0LL;
	RygelHTTPGet* _tmp0_ = NULL;
	RygelHTTPGetHandler* _tmp1_ = NULL;
	const gchar* range = NULL;
	RygelHTTPGet* _tmp10_ = NULL;
	SoupMessage* _tmp11_ = NULL;
	SoupMessageHeaders* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gchar** range_tokens = NULL;
	const gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar** _tmp27_ = NULL;
	gchar** _tmp28_ = NULL;
	gchar** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	gint range_tokens_length1 = 0;
	gint _range_tokens_size_ = 0;
	const gchar* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gboolean _tmp37_ = FALSE;
	const gchar* _tmp38_ = NULL;
	gint64 _tmp39_ = 0LL;
	gboolean _tmp40_ = FALSE;
	const gchar* _tmp46_ = NULL;
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	gboolean _tmp58_ = FALSE;
	gint64 _tmp59_ = 0LL;
	gboolean _tmp66_ = FALSE;
	gint64 _tmp67_ = 0LL;
	gboolean _tmp74_ = FALSE;
	gint64 _tmp75_ = 0LL;
	gint64 _tmp79_ = 0LL;
	gint64 _tmp80_ = 0LL;
	gint64 _tmp81_ = 0LL;
	gint64 _tmp82_ = 0LL;
	gint64 _tmp85_ = 0LL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (request != NULL, NULL);
	self = (RygelDTCPCleartextRequest*) rygel_http_seek_request_construct (object_type);
	_tmp0_ = request;
	_tmp1_ = _tmp0_->handler;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER)) {
		RygelMediaResource* resource = NULL;
		RygelHTTPGet* _tmp2_ = NULL;
		RygelHTTPGetHandler* _tmp3_ = NULL;
		RygelMediaResource* _tmp4_ = NULL;
		RygelMediaResource* _tmp5_ = NULL;
		RygelMediaResource* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
		gint64 _tmp8_ = 0LL;
		gint64 _tmp9_ = 0LL;
		_tmp2_ = request;
		_tmp3_ = _tmp2_->handler;
		_tmp4_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER) ? ((RygelHTTPMediaResourceHandler*) _tmp3_) : NULL)->media_resource;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		resource = _tmp5_;
		_tmp6_ = resource;
		_tmp7_ = rygel_media_resource_get_cleartext_size (_tmp6_);
		_tmp8_ = _tmp7_;
		total_size = _tmp8_;
		_tmp9_ = total_size;
		if (_tmp9_ <= ((gint64) 0)) {
			total_size = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
		}
		_g_object_unref0 (resource);
	} else {
		total_size = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	}
	_tmp10_ = request;
	_tmp11_ = ((RygelHTTPRequest*) _tmp10_)->msg;
	_tmp12_ = _tmp11_->request_headers;
	_tmp13_ = soup_message_headers_get_one (_tmp12_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER);
	range = _tmp13_;
	_tmp14_ = range;
	if (_tmp14_ == NULL) {
		gchar* msg = NULL;
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
		_tmp15_ = g_strdup ("%s request header not present");
		msg = _tmp15_;
		_tmp16_ = msg;
		_tmp17_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp16_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER);
		_inner_error_ = _tmp17_;
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (msg);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp18_ = range;
	_tmp19_ = g_str_has_prefix (_tmp18_, "bytes");
	if (!_tmp19_) {
		gchar* msg = NULL;
		gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		GError* _tmp23_ = NULL;
		_tmp20_ = g_strdup ("Invalid %s value (missing bytes field): '%s'");
		msg = _tmp20_;
		_tmp21_ = msg;
		_tmp22_ = range;
		_tmp23_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp21_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp22_);
		_inner_error_ = _tmp23_;
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (msg);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp24_ = range;
	_tmp25_ = string_substring (_tmp24_, (glong) 6, (glong) -1);
	_tmp26_ = _tmp25_;
	_tmp28_ = _tmp27_ = g_strsplit (_tmp26_, "-", 2);
	_tmp29_ = _tmp28_;
	_tmp29__length1 = _vala_array_length (_tmp27_);
	_g_free0 (_tmp26_);
	range_tokens = _tmp29_;
	range_tokens_length1 = _tmp29__length1;
	_range_tokens_size_ = range_tokens_length1;
	_tmp30_ = range_tokens[0];
	_tmp31_ = strlen (_tmp30_);
	_tmp32_ = _tmp31_;
	if (_tmp32_ == 0) {
		gchar* msg = NULL;
		gchar* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		GError* _tmp36_ = NULL;
		_tmp33_ = g_strdup ("No range start specified: '%s'");
		msg = _tmp33_;
		_tmp34_ = msg;
		_tmp35_ = range;
		_tmp36_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp34_, _tmp35_);
		_inner_error_ = _tmp36_;
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp38_ = range_tokens[0];
	_tmp40_ = int64_try_parse (_tmp38_, &_tmp39_);
	start = _tmp39_;
	if (!_tmp40_) {
		_tmp37_ = TRUE;
	} else {
		gint64 _tmp41_ = 0LL;
		_tmp41_ = start;
		_tmp37_ = _tmp41_ < ((gint64) 0);
	}
	if (_tmp37_) {
		gchar* msg = NULL;
		gchar* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		GError* _tmp45_ = NULL;
		_tmp42_ = g_strdup ("Invalid %s range start: '%s'");
		msg = _tmp42_;
		_tmp43_ = msg;
		_tmp44_ = range;
		_tmp45_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp43_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp44_);
		_inner_error_ = _tmp45_;
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp46_ = range_tokens[1];
	_tmp47_ = strlen (_tmp46_);
	_tmp48_ = _tmp47_;
	if (_tmp48_ == 0) {
		end = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	} else {
		gboolean _tmp49_ = FALSE;
		const gchar* _tmp50_ = NULL;
		gint64 _tmp51_ = 0LL;
		gboolean _tmp52_ = FALSE;
		_tmp50_ = range_tokens[1];
		_tmp52_ = int64_try_parse (_tmp50_, &_tmp51_);
		end = _tmp51_;
		if (!_tmp52_) {
			_tmp49_ = TRUE;
		} else {
			gint64 _tmp53_ = 0LL;
			_tmp53_ = end;
			_tmp49_ = _tmp53_ <= ((gint64) 0);
		}
		if (_tmp49_) {
			gchar* msg = NULL;
			gchar* _tmp54_ = NULL;
			const gchar* _tmp55_ = NULL;
			const gchar* _tmp56_ = NULL;
			GError* _tmp57_ = NULL;
			_tmp54_ = g_strdup ("Invalid %s range end: '%s'");
			msg = _tmp54_;
			_tmp55_ = msg;
			_tmp56_ = range;
			_tmp57_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp55_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp56_);
			_inner_error_ = _tmp57_;
			if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (self);
				return NULL;
			} else {
				_g_free0 (msg);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_free0 (msg);
		}
	}
	_tmp59_ = end;
	if (_tmp59_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		gint64 _tmp60_ = 0LL;
		gint64 _tmp61_ = 0LL;
		_tmp60_ = start;
		_tmp61_ = end;
		_tmp58_ = _tmp60_ > _tmp61_;
	} else {
		_tmp58_ = FALSE;
	}
	if (_tmp58_) {
		gchar* msg = NULL;
		gchar* _tmp62_ = NULL;
		const gchar* _tmp63_ = NULL;
		const gchar* _tmp64_ = NULL;
		GError* _tmp65_ = NULL;
		_tmp62_ = g_strdup ("Invalid %s range - start > end: '%s'");
		msg = _tmp62_;
		_tmp63_ = msg;
		_tmp64_ = range;
		_tmp65_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp63_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp64_);
		_inner_error_ = _tmp65_;
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp67_ = total_size;
	if (_tmp67_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		gint64 _tmp68_ = 0LL;
		gint64 _tmp69_ = 0LL;
		_tmp68_ = start;
		_tmp69_ = total_size;
		_tmp66_ = _tmp68_ > (_tmp69_ - 1);
	} else {
		_tmp66_ = FALSE;
	}
	if (_tmp66_) {
		gchar* msg = NULL;
		gchar* _tmp70_ = NULL;
		const gchar* _tmp71_ = NULL;
		const gchar* _tmp72_ = NULL;
		GError* _tmp73_ = NULL;
		_tmp70_ = g_strdup ("Invalid %s range - start > length: '%s'");
		msg = _tmp70_;
		_tmp71_ = msg;
		_tmp72_ = range;
		_tmp73_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE, _tmp71_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp72_);
		_inner_error_ = _tmp73_;
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp75_ = total_size;
	if (_tmp75_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		gint64 _tmp76_ = 0LL;
		gint64 _tmp77_ = 0LL;
		_tmp76_ = end;
		_tmp77_ = total_size;
		_tmp74_ = _tmp76_ > (_tmp77_ - 1);
	} else {
		_tmp74_ = FALSE;
	}
	if (_tmp74_) {
		gint64 _tmp78_ = 0LL;
		_tmp78_ = total_size;
		end = _tmp78_ - 1;
	}
	_tmp79_ = start;
	rygel_dtcp_cleartext_request_set_start_byte (self, _tmp79_);
	_tmp80_ = end;
	rygel_dtcp_cleartext_request_set_end_byte (self, _tmp80_);
	_tmp82_ = end;
	if (_tmp82_ == RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		_tmp81_ = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	} else {
		gint64 _tmp83_ = 0LL;
		gint64 _tmp84_ = 0LL;
		_tmp83_ = end;
		_tmp84_ = start;
		_tmp81_ = (_tmp83_ - _tmp84_) + 1;
	}
	rygel_dtcp_cleartext_request_set_range_length (self, _tmp81_);
	_tmp85_ = total_size;
	rygel_dtcp_cleartext_request_set_total_size (self, _tmp85_);
	range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


RygelDTCPCleartextRequest* rygel_dtcp_cleartext_request_new (RygelHTTPGet* request, GError** error) {
	return rygel_dtcp_cleartext_request_construct (RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, request, error);
}


gboolean rygel_dtcp_cleartext_request_supported (RygelHTTPGet* request) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	RygelHTTPGet* _tmp1_ = NULL;
	RygelHTTPGetHandler* _tmp2_ = NULL;
	g_return_val_if_fail (request != NULL, FALSE);
	_tmp1_ = request;
	_tmp2_ = _tmp1_->handler;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER)) {
		RygelHTTPGet* _tmp3_ = NULL;
		RygelHTTPGetHandler* _tmp4_ = NULL;
		RygelMediaResource* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp3_ = request;
		_tmp4_ = _tmp3_->handler;
		_tmp5_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER) ? ((RygelHTTPMediaResourceHandler*) _tmp4_) : NULL)->media_resource;
		_tmp6_ = rygel_media_resource_is_cleartext_range_support_enabled (_tmp5_);
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean rygel_dtcp_cleartext_request_requested (RygelHTTPGet* request) {
	gboolean result = FALSE;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_val_if_fail (request != NULL, FALSE);
	_tmp0_ = request;
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
	_tmp2_ = _tmp1_->request_headers;
	_tmp3_ = soup_message_headers_get_one (_tmp2_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER);
	result = _tmp3_ != NULL;
	return result;
}


gint64 rygel_dtcp_cleartext_request_get_start_byte (RygelDTCPCleartextRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_start_byte;
	result = _tmp0_;
	return result;
}


static void rygel_dtcp_cleartext_request_set_start_byte (RygelDTCPCleartextRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_start_byte = _tmp0_;
	g_object_notify ((GObject *) self, "start-byte");
}


gint64 rygel_dtcp_cleartext_request_get_end_byte (RygelDTCPCleartextRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_end_byte;
	result = _tmp0_;
	return result;
}


static void rygel_dtcp_cleartext_request_set_end_byte (RygelDTCPCleartextRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_end_byte = _tmp0_;
	g_object_notify ((GObject *) self, "end-byte");
}


gint64 rygel_dtcp_cleartext_request_get_range_length (RygelDTCPCleartextRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_range_length;
	result = _tmp0_;
	return result;
}


static void rygel_dtcp_cleartext_request_set_range_length (RygelDTCPCleartextRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_range_length = _tmp0_;
	g_object_notify ((GObject *) self, "range-length");
}


gint64 rygel_dtcp_cleartext_request_get_total_size (RygelDTCPCleartextRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_total_size;
	result = _tmp0_;
	return result;
}


static void rygel_dtcp_cleartext_request_set_total_size (RygelDTCPCleartextRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_total_size = _tmp0_;
	g_object_notify ((GObject *) self, "total-size");
}


static void rygel_dtcp_cleartext_request_class_init (RygelDTCPCleartextRequestClass * klass) {
	rygel_dtcp_cleartext_request_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelDTCPCleartextRequestPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_dtcp_cleartext_request_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_dtcp_cleartext_request_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_dtcp_cleartext_request_finalize;
	/**
	     * The start of the cleartext range in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE, g_param_spec_int64 ("start-byte", "start-byte", "start-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The end of the cleartext range in bytes (inclusive). May be
	     * HTTPSeekRequest.UNSPECIFIED
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE, g_param_spec_int64 ("end-byte", "end-byte", "end-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The length of the cleartext range in bytes. May be
	     * HTTPSeekRequest.UNSPECIFIED
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH, g_param_spec_int64 ("range-length", "range-length", "range-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The length of the cleartext resource in bytes. May be
	     * HTTPSeekRequest.UNSPECIFIED
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE, g_param_spec_int64 ("total-size", "total-size", "total-size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_dtcp_cleartext_request_instance_init (RygelDTCPCleartextRequest * self) {
	self->priv = RYGEL_DTCP_CLEARTEXT_REQUEST_GET_PRIVATE (self);
}


static void rygel_dtcp_cleartext_request_finalize (GObject* obj) {
	RygelDTCPCleartextRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequest);
	G_OBJECT_CLASS (rygel_dtcp_cleartext_request_parent_class)->finalize (obj);
}


GType rygel_dtcp_cleartext_request_get_type (void) {
	static volatile gsize rygel_dtcp_cleartext_request_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_dtcp_cleartext_request_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDTCPCleartextRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_dtcp_cleartext_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDTCPCleartextRequest), 0, (GInstanceInitFunc) rygel_dtcp_cleartext_request_instance_init, NULL };
		GType rygel_dtcp_cleartext_request_type_id;
		rygel_dtcp_cleartext_request_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK_REQUEST, "RygelDTCPCleartextRequest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_dtcp_cleartext_request_type_id__volatile, rygel_dtcp_cleartext_request_type_id);
	}
	return rygel_dtcp_cleartext_request_type_id__volatile;
}


static void _vala_rygel_dtcp_cleartext_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelDTCPCleartextRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequest);
	switch (property_id) {
		case RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE:
		g_value_set_int64 (value, rygel_dtcp_cleartext_request_get_start_byte (self));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE:
		g_value_set_int64 (value, rygel_dtcp_cleartext_request_get_end_byte (self));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH:
		g_value_set_int64 (value, rygel_dtcp_cleartext_request_get_range_length (self));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE:
		g_value_set_int64 (value, rygel_dtcp_cleartext_request_get_total_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_dtcp_cleartext_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelDTCPCleartextRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequest);
	switch (property_id) {
		case RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE:
		rygel_dtcp_cleartext_request_set_start_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE:
		rygel_dtcp_cleartext_request_set_end_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH:
		rygel_dtcp_cleartext_request_set_range_length (self, g_value_get_int64 (value));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE:
		rygel_dtcp_cleartext_request_set_total_size (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



