/* rygel-media-export-metadata-extractor.c generated by valac 0.18.1, the Vala compiler
 * generated from rygel-media-export-metadata-extractor.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-dlna/gupnp-dlna-discoverer.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <rygel-core.h>
#include <gst/gst.h>
#include <libgupnp-dlna/gupnp-dlna-information.h>
#include <gst/pbutils/codec-utils.h>
#include <gst/pbutils/descriptions.h>
#include <gst/pbutils/encoding-profile.h>
#include <gst/pbutils/encoding-target.h>
#include <gst/pbutils/gstdiscoverer.h>
#include <gst/pbutils/gstpluginsbaseversion.h>
#include <gst/pbutils/install-plugins.h>
#include <gst/pbutils/missing-plugins.h>
#include <gst/pbutils/pbutils-enumtypes.h>
#include <gst/pbutils/pbutils.h>
#include <glib/gi18n-lib.h>


#define RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR (rygel_media_export_metadata_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))

typedef struct _RygelMediaExportMetadataExtractor RygelMediaExportMetadataExtractor;
typedef struct _RygelMediaExportMetadataExtractorClass RygelMediaExportMetadataExtractorClass;
typedef struct _RygelMediaExportMetadataExtractorPrivate RygelMediaExportMetadataExtractorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelMediaExportMetadataExtractor {
	GObject parent_instance;
	RygelMediaExportMetadataExtractorPrivate * priv;
};

struct _RygelMediaExportMetadataExtractorClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportMetadataExtractorPrivate {
	GUPnPDLNADiscoverer* discoverer;
	GeeHashMap* file_hash;
	guint64 timeout;
	gboolean extract_metadata;
};


static gpointer rygel_media_export_metadata_extractor_parent_class = NULL;

GType rygel_media_export_metadata_extractor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_DUMMY_PROPERTY
};
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_new (void);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_construct (GType object_type);
static void rygel_media_export_metadata_extractor_on_config_changed (RygelMediaExportMetadataExtractor* self, RygelConfiguration* config, const gchar* section, const gchar* key);
static void _rygel_media_export_metadata_extractor_on_config_changed_rygel_configuration_setting_changed (RygelConfiguration* _sender, const gchar* section, const gchar* key, gpointer self);
#define RYGEL_MEDIA_EXPORT_PLUGIN_NAME "MediaExport"
void rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self, GFile* file, const gchar* content_type);
static void rygel_media_export_metadata_extractor_on_done (RygelMediaExportMetadataExtractor* self, GUPnPDLNAInformation* dlna, GError* err);
static void _rygel_media_export_metadata_extractor_on_done_gupnp_dlna_discoverer_done (GUPnPDLNADiscoverer* _sender, GUPnPDLNAInformation* dlna, GError* err, gpointer self);
static void rygel_media_export_metadata_extractor_extract_basic_information (RygelMediaExportMetadataExtractor* self, GFile* file, GUPnPDLNAInformation* dlna);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void rygel_media_export_metadata_extractor_finalize (GObject* obj);


static void _rygel_media_export_metadata_extractor_on_config_changed_rygel_configuration_setting_changed (RygelConfiguration* _sender, const gchar* section, const gchar* key, gpointer self) {
	rygel_media_export_metadata_extractor_on_config_changed (self, _sender, section, key);
}


RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_construct (GType object_type) {
	RygelMediaExportMetadataExtractor * self = NULL;
	GeeHashMap* _tmp0_;
	RygelMetaConfig* _tmp1_ = NULL;
	RygelMetaConfig* config;
	self = (RygelMediaExportMetadataExtractor*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->file_hash);
	self->priv->file_hash = _tmp0_;
	_tmp1_ = rygel_meta_config_get_default ();
	config = _tmp1_;
	g_signal_connect_object ((RygelConfiguration*) config, "setting-changed", (GCallback) _rygel_media_export_metadata_extractor_on_config_changed_rygel_configuration_setting_changed, self, 0);
	rygel_media_export_metadata_extractor_on_config_changed (self, (RygelConfiguration*) config, RYGEL_MEDIA_EXPORT_PLUGIN_NAME, "extract-metadata");
	_g_object_unref0 (config);
	return self;
}


RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_new (void) {
	return rygel_media_export_metadata_extractor_construct (RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR);
}


static void _rygel_media_export_metadata_extractor_on_done_gupnp_dlna_discoverer_done (GUPnPDLNADiscoverer* _sender, GUPnPDLNAInformation* dlna, GError* err, gpointer self) {
	rygel_media_export_metadata_extractor_on_done (self, dlna, err);
}


void rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self, GFile* file, const gchar* content_type) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (content_type != NULL);
	_tmp1_ = self->priv->extract_metadata;
	if (_tmp1_) {
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = content_type;
		_tmp3_ = g_str_has_prefix (_tmp2_, "text/");
		_tmp0_ = !_tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		GFile* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* uri;
		GeeHashMap* _tmp7_;
		const gchar* _tmp8_;
		GFile* _tmp9_;
		guint64 _tmp10_;
		GstClockTime gst_timeout;
		GstClockTime _tmp11_;
		GUPnPDLNADiscoverer* _tmp12_;
		GUPnPDLNADiscoverer* _tmp13_;
		GUPnPDLNADiscoverer* _tmp14_;
		GUPnPDLNADiscoverer* _tmp15_;
		const gchar* _tmp16_;
		_tmp5_ = file;
		_tmp6_ = g_file_get_uri (_tmp5_);
		uri = _tmp6_;
		_tmp7_ = self->priv->file_hash;
		_tmp8_ = uri;
		_tmp9_ = file;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp7_, _tmp8_, _tmp9_);
		_tmp10_ = self->priv->timeout;
		gst_timeout = (GstClockTime) (_tmp10_ * GST_SECOND);
		_tmp11_ = gst_timeout;
		_tmp12_ = gupnp_dlna_discoverer_new (_tmp11_, TRUE, TRUE);
		_g_object_unref0 (self->priv->discoverer);
		self->priv->discoverer = _tmp12_;
		_tmp13_ = self->priv->discoverer;
		g_signal_connect_object (_tmp13_, "done", (GCallback) _rygel_media_export_metadata_extractor_on_done_gupnp_dlna_discoverer_done, self, 0);
		_tmp14_ = self->priv->discoverer;
		gst_discoverer_start ((GstDiscoverer*) _tmp14_);
		_tmp15_ = self->priv->discoverer;
		_tmp16_ = uri;
		gupnp_dlna_discoverer_discover_uri (_tmp15_, _tmp16_);
		_g_free0 (uri);
	} else {
		GFile* _tmp17_;
		_tmp17_ = file;
		rygel_media_export_metadata_extractor_extract_basic_information (self, _tmp17_, NULL);
	}
}


static void rygel_media_export_metadata_extractor_on_done (RygelMediaExportMetadataExtractor* self, GUPnPDLNAInformation* dlna, GError* err) {
	GeeHashMap* _tmp0_;
	GUPnPDLNAInformation* _tmp1_;
	GstDiscovererInfo* _tmp2_;
	GstDiscovererInfo* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	GFile* file;
	GFile* _tmp6_;
	GeeHashMap* _tmp11_;
	GUPnPDLNAInformation* _tmp12_;
	GstDiscovererInfo* _tmp13_;
	GstDiscovererInfo* _tmp14_;
	const gchar* _tmp15_ = NULL;
	GUPnPDLNAInformation* _tmp16_;
	GstDiscovererInfo* _tmp17_;
	GstDiscovererInfo* _tmp18_;
	GstDiscovererResult _tmp19_ = 0;
	GFile* _tmp29_;
	GUPnPDLNAInformation* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dlna != NULL);
	_g_object_unref0 (self->priv->discoverer);
	self->priv->discoverer = NULL;
	_tmp0_ = self->priv->file_hash;
	_tmp1_ = dlna;
	_tmp2_ = gupnp_dlna_information_get_info (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gst_discoverer_info_get_uri (_tmp3_);
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp4_);
	file = (GFile*) _tmp5_;
	_tmp6_ = file;
	if (_tmp6_ == NULL) {
		GUPnPDLNAInformation* _tmp7_;
		GstDiscovererInfo* _tmp8_;
		GstDiscovererInfo* _tmp9_;
		const gchar* _tmp10_ = NULL;
		_tmp7_ = dlna;
		_tmp8_ = gupnp_dlna_information_get_info (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = gst_discoverer_info_get_uri (_tmp9_);
		g_warning ("rygel-media-export-metadata-extractor.vala:87: File %s already handled" \
", ignoring event", _tmp10_);
		_g_object_unref0 (file);
		return;
	}
	_tmp11_ = self->priv->file_hash;
	_tmp12_ = dlna;
	_tmp13_ = gupnp_dlna_information_get_info (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = gst_discoverer_info_get_uri (_tmp14_);
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp11_, _tmp15_, NULL);
	_tmp16_ = dlna;
	_tmp17_ = gupnp_dlna_information_get_info (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = gst_discoverer_info_get_result (_tmp18_);
	if ((_tmp19_ & GST_DISCOVERER_TIMEOUT) != 0) {
		GFile* _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		_tmp20_ = file;
		_tmp21_ = g_file_get_uri (_tmp20_);
		_tmp22_ = _tmp21_;
		g_debug ("rygel-media-export-metadata-extractor.vala:96: Extraction timed out on" \
" %s", _tmp22_);
		_g_free0 (_tmp22_);
		dlna = NULL;
	} else {
		GUPnPDLNAInformation* _tmp23_;
		GstDiscovererInfo* _tmp24_;
		GstDiscovererInfo* _tmp25_;
		GstDiscovererResult _tmp26_ = 0;
		_tmp23_ = dlna;
		_tmp24_ = gupnp_dlna_information_get_info (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = gst_discoverer_info_get_result (_tmp25_);
		if ((_tmp26_ & GST_DISCOVERER_ERROR) != 0) {
			GFile* _tmp27_;
			GError* _tmp28_;
			_tmp27_ = file;
			_tmp28_ = err;
			g_signal_emit_by_name (self, "error", _tmp27_, _tmp28_);
			_g_object_unref0 (file);
			return;
		}
	}
	_tmp29_ = file;
	_tmp30_ = dlna;
	rygel_media_export_metadata_extractor_extract_basic_information (self, _tmp29_, _tmp30_);
	_g_object_unref0 (file);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void rygel_media_export_metadata_extractor_extract_basic_information (RygelMediaExportMetadataExtractor* self, GFile* file, GUPnPDLNAInformation* dlna) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	{
		GFileInfo* file_info = NULL;
		GFile* _tmp11_;
		GUPnPDLNAInformation* _tmp12_;
		{
			GFile* _tmp0_;
			GFileInfo* _tmp1_ = NULL;
			GFileInfo* _tmp2_;
			_tmp0_ = file;
			_tmp1_ = g_file_query_info (_tmp0_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_SIZE "," G_FILE_ATTRIBUTE_TIME_MODIFIED "," G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
			_tmp2_ = _tmp1_;
			if (_inner_error_ != NULL) {
				goto __catch28_g_error;
			}
			_g_object_unref0 (file_info);
			file_info = _tmp2_;
		}
		goto __finally28;
		__catch28_g_error:
		{
			GError* _error_ = NULL;
			const gchar* _tmp3_ = NULL;
			GFile* _tmp4_;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			GFile* _tmp7_;
			GError* _tmp8_;
			GError* _tmp9_;
			GError* _tmp10_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp3_ = _ ("Failed to query content type for '%s'");
			_tmp4_ = file;
			_tmp5_ = g_file_get_uri (_tmp4_);
			_tmp6_ = _tmp5_;
			g_warning (_tmp3_, _tmp6_);
			_g_free0 (_tmp6_);
			_tmp7_ = file;
			_tmp8_ = _error_;
			g_signal_emit_by_name (self, "error", _tmp7_, _tmp8_);
			_tmp9_ = _error_;
			_tmp10_ = _g_error_copy0 (_tmp9_);
			_inner_error_ = _tmp10_;
			_g_error_free0 (_error_);
			goto __finally28;
		}
		__finally28:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file_info);
			goto __catch27_g_error;
		}
		_tmp11_ = file;
		_tmp12_ = dlna;
		g_signal_emit_by_name (self, "extraction-done", _tmp11_, _tmp12_, file_info);
		_g_object_unref0 (file_info);
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* _error_ = NULL;
		GFile* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		GError* _tmp16_;
		const gchar* _tmp17_;
		GFile* _tmp18_;
		GError* _tmp19_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = file;
		_tmp14_ = g_file_get_uri (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _error_;
		_tmp17_ = _tmp16_->message;
		g_debug ("rygel-media-export-metadata-extractor.vala:139: Failed to extract basi" \
"c metadata from %s: %s", _tmp15_, _tmp17_);
		_g_free0 (_tmp15_);
		_tmp18_ = file;
		_tmp19_ = _error_;
		g_signal_emit_by_name (self, "error", _tmp18_, _tmp19_);
		_g_error_free0 (_error_);
	}
	__finally27:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_metadata_extractor_on_config_changed (RygelMediaExportMetadataExtractor* self, RygelConfiguration* config, const gchar* section, const gchar* key) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (config != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	_tmp1_ = section;
	if (g_strcmp0 (_tmp1_, RYGEL_MEDIA_EXPORT_PLUGIN_NAME) != 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = key;
		_tmp0_ = g_strcmp0 (_tmp2_, "extract-metadata") != 0;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		return;
	}
	{
		RygelConfiguration* _tmp4_;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		_tmp4_ = config;
		_tmp5_ = rygel_configuration_get_bool (_tmp4_, RYGEL_MEDIA_EXPORT_PLUGIN_NAME, "extract-metadata", &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			goto __catch29_g_error;
		}
		self->priv->extract_metadata = _tmp6_;
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		self->priv->extract_metadata = TRUE;
		_g_error_free0 (_error_);
	}
	__finally29:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_object (param_values + 3), data2);
}


static void g_cclosure_user_marshal_VOID__OBJECT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_pointer (param_values + 2), data2);
}


static void rygel_media_export_metadata_extractor_class_init (RygelMediaExportMetadataExtractorClass * klass) {
	rygel_media_export_metadata_extractor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportMetadataExtractorPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_metadata_extractor_finalize;
	g_signal_new ("extraction_done", RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT, G_TYPE_NONE, 3, G_TYPE_FILE, gupnp_dlna_information_get_type (), g_file_info_get_type ());
	/**
	     * Signalize that an error occured during metadata extraction
	     */
	g_signal_new ("error", RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_POINTER, G_TYPE_NONE, 2, G_TYPE_FILE, G_TYPE_POINTER);
}


static void rygel_media_export_metadata_extractor_instance_init (RygelMediaExportMetadataExtractor * self) {
	self->priv = RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_PRIVATE (self);
	self->priv->timeout = (guint64) 10;
}


static void rygel_media_export_metadata_extractor_finalize (GObject* obj) {
	RygelMediaExportMetadataExtractor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor);
	_g_object_unref0 (self->priv->discoverer);
	_g_object_unref0 (self->priv->file_hash);
	G_OBJECT_CLASS (rygel_media_export_metadata_extractor_parent_class)->finalize (obj);
}


/**
 * Metadata extractor based on Gstreamer. Just set the URI of the media on the
 * uri property, it will extact the metadata for you and emit signal
 * metadata_available for each key/value pair extracted.
 */
GType rygel_media_export_metadata_extractor_get_type (void) {
	static volatile gsize rygel_media_export_metadata_extractor_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_metadata_extractor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMetadataExtractorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_metadata_extractor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMetadataExtractor), 0, (GInstanceInitFunc) rygel_media_export_metadata_extractor_instance_init, NULL };
		GType rygel_media_export_metadata_extractor_type_id;
		rygel_media_export_metadata_extractor_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportMetadataExtractor", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_metadata_extractor_type_id__volatile, rygel_media_export_metadata_extractor_type_id);
	}
	return rygel_media_export_metadata_extractor_type_id__volatile;
}



