/* rygel-http-item-uri_http-get.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-http-item-uri_http-get.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Authors: Jens Georg <mail@jensge.org>
 *          Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                                <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libsoup/soup.h>
#include <glib/gi18n-lib.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>


#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;
typedef struct _RygelHTTPItemURIPrivate RygelHTTPItemURIPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;
#define _rygel_thumbnail_unref0(var) ((var == NULL) ? NULL : (var = (rygel_thumbnail_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

struct _RygelHTTPItemURI {
	GObject parent_instance;
	RygelHTTPItemURIPrivate * priv;
	gchar* item_id;
	gint thumbnail_index;
	gint subtitle_index;
	gchar* transcode_target;
	RygelHTTPServer* http_server;
};

struct _RygelHTTPItemURIClass {
	GObjectClass parent_class;
};

struct _RygelHTTPItemURIPrivate {
	gchar* real_extension;
};

struct _RygelMediaObject {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* mime_type;
};

struct _RygelMediaObjectClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaObject *self);
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_pixel_width) (RygelVisualItem* self);
	void (*set_pixel_width) (RygelVisualItem* self, gint value);
	gint (*get_pixel_height) (RygelVisualItem* self);
	void (*set_pixel_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelThumbnail {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelThumbnailPrivate * priv;
	glong size;
	gchar* file_extension;
};

struct _RygelThumbnailClass {
	GTypeClass parent_class;
	void (*finalize) (RygelThumbnail *self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	glong size;
	GeeArrayList* subtitles;
	GeeArrayList* thumbnails;
	GeeArrayList* uris;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	gint64 duration;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelMusicItem {
	RygelAudioItem parent_instance;
	RygelMusicItemPrivate * priv;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelVideoItem {
	RygelAudioItem parent_instance;
	RygelVideoItemPrivate * priv;
	GeeArrayList* subtitles;
};

struct _RygelVideoItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	glong size;
	gchar* caption_type;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};


static gpointer rygel_http_item_uri_parent_class = NULL;
extern GeeHashMap* rygel_http_item_uri_mime_to_ext;
GeeHashMap* rygel_http_item_uri_mime_to_ext = NULL;

GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_ITEM_URI_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIPrivate))
enum  {
	RYGEL_HTTP_ITEM_URI_DUMMY_PROPERTY,
	RYGEL_HTTP_ITEM_URI_EXTENSION
};
gpointer rygel_media_object_ref (gpointer instance);
void rygel_media_object_unref (gpointer instance);
GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_media_object (GValue* value, gpointer v_object);
void rygel_value_take_media_object (GValue* value, gpointer v_object);
gpointer rygel_value_get_media_object (const GValue* value);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
RygelHTTPItemURI* rygel_http_item_uri_new (RygelMediaItem* item, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, RygelMediaItem* item, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
void rygel_http_item_uri_set_extension (RygelHTTPItemURI* self, const gchar* value);
gpointer rygel_thumbnail_ref (gpointer instance);
void rygel_thumbnail_unref (gpointer instance);
GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_thumbnail (GValue* value, gpointer v_object);
void rygel_value_take_thumbnail (GValue* value, gpointer v_object);
gpointer rygel_value_get_thumbnail (const GValue* value);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error);
const gchar* rygel_transcoder_get_extension (RygelTranscoder* self);
gchar* rygel_http_item_uri_get_extension (RygelHTTPItemURI* self);
static gchar* rygel_http_item_uri_ext_from_mime_type (RygelHTTPItemURI* self, const gchar* mime_type);
GQuark rygel_http_request_error_quark (void);
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static gchar* rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self, const gchar* path);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
static void rygel_http_item_uri_finalize (GObject* obj);
static void _vala_rygel_http_item_uri_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_item_uri_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	return self ? g_object_ref (self) : NULL;
#line 375 "rygel-http-item-uri_http-get.c"
}


static gpointer _rygel_thumbnail_ref0 (gpointer self) {
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	return self ? rygel_thumbnail_ref (self) : NULL;
#line 382 "rygel-http-item-uri_http-get.c"
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
#line 894 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 894 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 895 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 895 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 895 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 895 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 897 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 897 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 409 "rygel-http-item-uri_http-get.c"
		gchar* _tmp4_;
#line 898 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 898 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 898 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 417 "rygel-http-item-uri_http-get.c"
	} else {
#line 900 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = -1;
#line 900 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 423 "rygel-http-item-uri_http-get.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
#line 1143 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1143 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1143 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1143 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1144 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1144 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 447 "rygel-http-item-uri_http-get.c"
		glong _tmp4_;
#line 1145 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1145 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1145 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 455 "rygel-http-item-uri_http-get.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1147 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1147 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1147 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1147 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 467 "rygel-http-item-uri_http-get.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1154 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 492 "rygel-http-item-uri_http-get.c"
		glong _tmp2_;
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 498 "rygel-http-item-uri_http-get.c"
	} else {
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 502 "rygel-http-item-uri_http-get.c"
	}
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 508 "rygel-http-item-uri_http-get.c"
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
#line 1158 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1158 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1158 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1158 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 520 "rygel-http-item-uri_http-get.c"
	} else {
		gint _tmp7_;
		gint _tmp8_;
#line 1160 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1160 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1160 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 530 "rygel-http-item-uri_http-get.c"
	}
#line 1163 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1163 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 536 "rygel-http-item-uri_http-get.c"
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
#line 1164 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1164 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1164 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1165 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1165 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 550 "rygel-http-item-uri_http-get.c"
	} else {
		glong _tmp13_;
		glong _tmp14_;
#line 1167 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1167 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1167 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 560 "rygel-http-item-uri_http-get.c"
	}
#line 1169 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1169 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 566 "rygel-http-item-uri_http-get.c"
		glong _tmp16_;
		glong _tmp17_;
#line 1170 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1170 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1170 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 575 "rygel-http-item-uri_http-get.c"
	}
#line 1172 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1172 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1172 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1172 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1173 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1173 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1173 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1173 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1173 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	return result;
#line 595 "rygel-http-item-uri_http-get.c"
}


RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, RygelMediaItem* item, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
	RygelHTTPItemURI * self = NULL;
	RygelMediaItem* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	RygelHTTPServer* _tmp7_;
	gint _tmp8_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gboolean _tmp54_;
	GError * _inner_error_ = NULL;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp0_ = item;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp1_ = ((RygelMediaObject*) _tmp0_)->id;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_g_free0 (self->item_id);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	self->item_id = _tmp2_;
#line 55 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp3_ = thumbnail_index;
#line 55 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	self->thumbnail_index = _tmp3_;
#line 56 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp4_ = subtitle_index;
#line 56 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	self->subtitle_index = _tmp4_;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp5_ = transcode_target;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_g_free0 (self->transcode_target);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	self->transcode_target = _tmp6_;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp7_ = http_server;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	self->http_server = _tmp7_;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	rygel_http_item_uri_set_extension (self, "");
#line 61 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp8_ = thumbnail_index;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	if (_tmp8_ > (-1)) {
#line 657 "rygel-http-item-uri_http-get.c"
		RygelMediaItem* _tmp9_;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp9_ = item;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, RYGEL_TYPE_VISUAL_ITEM)) {
#line 663 "rygel-http-item-uri_http-get.c"
			RygelMediaItem* _tmp10_;
			GeeArrayList* _tmp11_;
			GeeArrayList* _tmp12_;
			GeeArrayList* _tmp13_;
			GeeArrayList* thumbnails;
			GeeArrayList* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp10_ = item;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp11_ = rygel_visual_item_get_thumbnails (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _tmp10_) : NULL);
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp12_ = _tmp11_;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp13_ = _g_object_ref0 (_tmp12_);
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			thumbnails = _tmp13_;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp14_ = thumbnails;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp15_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp14_);
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp16_ = _tmp15_;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp17_ = thumbnail_index;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			if (_tmp16_ > _tmp17_) {
#line 693 "rygel-http-item-uri_http-get.c"
				GeeArrayList* _tmp18_;
				gint _tmp19_;
				gpointer _tmp20_ = NULL;
				RygelThumbnail* _tmp21_;
				const gchar* _tmp22_;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp18_ = thumbnails;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp19_ = thumbnail_index;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _tmp19_);
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp21_ = (RygelThumbnail*) _tmp20_;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp22_ = _tmp21_->file_extension;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				rygel_http_item_uri_set_extension (self, _tmp22_);
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_rygel_thumbnail_unref0 (_tmp21_);
#line 713 "rygel-http-item-uri_http-get.c"
			}
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_g_object_unref0 (thumbnails);
#line 717 "rygel-http-item-uri_http-get.c"
		} else {
			RygelMediaItem* _tmp23_;
#line 68 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp23_ = item;
#line 68 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, RYGEL_TYPE_MUSIC_ITEM)) {
#line 724 "rygel-http-item-uri_http-get.c"
				RygelMediaItem* _tmp24_;
				RygelThumbnail* _tmp25_;
				RygelThumbnail* _tmp26_;
				RygelThumbnail* album_art;
				RygelThumbnail* _tmp27_;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp24_ = item;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp25_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) _tmp24_) : NULL)->album_art;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp26_ = _rygel_thumbnail_ref0 (_tmp25_);
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				album_art = _tmp26_;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp27_ = album_art;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				if (_tmp27_ != NULL) {
#line 742 "rygel-http-item-uri_http-get.c"
					RygelThumbnail* _tmp28_;
					const gchar* _tmp29_;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp28_ = album_art;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp29_ = _tmp28_->file_extension;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					rygel_http_item_uri_set_extension (self, _tmp29_);
#line 751 "rygel-http-item-uri_http-get.c"
				}
#line 68 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_rygel_thumbnail_unref0 (album_art);
#line 755 "rygel-http-item-uri_http-get.c"
			}
		}
	} else {
		gint _tmp30_;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp30_ = subtitle_index;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		if (_tmp30_ > (-1)) {
#line 764 "rygel-http-item-uri_http-get.c"
			RygelMediaItem* _tmp31_;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp31_ = item;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, RYGEL_TYPE_VIDEO_ITEM)) {
#line 770 "rygel-http-item-uri_http-get.c"
				RygelMediaItem* _tmp32_;
				GeeArrayList* _tmp33_;
				GeeArrayList* _tmp34_;
				GeeArrayList* subtitles;
				GeeArrayList* _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp32_ = item;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp33_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, RYGEL_TYPE_VIDEO_ITEM) ? ((RygelVideoItem*) _tmp32_) : NULL)->subtitles;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp34_ = _g_object_ref0 (_tmp33_);
#line 77 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				subtitles = _tmp34_;
#line 79 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp35_ = subtitles;
#line 79 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp36_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp35_);
#line 79 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp37_ = _tmp36_;
#line 79 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp38_ = subtitle_index;
#line 79 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				if (_tmp37_ > _tmp38_) {
#line 797 "rygel-http-item-uri_http-get.c"
					GeeArrayList* _tmp39_;
					gint _tmp40_;
					gpointer _tmp41_ = NULL;
					RygelSubtitle* _tmp42_;
					const gchar* _tmp43_;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp39_ = subtitles;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp40_ = subtitle_index;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, _tmp40_);
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp42_ = (RygelSubtitle*) _tmp41_;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp43_ = _tmp42_->caption_type;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					rygel_http_item_uri_set_extension (self, _tmp43_);
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_rygel_subtitle_unref0 (_tmp42_);
#line 817 "rygel-http-item-uri_http-get.c"
				}
#line 76 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_g_object_unref0 (subtitles);
#line 821 "rygel-http-item-uri_http-get.c"
			}
		} else {
			const gchar* _tmp44_;
#line 83 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp44_ = transcode_target;
#line 83 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			if (_tmp44_ != NULL) {
#line 829 "rygel-http-item-uri_http-get.c"
				{
					RygelHTTPServer* _tmp45_;
					const gchar* _tmp46_;
					RygelTranscoder* _tmp47_ = NULL;
					RygelTranscoder* tc;
					RygelTranscoder* _tmp48_;
					const gchar* _tmp49_;
					const gchar* _tmp50_;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp45_ = self->http_server;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp46_ = transcode_target;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp47_ = rygel_http_server_get_transcoder (_tmp45_, _tmp46_, &_inner_error_);
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					tc = _tmp47_;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					if (_inner_error_ != NULL) {
#line 848 "rygel-http-item-uri_http-get.c"
						goto __catch6_g_error;
					}
#line 87 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp48_ = tc;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp49_ = rygel_transcoder_get_extension (_tmp48_);
#line 87 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp50_ = _tmp49_;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					rygel_http_item_uri_set_extension (self, _tmp50_);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_g_object_unref0 (tc);
#line 861 "rygel-http-item-uri_http-get.c"
				}
				goto __finally6;
				__catch6_g_error:
				{
					GError* _error_ = NULL;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_error_ = _inner_error_;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_inner_error_ = NULL;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_g_error_free0 (_error_);
#line 873 "rygel-http-item-uri_http-get.c"
				}
				__finally6:
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				if (_inner_error_ != NULL) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					g_clear_error (&_inner_error_);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					return NULL;
#line 884 "rygel-http-item-uri_http-get.c"
				}
			}
		}
	}
#line 91 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp51_ = rygel_http_item_uri_get_extension (self);
#line 91 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp52_ = _tmp51_;
#line 91 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp53_ = _tmp52_;
#line 91 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp54_ = g_strcmp0 (_tmp53_, "") == 0;
#line 91 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_g_free0 (_tmp53_);
#line 91 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	if (_tmp54_) {
#line 901 "rygel-http-item-uri_http-get.c"
		gchar* _tmp55_;
		gchar* uri_extension;
		const gchar* _tmp76_;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp55_ = g_strdup ("");
#line 92 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		uri_extension = _tmp55_;
#line 909 "rygel-http-item-uri_http-get.c"
		{
			RygelMediaItem* _tmp56_;
			GeeArrayList* _tmp57_;
			GeeArrayList* _tmp58_;
			GeeArrayList* _uri_string_list;
			GeeArrayList* _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			gint _uri_string_size;
			gint _uri_string_index;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp56_ = item;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp57_ = _tmp56_->uris;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp58_ = _g_object_ref0 (_tmp57_);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_uri_string_list = _tmp58_;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp59_ = _uri_string_list;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp60_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp59_);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp61_ = _tmp60_;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_uri_string_size = _tmp61_;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_uri_string_index = -1;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			while (TRUE) {
#line 940 "rygel-http-item-uri_http-get.c"
				gint _tmp62_;
				gint _tmp63_;
				gint _tmp64_;
				GeeArrayList* _tmp65_;
				gint _tmp66_;
				gpointer _tmp67_ = NULL;
				gchar* uri_string;
				const gchar* _tmp68_;
				gchar* _tmp69_ = NULL;
				gchar* basename;
				const gchar* _tmp70_;
				gint _tmp71_ = 0;
				gint dot_index;
				gint _tmp72_;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp62_ = _uri_string_index;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_uri_string_index = _tmp62_ + 1;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp63_ = _uri_string_index;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp64_ = _uri_string_size;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				if (!(_tmp63_ < _tmp64_)) {
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					break;
#line 967 "rygel-http-item-uri_http-get.c"
				}
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp65_ = _uri_string_list;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp66_ = _uri_string_index;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp67_ = gee_abstract_list_get ((GeeAbstractList*) _tmp65_, _tmp66_);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				uri_string = (gchar*) _tmp67_;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp68_ = uri_string;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp69_ = g_path_get_basename (_tmp68_);
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				basename = _tmp69_;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp70_ = basename;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp71_ = string_last_index_of (_tmp70_, ".", 0);
#line 96 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				dot_index = _tmp71_;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp72_ = dot_index;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				if (_tmp72_ > (-1)) {
#line 993 "rygel-http-item-uri_http-get.c"
					const gchar* _tmp73_;
					gint _tmp74_;
					gchar* _tmp75_ = NULL;
#line 99 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp73_ = basename;
#line 99 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp74_ = dot_index;
#line 99 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp75_ = string_substring (_tmp73_, (glong) (_tmp74_ + 1), (glong) (-1));
#line 99 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_g_free0 (uri_extension);
#line 99 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					uri_extension = _tmp75_;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_g_free0 (basename);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_g_free0 (uri_string);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					break;
#line 1013 "rygel-http-item-uri_http-get.c"
				}
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_g_free0 (basename);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_g_free0 (uri_string);
#line 1019 "rygel-http-item-uri_http-get.c"
			}
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_g_object_unref0 (_uri_string_list);
#line 1023 "rygel-http-item-uri_http-get.c"
		}
#line 105 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp76_ = uri_extension;
#line 105 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		if (g_strcmp0 (_tmp76_, "") == 0) {
#line 1029 "rygel-http-item-uri_http-get.c"
			RygelMediaItem* _tmp77_;
			const gchar* _tmp78_;
			gchar* _tmp79_ = NULL;
			gchar* _tmp80_;
#line 106 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp77_ = item;
#line 106 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp78_ = ((RygelMediaObject*) _tmp77_)->mime_type;
#line 106 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp79_ = rygel_http_item_uri_ext_from_mime_type (self, _tmp78_);
#line 106 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp80_ = _tmp79_;
#line 106 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			rygel_http_item_uri_set_extension (self, _tmp80_);
#line 106 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_g_free0 (_tmp80_);
#line 1046 "rygel-http-item-uri_http-get.c"
		} else {
			const gchar* _tmp81_;
#line 108 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp81_ = uri_extension;
#line 108 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			rygel_http_item_uri_set_extension (self, _tmp81_);
#line 1053 "rygel-http-item-uri_http-get.c"
		}
#line 91 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_g_free0 (uri_extension);
#line 1057 "rygel-http-item-uri_http-get.c"
	}
#line 49 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	return self;
#line 1061 "rygel-http-item-uri_http-get.c"
}


RygelHTTPItemURI* rygel_http_item_uri_new (RygelMediaItem* item, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
#line 49 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	return rygel_http_item_uri_construct (RYGEL_TYPE_HTTP_ITEM_URI, item, http_server, thumbnail_index, subtitle_index, transcode_target);
#line 1068 "rygel-http-item-uri_http-get.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1228 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1228 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1228 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1081 "rygel-http-item-uri_http-get.c"
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1111 "rygel-http-item-uri_http-get.c"
				goto __catch7_g_regex_error;
			}
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			return NULL;
#line 1120 "rygel-http-item-uri_http-get.c"
		}
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp5_ = regex;
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp6_ = replacement;
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1136 "rygel-http-item-uri_http-get.c"
				goto __catch7_g_regex_error;
			}
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			return NULL;
#line 1147 "rygel-http-item-uri_http-get.c"
		}
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = _tmp8_;
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 1155 "rygel-http-item-uri_http-get.c"
	}
	goto __finally7;
	__catch7_g_regex_error:
	{
		GError* e = NULL;
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1233 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 1169 "rygel-http-item-uri_http-get.c"
	}
	__finally7:
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return NULL;
#line 1180 "rygel-http-item-uri_http-get.c"
	}
}


RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error) {
	RygelHTTPItemURI * self = NULL;
	RygelHTTPServer* _tmp0_;
	const gchar* _tmp1_;
	RygelHTTPServer* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* request_uri;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_ = NULL;
	gchar** parts;
	gint parts_length1;
	gint _parts_size_;
	gboolean _tmp9_ = FALSE;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gboolean _tmp12_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar** _tmp17_;
	gint _tmp17__length1;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* last_part;
	const gchar* _tmp20_;
	gint _tmp21_ = 0;
	gint dot_index;
	gint _tmp22_;
	const gchar* _tmp70_;
	GError * _inner_error_ = NULL;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	self->thumbnail_index = -1;
#line 118 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	self->subtitle_index = -1;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_g_free0 (self->transcode_target);
#line 119 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	self->transcode_target = NULL;
#line 120 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp0_ = http_server;
#line 120 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	self->http_server = _tmp0_;
#line 121 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	rygel_http_item_uri_set_extension (self, "");
#line 123 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp1_ = uri;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp2_ = http_server;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp3_ = rygel_http_server_get_path_root (_tmp2_);
#line 123 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp4_ = _tmp3_;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp5_ = string_replace (_tmp1_, _tmp4_, "");
#line 123 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	request_uri = _tmp5_;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp6_ = request_uri;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "/", 0);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	parts = _tmp8_;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	parts_length1 = _vala_array_length (_tmp7_);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_parts_size_ = parts_length1;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp10_ = parts;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp10__length1 = parts_length1;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	if (_tmp10__length1 < 2) {
#line 126 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp9_ = TRUE;
#line 1267 "rygel-http-item-uri_http-get.c"
	} else {
		gchar** _tmp11_;
		gint _tmp11__length1;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp11_ = parts;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp11__length1 = parts_length1;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp9_ = (_tmp11__length1 % 2) == 0;
#line 1277 "rygel-http-item-uri_http-get.c"
	}
#line 126 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp12_ = _tmp9_;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	if (_tmp12_) {
#line 1283 "rygel-http-item-uri_http-get.c"
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_;
		GError* _tmp15_;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp13_ = _ ("Invalid URI '%s'");
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp14_ = request_uri;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp15_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _tmp13_, _tmp14_);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_inner_error_ = _tmp15_;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			g_propagate_error (error, _inner_error_);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_g_free0 (request_uri);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_g_object_unref0 (self);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			return NULL;
#line 1307 "rygel-http-item-uri_http-get.c"
		} else {
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_g_free0 (request_uri);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			g_clear_error (&_inner_error_);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			return NULL;
#line 1319 "rygel-http-item-uri_http-get.c"
		}
	}
#line 131 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp16_ = parts;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp16__length1 = parts_length1;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp17_ = parts;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp17__length1 = parts_length1;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp18_ = _tmp16_[_tmp17__length1 - 1];
#line 131 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp19_ = g_strdup (_tmp18_);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	last_part = _tmp19_;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp20_ = last_part;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp21_ = string_last_index_of (_tmp20_, ".", 0);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	dot_index = _tmp21_;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp22_ = dot_index;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	if (_tmp22_ > (-1)) {
#line 1346 "rygel-http-item-uri_http-get.c"
		const gchar* _tmp23_;
		gint _tmp24_;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		gchar** _tmp27_;
		gint _tmp27__length1;
		gchar** _tmp28_;
		gint _tmp28__length1;
		const gchar* _tmp29_;
		gint _tmp30_;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp23_ = last_part;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp24_ = dot_index;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp25_ = string_substring (_tmp23_, (glong) (_tmp24_ + 1), (glong) (-1));
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp26_ = _tmp25_;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		rygel_http_item_uri_set_extension (self, _tmp26_);
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_g_free0 (_tmp26_);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp27_ = parts;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp27__length1 = parts_length1;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp28_ = parts;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp28__length1 = parts_length1;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp29_ = last_part;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp30_ = dot_index;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp31_ = string_substring (_tmp29_, (glong) 0, (glong) _tmp30_);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_g_free0 (_tmp27_[_tmp28__length1 - 1]);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp27_[_tmp28__length1 - 1] = _tmp31_;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp32_ = _tmp27_[_tmp28__length1 - 1];
#line 1391 "rygel-http-item-uri_http-get.c"
	}
	{
		gint i;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		i = 1;
#line 1397 "rygel-http-item-uri_http-get.c"
		{
			gboolean _tmp33_;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp33_ = TRUE;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			while (TRUE) {
#line 1404 "rygel-http-item-uri_http-get.c"
				gboolean _tmp34_;
				gint _tmp36_;
				gchar** _tmp37_;
				gint _tmp37__length1;
				gchar** _tmp38_;
				gint _tmp38__length1;
				gint _tmp39_;
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				GQuark _tmp43_ = 0U;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				static GQuark _tmp42_label0 = 0;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				static GQuark _tmp42_label1 = 0;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				static GQuark _tmp42_label2 = 0;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				static GQuark _tmp42_label3 = 0;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp34_ = _tmp33_;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				if (!_tmp34_) {
#line 1427 "rygel-http-item-uri_http-get.c"
					gint _tmp35_;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp35_ = i;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					i = _tmp35_ + 2;
#line 1433 "rygel-http-item-uri_http-get.c"
				}
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp33_ = FALSE;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp36_ = i;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp37_ = parts;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp37__length1 = parts_length1;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				if (!(_tmp36_ < (_tmp37__length1 - 1))) {
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					break;
#line 1447 "rygel-http-item-uri_http-get.c"
				}
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp38_ = parts;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp38__length1 = parts_length1;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp39_ = i;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp40_ = _tmp38_[_tmp39_];
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp41_ = _tmp40_;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp43_ = (NULL == _tmp41_) ? 0 : g_quark_from_string (_tmp41_);
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				if (_tmp43_ == ((0 != _tmp42_label0) ? _tmp42_label0 : (_tmp42_label0 = g_quark_from_static_string ("i")))) {
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					switch (0) {
#line 1465 "rygel-http-item-uri_http-get.c"
						default:
						{
							gchar** _tmp44_;
							gint _tmp44__length1;
							gint _tmp45_;
							const gchar* _tmp46_;
							gchar* _tmp47_ = NULL;
							gchar* _tmp48_;
							size_t _tmp49_;
							guchar* _tmp50_ = NULL;
							guchar* _tmp51_;
							gint _tmp51__length1;
							guchar* data;
							gint data_length1;
							gint _data_size_;
							GString* _tmp52_;
							GString* builder;
							GString* _tmp53_;
							guchar* _tmp54_;
							gint _tmp54__length1;
							GString* _tmp55_;
							const gchar* _tmp56_;
							gchar* _tmp57_;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp44_ = parts;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp44__length1 = parts_length1;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp45_ = i;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp46_ = _tmp44_[_tmp45_ + 1];
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp47_ = soup_uri_decode (_tmp46_);
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp48_ = _tmp47_;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp50_ = g_base64_decode (_tmp48_, &_tmp49_);
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp51_ = _tmp50_;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp51__length1 = _tmp49_;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_g_free0 (_tmp48_);
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							data = _tmp51_;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							data_length1 = _tmp51__length1;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_data_size_ = data_length1;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp52_ = g_string_new ("");
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							builder = _tmp52_;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp53_ = builder;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp54_ = data;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp54__length1 = data_length1;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							g_string_append (_tmp53_, (const gchar*) _tmp54_);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp55_ = builder;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp56_ = _tmp55_->str;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp57_ = g_strdup (_tmp56_);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_g_free0 (self->item_id);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							self->item_id = _tmp57_;
#line 147 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_g_string_free0 (builder);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							data = (g_free (data), NULL);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							break;
#line 1543 "rygel-http-item-uri_http-get.c"
						}
					}
				} else if (_tmp43_ == ((0 != _tmp42_label1) ? _tmp42_label1 : (_tmp42_label1 = g_quark_from_static_string ("tr")))) {
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					switch (0) {
#line 1549 "rygel-http-item-uri_http-get.c"
						default:
						{
							gchar** _tmp58_;
							gint _tmp58__length1;
							gint _tmp59_;
							const gchar* _tmp60_;
							gchar* _tmp61_ = NULL;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp58_ = parts;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp58__length1 = parts_length1;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp59_ = i;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp60_ = _tmp58_[_tmp59_ + 1];
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp61_ = soup_uri_decode (_tmp60_);
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_g_free0 (self->transcode_target);
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							self->transcode_target = _tmp61_;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							break;
#line 1573 "rygel-http-item-uri_http-get.c"
						}
					}
				} else if (_tmp43_ == ((0 != _tmp42_label2) ? _tmp42_label2 : (_tmp42_label2 = g_quark_from_static_string ("th")))) {
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					switch (0) {
#line 1579 "rygel-http-item-uri_http-get.c"
						default:
						{
							gchar** _tmp62_;
							gint _tmp62__length1;
							gint _tmp63_;
							const gchar* _tmp64_;
							gint _tmp65_ = 0;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp62_ = parts;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp62__length1 = parts_length1;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp63_ = i;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp64_ = _tmp62_[_tmp63_ + 1];
#line 153 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp65_ = atoi (_tmp64_);
#line 153 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							self->thumbnail_index = _tmp65_;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							break;
#line 1601 "rygel-http-item-uri_http-get.c"
						}
					}
				} else if (_tmp43_ == ((0 != _tmp42_label3) ? _tmp42_label3 : (_tmp42_label3 = g_quark_from_static_string ("sub")))) {
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					switch (0) {
#line 1607 "rygel-http-item-uri_http-get.c"
						default:
						{
							gchar** _tmp66_;
							gint _tmp66__length1;
							gint _tmp67_;
							const gchar* _tmp68_;
							gint _tmp69_ = 0;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp66_ = parts;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp66__length1 = parts_length1;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp67_ = i;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp68_ = _tmp66_[_tmp67_ + 1];
#line 157 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							_tmp69_ = atoi (_tmp68_);
#line 157 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							self->subtitle_index = _tmp69_;
#line 159 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							break;
#line 1629 "rygel-http-item-uri_http-get.c"
						}
					}
				} else {
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					switch (0) {
#line 1635 "rygel-http-item-uri_http-get.c"
						default:
						{
#line 161 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
							break;
#line 1640 "rygel-http-item-uri_http-get.c"
						}
					}
				}
			}
		}
	}
#line 165 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp70_ = self->item_id;
#line 165 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	if (_tmp70_ == NULL) {
#line 1651 "rygel-http-item-uri_http-get.c"
		const gchar* _tmp71_ = NULL;
		GError* _tmp72_;
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp71_ = _ ("Not Found");
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp72_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp71_);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_inner_error_ = _tmp72_;
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			g_propagate_error (error, _inner_error_);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_g_free0 (last_part);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_g_free0 (request_uri);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_g_object_unref0 (self);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			return NULL;
#line 1674 "rygel-http-item-uri_http-get.c"
		} else {
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_g_free0 (last_part);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_g_free0 (request_uri);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			g_clear_error (&_inner_error_);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			return NULL;
#line 1688 "rygel-http-item-uri_http-get.c"
		}
	}
#line 113 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_g_free0 (last_part);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_g_free0 (request_uri);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	return self;
#line 1699 "rygel-http-item-uri_http-get.c"
}


RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error) {
#line 113 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	return rygel_http_item_uri_construct_from_string (RYGEL_TYPE_HTTP_ITEM_URI, uri, http_server, error);
#line 1706 "rygel-http-item-uri_http-get.c"
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gint _tmp7__length1;
#line 1253 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1254 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1254 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1254 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
#line 1254 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1254 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_result__length1 = _tmp1_ + 1;
#line 1254 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	__result__size_ = _result__length1;
#line 1255 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp3_ = _result__length1;
#line 1255 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_result__length1 = _tmp3_ - 1;
#line 1256 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp4_ = _result_;
#line 1256 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp4__length1 = _result__length1;
#line 1256 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp5_ = strlen (self);
#line 1256 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp6_ = _tmp5_;
#line 1256 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	memcpy (_tmp4_, self, (gsize) _tmp6_);
#line 1257 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp7_ = _result_;
#line 1257 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp7__length1 = _result__length1;
#line 1257 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1257 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		*result_length1 = _tmp7__length1;
#line 1761 "rygel-http-item-uri_http-get.c"
	}
#line 1257 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1257 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	return result;
#line 1767 "rygel-http-item-uri_http-get.c"
}


gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gchar* data;
	gint data_length1;
	gint _data_size_;
	gchar* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* escaped;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* path;
	const gchar* _tmp10_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_ = NULL;
#line 170 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 174 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp0_ = self->item_id;
#line 174 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp2_ = string_to_utf8 (_tmp0_, &_tmp1_);
#line 174 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	data = _tmp2_;
#line 174 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	data_length1 = _tmp1_;
#line 174 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_data_size_ = data_length1;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp3_ = data;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp3__length1 = data_length1;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp4_ = g_base64_encode ((guchar*) _tmp3_, (_tmp3__length1 * sizeof (gchar)) / sizeof (guchar));
#line 175 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp5_ = _tmp4_;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp6_ = g_uri_escape_string (_tmp5_, "", TRUE);
#line 175 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp7_ = _tmp6_;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_g_free0 (_tmp5_);
#line 175 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	escaped = _tmp7_;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp8_ = escaped;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp9_ = g_strconcat ("/i/", _tmp8_, NULL);
#line 178 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	path = _tmp9_;
#line 180 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp10_ = self->transcode_target;
#line 180 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	if (_tmp10_ != NULL) {
#line 1835 "rygel-http-item-uri_http-get.c"
		const gchar* _tmp11_;
		gchar* _tmp12_ = NULL;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp11_ = self->transcode_target;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp12_ = g_uri_escape_string (_tmp11_, "", TRUE);
#line 181 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_g_free0 (escaped);
#line 181 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		escaped = _tmp12_;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp13_ = path;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp14_ = escaped;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp15_ = g_strconcat ("/tr/", _tmp14_, NULL);
#line 182 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp16_ = _tmp15_;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp17_ = g_strconcat (_tmp13_, _tmp16_, NULL);
#line 182 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_g_free0 (path);
#line 182 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		path = _tmp17_;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_g_free0 (_tmp16_);
#line 1867 "rygel-http-item-uri_http-get.c"
	} else {
		gint _tmp18_;
#line 183 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp18_ = self->thumbnail_index;
#line 183 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		if (_tmp18_ >= 0) {
#line 1874 "rygel-http-item-uri_http-get.c"
			const gchar* _tmp19_;
			gint _tmp20_;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp19_ = path;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp20_ = self->thumbnail_index;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp21_ = g_strdup_printf ("%i", _tmp20_);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp22_ = _tmp21_;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp23_ = g_strconcat ("/th/", _tmp22_, NULL);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp24_ = _tmp23_;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp25_ = g_strconcat (_tmp19_, _tmp24_, NULL);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_g_free0 (path);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			path = _tmp25_;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_g_free0 (_tmp24_);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_g_free0 (_tmp22_);
#line 1904 "rygel-http-item-uri_http-get.c"
		} else {
			gint _tmp26_;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			_tmp26_ = self->subtitle_index;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			if (_tmp26_ >= 0) {
#line 1911 "rygel-http-item-uri_http-get.c"
				const gchar* _tmp27_;
				gint _tmp28_;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp27_ = path;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp28_ = self->subtitle_index;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp29_ = g_strdup_printf ("%i", _tmp28_);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp30_ = _tmp29_;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp31_ = g_strconcat ("/sub/", _tmp30_, NULL);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp32_ = _tmp31_;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp33_ = g_strconcat (_tmp27_, _tmp32_, NULL);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_g_free0 (path);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				path = _tmp33_;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_g_free0 (_tmp32_);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_g_free0 (_tmp30_);
#line 1941 "rygel-http-item-uri_http-get.c"
			}
		}
	}
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp34_ = path;
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp35_ = rygel_http_item_uri_get_extension (self);
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp36_ = _tmp35_;
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp37_ = _tmp36_;
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp38_ = g_strconcat (_tmp34_, _tmp37_, NULL);
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_g_free0 (path);
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	path = _tmp38_;
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_g_free0 (_tmp37_);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp39_ = path;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp40_ = rygel_http_item_uri_create_uri_for_path (self, _tmp39_);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	result = _tmp40_;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_g_free0 (path);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_g_free0 (escaped);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	data = (g_free (data), NULL);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	return result;
#line 1975 "rygel-http-item-uri_http-get.c"
}


static gchar* rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self, const gchar* path) {
	gchar* result = NULL;
	RygelHTTPServer* _tmp0_;
	GUPnPContext* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	RygelHTTPServer* _tmp4_;
	GUPnPContext* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	RygelHTTPServer* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
#line 192 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 192 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp0_ = self->http_server;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp1_ = _tmp0_->context;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp2_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp1_);
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp3_ = _tmp2_;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp4_ = self->http_server;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp5_ = _tmp4_->context;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp6_ = gupnp_context_get_port (_tmp5_);
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp7_ = _tmp6_;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp8_ = self->http_server;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp9_ = rygel_http_server_get_path_root (_tmp8_);
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp10_ = _tmp9_;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp11_ = path;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp12_ = g_strdup_printf ("http://%s:%u%s%s", _tmp3_, _tmp7_, _tmp10_, _tmp11_);
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	result = _tmp12_;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	return result;
#line 2028 "rygel-http-item-uri_http-get.c"
}


static gchar* rygel_http_item_uri_ext_from_mime_type (RygelHTTPItemURI* self, const gchar* mime_type) {
	gchar* result = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp28_;
	const gchar* _tmp29_;
	gboolean _tmp30_ = FALSE;
	gchar* _tmp34_;
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	g_return_val_if_fail (mime_type != NULL, NULL);
#line 200 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp0_ = rygel_http_item_uri_mime_to_ext;
#line 200 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	if (_tmp0_ == NULL) {
#line 2047 "rygel-http-item-uri_http-get.c"
		GeeHashMap* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar** _tmp5_ = NULL;
		gchar** videos;
		gint videos_length1;
		gint _videos_size_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		GeeHashMap* _tmp13_;
		GeeHashMap* _tmp14_;
		GeeHashMap* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar** _tmp18_ = NULL;
		gchar** images;
		gint images_length1;
		gint _images_size_;
		gchar** _tmp19_;
		gint _tmp19__length1;
		GeeHashMap* _tmp26_;
		GeeHashMap* _tmp27_;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_g_object_unref0 (rygel_http_item_uri_mime_to_ext);
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		rygel_http_item_uri_mime_to_ext = _tmp1_;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp2_ = g_strdup ("mpeg");
#line 203 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp3_ = g_strdup ("webm");
#line 203 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp4_ = g_strdup ("ogg");
#line 203 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp5_ = g_new0 (gchar*, 3 + 1);
#line 203 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp5_[0] = _tmp2_;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp5_[1] = _tmp3_;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp5_[2] = _tmp4_;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		videos = _tmp5_;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		videos_length1 = 3;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_videos_size_ = videos_length1;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp6_ = videos;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp6__length1 = videos_length1;
#line 2101 "rygel-http-item-uri_http-get.c"
		{
			gchar** video_collection = NULL;
			gint video_collection_length1 = 0;
			gint _video_collection_size_ = 0;
			gint video_it = 0;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			video_collection = _tmp6_;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			video_collection_length1 = _tmp6__length1;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			for (video_it = 0; video_it < _tmp6__length1; video_it = video_it + 1) {
#line 2113 "rygel-http-item-uri_http-get.c"
				gchar* _tmp7_;
				gchar* video = NULL;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp7_ = g_strdup (video_collection[video_it]);
#line 205 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				video = _tmp7_;
#line 2120 "rygel-http-item-uri_http-get.c"
				{
					GeeHashMap* _tmp8_;
					const gchar* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					const gchar* _tmp12_;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp8_ = rygel_http_item_uri_mime_to_ext;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp9_ = video;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp10_ = g_strconcat ("video/", _tmp9_, NULL);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp11_ = _tmp10_;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp12_ = video;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp11_, _tmp12_);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_g_free0 (_tmp11_);
#line 205 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_g_free0 (video);
#line 2143 "rygel-http-item-uri_http-get.c"
				}
			}
		}
#line 208 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp13_ = rygel_http_item_uri_mime_to_ext;
#line 208 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, "video/x-matroska", "mkv");
#line 211 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp14_ = rygel_http_item_uri_mime_to_ext;
#line 211 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, "audio/x-wav", "wav");
#line 212 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp15_ = rygel_http_item_uri_mime_to_ext;
#line 212 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, "audio/x-matroska", "mka");
#line 215 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp16_ = g_strdup ("jpeg");
#line 215 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp17_ = g_strdup ("png");
#line 215 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp18_ = g_new0 (gchar*, 2 + 1);
#line 215 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp18_[0] = _tmp16_;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp18_[1] = _tmp17_;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		images = _tmp18_;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		images_length1 = 2;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_images_size_ = images_length1;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp19_ = images;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp19__length1 = images_length1;
#line 2179 "rygel-http-item-uri_http-get.c"
		{
			gchar** image_collection = NULL;
			gint image_collection_length1 = 0;
			gint _image_collection_size_ = 0;
			gint image_it = 0;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			image_collection = _tmp19_;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			image_collection_length1 = _tmp19__length1;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
			for (image_it = 0; image_it < _tmp19__length1; image_it = image_it + 1) {
#line 2191 "rygel-http-item-uri_http-get.c"
				gchar* _tmp20_;
				gchar* image = NULL;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				_tmp20_ = g_strdup (image_collection[image_it]);
#line 217 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
				image = _tmp20_;
#line 2198 "rygel-http-item-uri_http-get.c"
				{
					GeeHashMap* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					const gchar* _tmp25_;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp21_ = rygel_http_item_uri_mime_to_ext;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp22_ = image;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp23_ = g_strconcat ("image/", _tmp22_, NULL);
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp24_ = _tmp23_;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_tmp25_ = image;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, _tmp24_, _tmp25_);
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_g_free0 (_tmp24_);
#line 217 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
					_g_free0 (image);
#line 2221 "rygel-http-item-uri_http-get.c"
				}
			}
		}
#line 222 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp26_ = rygel_http_item_uri_mime_to_ext;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp26_, "text/srt", "srt");
#line 225 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp27_ = rygel_http_item_uri_mime_to_ext;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, "application/ogg", "ogg");
#line 200 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		images = (_vala_array_free (images, images_length1, (GDestroyNotify) g_free), NULL);
#line 200 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		videos = (_vala_array_free (videos, videos_length1, (GDestroyNotify) g_free), NULL);
#line 2237 "rygel-http-item-uri_http-get.c"
	}
#line 228 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp28_ = rygel_http_item_uri_mime_to_ext;
#line 228 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp29_ = mime_type;
#line 228 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp30_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp28_, _tmp29_);
#line 228 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	if (_tmp30_) {
#line 2247 "rygel-http-item-uri_http-get.c"
		GeeHashMap* _tmp31_;
		const gchar* _tmp32_;
		gpointer _tmp33_ = NULL;
#line 229 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp31_ = rygel_http_item_uri_mime_to_ext;
#line 229 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp32_ = mime_type;
#line 229 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp33_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp31_, _tmp32_);
#line 229 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		result = (gchar*) _tmp33_;
#line 229 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		return result;
#line 2261 "rygel-http-item-uri_http-get.c"
	}
#line 232 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp34_ = g_strdup ("");
#line 232 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	result = _tmp34_;
#line 232 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	return result;
#line 2269 "rygel-http-item-uri_http-get.c"
}


gchar* rygel_http_item_uri_get_extension (RygelHTTPItemURI* self) {
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp3_;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp0_ = self->priv->real_extension;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	if (g_strcmp0 (_tmp0_, "") != 0) {
#line 2283 "rygel-http-item-uri_http-get.c"
		const gchar* _tmp1_;
		gchar* _tmp2_;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp1_ = self->priv->real_extension;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		_tmp2_ = g_strconcat (".", _tmp1_, NULL);
#line 38 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		result = _tmp2_;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		return result;
#line 2294 "rygel-http-item-uri_http-get.c"
	}
#line 40 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp3_ = g_strdup ("");
#line 40 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	result = _tmp3_;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	return result;
#line 2302 "rygel-http-item-uri_http-get.c"
}


void rygel_http_item_uri_set_extension (RygelHTTPItemURI* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	g_return_if_fail (self != NULL);
#line 43 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp0_ = value;
#line 43 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 43 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_g_free0 (self->priv->real_extension);
#line 43 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	self->priv->real_extension = _tmp1_;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	g_object_notify ((GObject *) self, "extension");
#line 2321 "rygel-http-item-uri_http-get.c"
}


static void rygel_http_item_uri_class_init (RygelHTTPItemURIClass * klass) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	rygel_http_item_uri_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPItemURIPrivate));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_item_uri_get_property;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_item_uri_set_property;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_item_uri_finalize;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_EXTENSION, g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2338 "rygel-http-item-uri_http-get.c"
}


static void rygel_http_item_uri_instance_init (RygelHTTPItemURI * self) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	self->priv = RYGEL_HTTP_ITEM_URI_GET_PRIVATE (self);
#line 2345 "rygel-http-item-uri_http-get.c"
}


static void rygel_http_item_uri_finalize (GObject* obj) {
	RygelHTTPItemURI * self;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI);
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_g_free0 (self->item_id);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_g_free0 (self->transcode_target);
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	_g_free0 (self->priv->real_extension);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	G_OBJECT_CLASS (rygel_http_item_uri_parent_class)->finalize (obj);
#line 2361 "rygel-http-item-uri_http-get.c"
}


GType rygel_http_item_uri_get_type (void) {
	static volatile gsize rygel_http_item_uri_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_item_uri_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPItemURIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_item_uri_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPItemURI), 0, (GInstanceInitFunc) rygel_http_item_uri_instance_init, NULL };
		GType rygel_http_item_uri_type_id;
		rygel_http_item_uri_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPItemURI", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_item_uri_type_id__volatile, rygel_http_item_uri_type_id);
	}
	return rygel_http_item_uri_type_id__volatile;
}


static void _vala_rygel_http_item_uri_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPItemURI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	switch (property_id) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		case RYGEL_HTTP_ITEM_URI_EXTENSION:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		g_value_take_string (value, rygel_http_item_uri_get_extension (self));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		break;
#line 2388 "rygel-http-item-uri_http-get.c"
		default:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		break;
#line 2394 "rygel-http-item-uri_http-get.c"
	}
}


static void _vala_rygel_http_item_uri_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPItemURI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
	switch (property_id) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		case RYGEL_HTTP_ITEM_URI_EXTENSION:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		rygel_http_item_uri_set_extension (self, g_value_get_string (value));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		break;
#line 2410 "rygel-http-item-uri_http-get.c"
		default:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-get.vala"
		break;
#line 2416 "rygel-http-item-uri_http-get.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



