/* rygel-media-item.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-media-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gst/gst.h>
#include <rygel-core.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	RYGEL_MEDIA_ITEM_ERROR_BAD_URI
} RygelMediaItemError;
#define RYGEL_MEDIA_ITEM_ERROR rygel_media_item_error_quark ()
struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self, const gchar* host_ip);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelMediaItemPrivate {
	gint64 _size;
	gboolean _place_holder;
	gchar* _description;
};

struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	gchar* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
	gchar* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelHTTPServer {
	RygelTranscodeManager parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	RygelTranscodeManagerClass parent_class;
};


static gpointer rygel_media_item_parent_class = NULL;

GQuark rygel_media_item_error_quark (void);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemPrivate))
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY,
	RYGEL_MEDIA_ITEM_SIZE,
	RYGEL_MEDIA_ITEM_PLACE_HOLDER,
	RYGEL_MEDIA_ITEM_DESCRIPTION,
	RYGEL_MEDIA_ITEM_OCM_FLAGS
};
RygelMediaItem* rygel_media_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaObject* rygel_media_object_construct (GType object_type);
void rygel_media_object_set_title (RygelMediaObject* self, const gchar* value);
GstElement* rygel_media_item_create_stream_source (RygelMediaItem* self, const gchar* host_ip);
static GstElement* rygel_media_item_real_create_stream_source (RygelMediaItem* self, const gchar* host_ip);
GstElement* rygel_gst_utils_create_source_for_uri (const gchar* uri);
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
gboolean rygel_media_item_streamable (RygelMediaItem* self);
gint64 rygel_media_item_get_size (RygelMediaItem* self);
static gboolean rygel_media_item_real_streamable (RygelMediaItem* self);
void rygel_media_item_add_uri (RygelMediaItem* self, const gchar* uri);
static void rygel_media_item_real_add_uri (RygelMediaItem* self, const gchar* uri);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
gint rygel_media_item_compare_transcoders (RygelMediaItem* self, RygelTranscoder* transcoder1, RygelTranscoder* transcoder2);
guint rygel_transcoder_get_distance (RygelTranscoder* self, RygelMediaItem* item);
GUPnPDIDLLiteResource* rygel_media_item_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
static GUPnPDIDLLiteResource* rygel_media_item_real_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
GUPnPProtocolInfo* rygel_media_item_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
static gint rygel_media_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property);
static gint rygel_media_item_compare_by_date (RygelMediaItem* self, RygelMediaItem* item);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
static GUPnPDIDLLiteObject* rygel_media_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
const gchar* rygel_media_item_get_description (RygelMediaItem* self);
void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void rygel_media_item_real_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
void rygel_http_server_add_proxy_resource (RygelHTTPServer* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
void rygel_transcode_manager_add_resources (RygelTranscodeManager* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
static GUPnPProtocolInfo* rygel_media_item_real_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
gchar* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const gchar* uri, GError** error);
static void rygel_media_item_real_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
static gint rygel_media_item_compare_long (RygelMediaItem* self, glong a, glong b);
void rygel_media_item_set_size (RygelMediaItem* self, gint64 value);
void rygel_media_item_set_place_holder (RygelMediaItem* self, gboolean value);
void rygel_media_item_set_description (RygelMediaItem* self, const gchar* value);
static void rygel_media_item_finalize (GObject* obj);
static void _vala_rygel_media_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_media_item_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_item_error-quark");
}


RygelMediaItem* rygel_media_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
	RygelMediaItem * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	RygelMediaContainer* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
	_tmp0_ = id;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (((RygelMediaObject*) self)->id);
	((RygelMediaObject*) self)->id = _tmp1_;
	_tmp2_ = parent;
	((RygelMediaObject*) self)->parent = _tmp2_;
	_tmp3_ = title;
	rygel_media_object_set_title ((RygelMediaObject*) self, _tmp3_);
	_tmp4_ = upnp_class;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (((RygelMediaObject*) self)->upnp_class);
	((RygelMediaObject*) self)->upnp_class = _tmp5_;
	{
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		GRegex* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		_tmp6_ = g_regex_escape_string ("@ADDRESS@", -1);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_regex_new (_tmp7_, 0, 0, &_inner_error_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_tmp10_ = _tmp9_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch7_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (self->address_regex);
		self->address_regex = _tmp10_;
	}
	goto __finally7;
	__catch7_g_regex_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (err);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static GstElement* rygel_media_item_real_create_stream_source (RygelMediaItem* self, const gchar* host_ip) {
	GstElement* result = NULL;
	GstElement* src;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GError * _inner_error_ = NULL;
	src = NULL;
	_tmp0_ = ((RygelMediaObject*) self)->uris;
	_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != 0) {
		GeeArrayList* _tmp3_;
		gpointer _tmp4_ = NULL;
		gchar* translated_uri;
		const gchar* _tmp5_;
		const gchar* _tmp14_;
		GstElement* _tmp15_ = NULL;
		_tmp3_ = ((RygelMediaObject*) self)->uris;
		_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, 0);
		translated_uri = (gchar*) _tmp4_;
		_tmp5_ = host_ip;
		if (_tmp5_ != NULL) {
			{
				GRegex* _tmp6_;
				GeeArrayList* _tmp7_;
				gpointer _tmp8_ = NULL;
				gchar* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp6_ = self->address_regex;
				_tmp7_ = ((RygelMediaObject*) self)->uris;
				_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, 0);
				_tmp9_ = (gchar*) _tmp8_;
				_tmp10_ = host_ip;
				_tmp11_ = g_regex_replace_literal (_tmp6_, _tmp9_, (gssize) (-1), 0, _tmp10_, 0, &_inner_error_);
				_tmp12_ = _tmp11_;
				_g_free0 (_tmp9_);
				_tmp13_ = _tmp12_;
				if (_inner_error_ != NULL) {
					goto __catch8_g_error;
				}
				_g_free0 (translated_uri);
				translated_uri = _tmp13_;
			}
			goto __finally8;
			__catch8_g_error:
			{
				GError* _error_ = NULL;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				g_assert_not_reached ();
				_g_error_free0 (_error_);
			}
			__finally8:
			if (_inner_error_ != NULL) {
				_g_free0 (translated_uri);
				_gst_object_unref0 (src);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp14_ = translated_uri;
		_tmp15_ = rygel_gst_utils_create_source_for_uri (_tmp14_);
		_gst_object_unref0 (src);
		src = _tmp15_;
		_g_free0 (translated_uri);
	}
	result = src;
	return result;
}


GstElement* rygel_media_item_create_stream_source (RygelMediaItem* self, const gchar* host_ip) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->create_stream_source (self, host_ip);
}


gboolean rygel_media_item_is_live_stream (RygelMediaItem* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = rygel_media_item_streamable (self);
	if (_tmp1_) {
		gint64 _tmp2_;
		gint64 _tmp3_;
		_tmp2_ = rygel_media_item_get_size (self);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_ <= ((gint64) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	result = _tmp4_;
	return result;
}


static gboolean rygel_media_item_real_streamable (RygelMediaItem* self) {
	g_critical ("Type `%s' does not implement abstract method `rygel_media_item_streamable'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean rygel_media_item_streamable (RygelMediaItem* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->streamable (self);
}


static void rygel_media_item_real_add_uri (RygelMediaItem* self, const gchar* uri) {
	GeeArrayList* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (uri != NULL);
	_tmp0_ = ((RygelMediaObject*) self)->uris;
	_tmp1_ = uri;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
}


void rygel_media_item_add_uri (RygelMediaItem* self, const gchar* uri) {
	g_return_if_fail (self != NULL);
	RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_uri (self, uri);
}


gint rygel_media_item_compare_transcoders (RygelMediaItem* self, RygelTranscoder* transcoder1, RygelTranscoder* transcoder2) {
	gint result = 0;
	RygelTranscoder* _tmp0_;
	guint _tmp1_ = 0U;
	RygelTranscoder* _tmp2_;
	guint _tmp3_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (transcoder1 != NULL, 0);
	g_return_val_if_fail (transcoder2 != NULL, 0);
	_tmp0_ = transcoder1;
	_tmp1_ = rygel_transcoder_get_distance (_tmp0_, self);
	_tmp2_ = transcoder2;
	_tmp3_ = rygel_transcoder_get_distance (_tmp2_, self);
	result = ((gint) _tmp1_) - ((gint) _tmp3_);
	return result;
}


static GUPnPDIDLLiteResource* rygel_media_item_real_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error) {
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteItem* _tmp0_;
	GUPnPDIDLLiteResource* _tmp1_ = NULL;
	GUPnPDIDLLiteResource* res;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp5_;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	gboolean _tmp12_;
	GUPnPDIDLLiteResource* _tmp15_;
	gint64 _tmp16_;
	gint64 _tmp17_;
	GUPnPDIDLLiteResource* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GUPnPProtocolInfo* _tmp21_ = NULL;
	GUPnPProtocolInfo* _tmp22_;
	g_return_val_if_fail (didl_item != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	_tmp0_ = didl_item;
	_tmp1_ = gupnp_didl_lite_object_add_resource ((GUPnPDIDLLiteObject*) _tmp0_);
	res = _tmp1_;
	_tmp3_ = uri;
	if (_tmp3_ != NULL) {
		gboolean _tmp4_;
		_tmp4_ = self->priv->_place_holder;
		_tmp2_ = !_tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		GUPnPDIDLLiteResource* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = res;
		_tmp7_ = uri;
		gupnp_didl_lite_resource_set_uri (_tmp6_, _tmp7_);
	} else {
		GUPnPDIDLLiteResource* _tmp8_;
		_tmp8_ = res;
		gupnp_didl_lite_resource_set_uri (_tmp8_, "");
	}
	_tmp10_ = import_uri;
	if (_tmp10_ != NULL) {
		gboolean _tmp11_;
		_tmp11_ = self->priv->_place_holder;
		_tmp9_ = _tmp11_;
	} else {
		_tmp9_ = FALSE;
	}
	_tmp12_ = _tmp9_;
	if (_tmp12_) {
		GUPnPDIDLLiteResource* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = res;
		_tmp14_ = import_uri;
		gupnp_didl_lite_resource_set_import_uri (_tmp13_, _tmp14_);
	}
	_tmp15_ = res;
	_tmp16_ = rygel_media_item_get_size (self);
	_tmp17_ = _tmp16_;
	gupnp_didl_lite_resource_set_size64 (_tmp15_, _tmp17_);
	_tmp18_ = res;
	_tmp19_ = uri;
	_tmp20_ = protocol;
	_tmp21_ = rygel_media_item_get_protocol_info (self, _tmp19_, _tmp20_);
	_tmp22_ = _tmp21_;
	gupnp_didl_lite_resource_set_protocol_info (_tmp18_, _tmp22_);
	_g_object_unref0 (_tmp22_);
	result = res;
	return result;
}


GUPnPDIDLLiteResource* rygel_media_item_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_resource (self, didl_item, uri, protocol, import_uri, error);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gint rygel_media_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property) {
	RygelMediaItem * self;
	gint result = 0;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaItem* _tmp2_;
	RygelMediaItem* item;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	self = (RygelMediaItem*) base;
	g_return_val_if_fail (media_object != NULL, 0);
	g_return_val_if_fail (property != NULL, 0);
	_tmp0_ = media_object;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_ITEM)) {
		result = 1;
		return result;
	}
	_tmp1_ = media_object;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp1_) : NULL);
	item = _tmp2_;
	_tmp3_ = property;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("dc:date")))) {
		switch (0) {
			default:
			{
				RygelMediaItem* _tmp7_;
				gint _tmp8_ = 0;
				_tmp7_ = item;
				_tmp8_ = rygel_media_item_compare_by_date (self, _tmp7_);
				result = _tmp8_;
				_g_object_unref0 (item);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				RygelMediaItem* _tmp9_;
				const gchar* _tmp10_;
				gint _tmp11_ = 0;
				_tmp9_ = item;
				_tmp10_ = property;
				_tmp11_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_media_item_parent_class)->compare_by_property (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject), (RygelMediaObject*) _tmp9_, _tmp10_);
				result = _tmp11_;
				_g_object_unref0 (item);
				return result;
			}
		}
	}
	_g_object_unref0 (item);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static GUPnPDIDLLiteObject* rygel_media_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error) {
	RygelMediaItem * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteWriter* _tmp0_;
	GUPnPDIDLLiteItem* _tmp1_ = NULL;
	GUPnPDIDLLiteItem* didl_item;
	GUPnPDIDLLiteItem* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	RygelMediaContainer* _tmp7_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GUPnPDIDLLiteItem* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GUPnPDIDLLiteItem* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp27_;
	RygelHTTPServer* _tmp30_;
	GUPnPDIDLLiteItem* _tmp31_;
	gboolean _tmp32_;
	GError * _inner_error_ = NULL;
	self = (RygelMediaItem*) base;
	g_return_val_if_fail (writer != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	_tmp0_ = writer;
	_tmp1_ = gupnp_didl_lite_writer_add_item (_tmp0_);
	didl_item = _tmp1_;
	_tmp2_ = didl_item;
	_tmp3_ = ((RygelMediaObject*) self)->id;
	gupnp_didl_lite_object_set_id ((GUPnPDIDLLiteObject*) _tmp2_, _tmp3_);
	_tmp4_ = ((RygelMediaObject*) self)->ref_id;
	if (_tmp4_ != NULL) {
		GUPnPDIDLLiteItem* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = didl_item;
		_tmp6_ = ((RygelMediaObject*) self)->ref_id;
		gupnp_didl_lite_item_set_ref_id (_tmp5_, _tmp6_);
	}
	_tmp7_ = ((RygelMediaObject*) self)->parent;
	if (_tmp7_ != NULL) {
		GUPnPDIDLLiteItem* _tmp8_;
		RygelMediaContainer* _tmp9_;
		const gchar* _tmp10_;
		_tmp8_ = didl_item;
		_tmp9_ = ((RygelMediaObject*) self)->parent;
		_tmp10_ = ((RygelMediaObject*) _tmp9_)->id;
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) _tmp8_, _tmp10_);
	} else {
		GUPnPDIDLLiteItem* _tmp11_;
		_tmp11_ = didl_item;
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) _tmp11_, "0");
	}
	_tmp12_ = rygel_media_object_get_restricted ((RygelMediaObject*) self);
	_tmp13_ = _tmp12_;
	if (_tmp13_) {
		GUPnPDIDLLiteItem* _tmp14_;
		_tmp14_ = didl_item;
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) _tmp14_, TRUE);
	} else {
		GUPnPDIDLLiteItem* _tmp15_;
		GUPnPDIDLLiteItem* _tmp16_;
		GUPnPOCMFlags _tmp17_;
		GUPnPOCMFlags _tmp18_;
		_tmp15_ = didl_item;
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) _tmp15_, FALSE);
		_tmp16_ = didl_item;
		_tmp17_ = rygel_media_object_get_ocm_flags ((RygelMediaObject*) self);
		_tmp18_ = _tmp17_;
		gupnp_didl_lite_object_set_dlna_managed ((GUPnPDIDLLiteObject*) _tmp16_, _tmp18_);
	}
	_tmp19_ = didl_item;
	_tmp20_ = rygel_media_object_get_title ((RygelMediaObject*) self);
	_tmp21_ = _tmp20_;
	gupnp_didl_lite_object_set_title ((GUPnPDIDLLiteObject*) _tmp19_, _tmp21_);
	_tmp22_ = didl_item;
	_tmp23_ = ((RygelMediaObject*) self)->upnp_class;
	gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) _tmp22_, _tmp23_);
	_tmp24_ = self->date;
	if (_tmp24_ != NULL) {
		GUPnPDIDLLiteItem* _tmp25_;
		const gchar* _tmp26_;
		_tmp25_ = didl_item;
		_tmp26_ = self->date;
		gupnp_didl_lite_object_set_date ((GUPnPDIDLLiteObject*) _tmp25_, _tmp26_);
	}
	_tmp27_ = self->priv->_description;
	if (_tmp27_ != NULL) {
		GUPnPDIDLLiteItem* _tmp28_;
		const gchar* _tmp29_;
		_tmp28_ = didl_item;
		_tmp29_ = self->priv->_description;
		gupnp_didl_lite_object_set_description ((GUPnPDIDLLiteObject*) _tmp28_, _tmp29_);
	}
	_tmp30_ = http_server;
	_tmp31_ = didl_item;
	rygel_media_item_add_proxy_resources (self, _tmp30_, _tmp31_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (didl_item);
		return NULL;
	}
	_tmp32_ = self->priv->_place_holder;
	if (!_tmp32_) {
		RygelHTTPServer* _tmp33_;
		GUPnPContext* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* host_ip;
		gboolean internal_allowed = FALSE;
		gboolean _tmp38_ = FALSE;
		RygelHTTPServer* _tmp39_;
		GUPnPContext* _tmp40_;
		const gchar* _tmp41_;
		const gchar* _tmp42_;
		gboolean _tmp44_;
		GUPnPDIDLLiteItem* _tmp45_;
		gboolean _tmp46_;
		GUPnPDIDLLiteItem* _tmp47_;
		GList* _tmp48_ = NULL;
		_tmp33_ = http_server;
		_tmp34_ = _tmp33_->context;
		_tmp35_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_strdup (_tmp36_);
		host_ip = _tmp37_;
		_tmp39_ = http_server;
		_tmp40_ = _tmp39_->context;
		_tmp41_ = gssdp_client_get_interface ((GSSDPClient*) _tmp40_);
		_tmp42_ = _tmp41_;
		if (g_strcmp0 (_tmp42_, "lo") == 0) {
			_tmp38_ = TRUE;
		} else {
			const gchar* _tmp43_;
			_tmp43_ = host_ip;
			_tmp38_ = g_strcmp0 (_tmp43_, "127.0.0.1") == 0;
		}
		_tmp44_ = _tmp38_;
		internal_allowed = _tmp44_;
		_tmp45_ = didl_item;
		_tmp46_ = internal_allowed;
		rygel_media_item_add_resources (self, _tmp45_, _tmp46_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (host_ip);
			_g_object_unref0 (didl_item);
			return NULL;
		}
		_tmp47_ = didl_item;
		_tmp48_ = gupnp_didl_lite_object_get_resources ((GUPnPDIDLLiteObject*) _tmp47_);
		{
			GList* res_collection = NULL;
			GList* res_it = NULL;
			res_collection = _tmp48_;
			for (res_it = res_collection; res_it != NULL; res_it = res_it->next) {
				GUPnPDIDLLiteResource* _tmp49_;
				GUPnPDIDLLiteResource* res = NULL;
				_tmp49_ = _g_object_ref0 ((GUPnPDIDLLiteResource*) res_it->data);
				res = _tmp49_;
				{
					GRegex* _tmp50_;
					GUPnPDIDLLiteResource* _tmp51_;
					const gchar* _tmp52_;
					const gchar* _tmp53_;
					const gchar* _tmp54_;
					gchar* _tmp55_ = NULL;
					gchar* _tmp56_;
					GUPnPDIDLLiteResource* _tmp57_;
					gchar* _tmp58_;
					_tmp50_ = self->address_regex;
					_tmp51_ = res;
					_tmp52_ = gupnp_didl_lite_resource_get_uri (_tmp51_);
					_tmp53_ = _tmp52_;
					_tmp54_ = host_ip;
					_tmp55_ = g_regex_replace_literal (_tmp50_, _tmp53_, (gssize) (-1), 0, _tmp54_, 0, &_inner_error_);
					_tmp56_ = _tmp55_;
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (res);
						__g_list_free__g_object_unref0_0 (res_collection);
						_g_free0 (host_ip);
						_g_object_unref0 (didl_item);
						return NULL;
					}
					_tmp57_ = res;
					_tmp58_ = _tmp56_;
					gupnp_didl_lite_resource_set_uri (_tmp57_, _tmp58_);
					_g_free0 (_tmp58_);
					_g_object_unref0 (res);
				}
			}
			__g_list_free__g_object_unref0_0 (res_collection);
		}
		_g_free0 (host_ip);
	}
	result = (GUPnPDIDLLiteObject*) didl_item;
	return result;
}


static void rygel_media_item_real_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
	RygelHTTPServer* _tmp0_;
	GUPnPDIDLLiteItem* _tmp1_;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (server != NULL);
	g_return_if_fail (didl_item != NULL);
	_tmp0_ = server;
	_tmp1_ = didl_item;
	rygel_http_server_add_proxy_resource (_tmp0_, _tmp1_, self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = self->priv->_place_holder;
	if (!_tmp2_) {
		RygelHTTPServer* _tmp3_;
		GUPnPDIDLLiteItem* _tmp4_;
		_tmp3_ = server;
		_tmp4_ = didl_item;
		rygel_transcode_manager_add_resources ((RygelTranscodeManager*) _tmp3_, _tmp4_, self, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
	g_return_if_fail (self != NULL);
	RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_proxy_resources (self, server, didl_item, error);
}


static GUPnPProtocolInfo* rygel_media_item_real_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol) {
	GUPnPProtocolInfo* result = NULL;
	GUPnPProtocolInfo* _tmp0_;
	GUPnPProtocolInfo* protocol_info;
	GUPnPProtocolInfo* _tmp1_;
	const gchar* _tmp2_;
	GUPnPProtocolInfo* _tmp3_;
	const gchar* _tmp4_;
	GUPnPProtocolInfo* _tmp5_;
	const gchar* _tmp6_;
	GUPnPProtocolInfo* _tmp7_;
	gint64 _tmp8_;
	gint64 _tmp9_;
	gboolean _tmp11_ = FALSE;
	g_return_val_if_fail (protocol != NULL, NULL);
	_tmp0_ = gupnp_protocol_info_new ();
	protocol_info = _tmp0_;
	_tmp1_ = protocol_info;
	_tmp2_ = self->mime_type;
	gupnp_protocol_info_set_mime_type (_tmp1_, _tmp2_);
	_tmp3_ = protocol_info;
	_tmp4_ = self->dlna_profile;
	gupnp_protocol_info_set_dlna_profile (_tmp3_, _tmp4_);
	_tmp5_ = protocol_info;
	_tmp6_ = protocol;
	gupnp_protocol_info_set_protocol (_tmp5_, _tmp6_);
	_tmp7_ = protocol_info;
	gupnp_protocol_info_set_dlna_flags (_tmp7_, (GUPNP_DLNA_FLAGS_DLNA_V15 | GUPNP_DLNA_FLAGS_CONNECTION_STALL) | GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE);
	_tmp8_ = rygel_media_item_get_size (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ > ((gint64) 0)) {
		GUPnPProtocolInfo* _tmp10_;
		_tmp10_ = protocol_info;
		gupnp_protocol_info_set_dlna_operation (_tmp10_, GUPNP_DLNA_OPERATION_RANGE);
	}
	_tmp11_ = rygel_media_item_streamable (self);
	if (_tmp11_) {
		GUPnPProtocolInfo* _tmp12_;
		GUPnPProtocolInfo* _tmp13_;
		GUPnPDLNAFlags _tmp14_;
		GUPnPDLNAFlags _tmp15_;
		_tmp12_ = protocol_info;
		_tmp13_ = protocol_info;
		_tmp14_ = gupnp_protocol_info_get_dlna_flags (_tmp13_);
		_tmp15_ = _tmp14_;
		gupnp_protocol_info_set_dlna_flags (_tmp13_, _tmp15_ | GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE);
	}
	result = protocol_info;
	return result;
}


GUPnPProtocolInfo* rygel_media_item_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->get_protocol_info (self, uri, protocol);
}


gchar* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const gchar* uri, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* scheme;
	const gchar* _tmp2_;
	const gchar* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = uri;
	_tmp1_ = g_uri_parse_scheme (_tmp0_);
	scheme = _tmp1_;
	_tmp2_ = scheme;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_;
		GError* _tmp5_;
		_tmp3_ = _ ("Bad URI: %s");
		_tmp4_ = uri;
		_tmp5_ = g_error_new (RYGEL_MEDIA_ITEM_ERROR, RYGEL_MEDIA_ITEM_ERROR_BAD_URI, _tmp3_, _tmp4_);
		_inner_error_ = _tmp5_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (scheme);
		return NULL;
	}
	_tmp6_ = scheme;
	if (g_strcmp0 (_tmp6_, "http") == 0) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("http-get");
		result = _tmp7_;
		_g_free0 (scheme);
		return result;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = scheme;
		if (g_strcmp0 (_tmp8_, "file") == 0) {
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("internal");
			result = _tmp9_;
			_g_free0 (scheme);
			return result;
		} else {
			const gchar* _tmp10_;
			_tmp10_ = scheme;
			if (g_strcmp0 (_tmp10_, "rtsp") == 0) {
				gchar* _tmp11_;
				_tmp11_ = g_strdup ("rtsp-rtp-udp");
				result = _tmp11_;
				_g_free0 (scheme);
				return result;
			} else {
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp12_ = _ ("Failed to probe protocol for URI %s. Assuming '%s'");
				_tmp13_ = uri;
				_tmp14_ = scheme;
				g_warning (_tmp12_, _tmp13_, _tmp14_);
				result = scheme;
				return result;
			}
		}
	}
	_g_free0 (scheme);
}


static void rygel_media_item_real_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (didl_item != NULL);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _uri_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _uri_size;
		gint _uri_index;
		_tmp0_ = ((RygelMediaObject*) self)->uris;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_uri_list = _tmp1_;
		_tmp2_ = _uri_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_uri_size = _tmp4_;
		_uri_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			gchar* uri;
			const gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* protocol;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_;
			gboolean _tmp16_;
			_tmp5_ = _uri_index;
			_uri_index = _tmp5_ + 1;
			_tmp6_ = _uri_index;
			_tmp7_ = _uri_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _uri_list;
			_tmp9_ = _uri_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			uri = (gchar*) _tmp10_;
			_tmp11_ = uri;
			_tmp12_ = rygel_media_item_get_protocol_for_uri (self, _tmp11_, &_inner_error_);
			protocol = _tmp12_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (uri);
				_g_object_unref0 (_uri_list);
				return;
			}
			_tmp14_ = allow_internal;
			if (_tmp14_) {
				_tmp13_ = TRUE;
			} else {
				const gchar* _tmp15_;
				_tmp15_ = protocol;
				_tmp13_ = g_strcmp0 (_tmp15_, "internal") != 0;
			}
			_tmp16_ = _tmp13_;
			if (_tmp16_) {
				GUPnPDIDLLiteItem* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				GUPnPDIDLLiteResource* _tmp20_ = NULL;
				GUPnPDIDLLiteResource* _tmp21_;
				_tmp17_ = didl_item;
				_tmp18_ = uri;
				_tmp19_ = protocol;
				_tmp20_ = rygel_media_item_add_resource (self, _tmp17_, _tmp18_, _tmp19_, NULL, &_inner_error_);
				_tmp21_ = _tmp20_;
				_g_object_unref0 (_tmp21_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (protocol);
					_g_free0 (uri);
					_g_object_unref0 (_uri_list);
					return;
				}
			}
			_g_free0 (protocol);
			_g_free0 (uri);
		}
		_g_object_unref0 (_uri_list);
	}
}


void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
	g_return_if_fail (self != NULL);
	RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_resources (self, didl_item, allow_internal, error);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gint rygel_media_item_compare_by_date (RygelMediaItem* self, RygelMediaItem* item) {
	gint result = 0;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (item != NULL, 0);
	_tmp0_ = self->date;
	if (_tmp0_ == NULL) {
		result = -1;
		return result;
	} else {
		RygelMediaItem* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = item;
		_tmp2_ = _tmp1_->date;
		if (_tmp2_ == NULL) {
			result = 1;
			return result;
		} else {
			const gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* our_date;
			RygelMediaItem* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* other_date;
			const gchar* _tmp8_;
			gboolean _tmp9_ = FALSE;
			const gchar* _tmp12_;
			gboolean _tmp13_ = FALSE;
			GTimeVal tv1 = {0};
			const gchar* _tmp16_;
			gboolean _tmp17_ = FALSE;
			GTimeVal tv2 = {0};
			RygelMediaItem* _tmp18_;
			const gchar* _tmp19_;
			gboolean _tmp20_ = FALSE;
			GTimeVal _tmp21_;
			glong _tmp22_;
			GTimeVal _tmp23_;
			glong _tmp24_;
			gint _tmp25_ = 0;
			gint ret;
			gint _tmp26_;
			_tmp3_ = self->date;
			_tmp4_ = g_strdup (_tmp3_);
			our_date = _tmp4_;
			_tmp5_ = item;
			_tmp6_ = _tmp5_->date;
			_tmp7_ = g_strdup (_tmp6_);
			other_date = _tmp7_;
			_tmp8_ = our_date;
			_tmp9_ = string_contains (_tmp8_, "T");
			if (!_tmp9_) {
				const gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp10_ = our_date;
				_tmp11_ = g_strconcat (_tmp10_, "T00:00:00Z", NULL);
				_g_free0 (our_date);
				our_date = _tmp11_;
			}
			_tmp12_ = other_date;
			_tmp13_ = string_contains (_tmp12_, "T");
			if (!_tmp13_) {
				const gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp14_ = other_date;
				_tmp15_ = g_strconcat (_tmp14_, "T00:00:00Z", NULL);
				_g_free0 (other_date);
				other_date = _tmp15_;
			}
			g_get_current_time (&tv1);
			_tmp16_ = self->date;
			_tmp17_ = g_time_val_from_iso8601 (_tmp16_, &tv1);
			_vala_assert (_tmp17_, "tv1.from_iso8601 (this.date)");
			g_get_current_time (&tv2);
			_tmp18_ = item;
			_tmp19_ = _tmp18_->date;
			_tmp20_ = g_time_val_from_iso8601 (_tmp19_, &tv2);
			_vala_assert (_tmp20_, "tv2.from_iso8601 (item.date)");
			_tmp21_ = tv1;
			_tmp22_ = _tmp21_.tv_sec;
			_tmp23_ = tv2;
			_tmp24_ = _tmp23_.tv_sec;
			_tmp25_ = rygel_media_item_compare_long (self, _tmp22_, _tmp24_);
			ret = _tmp25_;
			_tmp26_ = ret;
			if (_tmp26_ == 0) {
				GTimeVal _tmp27_;
				glong _tmp28_;
				GTimeVal _tmp29_;
				glong _tmp30_;
				gint _tmp31_ = 0;
				_tmp27_ = tv1;
				_tmp28_ = _tmp27_.tv_usec;
				_tmp29_ = tv2;
				_tmp30_ = _tmp29_.tv_usec;
				_tmp31_ = rygel_media_item_compare_long (self, _tmp28_, _tmp30_);
				ret = _tmp31_;
			}
			result = ret;
			_g_free0 (other_date);
			_g_free0 (our_date);
			return result;
		}
	}
}


static gint rygel_media_item_compare_long (RygelMediaItem* self, glong a, glong b) {
	gint result = 0;
	glong _tmp0_;
	glong _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = b;
	if (_tmp0_ < _tmp1_) {
		result = -1;
		return result;
	} else {
		glong _tmp2_;
		glong _tmp3_;
		_tmp2_ = a;
		_tmp3_ = b;
		if (_tmp2_ > _tmp3_) {
			result = 1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}


gint64 rygel_media_item_get_size (RygelMediaItem* self) {
	gint64 result;
	gint64 _tmp0_;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_size;
	result = _tmp0_;
	return result;
}


void rygel_media_item_set_size (RygelMediaItem* self, gint64 value) {
	gint64 _tmp0_;
	gint64 _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	if (_tmp0_ == ((gint64) 0)) {
		rygel_media_item_set_place_holder (self, TRUE);
	}
	_tmp1_ = value;
	self->priv->_size = _tmp1_;
	g_object_notify ((GObject *) self, "size");
}


gboolean rygel_media_item_get_place_holder (RygelMediaItem* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_place_holder;
	result = _tmp0_;
	return result;
}


void rygel_media_item_set_place_holder (RygelMediaItem* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_place_holder = _tmp0_;
	g_object_notify ((GObject *) self, "place-holder");
}


const gchar* rygel_media_item_get_description (RygelMediaItem* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}


void rygel_media_item_set_description (RygelMediaItem* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp1_;
	g_object_notify ((GObject *) self, "description");
}


static GUPnPOCMFlags rygel_media_item_real_get_ocm_flags (RygelMediaObject* base) {
	GUPnPOCMFlags result;
	RygelMediaItem* self;
	gboolean _tmp0_;
	RygelMetaConfig* _tmp1_ = NULL;
	RygelMetaConfig* config;
	gboolean allow_deletion;
	gboolean _tmp5_;
	GError * _inner_error_ = NULL;
	self = (RygelMediaItem*) base;
	_tmp0_ = self->priv->_place_holder;
	if (_tmp0_) {
		result = GUPNP_OCM_FLAGS_DESTROYABLE;
		return result;
	}
	_tmp1_ = rygel_meta_config_get_default ();
	config = _tmp1_;
	allow_deletion = TRUE;
	{
		RygelMetaConfig* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
		_tmp2_ = config;
		_tmp3_ = rygel_configuration_get_allow_deletion ((RygelConfiguration*) _tmp2_, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		allow_deletion = _tmp4_;
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp5_ = allow_deletion;
	if (_tmp5_) {
		result = GUPNP_OCM_FLAGS_DESTROYABLE;
		_g_object_unref0 (config);
		return result;
	} else {
		result = GUPNP_OCM_FLAGS_NONE;
		_g_object_unref0 (config);
		return result;
	}
	_g_object_unref0 (config);
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaItemPrivate));
	RYGEL_MEDIA_ITEM_CLASS (klass)->create_stream_source = rygel_media_item_real_create_stream_source;
	RYGEL_MEDIA_ITEM_CLASS (klass)->streamable = rygel_media_item_real_streamable;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_uri = rygel_media_item_real_add_uri;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resource = rygel_media_item_real_add_resource;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->compare_by_property = rygel_media_item_real_compare_by_property;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_media_item_real_serialize;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_proxy_resources = rygel_media_item_real_add_proxy_resources;
	RYGEL_MEDIA_ITEM_CLASS (klass)->get_protocol_info = rygel_media_item_real_get_protocol_info;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resources = rygel_media_item_real_add_resources;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_ocm_flags = rygel_media_item_real_get_ocm_flags;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_SIZE, g_param_spec_int64 ("size", "size", "size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_PLACE_HOLDER, g_param_spec_boolean ("place-holder", "place-holder", "place-holder", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_OCM_FLAGS, g_param_spec_flags ("ocm-flags", "ocm-flags", "ocm-flags", GUPNP_TYPE_OCM_FLAGS, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
	self->priv = RYGEL_MEDIA_ITEM_GET_PRIVATE (self);
	self->priv->_size = (gint64) (-1);
	self->priv->_place_holder = FALSE;
	self->priv->_description = NULL;
}


static void rygel_media_item_finalize (GObject* obj) {
	RygelMediaItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
	_g_free0 (self->date);
	_g_free0 (self->mime_type);
	_g_free0 (self->dlna_profile);
	_g_free0 (self->priv->_description);
	_g_regex_unref0 (self->address_regex);
	G_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
}


/**
 * Represents a media (Music, Video and Image) item.
 */
GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


static void _vala_rygel_media_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
	switch (property_id) {
		case RYGEL_MEDIA_ITEM_SIZE:
		g_value_set_int64 (value, rygel_media_item_get_size (self));
		break;
		case RYGEL_MEDIA_ITEM_PLACE_HOLDER:
		g_value_set_boolean (value, rygel_media_item_get_place_holder (self));
		break;
		case RYGEL_MEDIA_ITEM_DESCRIPTION:
		g_value_set_string (value, rygel_media_item_get_description (self));
		break;
		case RYGEL_MEDIA_ITEM_OCM_FLAGS:
		g_value_set_flags (value, rygel_media_object_get_ocm_flags ((RygelMediaObject*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
	switch (property_id) {
		case RYGEL_MEDIA_ITEM_SIZE:
		rygel_media_item_set_size (self, g_value_get_int64 (value));
		break;
		case RYGEL_MEDIA_ITEM_PLACE_HOLDER:
		rygel_media_item_set_place_holder (self, g_value_get_boolean (value));
		break;
		case RYGEL_MEDIA_ITEM_DESCRIPTION:
		rygel_media_item_set_description (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



