/* rygel-http-byte-seek-test.c generated by valac 0.15.0.16-b8cde, the Vala compiler
 * generated from rygel-http-byte-seek-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                               <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>


#define RYGEL_TYPE_HTTP_IDENTITY_HANDLER (rygel_http_identity_handler_get_type ())
#define RYGEL_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandler))
#define RYGEL_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_HTTP_IDENTITY_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))

typedef struct _RygelHTTPIdentityHandler RygelHTTPIdentityHandler;
typedef struct _RygelHTTPIdentityHandlerClass RygelHTTPIdentityHandlerClass;
typedef struct _RygelHTTPIdentityHandlerPrivate RygelHTTPIdentityHandlerPrivate;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_BYTE_SEEK_TEST (rygel_http_byte_seek_test_get_type ())
#define RYGEL_HTTP_BYTE_SEEK_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST, RygelHTTPByteSeekTest))
#define RYGEL_HTTP_BYTE_SEEK_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST, RygelHTTPByteSeekTestClass))
#define RYGEL_IS_HTTP_BYTE_SEEK_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST))
#define RYGEL_IS_HTTP_BYTE_SEEK_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST))
#define RYGEL_HTTP_BYTE_SEEK_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST, RygelHTTPByteSeekTestClass))

typedef struct _RygelHTTPByteSeekTest RygelHTTPByteSeekTest;
typedef struct _RygelHTTPByteSeekTestClass RygelHTTPByteSeekTestClass;
typedef struct _RygelHTTPByteSeekTestPrivate RygelHTTPByteSeekTestPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_BYTE_SEEK (rygel_http_byte_seek_get_type ())
#define RYGEL_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeek))
#define RYGEL_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))
#define RYGEL_IS_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_IS_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_HTTP_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))

typedef struct _RygelHTTPByteSeek RygelHTTPByteSeek;
typedef struct _RygelHTTPByteSeekClass RygelHTTPByteSeekClass;
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	RYGEL_TEST_ERROR_SKIP
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
struct _RygelHTTPIdentityHandler {
	GObject parent_instance;
	RygelHTTPIdentityHandlerPrivate * priv;
};

struct _RygelHTTPIdentityHandlerClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	GObject parent_instance;
	RygelMediaItemPrivate * priv;
	gint64 size;
};

struct _RygelMediaItemClass {
	GObjectClass parent_class;
};

struct _RygelThumbnail {
	GObject parent_instance;
	RygelThumbnailPrivate * priv;
	gint64 size;
};

struct _RygelThumbnailClass {
	GObjectClass parent_class;
};

struct _RygelSubtitle {
	GObject parent_instance;
	RygelSubtitlePrivate * priv;
	gint64 size;
};

struct _RygelSubtitleClass {
	GObjectClass parent_class;
};

struct _RygelHTTPGet {
	GObject parent_instance;
	RygelHTTPGetPrivate * priv;
	SoupMessage* msg;
	RygelMediaItem* item;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPIdentityHandler* handler;
};

struct _RygelHTTPGetClass {
	GObjectClass parent_class;
};

struct _RygelHTTPByteSeekTest {
	GObject parent_instance;
	RygelHTTPByteSeekTestPrivate * priv;
};

struct _RygelHTTPByteSeekTestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPByteSeekTestPrivate {
	GRegex* range_regex;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()

static gpointer rygel_http_identity_handler_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;
static gpointer rygel_thumbnail_parent_class = NULL;
static gpointer rygel_subtitle_parent_class = NULL;
static gpointer rygel_http_get_parent_class = NULL;
static gpointer rygel_http_byte_seek_test_parent_class = NULL;

GQuark rygel_test_error_quark (void);
GType rygel_http_identity_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_IDENTITY_HANDLER_DUMMY_PROPERTY
};
RygelHTTPIdentityHandler* rygel_http_identity_handler_new (void);
RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
RygelMediaItem* rygel_media_item_new (void);
RygelMediaItem* rygel_media_item_construct (GType object_type);
static void rygel_media_item_finalize (GObject* obj);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_THUMBNAIL_DUMMY_PROPERTY
};
RygelThumbnail* rygel_thumbnail_new (void);
RygelThumbnail* rygel_thumbnail_construct (GType object_type);
static void rygel_thumbnail_finalize (GObject* obj);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_SUBTITLE_DUMMY_PROPERTY
};
RygelSubtitle* rygel_subtitle_new (void);
RygelSubtitle* rygel_subtitle_construct (GType object_type);
static void rygel_subtitle_finalize (GObject* obj);
GType rygel_http_get_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_GET_DUMMY_PROPERTY
};
#define RYGEL_HTTP_GET_ITEM_URI "http://DoesntMatterWhatThisIs"
RygelHTTPGet* rygel_http_get_new (RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_new_seek_start (gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_start (GType object_type, gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
static void rygel_http_get_add_headers (RygelHTTPGet* self, gint64 start, gint64 stop);
RygelHTTPGet* rygel_http_get_new_seek_stop (gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_stop (GType object_type, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_new_seek_start_stop (gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_start_stop (GType object_type, gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
static void rygel_http_get_finalize (GObject* obj);
GType rygel_http_byte_seek_test_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_BYTE_SEEK_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST, RygelHTTPByteSeekTestPrivate))
enum  {
	RYGEL_HTTP_BYTE_SEEK_TEST_DUMMY_PROPERTY
};
gint rygel_http_byte_seek_test_main (gchar** args, int args_length1);
static RygelHTTPByteSeekTest* rygel_http_byte_seek_test_new (void);
static RygelHTTPByteSeekTest* rygel_http_byte_seek_test_construct (GType object_type);
GQuark rygel_http_seek_error_quark (void);
void rygel_http_byte_seek_test_run (RygelHTTPByteSeekTest* self, GError** error);
static void rygel_http_byte_seek_test_test_no_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_byte_seek_test_test_start_only_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_byte_seek_test_test_stop_only_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_byte_seek_test_test_start_stop_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_byte_seek_test_test_seek (RygelHTTPByteSeekTest* self, RygelHTTPGet* request, gint64 start, gint64 stop, GError** error);
gboolean rygel_http_byte_seek_needed (RygelHTTPGet* request);
RygelHTTPByteSeek* rygel_http_byte_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_http_byte_seek_get_type (void) G_GNUC_CONST;
void rygel_http_seek_add_response_headers (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_length (RygelHTTPSeek* self);
static void rygel_http_byte_seek_test_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type) {
	RygelHTTPIdentityHandler * self = NULL;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelHTTPIdentityHandler*) g_object_new (object_type, NULL);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 292 "rygel-http-byte-seek-test.c"
}


RygelHTTPIdentityHandler* rygel_http_identity_handler_new (void) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_identity_handler_construct (RYGEL_TYPE_HTTP_IDENTITY_HANDLER);
#line 299 "rygel-http-byte-seek-test.c"
}


static void rygel_http_identity_handler_class_init (RygelHTTPIdentityHandlerClass * klass) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_identity_handler_parent_class = g_type_class_peek_parent (klass);
#line 306 "rygel-http-byte-seek-test.c"
}


static void rygel_http_identity_handler_instance_init (RygelHTTPIdentityHandler * self) {
}


GType rygel_http_identity_handler_get_type (void) {
	static volatile gsize rygel_http_identity_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_identity_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPIdentityHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_identity_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPIdentityHandler), 0, (GInstanceInitFunc) rygel_http_identity_handler_instance_init, NULL };
		GType rygel_http_identity_handler_type_id;
		rygel_http_identity_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPIdentityHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_identity_handler_type_id__volatile, rygel_http_identity_handler_type_id);
	}
	return rygel_http_identity_handler_type_id__volatile;
}


RygelMediaItem* rygel_media_item_construct (GType object_type) {
	RygelMediaItem * self = NULL;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelMediaItem*) g_object_new (object_type, NULL);
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 332 "rygel-http-byte-seek-test.c"
}


RygelMediaItem* rygel_media_item_new (void) {
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_media_item_construct (RYGEL_TYPE_MEDIA_ITEM);
#line 339 "rygel-http-byte-seek-test.c"
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
#line 348 "rygel-http-byte-seek-test.c"
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
#line 31 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->size = (gint64) 2048;
#line 355 "rygel-http-byte-seek-test.c"
}


static void rygel_media_item_finalize (GObject* obj) {
	RygelMediaItem * self;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = RYGEL_MEDIA_ITEM (obj);
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
#line 365 "rygel-http-byte-seek-test.c"
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


RygelThumbnail* rygel_thumbnail_construct (GType object_type) {
	RygelThumbnail * self = NULL;
#line 34 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelThumbnail*) g_object_new (object_type, NULL);
#line 34 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 387 "rygel-http-byte-seek-test.c"
}


RygelThumbnail* rygel_thumbnail_new (void) {
#line 34 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_thumbnail_construct (RYGEL_TYPE_THUMBNAIL);
#line 394 "rygel-http-byte-seek-test.c"
}


static void rygel_thumbnail_class_init (RygelThumbnailClass * klass) {
#line 34 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_thumbnail_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_thumbnail_finalize;
#line 403 "rygel-http-byte-seek-test.c"
}


static void rygel_thumbnail_instance_init (RygelThumbnail * self) {
#line 35 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->size = (gint64) 1024;
#line 410 "rygel-http-byte-seek-test.c"
}


static void rygel_thumbnail_finalize (GObject* obj) {
	RygelThumbnail * self;
#line 34 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = RYGEL_THUMBNAIL (obj);
#line 34 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (rygel_thumbnail_parent_class)->finalize (obj);
#line 420 "rygel-http-byte-seek-test.c"
}


GType rygel_thumbnail_get_type (void) {
	static volatile gsize rygel_thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnail_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnail), 0, (GInstanceInitFunc) rygel_thumbnail_instance_init, NULL };
		GType rygel_thumbnail_type_id;
		rygel_thumbnail_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelThumbnail", &g_define_type_info, 0);
		g_once_init_leave (&rygel_thumbnail_type_id__volatile, rygel_thumbnail_type_id);
	}
	return rygel_thumbnail_type_id__volatile;
}


RygelSubtitle* rygel_subtitle_construct (GType object_type) {
	RygelSubtitle * self = NULL;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelSubtitle*) g_object_new (object_type, NULL);
#line 38 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 442 "rygel-http-byte-seek-test.c"
}


RygelSubtitle* rygel_subtitle_new (void) {
#line 38 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_subtitle_construct (RYGEL_TYPE_SUBTITLE);
#line 449 "rygel-http-byte-seek-test.c"
}


static void rygel_subtitle_class_init (RygelSubtitleClass * klass) {
#line 38 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_subtitle_parent_class = g_type_class_peek_parent (klass);
#line 38 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_subtitle_finalize;
#line 458 "rygel-http-byte-seek-test.c"
}


static void rygel_subtitle_instance_init (RygelSubtitle * self) {
#line 39 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->size = (gint64) 512;
#line 465 "rygel-http-byte-seek-test.c"
}


static void rygel_subtitle_finalize (GObject* obj) {
	RygelSubtitle * self;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = RYGEL_SUBTITLE (obj);
#line 38 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (rygel_subtitle_parent_class)->finalize (obj);
#line 475 "rygel-http-byte-seek-test.c"
}


GType rygel_subtitle_get_type (void) {
	static volatile gsize rygel_subtitle_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitle), 0, (GInstanceInitFunc) rygel_subtitle_instance_init, NULL };
		GType rygel_subtitle_type_id;
		rygel_subtitle_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSubtitle", &g_define_type_info, 0);
		g_once_init_leave (&rygel_subtitle_type_id__volatile, rygel_subtitle_type_id);
	}
	return rygel_subtitle_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 56 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 494 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	SoupMessage* _tmp0_;
	RygelMediaItem* _tmp1_;
	RygelHTTPIdentityHandler* _tmp2_;
	RygelThumbnail* _tmp3_;
	RygelThumbnail* _tmp4_;
	RygelSubtitle* _tmp5_;
	RygelSubtitle* _tmp6_;
#line 52 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelHTTPGet*) g_object_new (object_type, NULL);
#line 53 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = soup_message_new ("HTTP", RYGEL_HTTP_GET_ITEM_URI);
#line 53 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->msg);
#line 53 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->msg = _tmp0_;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = rygel_media_item_new ();
#line 54 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->item);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->item = _tmp1_;
#line 55 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = rygel_http_identity_handler_new ();
#line 55 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->handler);
#line 55 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->handler = _tmp2_;
#line 56 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_ = thumbnail;
#line 56 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 56 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->thumbnail);
#line 56 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->thumbnail = _tmp4_;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp5_ = subtitle;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->subtitle);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->subtitle = _tmp6_;
#line 52 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 545 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new (RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 52 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_get_construct (RYGEL_TYPE_HTTP_GET, thumbnail, subtitle);
#line 552 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct_seek_start (GType object_type, gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	gint64 _tmp2_;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = thumbnail;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = subtitle;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
#line 65 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = start;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_get_add_headers (self, _tmp2_, (gint64) (-1));
#line 60 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 573 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new_seek_start (gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 60 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_get_construct_seek_start (RYGEL_TYPE_HTTP_GET, start, thumbnail, subtitle);
#line 580 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct_seek_stop (GType object_type, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	gint64 _tmp2_;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = thumbnail;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = subtitle;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
#line 73 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = stop;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_get_add_headers (self, (gint64) 0, _tmp2_);
#line 68 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 601 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new_seek_stop (gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 68 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_get_construct_seek_stop (RYGEL_TYPE_HTTP_GET, stop, thumbnail, subtitle);
#line 608 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct_seek_start_stop (GType object_type, gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = thumbnail;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = subtitle;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = start;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_ = stop;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_get_add_headers (self, _tmp2_, _tmp3_);
#line 76 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 632 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new_seek_start_stop (gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 76 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_get_construct_seek_start_stop (RYGEL_TYPE_HTTP_GET, start, stop, thumbnail, subtitle);
#line 639 "rygel-http-byte-seek-test.c"
}


static void rygel_http_get_add_headers (RygelHTTPGet* self, gint64 start, gint64 stop) {
	SoupMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 86 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = self->msg;
#line 86 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = _tmp0_->request_headers;
#line 86 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = start;
#line 86 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_ = stop;
#line 86 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	soup_message_headers_set_range (_tmp1_, _tmp2_, _tmp3_);
#line 660 "rygel-http-byte-seek-test.c"
}


static void rygel_http_get_class_init (RygelHTTPGetClass * klass) {
#line 42 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_get_parent_class = g_type_class_peek_parent (klass);
#line 42 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_finalize;
#line 669 "rygel-http-byte-seek-test.c"
}


static void rygel_http_get_instance_init (RygelHTTPGet * self) {
}


static void rygel_http_get_finalize (GObject* obj) {
	RygelHTTPGet * self;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = RYGEL_HTTP_GET (obj);
#line 45 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->msg);
#line 46 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->item);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->thumbnail);
#line 48 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->subtitle);
#line 50 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->handler);
#line 42 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (rygel_http_get_parent_class)->finalize (obj);
#line 693 "rygel-http-byte-seek-test.c"
}


GType rygel_http_get_get_type (void) {
	static volatile gsize rygel_http_get_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGet), 0, (GInstanceInitFunc) rygel_http_get_instance_init, NULL };
		GType rygel_http_get_type_id;
		rygel_http_get_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGet", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_type_id__volatile, rygel_http_get_type_id);
	}
	return rygel_http_get_type_id__volatile;
}


gint rygel_http_byte_seek_test_main (gchar** args, int args_length1) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		RygelHTTPByteSeekTest* _tmp0_;
		RygelHTTPByteSeekTest* test;
		RygelHTTPByteSeekTest* _tmp1_;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp0_ = rygel_http_byte_seek_test_new ();
#line 95 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		test = _tmp0_;
#line 97 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp1_ = test;
#line 97 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		rygel_http_byte_seek_test_run (_tmp1_, &_inner_error_);
#line 97 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_ != NULL) {
#line 97 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (test);
#line 97 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 730 "rygel-http-byte-seek-test.c"
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 94 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_object_unref0 (test);
#line 737 "rygel-http-byte-seek-test.c"
	}
	goto __finally0;
	__catch0_rygel_test_error_skip:
	{
		GError* _error_ = NULL;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_error_ = _inner_error_;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_inner_error_ = NULL;
#line 99 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		result = 77;
#line 99 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_error_free0 (_error_);
#line 99 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		return result;
#line 753 "rygel-http-byte-seek-test.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_error_ = _inner_error_;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_inner_error_ = NULL;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp2_ = _error_;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp3_ = _tmp2_->message;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_critical ("rygel-http-byte-seek-test.vala:101: %s", _tmp3_);
#line 103 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		result = -1;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_error_free0 (_error_);
#line 103 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		return result;
#line 777 "rygel-http-byte-seek-test.c"
	}
	__finally0:
#line 94 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 94 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_clear_error (&_inner_error_);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		return 0;
#line 788 "rygel-http-byte-seek-test.c"
	}
#line 106 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	result = 0;
#line 106 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return result;
#line 794 "rygel-http-byte-seek-test.c"
}


int main (int argc, char ** argv) {
#line 93 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_thread_init (NULL);
#line 93 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_type_init ();
#line 93 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_byte_seek_test_main (argv, argc);
#line 805 "rygel-http-byte-seek-test.c"
}


void rygel_http_byte_seek_test_run (RygelHTTPByteSeekTest* self, GError** error) {
	RygelThumbnail* _tmp0_;
	RygelThumbnail** _tmp1_ = NULL;
	RygelThumbnail** thumbnails;
	gint thumbnails_length1;
	gint _thumbnails_size_;
	RygelSubtitle* _tmp2_;
	RygelSubtitle** _tmp3_ = NULL;
	RygelSubtitle** subtitles;
	gint subtitles_length1;
	gint _subtitles_size_;
	RygelThumbnail** _tmp4_;
	gint _tmp4__length1;
	GError * _inner_error_ = NULL;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 110 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = rygel_thumbnail_new ();
#line 110 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = g_new0 (RygelThumbnail*, 2 + 1);
#line 110 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_[0] = NULL;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_[1] = _tmp0_;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	thumbnails = _tmp1_;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	thumbnails_length1 = 2;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_thumbnails_size_ = thumbnails_length1;
#line 111 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = rygel_subtitle_new ();
#line 111 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_ = g_new0 (RygelSubtitle*, 2 + 1);
#line 111 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_[0] = NULL;
#line 111 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_[1] = _tmp2_;
#line 111 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	subtitles = _tmp3_;
#line 111 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	subtitles_length1 = 2;
#line 111 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_subtitles_size_ = subtitles_length1;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp4_ = thumbnails;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp4__length1 = thumbnails_length1;
#line 857 "rygel-http-byte-seek-test.c"
	{
		RygelThumbnail** thumbnail_collection = NULL;
		gint thumbnail_collection_length1 = 0;
		gint _thumbnail_collection_size_ = 0;
		gint thumbnail_it = 0;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		thumbnail_collection = _tmp4_;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		thumbnail_collection_length1 = _tmp4__length1;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		for (thumbnail_it = 0; thumbnail_it < _tmp4__length1; thumbnail_it = thumbnail_it + 1) {
#line 869 "rygel-http-byte-seek-test.c"
			RygelThumbnail* _tmp5_;
			RygelThumbnail* thumbnail = NULL;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp5_ = _g_object_ref0 (thumbnail_collection[thumbnail_it]);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			thumbnail = _tmp5_;
#line 876 "rygel-http-byte-seek-test.c"
			{
				RygelSubtitle** _tmp6_;
				gint _tmp6__length1;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
				_tmp6_ = subtitles;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
				_tmp6__length1 = subtitles_length1;
#line 884 "rygel-http-byte-seek-test.c"
				{
					RygelSubtitle** subtitle_collection = NULL;
					gint subtitle_collection_length1 = 0;
					gint _subtitle_collection_size_ = 0;
					gint subtitle_it = 0;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
					subtitle_collection = _tmp6_;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
					subtitle_collection_length1 = _tmp6__length1;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
					for (subtitle_it = 0; subtitle_it < _tmp6__length1; subtitle_it = subtitle_it + 1) {
#line 896 "rygel-http-byte-seek-test.c"
						RygelSubtitle* _tmp7_;
						RygelSubtitle* subtitle = NULL;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
						_tmp7_ = _g_object_ref0 (subtitle_collection[subtitle_it]);
#line 114 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
						subtitle = _tmp7_;
#line 903 "rygel-http-byte-seek-test.c"
						{
							RygelThumbnail* _tmp8_;
							RygelSubtitle* _tmp9_;
							RygelThumbnail* _tmp10_;
							RygelSubtitle* _tmp11_;
							RygelThumbnail* _tmp12_;
							RygelSubtitle* _tmp13_;
							RygelThumbnail* _tmp14_;
							RygelSubtitle* _tmp15_;
#line 115 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp8_ = thumbnail;
#line 115 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp9_ = subtitle;
#line 115 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							rygel_http_byte_seek_test_test_no_seek (self, _tmp8_, _tmp9_, &_inner_error_);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 115 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 115 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 935 "rygel-http-byte-seek-test.c"
								} else {
#line 115 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 951 "rygel-http-byte-seek-test.c"
								}
							}
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp10_ = thumbnail;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp11_ = subtitle;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							rygel_http_byte_seek_test_test_start_only_seek (self, _tmp10_, _tmp11_, &_inner_error_);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 976 "rygel-http-byte-seek-test.c"
								} else {
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 992 "rygel-http-byte-seek-test.c"
								}
							}
#line 117 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp12_ = thumbnail;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp13_ = subtitle;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							rygel_http_byte_seek_test_test_stop_only_seek (self, _tmp12_, _tmp13_, &_inner_error_);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 117 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 117 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 1017 "rygel-http-byte-seek-test.c"
								} else {
#line 117 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 1033 "rygel-http-byte-seek-test.c"
								}
							}
#line 118 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp14_ = thumbnail;
#line 118 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp15_ = subtitle;
#line 118 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							rygel_http_byte_seek_test_test_start_stop_seek (self, _tmp14_, _tmp15_, &_inner_error_);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 118 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 118 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 1058 "rygel-http-byte-seek-test.c"
								} else {
#line 118 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 1074 "rygel-http-byte-seek-test.c"
								}
							}
#line 114 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_g_object_unref0 (subtitle);
#line 1079 "rygel-http-byte-seek-test.c"
						}
					}
				}
#line 113 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
				_g_object_unref0 (thumbnail);
#line 1085 "rygel-http-byte-seek-test.c"
			}
		}
	}
#line 109 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1093 "rygel-http-byte-seek-test.c"
}


static RygelHTTPByteSeekTest* rygel_http_byte_seek_test_construct (GType object_type) {
	RygelHTTPByteSeekTest * self = NULL;
	GRegex* _tmp0_;
	GRegex* _tmp1_;
	GError * _inner_error_ = NULL;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelHTTPByteSeekTest*) g_object_new (object_type, NULL);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = g_regex_new ("bytes +[0-9]+-[0-9]+/[0-9]+", G_REGEX_CASELESS, 0, &_inner_error_);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = _tmp0_;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 124 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_clear_error (&_inner_error_);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		return NULL;
#line 1116 "rygel-http-byte-seek-test.c"
	}
#line 124 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_regex_unref0 (self->priv->range_regex);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->priv->range_regex = _tmp1_;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 1124 "rygel-http-byte-seek-test.c"
}


static RygelHTTPByteSeekTest* rygel_http_byte_seek_test_new (void) {
#line 123 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_byte_seek_test_construct (RYGEL_TYPE_HTTP_BYTE_SEEK_TEST);
#line 1131 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_test_no_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	RygelHTTPGet* _tmp2_;
	RygelHTTPGet* request;
	gint64 size = 0LL;
	RygelHTTPGet* _tmp3_;
	RygelThumbnail* _tmp4_;
	RygelHTTPGet* _tmp16_;
	gint64 _tmp17_;
	GError * _inner_error_ = NULL;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 130 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = thumbnail;
#line 130 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = subtitle;
#line 130 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = rygel_http_get_new (_tmp0_, _tmp1_);
#line 130 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	request = _tmp2_;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_ = request;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp4_ = _tmp3_->thumbnail;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_tmp4_ != NULL) {
#line 1162 "rygel-http-byte-seek-test.c"
		RygelHTTPGet* _tmp5_;
		RygelThumbnail* _tmp6_;
		gint64 _tmp7_;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp5_ = request;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp6_ = _tmp5_->thumbnail;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp7_ = _tmp6_->size;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		size = _tmp7_;
#line 1174 "rygel-http-byte-seek-test.c"
	} else {
		RygelHTTPGet* _tmp8_;
		RygelSubtitle* _tmp9_;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp8_ = request;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp9_ = _tmp8_->subtitle;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_tmp9_ != NULL) {
#line 1184 "rygel-http-byte-seek-test.c"
			RygelHTTPGet* _tmp10_;
			RygelSubtitle* _tmp11_;
			gint64 _tmp12_;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp10_ = request;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp11_ = _tmp10_->subtitle;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp12_ = _tmp11_->size;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			size = _tmp12_;
#line 1196 "rygel-http-byte-seek-test.c"
		} else {
			RygelHTTPGet* _tmp13_;
			RygelMediaItem* _tmp14_;
			gint64 _tmp15_;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp13_ = request;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp14_ = _tmp13_->item;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp15_ = _tmp14_->size;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			size = _tmp15_;
#line 1209 "rygel-http-byte-seek-test.c"
		}
	}
#line 141 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp16_ = request;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp17_ = size;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_test_test_seek (self, _tmp16_, (gint64) 0, _tmp17_ - 1, &_inner_error_);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 141 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 141 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1228 "rygel-http-byte-seek-test.c"
		} else {
#line 141 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1238 "rygel-http-byte-seek-test.c"
		}
	}
#line 128 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (request);
#line 1243 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_test_start_only_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	RygelHTTPGet* _tmp2_;
	RygelHTTPGet* request;
	gint64 size = 0LL;
	RygelHTTPGet* _tmp3_;
	RygelThumbnail* _tmp4_;
	RygelHTTPGet* _tmp16_;
	gint64 _tmp17_;
	GError * _inner_error_ = NULL;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = thumbnail;
#line 147 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = subtitle;
#line 147 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = rygel_http_get_new_seek_start ((gint64) 128, _tmp0_, _tmp1_);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	request = _tmp2_;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_ = request;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp4_ = _tmp3_->thumbnail;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_tmp4_ != NULL) {
#line 1274 "rygel-http-byte-seek-test.c"
		RygelHTTPGet* _tmp5_;
		RygelThumbnail* _tmp6_;
		gint64 _tmp7_;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp5_ = request;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp6_ = _tmp5_->thumbnail;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp7_ = _tmp6_->size;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		size = _tmp7_;
#line 1286 "rygel-http-byte-seek-test.c"
	} else {
		RygelHTTPGet* _tmp8_;
		RygelSubtitle* _tmp9_;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp8_ = request;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp9_ = _tmp8_->subtitle;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_tmp9_ != NULL) {
#line 1296 "rygel-http-byte-seek-test.c"
			RygelHTTPGet* _tmp10_;
			RygelSubtitle* _tmp11_;
			gint64 _tmp12_;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp10_ = request;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp11_ = _tmp10_->subtitle;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp12_ = _tmp11_->size;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			size = _tmp12_;
#line 1308 "rygel-http-byte-seek-test.c"
		} else {
			RygelHTTPGet* _tmp13_;
			RygelMediaItem* _tmp14_;
			gint64 _tmp15_;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp13_ = request;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp14_ = _tmp13_->item;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp15_ = _tmp14_->size;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			size = _tmp15_;
#line 1321 "rygel-http-byte-seek-test.c"
		}
	}
#line 158 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp16_ = request;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp17_ = size;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_test_test_seek (self, _tmp16_, (gint64) 128, _tmp17_ - 1, &_inner_error_);
#line 158 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 158 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 158 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 158 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 158 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1340 "rygel-http-byte-seek-test.c"
		} else {
#line 158 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 158 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 158 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 158 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1350 "rygel-http-byte-seek-test.c"
		}
	}
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (request);
#line 1355 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_test_stop_only_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	RygelHTTPGet* _tmp2_;
	RygelHTTPGet* request;
	GError * _inner_error_ = NULL;
#line 161 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 164 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = thumbnail;
#line 164 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = subtitle;
#line 164 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = rygel_http_get_new_seek_stop ((gint64) 128, _tmp0_, _tmp1_);
#line 164 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	request = _tmp2_;
#line 166 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_test_test_seek (self, request, (gint64) 0, (gint64) 128, &_inner_error_);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 166 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 166 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1387 "rygel-http-byte-seek-test.c"
		} else {
#line 166 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1397 "rygel-http-byte-seek-test.c"
		}
	}
#line 161 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (request);
#line 1402 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_test_start_stop_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	RygelHTTPGet* _tmp2_;
	RygelHTTPGet* request;
	GError * _inner_error_ = NULL;
#line 169 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 172 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = thumbnail;
#line 172 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = subtitle;
#line 172 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = rygel_http_get_new_seek_start_stop ((gint64) 128, (gint64) 256, _tmp0_, _tmp1_);
#line 172 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	request = _tmp2_;
#line 177 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_test_test_seek (self, request, (gint64) 128, (gint64) 256, &_inner_error_);
#line 177 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 177 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 177 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 177 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 177 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1434 "rygel-http-byte-seek-test.c"
		} else {
#line 177 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 177 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 177 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 177 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1444 "rygel-http-byte-seek-test.c"
		}
	}
#line 169 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (request);
#line 1449 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_test_seek (RygelHTTPByteSeekTest* self, RygelHTTPGet* request, gint64 start, gint64 stop, GError** error) {
	RygelHTTPGet* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelHTTPGet* _tmp2_;
	RygelHTTPByteSeek* _tmp3_;
	RygelHTTPByteSeek* seek;
	gint64 _tmp4_;
	gint64 _tmp5_;
	gint64 _tmp6_;
	gint64 _tmp7_;
	gint64 _tmp8_;
	gint64 _tmp9_;
	RygelHTTPGet* _tmp10_;
	RygelThumbnail* _tmp11_;
	RygelHTTPGet* _tmp29_;
	SoupMessage* _tmp30_;
	SoupMessageHeaders* _tmp31_;
	const gchar* _tmp32_ = NULL;
	RygelHTTPGet* _tmp48_;
	SoupMessage* _tmp49_;
	SoupMessageHeaders* _tmp50_;
	gint64 _tmp51_ = 0LL;
	gint64 _tmp52_;
	gint64 _tmp53_;
	GError * _inner_error_ = NULL;
#line 180 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 180 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (request != NULL);
#line 183 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = request;
#line 183 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = rygel_http_byte_seek_needed (_tmp0_);
#line 183 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_assert (_tmp1_);
#line 185 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = request;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_ = rygel_http_byte_seek_new (_tmp2_, &_inner_error_);
#line 185 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	seek = _tmp3_;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 185 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 185 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 185 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1502 "rygel-http-byte-seek-test.c"
		} else {
#line 185 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 185 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 185 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1510 "rygel-http-byte-seek-test.c"
		}
	}
#line 186 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_seek_add_response_headers ((RygelHTTPSeek*) seek);
#line 188 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_assert (seek != NULL);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp4_ = rygel_http_seek_get_start ((RygelHTTPSeek*) seek);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp5_ = _tmp4_;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp6_ = start;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_assert (_tmp5_ == _tmp6_);
#line 190 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp7_ = rygel_http_seek_get_stop ((RygelHTTPSeek*) seek);
#line 190 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp8_ = _tmp7_;
#line 190 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp9_ = stop;
#line 190 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_assert (_tmp8_ == _tmp9_);
#line 192 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp10_ = request;
#line 192 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp11_ = _tmp10_->thumbnail;
#line 192 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_tmp11_ != NULL) {
#line 1539 "rygel-http-byte-seek-test.c"
		gint64 _tmp12_;
		gint64 _tmp13_;
		RygelHTTPGet* _tmp14_;
		RygelThumbnail* _tmp15_;
		gint64 _tmp16_;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp12_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) seek);
#line 193 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp13_ = _tmp12_;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp14_ = request;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp15_ = _tmp14_->thumbnail;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp16_ = _tmp15_->size;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_assert (_tmp13_ == _tmp16_);
#line 1557 "rygel-http-byte-seek-test.c"
	} else {
		RygelHTTPGet* _tmp17_;
		RygelSubtitle* _tmp18_;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp17_ = request;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp18_ = _tmp17_->subtitle;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_tmp18_ != NULL) {
#line 1567 "rygel-http-byte-seek-test.c"
			gint64 _tmp19_;
			gint64 _tmp20_;
			RygelHTTPGet* _tmp21_;
			RygelSubtitle* _tmp22_;
			gint64 _tmp23_;
#line 195 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp19_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) seek);
#line 195 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp20_ = _tmp19_;
#line 195 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp21_ = request;
#line 195 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp22_ = _tmp21_->subtitle;
#line 195 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp23_ = _tmp22_->size;
#line 195 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_assert (_tmp20_ == _tmp23_);
#line 1585 "rygel-http-byte-seek-test.c"
		} else {
			gint64 _tmp24_;
			gint64 _tmp25_;
			RygelHTTPGet* _tmp26_;
			RygelMediaItem* _tmp27_;
			gint64 _tmp28_;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp24_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) seek);
#line 197 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp25_ = _tmp24_;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp26_ = request;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp27_ = _tmp26_->item;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp28_ = _tmp27_->size;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_assert (_tmp25_ == _tmp28_);
#line 1604 "rygel-http-byte-seek-test.c"
		}
	}
#line 200 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp29_ = request;
#line 200 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp30_ = _tmp29_->msg;
#line 200 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp31_ = _tmp30_->request_headers;
#line 200 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp32_ = soup_message_headers_get_one (_tmp31_, "Range");
#line 200 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_tmp32_ != NULL) {
#line 1617 "rygel-http-byte-seek-test.c"
		RygelHTTPGet* _tmp33_;
		SoupMessage* _tmp34_;
		SoupMessageHeaders* _tmp35_;
		const gchar* _tmp36_ = NULL;
		gchar* _tmp37_;
		gchar* header;
		const gchar* _tmp38_;
		RygelHTTPGet* _tmp39_;
		SoupMessage* _tmp40_;
		SoupMessageHeaders* _tmp41_;
		const gchar* _tmp42_ = NULL;
		gchar* _tmp43_;
		const gchar* _tmp44_;
		GRegex* _tmp45_;
		const gchar* _tmp46_;
		gboolean _tmp47_ = FALSE;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp33_ = request;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp34_ = _tmp33_->msg;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp35_ = _tmp34_->response_headers;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp36_ = soup_message_headers_get_one (_tmp35_, "Accept-Ranges");
#line 201 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp37_ = g_strdup (_tmp36_);
#line 201 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		header = _tmp37_;
#line 202 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp38_ = header;
#line 202 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_assert (g_strcmp0 (_tmp38_, "bytes") == 0);
#line 203 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp39_ = request;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp40_ = _tmp39_->msg;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp41_ = _tmp40_->response_headers;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp42_ = soup_message_headers_get_one (_tmp41_, "Content-Range");
#line 203 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp43_ = g_strdup (_tmp42_);
#line 203 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_free0 (header);
#line 203 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		header = _tmp43_;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp44_ = header;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_assert (_tmp44_ != NULL);
#line 205 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp45_ = self->priv->range_regex;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp46_ = header;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp47_ = g_regex_match (_tmp45_, _tmp46_, 0, NULL);
#line 205 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_assert (_tmp47_);
#line 200 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_free0 (header);
#line 1678 "rygel-http-byte-seek-test.c"
	}
#line 208 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp48_ = request;
#line 208 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp49_ = _tmp48_->msg;
#line 208 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp50_ = _tmp49_->response_headers;
#line 208 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp51_ = soup_message_headers_get_content_length (_tmp50_);
#line 208 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp52_ = rygel_http_seek_get_length ((RygelHTTPSeek*) seek);
#line 208 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp53_ = _tmp52_;
#line 208 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_assert (_tmp51_ == _tmp53_);
#line 180 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (seek);
#line 1696 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_class_init (RygelHTTPByteSeekTestClass * klass) {
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_test_parent_class = g_type_class_peek_parent (klass);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPByteSeekTestPrivate));
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_byte_seek_test_finalize;
#line 1707 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_instance_init (RygelHTTPByteSeekTest * self) {
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->priv = RYGEL_HTTP_BYTE_SEEK_TEST_GET_PRIVATE (self);
#line 1714 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_finalize (GObject* obj) {
	RygelHTTPByteSeekTest * self;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = RYGEL_HTTP_BYTE_SEEK_TEST (obj);
#line 91 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_regex_unref0 (self->priv->range_regex);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (rygel_http_byte_seek_test_parent_class)->finalize (obj);
#line 1726 "rygel-http-byte-seek-test.c"
}


GType rygel_http_byte_seek_test_get_type (void) {
	static volatile gsize rygel_http_byte_seek_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_byte_seek_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPByteSeekTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_byte_seek_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPByteSeekTest), 0, (GInstanceInitFunc) rygel_http_byte_seek_test_instance_init, NULL };
		GType rygel_http_byte_seek_test_type_id;
		rygel_http_byte_seek_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPByteSeekTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_byte_seek_test_type_id__volatile, rygel_http_byte_seek_test_type_id);
	}
	return rygel_http_byte_seek_test_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



