/* rygel-http-byte-seek.c generated by valac 0.14.1, the Vala compiler
 * generated from rygel-http-byte-seek.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;
typedef struct _RygelHTTPSeekPrivate RygelHTTPSeekPrivate;

#define RYGEL_TYPE_HTTP_BYTE_SEEK (rygel_http_byte_seek_get_type ())
#define RYGEL_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeek))
#define RYGEL_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))
#define RYGEL_IS_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_IS_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_HTTP_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))

typedef struct _RygelHTTPByteSeek RygelHTTPByteSeek;
typedef struct _RygelHTTPByteSeekClass RygelHTTPByteSeekClass;
typedef struct _RygelHTTPByteSeekPrivate RygelHTTPByteSeekPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_IDENTITY_HANDLER (rygel_http_identity_handler_get_type ())
#define RYGEL_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandler))
#define RYGEL_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_HTTP_IDENTITY_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))

typedef struct _RygelHTTPIdentityHandler RygelHTTPIdentityHandler;
typedef struct _RygelHTTPIdentityHandlerClass RygelHTTPIdentityHandlerClass;

struct _RygelHTTPSeek {
	GObject parent_instance;
	RygelHTTPSeekPrivate * priv;
};

struct _RygelHTTPSeekClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPSeek* self);
};

struct _RygelHTTPByteSeek {
	RygelHTTPSeek parent_instance;
	RygelHTTPByteSeekPrivate * priv;
};

struct _RygelHTTPByteSeekClass {
	RygelHTTPSeekClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()
struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaItem* item;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPSeek* seek;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	gchar* mime_type;
	gchar* uri;
	gchar* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	gchar* uri;
	gchar* mime_type;
	gchar* caption_type;
	gint64 size;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};


static gpointer rygel_http_byte_seek_parent_class = NULL;

GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_http_byte_seek_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_BYTE_SEEK_DUMMY_PROPERTY
};
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_error_quark (void);
RygelHTTPByteSeek* rygel_http_byte_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
gint64 rygel_media_item_get_size (RygelMediaItem* self);
RygelHTTPSeek* rygel_http_seek_construct (GType object_type, SoupMessage* msg, gint64 start, gint64 stop, gint64 step, gint64 total_length, GError** error);
gboolean rygel_http_byte_seek_needed (RygelHTTPGet* request);
GType rygel_http_identity_handler_get_type (void) G_GNUC_CONST;
gboolean rygel_http_byte_seek_requested (RygelHTTPGet* request);
static void rygel_http_byte_seek_real_add_response_headers (RygelHTTPSeek* base);
SoupMessage* rygel_http_seek_get_msg (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_length (RygelHTTPSeek* self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, RygelHTTPGet* request, GError** error) {
	RygelHTTPByteSeek * self = NULL;
	gchar* range = NULL;
	gchar* pos = NULL;
	gchar** range_tokens = NULL;
	gint range_tokens_length1 = 0;
	gint _range_tokens_size_ = 0;
	gint64 start;
	gint64 total_length = 0LL;
	RygelHTTPGet* _tmp0_;
	RygelThumbnail* _tmp1_;
	gint64 _tmp14_;
	gint64 stop;
	RygelHTTPGet* _tmp15_;
	SoupMessage* _tmp16_;
	SoupMessageHeaders* _tmp17_;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	RygelHTTPGet* _tmp69_;
	SoupMessage* _tmp70_;
	gint64 _tmp71_;
	gint64 _tmp72_;
	gint64 _tmp73_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (request != NULL, NULL);
	start = (gint64) 0;
	_tmp0_ = request;
	_tmp1_ = _tmp0_->thumbnail;
	if (_tmp1_ != NULL) {
		RygelHTTPGet* _tmp2_;
		RygelThumbnail* _tmp3_;
		gint64 _tmp4_;
		_tmp2_ = request;
		_tmp3_ = _tmp2_->thumbnail;
		_tmp4_ = ((RygelIconInfo*) _tmp3_)->size;
		total_length = _tmp4_;
	} else {
		RygelHTTPGet* _tmp5_;
		RygelSubtitle* _tmp6_;
		_tmp5_ = request;
		_tmp6_ = _tmp5_->subtitle;
		if (_tmp6_ != NULL) {
			RygelHTTPGet* _tmp7_;
			RygelSubtitle* _tmp8_;
			gint64 _tmp9_;
			_tmp7_ = request;
			_tmp8_ = _tmp7_->subtitle;
			_tmp9_ = _tmp8_->size;
			total_length = _tmp9_;
		} else {
			RygelHTTPGet* _tmp10_;
			RygelMediaItem* _tmp11_;
			gint64 _tmp12_;
			gint64 _tmp13_;
			_tmp10_ = request;
			_tmp11_ = ((RygelHTTPRequest*) _tmp10_)->item;
			_tmp12_ = rygel_media_item_get_size (_tmp11_);
			_tmp13_ = _tmp12_;
			total_length = _tmp13_;
		}
	}
	_tmp14_ = total_length;
	stop = _tmp14_ - 1;
	_tmp15_ = request;
	_tmp16_ = ((RygelHTTPRequest*) _tmp15_)->msg;
	_tmp17_ = _tmp16_->request_headers;
	_tmp18_ = soup_message_headers_get_one (_tmp17_, "Range");
	_tmp19_ = g_strdup (_tmp18_);
	_g_free0 (range);
	range = _tmp19_;
	_tmp20_ = range;
	if (_tmp20_ != NULL) {
		const gchar* _tmp21_;
		gboolean _tmp22_ = FALSE;
		const gchar* _tmp26_;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_;
		gchar** _tmp29_;
		gchar** _tmp30_ = NULL;
		gboolean _tmp31_ = FALSE;
		gchar** _tmp32_;
		gint _tmp32__length1;
		const gchar* _tmp33_;
		gboolean _tmp36_;
		gchar** _tmp40_;
		gint _tmp40__length1;
		const gchar* _tmp41_;
		gchar* _tmp42_;
		const gchar* _tmp43_;
		gchar _tmp44_ = '\0';
		gboolean _tmp45_ = FALSE;
		gchar** _tmp52_;
		gint _tmp52__length1;
		const gchar* _tmp53_;
		gchar* _tmp54_;
		const gchar* _tmp55_;
		gchar _tmp56_ = '\0';
		gboolean _tmp57_ = FALSE;
		_tmp21_ = range;
		_tmp22_ = g_str_has_prefix (_tmp21_, "bytes=");
		if (!_tmp22_) {
			const gchar* _tmp23_ = NULL;
			const gchar* _tmp24_;
			GError* _tmp25_;
			_tmp23_ = _ ("Invalid Range '%s'");
			_tmp24_ = range;
			_tmp25_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp23_, _tmp24_);
			_inner_error_ = _tmp25_;
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
				g_propagate_error (error, _inner_error_);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (pos);
				_g_free0 (range);
				_g_object_unref0 (self);
				return NULL;
			} else {
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (pos);
				_g_free0 (range);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp26_ = range;
		_tmp27_ = string_substring (_tmp26_, (glong) 6, (glong) (-1));
		_tmp28_ = _tmp27_;
		_tmp30_ = _tmp29_ = g_strsplit (_tmp28_, "-", 2);
		range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
		range_tokens = _tmp30_;
		range_tokens_length1 = _vala_array_length (_tmp29_);
		_range_tokens_size_ = range_tokens_length1;
		_g_free0 (_tmp28_);
		_tmp32_ = range_tokens;
		_tmp32__length1 = range_tokens_length1;
		_tmp33_ = _tmp32_[0];
		if (_tmp33_ == NULL) {
			_tmp31_ = TRUE;
		} else {
			gchar** _tmp34_;
			gint _tmp34__length1;
			const gchar* _tmp35_;
			_tmp34_ = range_tokens;
			_tmp34__length1 = range_tokens_length1;
			_tmp35_ = _tmp34_[1];
			_tmp31_ = _tmp35_ == NULL;
		}
		_tmp36_ = _tmp31_;
		if (_tmp36_) {
			const gchar* _tmp37_ = NULL;
			const gchar* _tmp38_;
			GError* _tmp39_;
			_tmp37_ = _ ("Invalid Range '%s'");
			_tmp38_ = range;
			_tmp39_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp37_, _tmp38_);
			_inner_error_ = _tmp39_;
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
				g_propagate_error (error, _inner_error_);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (pos);
				_g_free0 (range);
				_g_object_unref0 (self);
				return NULL;
			} else {
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (pos);
				_g_free0 (range);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp40_ = range_tokens;
		_tmp40__length1 = range_tokens_length1;
		_tmp41_ = _tmp40_[0];
		_tmp42_ = g_strdup (_tmp41_);
		_g_free0 (pos);
		pos = _tmp42_;
		_tmp43_ = pos;
		_tmp44_ = string_get (_tmp43_, (glong) 0);
		_tmp45_ = g_ascii_isdigit (_tmp44_);
		if (_tmp45_) {
			const gchar* _tmp46_;
			gint64 _tmp47_ = 0LL;
			_tmp46_ = pos;
			_tmp47_ = int64_parse (_tmp46_);
			start = _tmp47_;
		} else {
			const gchar* _tmp48_;
			_tmp48_ = pos;
			if (g_strcmp0 (_tmp48_, "") != 0) {
				const gchar* _tmp49_ = NULL;
				const gchar* _tmp50_;
				GError* _tmp51_;
				_tmp49_ = _ ("Invalid Range '%s'");
				_tmp50_ = range;
				_tmp51_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp49_, _tmp50_);
				_inner_error_ = _tmp51_;
				if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
					g_propagate_error (error, _inner_error_);
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (pos);
					_g_free0 (range);
					_g_object_unref0 (self);
					return NULL;
				} else {
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (pos);
					_g_free0 (range);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
		_tmp52_ = range_tokens;
		_tmp52__length1 = range_tokens_length1;
		_tmp53_ = _tmp52_[1];
		_tmp54_ = g_strdup (_tmp53_);
		_g_free0 (pos);
		pos = _tmp54_;
		_tmp55_ = pos;
		_tmp56_ = string_get (_tmp55_, (glong) 0);
		_tmp57_ = g_ascii_isdigit (_tmp56_);
		if (_tmp57_) {
			const gchar* _tmp58_;
			gint64 _tmp59_ = 0LL;
			gint64 _tmp60_;
			gint64 _tmp61_;
			_tmp58_ = pos;
			_tmp59_ = int64_parse (_tmp58_);
			stop = _tmp59_;
			_tmp60_ = stop;
			_tmp61_ = start;
			if (_tmp60_ < _tmp61_) {
				const gchar* _tmp62_ = NULL;
				const gchar* _tmp63_;
				GError* _tmp64_;
				_tmp62_ = _ ("Invalid Range '%s'");
				_tmp63_ = range;
				_tmp64_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp62_, _tmp63_);
				_inner_error_ = _tmp64_;
				if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
					g_propagate_error (error, _inner_error_);
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (pos);
					_g_free0 (range);
					_g_object_unref0 (self);
					return NULL;
				} else {
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (pos);
					_g_free0 (range);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		} else {
			const gchar* _tmp65_;
			_tmp65_ = pos;
			if (g_strcmp0 (_tmp65_, "") != 0) {
				const gchar* _tmp66_ = NULL;
				const gchar* _tmp67_;
				GError* _tmp68_;
				_tmp66_ = _ ("Invalid Range '%s'");
				_tmp67_ = range;
				_tmp68_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp66_, _tmp67_);
				_inner_error_ = _tmp68_;
				if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
					g_propagate_error (error, _inner_error_);
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (pos);
					_g_free0 (range);
					_g_object_unref0 (self);
					return NULL;
				} else {
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (pos);
					_g_free0 (range);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	}
	_tmp69_ = request;
	_tmp70_ = ((RygelHTTPRequest*) _tmp69_)->msg;
	_tmp71_ = start;
	_tmp72_ = stop;
	_tmp73_ = total_length;
	self = (RygelHTTPByteSeek*) rygel_http_seek_construct (object_type, _tmp70_, _tmp71_, _tmp72_, (gint64) 1, _tmp73_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (pos);
			_g_free0 (range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (pos);
			_g_free0 (range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (pos);
	_g_free0 (range);
	return self;
}


RygelHTTPByteSeek* rygel_http_byte_seek_new (RygelHTTPGet* request, GError** error) {
	return rygel_http_byte_seek_construct (RYGEL_TYPE_HTTP_BYTE_SEEK, request, error);
}


gboolean rygel_http_byte_seek_needed (RygelHTTPGet* request) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	RygelHTTPGet* _tmp4_;
	RygelMediaItem* _tmp5_;
	gint64 _tmp6_;
	gint64 _tmp7_;
	gboolean _tmp10_;
	gboolean _tmp18_;
	gboolean _tmp26_;
	gboolean _tmp31_;
	g_return_val_if_fail (request != NULL, FALSE);
	_tmp4_ = request;
	_tmp5_ = ((RygelHTTPRequest*) _tmp4_)->item;
	_tmp6_ = rygel_media_item_get_size (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ > ((gint64) 0)) {
		RygelHTTPGet* _tmp8_;
		RygelHTTPGetHandler* _tmp9_;
		_tmp8_ = request;
		_tmp9_ = _tmp8_->handler;
		_tmp3_ = RYGEL_IS_HTTP_IDENTITY_HANDLER (_tmp9_);
	} else {
		_tmp3_ = FALSE;
	}
	_tmp10_ = _tmp3_;
	if (_tmp10_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp11_ = FALSE;
		RygelHTTPGet* _tmp12_;
		RygelThumbnail* _tmp13_;
		gboolean _tmp17_;
		_tmp12_ = request;
		_tmp13_ = _tmp12_->thumbnail;
		if (_tmp13_ != NULL) {
			RygelHTTPGet* _tmp14_;
			RygelThumbnail* _tmp15_;
			gint64 _tmp16_;
			_tmp14_ = request;
			_tmp15_ = _tmp14_->thumbnail;
			_tmp16_ = ((RygelIconInfo*) _tmp15_)->size;
			_tmp11_ = _tmp16_ > ((gint64) 0);
		} else {
			_tmp11_ = FALSE;
		}
		_tmp17_ = _tmp11_;
		_tmp2_ = _tmp17_;
	}
	_tmp18_ = _tmp2_;
	if (_tmp18_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp19_ = FALSE;
		RygelHTTPGet* _tmp20_;
		RygelSubtitle* _tmp21_;
		gboolean _tmp25_;
		_tmp20_ = request;
		_tmp21_ = _tmp20_->subtitle;
		if (_tmp21_ != NULL) {
			RygelHTTPGet* _tmp22_;
			RygelSubtitle* _tmp23_;
			gint64 _tmp24_;
			_tmp22_ = request;
			_tmp23_ = _tmp22_->subtitle;
			_tmp24_ = _tmp23_->size;
			_tmp19_ = _tmp24_ > ((gint64) 0);
		} else {
			_tmp19_ = FALSE;
		}
		_tmp25_ = _tmp19_;
		_tmp1_ = _tmp25_;
	}
	_tmp26_ = _tmp1_;
	if (_tmp26_) {
		_tmp0_ = TRUE;
	} else {
		RygelHTTPGet* _tmp27_;
		SoupMessage* _tmp28_;
		SoupMessageHeaders* _tmp29_;
		const gchar* _tmp30_ = NULL;
		_tmp27_ = request;
		_tmp28_ = ((RygelHTTPRequest*) _tmp27_)->msg;
		_tmp29_ = _tmp28_->request_headers;
		_tmp30_ = soup_message_headers_get_one (_tmp29_, "User-Agent");
		_tmp0_ = g_strcmp0 (_tmp30_, "PLAYSTATION 3") == 0;
	}
	_tmp31_ = _tmp0_;
	result = _tmp31_;
	return result;
}


gboolean rygel_http_byte_seek_requested (RygelHTTPGet* request) {
	gboolean result = FALSE;
	RygelHTTPGet* _tmp0_;
	SoupMessage* _tmp1_;
	SoupMessageHeaders* _tmp2_;
	const gchar* _tmp3_ = NULL;
	g_return_val_if_fail (request != NULL, FALSE);
	_tmp0_ = request;
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
	_tmp2_ = _tmp1_->request_headers;
	_tmp3_ = soup_message_headers_get_one (_tmp2_, "Range");
	result = _tmp3_ != NULL;
	return result;
}


static void rygel_http_byte_seek_real_add_response_headers (RygelHTTPSeek* base) {
	RygelHTTPByteSeek * self;
	gchar* _tmp0_;
	gchar* range;
	SoupMessage* _tmp1_;
	SoupMessage* _tmp2_;
	SoupMessageHeaders* _tmp3_;
	SoupMessageHeaders* headers;
	SoupMessage* _tmp4_;
	SoupMessage* _tmp5_;
	SoupMessageHeaders* _tmp6_;
	const gchar* _tmp7_ = NULL;
	SoupMessageHeaders* _tmp33_;
	gint64 _tmp34_;
	gint64 _tmp35_;
	self = (RygelHTTPByteSeek*) base;
	_tmp0_ = g_strdup ("bytes ");
	range = _tmp0_;
	_tmp1_ = rygel_http_seek_get_msg ((RygelHTTPSeek*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->response_headers;
	headers = _tmp3_;
	_tmp4_ = rygel_http_seek_get_msg ((RygelHTTPSeek*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->request_headers;
	_tmp7_ = soup_message_headers_get_one (_tmp6_, "Range");
	if (_tmp7_ != NULL) {
		SoupMessageHeaders* _tmp8_;
		const gchar* _tmp9_;
		gint64 _tmp10_;
		gint64 _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gint64 _tmp16_;
		gint64 _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gint64 _tmp24_;
		gint64 _tmp25_;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		SoupMessageHeaders* _tmp31_;
		const gchar* _tmp32_;
		_tmp8_ = headers;
		soup_message_headers_append (_tmp8_, "Accept-Ranges", "bytes");
		_tmp9_ = range;
		_tmp10_ = rygel_http_seek_get_start ((RygelHTTPSeek*) self);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp13_, "-", NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = rygel_http_seek_get_stop ((RygelHTTPSeek*) self);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp15_, _tmp19_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat (_tmp21_, "/", NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat (_tmp23_, _tmp27_, NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp9_, _tmp29_, NULL);
		_g_free0 (range);
		range = _tmp30_;
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_tmp31_ = headers;
		_tmp32_ = range;
		soup_message_headers_append (_tmp31_, "Content-Range", _tmp32_);
	}
	_tmp33_ = headers;
	_tmp34_ = rygel_http_seek_get_length ((RygelHTTPSeek*) self);
	_tmp35_ = _tmp34_;
	soup_message_headers_set_content_length (_tmp33_, _tmp35_);
	_g_free0 (range);
}


static void rygel_http_byte_seek_class_init (RygelHTTPByteSeekClass * klass) {
	rygel_http_byte_seek_parent_class = g_type_class_peek_parent (klass);
	RYGEL_HTTP_SEEK_CLASS (klass)->add_response_headers = rygel_http_byte_seek_real_add_response_headers;
}


static void rygel_http_byte_seek_instance_init (RygelHTTPByteSeek * self) {
}


GType rygel_http_byte_seek_get_type (void) {
	static volatile gsize rygel_http_byte_seek_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_byte_seek_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPByteSeekClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_byte_seek_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPByteSeek), 0, (GInstanceInitFunc) rygel_http_byte_seek_instance_init, NULL };
		GType rygel_http_byte_seek_type_id;
		rygel_http_byte_seek_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK, "RygelHTTPByteSeek", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_byte_seek_type_id__volatile, rygel_http_byte_seek_type_id);
	}
	return rygel_http_byte_seek_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



