/* rygel-mediathek-video-item-factory.c generated by valac 0.14.1, the Vala compiler
 * generated from rygel-mediathek-video-item-factory.vala, do not modify */

/*
 * Copyright (C) 2011 Jens Georg
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <rygel.h>
#include <libxml/tree.h>
#include <gee.h>
#include <libsoup/soup.h>


#define RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY (rygel_mediathek_video_item_factory_get_type ())
#define RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY, RygelMediathekVideoItemFactory))
#define RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY, RygelMediathekVideoItemFactoryClass))
#define RYGEL_MEDIATHEK_IS_VIDEO_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY))
#define RYGEL_MEDIATHEK_IS_VIDEO_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY))
#define RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY, RygelMediathekVideoItemFactoryClass))

typedef struct _RygelMediathekVideoItemFactory RygelMediathekVideoItemFactory;
typedef struct _RygelMediathekVideoItemFactoryClass RygelMediathekVideoItemFactoryClass;
typedef struct _RygelMediathekVideoItemFactoryPrivate RygelMediathekVideoItemFactoryPrivate;

#define RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER (rygel_mediathek_playlist_parser_get_type ())
#define RYGEL_MEDIATHEK_PLAYLIST_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER, RygelMediathekPlaylistParser))
#define RYGEL_MEDIATHEK_PLAYLIST_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER, RygelMediathekPlaylistParserClass))
#define RYGEL_MEDIATHEK_IS_PLAYLIST_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER))
#define RYGEL_MEDIATHEK_IS_PLAYLIST_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER))
#define RYGEL_MEDIATHEK_PLAYLIST_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER, RygelMediathekPlaylistParserClass))

typedef struct _RygelMediathekPlaylistParser RygelMediathekPlaylistParser;
typedef struct _RygelMediathekPlaylistParserClass RygelMediathekPlaylistParserClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelMediathekVideoItemFactoryCreateData RygelMediathekVideoItemFactoryCreateData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST_PARSER (rygel_mediathek_asx_playlist_parser_get_type ())
#define RYGEL_MEDIATHEK_ASX_PLAYLIST_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST_PARSER, RygelMediathekAsxPlaylistParser))
#define RYGEL_MEDIATHEK_ASX_PLAYLIST_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST_PARSER, RygelMediathekAsxPlaylistParserClass))
#define RYGEL_MEDIATHEK_IS_ASX_PLAYLIST_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST_PARSER))
#define RYGEL_MEDIATHEK_IS_ASX_PLAYLIST_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST_PARSER))
#define RYGEL_MEDIATHEK_ASX_PLAYLIST_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST_PARSER, RygelMediathekAsxPlaylistParserClass))

typedef struct _RygelMediathekAsxPlaylistParser RygelMediathekAsxPlaylistParser;
typedef struct _RygelMediathekAsxPlaylistParserClass RygelMediathekAsxPlaylistParserClass;

#define RYGEL_MEDIATHEK_TYPE_MOV_PLAYLIST_PARSER (rygel_mediathek_mov_playlist_parser_get_type ())
#define RYGEL_MEDIATHEK_MOV_PLAYLIST_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIATHEK_TYPE_MOV_PLAYLIST_PARSER, RygelMediathekMovPlaylistParser))
#define RYGEL_MEDIATHEK_MOV_PLAYLIST_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIATHEK_TYPE_MOV_PLAYLIST_PARSER, RygelMediathekMovPlaylistParserClass))
#define RYGEL_MEDIATHEK_IS_MOV_PLAYLIST_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIATHEK_TYPE_MOV_PLAYLIST_PARSER))
#define RYGEL_MEDIATHEK_IS_MOV_PLAYLIST_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIATHEK_TYPE_MOV_PLAYLIST_PARSER))
#define RYGEL_MEDIATHEK_MOV_PLAYLIST_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIATHEK_TYPE_MOV_PLAYLIST_PARSER, RygelMediathekMovPlaylistParserClass))

typedef struct _RygelMediathekMovPlaylistParser RygelMediathekMovPlaylistParser;
typedef struct _RygelMediathekMovPlaylistParserClass RygelMediathekMovPlaylistParserClass;

typedef enum  {
	RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR,
	RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_NETWORK_ERROR
} RygelMediathekVideoItemError;
#define RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR rygel_mediathek_video_item_error_quark ()
struct _RygelMediathekVideoItemFactory {
	GObject parent_instance;
	RygelMediathekVideoItemFactoryPrivate * priv;
};

struct _RygelMediathekVideoItemFactoryClass {
	GObjectClass parent_class;
};

struct _RygelMediathekVideoItemFactoryPrivate {
	RygelMediathekPlaylistParser* playlist_parser;
	gchar* video_format;
};

struct _RygelMediathekVideoItemFactoryCreateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediathekVideoItemFactory* self;
	RygelMediaContainer* parent;
	xmlNode* xml_item;
	RygelVideoItem* result;
	gchar* title;
	gchar* playlist_url;
	xmlNode* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	RygelMediathekPlaylistParser* _tmp3_;
	const gchar* _tmp4_;
	GeeList* _tmp5_;
	GeeList* resolved_uris;
	gboolean _tmp6_;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gboolean _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* id;
	const gchar* _tmp14_;
	RygelMediaContainer* _tmp15_;
	const gchar* _tmp16_;
	RygelVideoItem* _tmp17_;
	RygelVideoItem* item;
	RygelVideoItem* _tmp18_;
	RygelMediathekPlaylistParser* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	RygelVideoItem* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	RygelVideoItem* _tmp26_;
	gchar* _tmp27_;
	GeeList* _tmp28_;
	GeeList* _tmp29_;
	GeeList* _uri_list;
	GeeList* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gint _uri_size;
	gint _uri_index;
	gint _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	GeeList* _tmp36_;
	gint _tmp37_;
	gpointer _tmp38_;
	gchar* uri;
	RygelVideoItem* _tmp39_;
	const gchar* _tmp40_;
	GError * _inner_error_;
};


static gpointer rygel_mediathek_video_item_factory_parent_class = NULL;
static RygelMediathekVideoItemFactory* rygel_mediathek_video_item_factory_instance;
static RygelMediathekVideoItemFactory* rygel_mediathek_video_item_factory_instance = NULL;

GQuark rygel_mediathek_video_item_error_quark (void);
GType rygel_mediathek_video_item_factory_get_type (void) G_GNUC_CONST;
GType rygel_mediathek_playlist_parser_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY, RygelMediathekVideoItemFactoryPrivate))
enum  {
	RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_DUMMY_PROPERTY
};
#define RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_VIDEO_FORMAT_WMV "wmv"
#define RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_VIDEO_FORMAT_MP4 "mp4"
RygelMediathekVideoItemFactory* rygel_mediathek_video_item_factory_get_default (void);
static RygelMediathekVideoItemFactory* rygel_mediathek_video_item_factory_new (void);
static RygelMediathekVideoItemFactory* rygel_mediathek_video_item_factory_construct (GType object_type);
static void rygel_mediathek_video_item_factory_create_data_free (gpointer _data);
void rygel_mediathek_video_item_factory_create (RygelMediathekVideoItemFactory* self, RygelMediaContainer* parent, xmlNode* xml_item, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelVideoItem* rygel_mediathek_video_item_factory_create_finish (RygelMediathekVideoItemFactory* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_mediathek_video_item_factory_create_co (RygelMediathekVideoItemFactoryCreateData* _data_);
static void rygel_mediathek_video_item_factory_extract_data_from_xml (RygelMediathekVideoItemFactory* self, xmlNode* item, gchar** title, gchar** playlist_url, GError** error);
void rygel_mediathek_playlist_parser_parse (RygelMediathekPlaylistParser* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
GeeList* rygel_mediathek_playlist_parser_parse_finish (RygelMediathekPlaylistParser* self, GAsyncResult* _res_, GError** error);
static void rygel_mediathek_video_item_factory_create_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
const gchar* rygel_mediathek_playlist_parser_get_mime_type (RygelMediathekPlaylistParser* self);
SoupSessionAsync* rygel_mediathek_root_container_get_default_session (void);
RygelMediathekAsxPlaylistParser* rygel_mediathek_asx_playlist_parser_new (SoupSession* session);
RygelMediathekAsxPlaylistParser* rygel_mediathek_asx_playlist_parser_construct (GType object_type, SoupSession* session);
GType rygel_mediathek_asx_playlist_parser_get_type (void) G_GNUC_CONST;
RygelMediathekMovPlaylistParser* rygel_mediathek_mov_playlist_parser_new (SoupSession* session);
RygelMediathekMovPlaylistParser* rygel_mediathek_mov_playlist_parser_construct (GType object_type, SoupSession* session);
GType rygel_mediathek_mov_playlist_parser_get_type (void) G_GNUC_CONST;
static gboolean rygel_mediathek_video_item_factory_namespace_ok (RygelMediathekVideoItemFactory* self, xmlNode* node);
const gchar* rygel_mediathek_playlist_parser_get_playlist_suffix (RygelMediathekPlaylistParser* self);
static void rygel_mediathek_video_item_factory_finalize (GObject* obj);


GQuark rygel_mediathek_video_item_error_quark (void) {
	return g_quark_from_static_string ("rygel_mediathek_video_item_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediathekVideoItemFactory* rygel_mediathek_video_item_factory_get_default (void) {
	RygelMediathekVideoItemFactory* result = NULL;
	RygelMediathekVideoItemFactory* _tmp0_;
	RygelMediathekVideoItemFactory* _tmp2_;
	RygelMediathekVideoItemFactory* _tmp3_;
	_tmp0_ = rygel_mediathek_video_item_factory_instance;
	if (_tmp0_ == NULL) {
		RygelMediathekVideoItemFactory* _tmp1_;
		_tmp1_ = rygel_mediathek_video_item_factory_new ();
		_g_object_unref0 (rygel_mediathek_video_item_factory_instance);
		rygel_mediathek_video_item_factory_instance = _tmp1_;
	}
	_tmp2_ = rygel_mediathek_video_item_factory_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static void rygel_mediathek_video_item_factory_create_data_free (gpointer _data) {
	RygelMediathekVideoItemFactoryCreateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->parent);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediathekVideoItemFactoryCreateData, _data_);
}


void rygel_mediathek_video_item_factory_create (RygelMediathekVideoItemFactory* self, RygelMediaContainer* parent, xmlNode* xml_item, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediathekVideoItemFactoryCreateData* _data_;
	RygelMediathekVideoItemFactory* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelMediaContainer* _tmp2_;
	xmlNode* _tmp3_;
	_data_ = g_slice_new0 (RygelMediathekVideoItemFactoryCreateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_mediathek_video_item_factory_create);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_mediathek_video_item_factory_create_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = parent;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->parent = _tmp2_;
	_tmp3_ = xml_item;
	_data_->xml_item = _tmp3_;
	rygel_mediathek_video_item_factory_create_co (_data_);
}


RygelVideoItem* rygel_mediathek_video_item_factory_create_finish (RygelMediathekVideoItemFactory* self, GAsyncResult* _res_, GError** error) {
	RygelVideoItem* result;
	RygelMediathekVideoItemFactoryCreateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_mediathek_video_item_factory_create_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediathekVideoItemFactoryCreateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_mediathek_video_item_factory_create_co (_data_);
}


static gboolean rygel_mediathek_video_item_factory_create_co (RygelMediathekVideoItemFactoryCreateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->xml_item;
	_data_->_tmp1_ = NULL;
	_data_->_tmp2_ = NULL;
	rygel_mediathek_video_item_factory_extract_data_from_xml (_data_->self, _data_->_tmp0_, &_data_->_tmp1_, &_data_->_tmp2_, &_data_->_inner_error_);
	_g_free0 (_data_->title);
	_data_->title = _data_->_tmp1_;
	_g_free0 (_data_->playlist_url);
	_data_->playlist_url = _data_->_tmp2_;
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->playlist_url);
			_g_free0 (_data_->title);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->playlist_url);
			_g_free0 (_data_->title);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp3_ = _data_->self->priv->playlist_parser;
	_data_->_tmp4_ = _data_->playlist_url;
	_data_->_state_ = 1;
	rygel_mediathek_playlist_parser_parse (_data_->_tmp3_, _data_->_tmp4_, rygel_mediathek_video_item_factory_create_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = rygel_mediathek_playlist_parser_parse_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
	_data_->resolved_uris = _data_->_tmp5_;
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->playlist_url);
			_g_free0 (_data_->title);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->playlist_url);
			_g_free0 (_data_->title);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp7_ = _data_->resolved_uris;
	if (_data_->_tmp7_ == NULL) {
		_data_->_tmp6_ = TRUE;
	} else {
		_data_->_tmp8_ = _data_->resolved_uris;
		_data_->_tmp9_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp6_ = _data_->_tmp10_ == 0;
	}
	_data_->_tmp11_ = _data_->_tmp6_;
	if (_data_->_tmp11_) {
		_data_->result = NULL;
		_g_object_unref0 (_data_->resolved_uris);
		_g_free0 (_data_->playlist_url);
		_g_free0 (_data_->title);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->title;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _data_->_tmp12_, (gsize) (-1));
	_data_->id = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->id;
	_data_->_tmp15_ = _data_->parent;
	_data_->_tmp16_ = _data_->title;
	_data_->_tmp17_ = rygel_video_item_new (_data_->_tmp14_, _data_->_tmp15_, _data_->_tmp16_, RYGEL_VIDEO_ITEM_UPNP_CLASS);
	_data_->item = _data_->_tmp17_;
	_data_->_tmp18_ = _data_->item;
	_data_->_tmp19_ = _data_->self->priv->playlist_parser;
	_data_->_tmp20_ = rygel_mediathek_playlist_parser_get_mime_type (_data_->_tmp19_);
	_data_->_tmp21_ = _data_->_tmp20_;
	_data_->_tmp22_ = g_strdup (_data_->_tmp21_);
	_g_free0 (((RygelMediaItem*) _data_->_tmp18_)->mime_type);
	((RygelMediaItem*) _data_->_tmp18_)->mime_type = _data_->_tmp22_;
	_data_->_tmp23_ = _data_->item;
	_data_->_tmp24_ = g_strdup ("ZDF - Second German TV Channel Streams");
	_g_free0 (_data_->_tmp23_->author);
	_data_->_tmp23_->author = _data_->_tmp24_;
	_data_->_tmp25_ = _data_->self->priv->video_format;
	if (g_strcmp0 (_data_->_tmp25_, RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_VIDEO_FORMAT_WMV) == 0) {
		_data_->_tmp26_ = _data_->item;
		_data_->_tmp27_ = g_strdup ("WMVMED_FULL");
		_g_free0 (((RygelMediaItem*) _data_->_tmp26_)->dlna_profile);
		((RygelMediaItem*) _data_->_tmp26_)->dlna_profile = _data_->_tmp27_;
	}
	{
		_data_->_tmp28_ = _data_->resolved_uris;
		_data_->_tmp29_ = _g_object_ref0 (_data_->_tmp28_);
		_data_->_uri_list = _data_->_tmp29_;
		_data_->_tmp30_ = _data_->_uri_list;
		_data_->_tmp31_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp30_);
		_data_->_tmp32_ = _data_->_tmp31_;
		_data_->_uri_size = _data_->_tmp32_;
		_data_->_uri_index = -1;
		while (TRUE) {
			_data_->_tmp33_ = _data_->_uri_index;
			_data_->_uri_index = _data_->_tmp33_ + 1;
			_data_->_tmp34_ = _data_->_uri_index;
			_data_->_tmp35_ = _data_->_uri_size;
			if (!(_data_->_tmp34_ < _data_->_tmp35_)) {
				break;
			}
			_data_->_tmp36_ = _data_->_uri_list;
			_data_->_tmp37_ = _data_->_uri_index;
			_data_->_tmp38_ = NULL;
			_data_->_tmp38_ = gee_list_get (_data_->_tmp36_, _data_->_tmp37_);
			_data_->uri = (gchar*) _data_->_tmp38_;
			_data_->_tmp39_ = _data_->item;
			_data_->_tmp40_ = _data_->uri;
			rygel_media_item_add_uri ((RygelMediaItem*) _data_->_tmp39_, _data_->_tmp40_);
			_g_free0 (_data_->uri);
		}
		_g_object_unref0 (_data_->_uri_list);
	}
	_data_->result = _data_->item;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->resolved_uris);
	_g_free0 (_data_->playlist_url);
	_g_free0 (_data_->title);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->item);
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->resolved_uris);
	_g_free0 (_data_->playlist_url);
	_g_free0 (_data_->title);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static RygelMediathekVideoItemFactory* rygel_mediathek_video_item_factory_construct (GType object_type) {
	RygelMediathekVideoItemFactory * self = NULL;
	RygelMetaConfig* _tmp0_ = NULL;
	RygelMetaConfig* config;
	gchar* _tmp1_;
	const gchar* _tmp11_;
	SoupSessionAsync* _tmp12_ = NULL;
	SoupSessionAsync* session;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GQuark _tmp16_ = 0U;
	GError * _inner_error_ = NULL;
	self = (RygelMediathekVideoItemFactory*) g_object_new (object_type, NULL);
	_tmp0_ = rygel_meta_config_get_default ();
	config = _tmp0_;
	_tmp1_ = g_strdup (RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_VIDEO_FORMAT_WMV);
	_g_free0 (self->priv->video_format);
	self->priv->video_format = _tmp1_;
	{
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		gboolean _tmp9_;
		_tmp2_ = rygel_configuration_get_string ((RygelConfiguration*) config, "ZDFMediathek", "video-format", &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_g_free0 (self->priv->video_format);
		self->priv->video_format = _tmp3_;
		_tmp4_ = self->priv->video_format;
		_tmp5_ = g_utf8_casefold (_tmp4_, (gssize) (-1));
		_g_free0 (self->priv->video_format);
		self->priv->video_format = _tmp5_;
		_tmp7_ = self->priv->video_format;
		if (g_strcmp0 (_tmp7_, RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_VIDEO_FORMAT_WMV) != 0) {
			const gchar* _tmp8_;
			_tmp8_ = self->priv->video_format;
			_tmp6_ = g_strcmp0 (_tmp8_, RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_VIDEO_FORMAT_MP4) != 0;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp9_ = _tmp6_;
		if (_tmp9_) {
			gchar* _tmp10_;
			_tmp10_ = g_strdup (RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_VIDEO_FORMAT_WMV);
			_g_free0 (self->priv->video_format);
			self->priv->video_format = _tmp10_;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp11_ = self->priv->video_format;
	g_debug ("rygel-mediathek-video-item-factory.vala:89: Exposing mediathek items i" \
"n format: %s", _tmp11_);
	_tmp12_ = rygel_mediathek_root_container_get_default_session ();
	session = _tmp12_;
	_tmp13_ = self->priv->video_format;
	_tmp14_ = _tmp13_;
	_tmp16_ = (NULL == _tmp14_) ? 0 : g_quark_from_string (_tmp14_);
	if (_tmp16_ == g_quark_from_string (RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_VIDEO_FORMAT_WMV)) {
		switch (0) {
			default:
			{
				SoupSessionAsync* _tmp17_;
				RygelMediathekAsxPlaylistParser* _tmp18_;
				_tmp17_ = session;
				_tmp18_ = rygel_mediathek_asx_playlist_parser_new ((SoupSession*) _tmp17_);
				_g_object_unref0 (self->priv->playlist_parser);
				self->priv->playlist_parser = (RygelMediathekPlaylistParser*) _tmp18_;
				break;
			}
		}
	} else if (_tmp16_ == g_quark_from_string (RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_VIDEO_FORMAT_MP4)) {
		switch (0) {
			default:
			{
				SoupSessionAsync* _tmp19_;
				RygelMediathekMovPlaylistParser* _tmp20_;
				_tmp19_ = session;
				_tmp20_ = rygel_mediathek_mov_playlist_parser_new ((SoupSession*) _tmp19_);
				_g_object_unref0 (self->priv->playlist_parser);
				self->priv->playlist_parser = (RygelMediathekPlaylistParser*) _tmp20_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	_g_object_unref0 (session);
	_g_object_unref0 (config);
	return self;
}


static RygelMediathekVideoItemFactory* rygel_mediathek_video_item_factory_new (void) {
	return rygel_mediathek_video_item_factory_construct (RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY);
}


static gboolean rygel_mediathek_video_item_factory_namespace_ok (RygelMediathekVideoItemFactory* self, xmlNode* node) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	xmlNode* _tmp1_;
	xmlNs* _tmp2_;
	gboolean _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = node;
	_tmp2_ = _tmp1_->ns;
	if (_tmp2_ != NULL) {
		xmlNode* _tmp3_;
		xmlNs* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = node;
		_tmp4_ = _tmp3_->ns;
		_tmp5_ = _tmp4_->prefix;
		_tmp0_ = g_strcmp0 (_tmp5_, "media") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	result = _tmp6_;
	return result;
}


static void rygel_mediathek_video_item_factory_extract_data_from_xml (RygelMediathekVideoItemFactory* self, xmlNode* item, gchar** title, gchar** playlist_url, GError** error) {
	gchar* _vala_title = NULL;
	gchar* _vala_playlist_url = NULL;
	xmlNode* _tmp0_;
	xmlNode* _tmp1_ = NULL;
	xmlNode* title_node;
	xmlNode* _tmp2_;
	xmlNode* _tmp3_ = NULL;
	xmlNode* group;
	xmlNode* _tmp4_;
	xmlNode* _tmp6_;
	xmlNode* _tmp8_;
	gboolean _tmp9_ = FALSE;
	xmlNode* _tmp11_;
	xmlNode* _tmp12_ = NULL;
	xmlNode* content;
	xmlNode* _tmp13_;
	const gchar* _tmp35_;
	xmlNode* _tmp37_;
	gchar* _tmp38_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = item;
	_tmp1_ = rygel_xml_utils_get_element (_tmp0_, "title", NULL);
	title_node = _tmp1_;
	_tmp2_ = item;
	_tmp3_ = rygel_xml_utils_get_element (_tmp2_, "group", NULL);
	group = _tmp3_;
	_g_free0 (_vala_playlist_url);
	_vala_playlist_url = NULL;
	_tmp4_ = title_node;
	if (_tmp4_ == NULL) {
		GError* _tmp5_;
		_tmp5_ = g_error_new_literal (RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR, RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR, "No 'title' element");
		_inner_error_ = _tmp5_;
		if (_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp6_ = group;
	if (_tmp6_ == NULL) {
		GError* _tmp7_;
		_tmp7_ = g_error_new_literal (RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR, RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR, "No 'group' element");
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp8_ = group;
	_tmp9_ = rygel_mediathek_video_item_factory_namespace_ok (self, _tmp8_);
	if (!_tmp9_) {
		GError* _tmp10_;
		_tmp10_ = g_error_new_literal (RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR, RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR, "Invalid namespace");
		_inner_error_ = _tmp10_;
		if (_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp11_ = group;
	_tmp12_ = rygel_xml_utils_get_element (_tmp11_, "content", NULL);
	content = _tmp12_;
	_tmp13_ = content;
	if (_tmp13_ == NULL) {
		GError* _tmp14_;
		_tmp14_ = g_error_new_literal (RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR, RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR, "'group' has no 'content' element");
		_inner_error_ = _tmp14_;
		if (_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	while (TRUE) {
		xmlNode* _tmp15_;
		xmlNode* _tmp16_;
		xmlAttr* _tmp17_ = NULL;
		xmlAttr* url_attribute;
		gboolean _tmp18_ = FALSE;
		xmlAttr* _tmp19_;
		gboolean _tmp22_;
		xmlNode* _tmp33_;
		xmlNode* _tmp34_;
		_tmp15_ = content;
		if (!(_tmp15_ != NULL)) {
			break;
		}
		_tmp16_ = content;
		_tmp17_ = xmlHasProp (_tmp16_, "url");
		url_attribute = _tmp17_;
		_tmp19_ = url_attribute;
		if (_tmp19_ != NULL) {
			xmlNode* _tmp20_;
			gboolean _tmp21_ = FALSE;
			_tmp20_ = content;
			_tmp21_ = rygel_mediathek_video_item_factory_namespace_ok (self, _tmp20_);
			_tmp18_ = _tmp21_;
		} else {
			_tmp18_ = FALSE;
		}
		_tmp22_ = _tmp18_;
		if (_tmp22_) {
			xmlAttr* _tmp23_;
			xmlNode* _tmp24_;
			const gchar* _tmp25_;
			const gchar* url;
			const gchar* _tmp26_;
			RygelMediathekPlaylistParser* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			gboolean _tmp30_ = FALSE;
			_tmp23_ = url_attribute;
			_tmp24_ = _tmp23_->children;
			_tmp25_ = _tmp24_->content;
			url = _tmp25_;
			_tmp26_ = url;
			_tmp27_ = self->priv->playlist_parser;
			_tmp28_ = rygel_mediathek_playlist_parser_get_playlist_suffix (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_str_has_suffix (_tmp26_, _tmp29_);
			if (_tmp30_) {
				const gchar* _tmp31_;
				gchar* _tmp32_;
				_tmp31_ = url;
				_tmp32_ = g_strdup (_tmp31_);
				_g_free0 (_vala_playlist_url);
				_vala_playlist_url = _tmp32_;
				break;
			}
		}
		_tmp33_ = content;
		_tmp34_ = _tmp33_->next;
		content = _tmp34_;
	}
	_tmp35_ = _vala_playlist_url;
	if (_tmp35_ == NULL) {
		GError* _tmp36_;
		_tmp36_ = g_error_new_literal (RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR, RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR, "No URL found");
		_inner_error_ = _tmp36_;
		if (_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp37_ = title_node;
	_tmp38_ = xmlNodeGetContent (_tmp37_);
	_g_free0 (_vala_title);
	_vala_title = _tmp38_;
	if (title) {
		*title = _vala_title;
	} else {
		_g_free0 (_vala_title);
	}
	if (playlist_url) {
		*playlist_url = _vala_playlist_url;
	} else {
		_g_free0 (_vala_playlist_url);
	}
}


static void rygel_mediathek_video_item_factory_class_init (RygelMediathekVideoItemFactoryClass * klass) {
	rygel_mediathek_video_item_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediathekVideoItemFactoryPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_mediathek_video_item_factory_finalize;
}


static void rygel_mediathek_video_item_factory_instance_init (RygelMediathekVideoItemFactory * self) {
	self->priv = RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_GET_PRIVATE (self);
}


static void rygel_mediathek_video_item_factory_finalize (GObject* obj) {
	RygelMediathekVideoItemFactory * self;
	self = RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY (obj);
	_g_object_unref0 (self->priv->playlist_parser);
	_g_free0 (self->priv->video_format);
	G_OBJECT_CLASS (rygel_mediathek_video_item_factory_parent_class)->finalize (obj);
}


GType rygel_mediathek_video_item_factory_get_type (void) {
	static volatile gsize rygel_mediathek_video_item_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mediathek_video_item_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediathekVideoItemFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_mediathek_video_item_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediathekVideoItemFactory), 0, (GInstanceInitFunc) rygel_mediathek_video_item_factory_instance_init, NULL };
		GType rygel_mediathek_video_item_factory_type_id;
		rygel_mediathek_video_item_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediathekVideoItemFactory", &g_define_type_info, 0);
		g_once_init_leave (&rygel_mediathek_video_item_factory_type_id__volatile, rygel_mediathek_video_item_factory_type_id);
	}
	return rygel_mediathek_video_item_factory_type_id__volatile;
}



