/* rygel-media-export-query-container.c generated by valac 0.14.1, the Vala compiler
 * generated from rygel-media-export-query-container.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;
typedef struct _RygelMediaExportDBContainerPrivate RygelMediaExportDBContainerPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER (rygel_media_export_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainer))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))

typedef struct _RygelMediaExportQueryContainer RygelMediaExportQueryContainer;
typedef struct _RygelMediaExportQueryContainerClass RygelMediaExportQueryContainerClass;
typedef struct _RygelMediaExportQueryContainerPrivate RygelMediaExportQueryContainerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaExportQueryContainerSearchData RygelMediaExportQueryContainerSearchData;
typedef struct _RygelMediaExportQueryContainerGetChildrenData RygelMediaExportQueryContainerGetChildrenData;

struct _RygelMediaExportDBContainer {
	RygelMediaContainer parent_instance;
	RygelMediaExportDBContainerPrivate * priv;
	RygelMediaExportMediaCache* media_db;
};

struct _RygelMediaExportDBContainerClass {
	RygelMediaContainerClass parent_class;
	void (*search) (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelMediaExportDBContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelMediaExportQueryContainer {
	RygelMediaExportDBContainer parent_instance;
	RygelMediaExportQueryContainerPrivate * priv;
	gchar* plaintext_id;
};

struct _RygelMediaExportQueryContainerClass {
	RygelMediaExportDBContainerClass parent_class;
};

struct _RygelMediaExportQueryContainerPrivate {
	gchar* attribute;
	RygelSearchExpression* expression;
	gchar* pattern;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH
} RygelMediaExportMediaCacheError;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR rygel_media_export_media_cache_error_quark ()
struct _RygelMediaExportQueryContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportQueryContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* children;
	RygelSearchExpression* combined_expression;
	RygelSearchExpression* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	RygelLogicalExpression* _tmp3_;
	RygelLogicalExpression* local_expression;
	RygelLogicalExpression* _tmp4_;
	RygelSearchExpression* _tmp5_;
	RygelSearchExpression* _tmp6_;
	RygelLogicalExpression* _tmp7_;
	RygelLogicalExpression* _tmp8_;
	RygelSearchExpression* _tmp9_;
	RygelSearchExpression* _tmp10_;
	RygelLogicalExpression* _tmp11_;
	RygelSearchExpression* _tmp12_;
	RygelMediaExportMediaCache* _tmp13_;
	RygelSearchExpression* _tmp14_;
	guint _tmp15_;
	guint _tmp16_;
	guint _tmp17_;
	RygelMediaObjects* _tmp18_;
	RygelMediaObjects* _tmp19_;
	GError* _error_;
	GError* _tmp20_;
	RygelMediaObjects* _tmp21_;
	GError* _tmp22_;
	GError* _tmp23_;
	GError * _inner_error_;
};

struct _RygelMediaExportQueryContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportQueryContainer* self;
	guint offset;
	guint max_count;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* children;
	const gchar* _tmp0_;
	guint total_matches;
	RygelSearchExpression* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	GCancellable* _tmp4_;
	guint _tmp5_;
	RygelMediaObjects* _tmp6_;
	RygelMediaObjects* _tmp7_;
	RygelMediaObjects* _tmp8_;
	RygelMediaExportMediaCache* _tmp9_;
	const gchar* _tmp10_;
	RygelSearchExpression* _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	GeeList* _tmp14_;
	GeeList* data;
	GeeList* _tmp15_;
	GeeList* _tmp16_;
	GeeList* _meta_data_list;
	GeeList* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _meta_data_size;
	gint _meta_data_index;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GeeList* _tmp23_;
	gint _tmp24_;
	gpointer _tmp25_;
	gchar* meta_data;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* new_id;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	RygelMediaExportMediaCache* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	RygelMediaExportQueryContainer* _tmp34_;
	RygelMediaExportQueryContainer* container;
	RygelMediaObjects* _tmp35_;
	RygelMediaExportQueryContainer* _tmp36_;
	RygelMediaObjects* _tmp37_;
	RygelMediaObjects* _tmp38_;
	RygelMediaObjects* _child_list;
	RygelMediaObjects* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	gint _child_size;
	gint _child_index;
	gint _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	RygelMediaObjects* _tmp45_;
	gint _tmp46_;
	gpointer _tmp47_;
	RygelMediaObject* child;
	RygelMediaObject* _tmp48_;
	GError * _inner_error_;
};


static gpointer rygel_media_export_query_container_parent_class = NULL;
static GeeHashMap* rygel_media_export_query_container_virtual_container_map;
static GeeHashMap* rygel_media_export_query_container_virtual_container_map = NULL;

GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_query_container_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "virtual-container:"
RygelMediaExportQueryContainer* rygel_media_export_query_container_new (RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* name);
RygelMediaExportQueryContainer* rygel_media_export_query_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* name);
RygelMediaExportDBContainer* rygel_media_export_db_container_new (RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title);
RygelMediaExportDBContainer* rygel_media_export_db_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title);
gchar* rygel_media_export_query_container_get_virtual_container_definition (const gchar* hash);
static void rygel_media_export_query_container_update_search_expression (RygelMediaExportQueryContainer* self, const gchar* op1_, const gchar* op2);
static gint rygel_media_export_query_container_count_children (RygelMediaExportQueryContainer* self);
glong rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, GError** error);
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "Filesystem"
GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const gchar* attribute, RygelSearchExpression* expression, glong offset, guint max_count, GError** error);
static void rygel_media_export_query_container_real_search_data_free (gpointer _data);
static void rygel_media_export_query_container_real_search (RygelMediaExportDBContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_query_container_real_search_co (RygelMediaExportQueryContainerSearchData* _data_);
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, guint offset, guint max_count, guint* total_matches, GError** error);
GQuark rygel_media_export_media_cache_error_quark (void);
static void rygel_media_export_query_container_real_get_children_data_free (gpointer _data);
static void rygel_media_export_query_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_query_container_real_get_children_co (RygelMediaExportQueryContainerGetChildrenData* _data_);
void rygel_media_export_db_container_search (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_export_db_container_search_finish (RygelMediaExportDBContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_media_export_query_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_export_query_container_register_id (gchar** id);
static void rygel_media_export_query_container_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch36_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch36_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally36;
	__catch36_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally36:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


RygelMediaExportQueryContainer* rygel_media_export_query_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* name) {
	RygelMediaExportQueryContainer * self = NULL;
	RygelMediaExportMediaCache* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_ = NULL;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	gint i;
	gint _tmp31_ = 0;
	g_return_val_if_fail (media_db != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = media_db;
	_tmp1_ = id;
	_tmp2_ = name;
	self = (RygelMediaExportQueryContainer*) rygel_media_export_db_container_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = id;
	_tmp4_ = rygel_media_export_query_container_get_virtual_container_definition (_tmp3_);
	_g_free0 (self->plaintext_id);
	self->plaintext_id = _tmp4_;
	_tmp5_ = self->plaintext_id;
	g_debug ("rygel-media-export-query-container.vala:57: plaintext ID is: %s", _tmp5_);
	_tmp6_ = self->plaintext_id;
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, ",", 0);
	args = _tmp8_;
	args_length1 = _vala_array_length (_tmp7_);
	_args_size_ = args_length1;
	if ((args_length1 % 2) != 0) {
		g_assert_not_reached ();
	}
	i = 0;
	while (TRUE) {
		gint _tmp9_;
		gint _tmp10_;
		const gchar* _tmp11_;
		gint _tmp30_;
		_tmp9_ = i;
		if (!(_tmp9_ < args_length1)) {
			break;
		}
		_tmp10_ = i;
		_tmp11_ = args[_tmp10_ + 1];
		if (g_strcmp0 (_tmp11_, "?") != 0) {
			gint _tmp12_;
			const gchar* _tmp13_;
			gint _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp12_ = i;
			_tmp13_ = args[_tmp12_];
			_tmp14_ = i;
			_tmp15_ = args[_tmp14_ + 1];
			rygel_media_export_query_container_update_search_expression (self, _tmp13_, _tmp15_);
			_tmp16_ = name;
			if (g_strcmp0 (_tmp16_, "") == 0) {
				gint _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
				_tmp17_ = i;
				_tmp18_ = args[_tmp17_ + 1];
				_tmp19_ = g_uri_unescape_string (_tmp18_, NULL);
				_tmp20_ = _tmp19_;
				rygel_media_object_set_title ((RygelMediaObject*) self, _tmp20_);
				_g_free0 (_tmp20_);
			}
		} else {
			gint _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gint _tmp24_;
			const gchar* _tmp25_;
			gchar* _tmp26_ = NULL;
			const gchar* _tmp27_;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
			_tmp21_ = i;
			_tmp22_ = g_strdup ("%s");
			_g_free0 (args[_tmp21_ + 1]);
			args[_tmp21_ + 1] = _tmp22_;
			_tmp23_ = args[_tmp21_ + 1];
			_tmp24_ = i;
			_tmp25_ = args[_tmp24_];
			_tmp26_ = string_replace (_tmp25_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
			_g_free0 (self->priv->attribute);
			self->priv->attribute = _tmp26_;
			_tmp27_ = self->priv->attribute;
			_tmp28_ = g_uri_unescape_string (_tmp27_, NULL);
			_g_free0 (self->priv->attribute);
			self->priv->attribute = _tmp28_;
			_tmp29_ = g_strjoinv (",", args);
			_g_free0 (self->priv->pattern);
			self->priv->pattern = _tmp29_;
			break;
		}
		_tmp30_ = i;
		i = _tmp30_ + 2;
	}
	_tmp31_ = rygel_media_export_query_container_count_children (self);
	((RygelMediaContainer*) self)->child_count = _tmp31_;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


RygelMediaExportQueryContainer* rygel_media_export_query_container_new (RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* name) {
	return rygel_media_export_query_container_construct (RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, media_db, id, name);
}


static gint rygel_media_export_query_container_count_children (RygelMediaExportQueryContainer* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	{
		const gchar* _tmp0_;
		_tmp0_ = self->priv->pattern;
		if (g_strcmp0 (_tmp0_, "") == 0) {
			RygelMediaExportMediaCache* _tmp1_;
			RygelSearchExpression* _tmp2_;
			glong _tmp3_ = 0L;
			glong _tmp4_;
			_tmp1_ = ((RygelMediaExportDBContainer*) self)->media_db;
			_tmp2_ = self->priv->expression;
			_tmp3_ = rygel_media_export_media_cache_get_object_count_by_search_expression (_tmp1_, _tmp2_, RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				goto __catch37_g_error;
			}
			result = (gint) _tmp4_;
			return result;
		} else {
			RygelMediaExportMediaCache* _tmp5_;
			const gchar* _tmp6_;
			RygelSearchExpression* _tmp7_;
			GeeList* _tmp8_ = NULL;
			GeeList* data;
			GeeList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp5_ = ((RygelMediaExportDBContainer*) self)->media_db;
			_tmp6_ = self->priv->attribute;
			_tmp7_ = self->priv->expression;
			_tmp8_ = rygel_media_export_media_cache_get_object_attribute_by_search_expression (_tmp5_, _tmp6_, _tmp7_, (glong) 0, (guint) (-1), &_inner_error_);
			data = _tmp8_;
			if (_inner_error_ != NULL) {
				goto __catch37_g_error;
			}
			_tmp9_ = data;
			_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			result = _tmp11_;
			_g_object_unref0 (data);
			return result;
		}
	}
	goto __finally37;
	__catch37_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = 0;
		_g_error_free0 (e);
		return result;
	}
	__finally37:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


static void rygel_media_export_query_container_real_search_data_free (gpointer _data) {
	RygelMediaExportQueryContainerSearchData* _data_;
	_data_ = _data;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportQueryContainerSearchData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static void rygel_media_export_query_container_real_search (RygelMediaExportDBContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportQueryContainer * self;
	RygelMediaExportQueryContainerSearchData* _data_;
	RygelMediaExportQueryContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	self = (RygelMediaExportQueryContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportQueryContainerSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_query_container_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_query_container_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = expression;
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
	_data_->expression = _tmp2_;
	_tmp3_ = offset;
	_data_->offset = _tmp3_;
	_tmp4_ = max_count;
	_data_->max_count = _tmp4_;
	_tmp5_ = cancellable;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_data_->cancellable = _tmp6_;
	rygel_media_export_query_container_real_search_co (_data_);
}


static RygelMediaObjects* rygel_media_export_query_container_real_search_finish (RygelMediaExportDBContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelMediaExportQueryContainerSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean rygel_media_export_query_container_real_search_co (RygelMediaExportQueryContainerSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->children = NULL;
	_data_->_tmp0_ = _data_->expression;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = _data_->self->priv->expression;
		_data_->_tmp2_ = _rygel_search_expression_ref0 (_data_->_tmp1_);
		_rygel_search_expression_unref0 (_data_->combined_expression);
		_data_->combined_expression = _data_->_tmp2_;
	} else {
		_data_->_tmp3_ = rygel_logical_expression_new ();
		_data_->local_expression = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->local_expression;
		_data_->_tmp5_ = _data_->self->priv->expression;
		_data_->_tmp6_ = _rygel_search_expression_ref0 (_data_->_tmp5_);
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _data_->_tmp4_)->operand1);
		((RygelSearchExpression*) _data_->_tmp4_)->operand1 = _data_->_tmp6_;
		_data_->_tmp7_ = _data_->local_expression;
		((RygelSearchExpression*) _data_->_tmp7_)->op = GINT_TO_POINTER (RYGEL_LOGICAL_OPERATOR_AND);
		_data_->_tmp8_ = _data_->local_expression;
		_data_->_tmp9_ = _data_->expression;
		_data_->_tmp10_ = _rygel_search_expression_ref0 (_data_->_tmp9_);
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _data_->_tmp8_)->operand2);
		((RygelSearchExpression*) _data_->_tmp8_)->operand2 = _data_->_tmp10_;
		_data_->_tmp11_ = _data_->local_expression;
		_data_->_tmp12_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _data_->_tmp11_);
		_rygel_search_expression_unref0 (_data_->combined_expression);
		_data_->combined_expression = _data_->_tmp12_;
		_rygel_search_expression_unref0 (_data_->local_expression);
	}
	{
		_data_->_tmp13_ = ((RygelMediaExportDBContainer*) _data_->self)->media_db;
		_data_->_tmp14_ = _data_->combined_expression;
		_data_->_tmp15_ = _data_->offset;
		_data_->_tmp16_ = _data_->max_count;
		_data_->_tmp17_ = 0U;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = rygel_media_export_media_cache_get_objects_by_search_expression (_data_->_tmp13_, _data_->_tmp14_, RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID, _data_->_tmp15_, _data_->_tmp16_, &_data_->_tmp17_, &_data_->_inner_error_);
		_data_->total_matches = _data_->_tmp17_;
		_data_->_tmp19_ = _data_->_tmp18_;
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR) {
				goto __catch38_rygel_media_export_media_cache_error;
			}
			goto __finally38;
		}
		_g_object_unref0 (_data_->children);
		_data_->children = _data_->_tmp19_;
	}
	goto __finally38;
	__catch38_rygel_media_export_media_cache_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp20_ = _data_->_error_;
		if (g_error_matches (_data_->_tmp20_, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH)) {
			_data_->_tmp21_ = rygel_media_objects_new ();
			_g_object_unref0 (_data_->children);
			_data_->children = _data_->_tmp21_;
			_data_->total_matches = (guint) 0;
		} else {
			_data_->_tmp22_ = _data_->_error_;
			_data_->_tmp23_ = _g_error_copy0 (_data_->_tmp22_);
			_data_->_inner_error_ = _data_->_tmp23_;
			_g_error_free0 (_data_->_error_);
			goto __finally38;
		}
		_g_error_free0 (_data_->_error_);
	}
	__finally38:
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_rygel_search_expression_unref0 (_data_->combined_expression);
		_g_object_unref0 (_data_->children);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->children;
	_rygel_search_expression_unref0 (_data_->combined_expression);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_rygel_search_expression_unref0 (_data_->combined_expression);
	_g_object_unref0 (_data_->children);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_media_export_query_container_real_get_children_data_free (gpointer _data) {
	RygelMediaExportQueryContainerGetChildrenData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportQueryContainerGetChildrenData, _data_);
}


static void rygel_media_export_query_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportQueryContainer * self;
	RygelMediaExportQueryContainerGetChildrenData* _data_;
	RygelMediaExportQueryContainer* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	self = (RygelMediaExportQueryContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportQueryContainerGetChildrenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_query_container_real_get_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_query_container_real_get_children_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = offset;
	_data_->offset = _tmp1_;
	_tmp2_ = max_count;
	_data_->max_count = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->cancellable = _tmp4_;
	rygel_media_export_query_container_real_get_children_co (_data_);
}


static RygelMediaObjects* rygel_media_export_query_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelMediaExportQueryContainerGetChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_export_query_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportQueryContainerGetChildrenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_query_container_real_get_children_co (_data_);
}


static gboolean rygel_media_export_query_container_real_get_children_co (RygelMediaExportQueryContainerGetChildrenData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->pattern;
	if (g_strcmp0 (_data_->_tmp0_, "") == 0) {
		_data_->_tmp1_ = _data_->self->priv->expression;
		_data_->_tmp2_ = _data_->offset;
		_data_->_tmp3_ = _data_->max_count;
		_data_->_tmp4_ = _data_->cancellable;
		_data_->_tmp5_ = 0U;
		_data_->_state_ = 1;
		rygel_media_export_db_container_search ((RygelMediaExportDBContainer*) _data_->self, _data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, rygel_media_export_query_container_get_children_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = rygel_media_export_db_container_search_finish ((RygelMediaExportDBContainer*) _data_->self, _data_->_res_, &_data_->_tmp5_, &_data_->_inner_error_);
		_data_->total_matches = _data_->_tmp5_;
		_data_->_tmp7_ = _data_->_tmp6_;
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->children);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->children);
		_data_->children = _data_->_tmp7_;
	} else {
		_data_->_tmp8_ = rygel_media_objects_new ();
		_g_object_unref0 (_data_->children);
		_data_->children = _data_->_tmp8_;
		_data_->_tmp9_ = ((RygelMediaExportDBContainer*) _data_->self)->media_db;
		_data_->_tmp10_ = _data_->self->priv->attribute;
		_data_->_tmp11_ = _data_->self->priv->expression;
		_data_->_tmp12_ = _data_->offset;
		_data_->_tmp13_ = _data_->max_count;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = rygel_media_export_media_cache_get_object_attribute_by_search_expression (_data_->_tmp9_, _data_->_tmp10_, _data_->_tmp11_, (glong) _data_->_tmp12_, _data_->_tmp13_, &_data_->_inner_error_);
		_data_->data = _data_->_tmp14_;
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->children);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		{
			_data_->_tmp15_ = _data_->data;
			_data_->_tmp16_ = _g_object_ref0 (_data_->_tmp15_);
			_data_->_meta_data_list = _data_->_tmp16_;
			_data_->_tmp17_ = _data_->_meta_data_list;
			_data_->_tmp18_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp17_);
			_data_->_tmp19_ = _data_->_tmp18_;
			_data_->_meta_data_size = _data_->_tmp19_;
			_data_->_meta_data_index = -1;
			while (TRUE) {
				_data_->_tmp20_ = _data_->_meta_data_index;
				_data_->_meta_data_index = _data_->_tmp20_ + 1;
				_data_->_tmp21_ = _data_->_meta_data_index;
				_data_->_tmp22_ = _data_->_meta_data_size;
				if (!(_data_->_tmp21_ < _data_->_tmp22_)) {
					break;
				}
				_data_->_tmp23_ = _data_->_meta_data_list;
				_data_->_tmp24_ = _data_->_meta_data_index;
				_data_->_tmp25_ = NULL;
				_data_->_tmp25_ = gee_list_get (_data_->_tmp23_, _data_->_tmp24_);
				_data_->meta_data = (gchar*) _data_->_tmp25_;
				_data_->_tmp26_ = _data_->meta_data;
				_data_->_tmp27_ = NULL;
				_data_->_tmp27_ = g_uri_escape_string (_data_->_tmp26_, "", TRUE);
				_data_->new_id = _data_->_tmp27_;
				_data_->_tmp28_ = _data_->self->priv->pattern;
				_data_->_tmp29_ = _data_->new_id;
				_data_->_tmp30_ = NULL;
				_data_->_tmp30_ = string_replace (_data_->_tmp28_, "%s", _data_->_tmp29_);
				_g_free0 (_data_->new_id);
				_data_->new_id = _data_->_tmp30_;
				rygel_media_export_query_container_register_id (&_data_->new_id);
				_data_->_tmp31_ = ((RygelMediaExportDBContainer*) _data_->self)->media_db;
				_data_->_tmp32_ = _data_->new_id;
				_data_->_tmp33_ = _data_->meta_data;
				_data_->_tmp34_ = rygel_media_export_query_container_new (_data_->_tmp31_, _data_->_tmp32_, _data_->_tmp33_);
				_data_->container = _data_->_tmp34_;
				_data_->_tmp35_ = _data_->children;
				_data_->_tmp36_ = _data_->container;
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp35_, (RygelMediaObject*) _data_->_tmp36_);
				_g_object_unref0 (_data_->container);
				_g_free0 (_data_->new_id);
				_g_free0 (_data_->meta_data);
			}
			_g_object_unref0 (_data_->_meta_data_list);
		}
		_g_object_unref0 (_data_->data);
	}
	{
		_data_->_tmp37_ = _data_->children;
		_data_->_tmp38_ = _g_object_ref0 (_data_->_tmp37_);
		_data_->_child_list = _data_->_tmp38_;
		_data_->_tmp39_ = _data_->_child_list;
		_data_->_tmp40_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp39_);
		_data_->_tmp41_ = _data_->_tmp40_;
		_data_->_child_size = _data_->_tmp41_;
		_data_->_child_index = -1;
		while (TRUE) {
			_data_->_tmp42_ = _data_->_child_index;
			_data_->_child_index = _data_->_tmp42_ + 1;
			_data_->_tmp43_ = _data_->_child_index;
			_data_->_tmp44_ = _data_->_child_size;
			if (!(_data_->_tmp43_ < _data_->_tmp44_)) {
				break;
			}
			_data_->_tmp45_ = _data_->_child_list;
			_data_->_tmp46_ = _data_->_child_index;
			_data_->_tmp47_ = NULL;
			_data_->_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp45_, _data_->_tmp46_);
			_data_->child = (RygelMediaObject*) _data_->_tmp47_;
			_data_->_tmp48_ = _data_->child;
			_data_->_tmp48_->parent = (RygelMediaContainer*) _data_->self;
			_g_object_unref0 (_data_->child);
		}
		_g_object_unref0 (_data_->_child_list);
	}
	_data_->result = _data_->children;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->children);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void rygel_media_export_query_container_register_id (gchar** id) {
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* md5;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_if_fail (id != NULL);
	_tmp0_ = *id;
	_tmp1_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp0_, (gsize) (-1));
	md5 = _tmp1_;
	_tmp2_ = rygel_media_export_query_container_virtual_container_map;
	if (_tmp2_ == NULL) {
		GeeHashMap* _tmp3_;
		_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
		_g_object_unref0 (rygel_media_export_query_container_virtual_container_map);
		rygel_media_export_query_container_virtual_container_map = _tmp3_;
	}
	_tmp4_ = rygel_media_export_query_container_virtual_container_map;
	_tmp5_ = md5;
	_tmp6_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp4_, _tmp5_);
	if (!_tmp6_) {
		GeeHashMap* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp7_ = rygel_media_export_query_container_virtual_container_map;
		_tmp8_ = md5;
		_tmp9_ = *id;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp7_, _tmp8_, _tmp9_);
		_tmp10_ = md5;
		_tmp11_ = *id;
		g_debug ("rygel-media-export-query-container.vala:191: Registering %s for %s", _tmp10_, _tmp11_);
	}
	_tmp12_ = md5;
	_tmp13_ = g_strconcat (RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, _tmp12_, NULL);
	_g_free0 (*id);
	*id = _tmp13_;
	_g_free0 (md5);
}


gchar* rygel_media_export_query_container_get_virtual_container_definition (const gchar* hash) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* id;
	gboolean _tmp2_ = FALSE;
	GeeHashMap* _tmp3_;
	gboolean _tmp7_;
	g_return_val_if_fail (hash != NULL, NULL);
	_tmp0_ = hash;
	_tmp1_ = string_replace (_tmp0_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
	id = _tmp1_;
	_tmp3_ = rygel_media_export_query_container_virtual_container_map;
	if (_tmp3_ != NULL) {
		GeeHashMap* _tmp4_;
		const gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = rygel_media_export_query_container_virtual_container_map;
		_tmp5_ = id;
		_tmp6_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp4_, _tmp5_);
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		GeeHashMap* _tmp8_;
		const gchar* _tmp9_;
		gpointer _tmp10_ = NULL;
		_tmp8_ = rygel_media_export_query_container_virtual_container_map;
		_tmp9_ = id;
		_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, _tmp9_);
		result = (gchar*) _tmp10_;
		_g_free0 (id);
		return result;
	}
	result = NULL;
	_g_free0 (id);
	return result;
}


static void rygel_media_export_query_container_update_search_expression (RygelMediaExportQueryContainer* self, const gchar* op1_, const gchar* op2) {
	RygelRelationalExpression* _tmp0_;
	RygelRelationalExpression* exp;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* op1;
	RygelRelationalExpression* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	RygelRelationalExpression* _tmp6_;
	RygelRelationalExpression* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	RygelSearchExpression* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op1_ != NULL);
	g_return_if_fail (op2 != NULL);
	_tmp0_ = rygel_relational_expression_new ();
	exp = _tmp0_;
	_tmp1_ = op1_;
	_tmp2_ = string_replace (_tmp1_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
	op1 = _tmp2_;
	_tmp3_ = exp;
	_tmp4_ = op1;
	_tmp5_ = g_uri_unescape_string (_tmp4_, NULL);
	_g_free0 (((RygelSearchExpression*) _tmp3_)->operand1);
	((RygelSearchExpression*) _tmp3_)->operand1 = _tmp5_;
	_tmp6_ = exp;
	((RygelSearchExpression*) _tmp6_)->op = GINT_TO_POINTER (GUPNP_SEARCH_CRITERIA_OP_EQ);
	_tmp7_ = exp;
	_tmp8_ = op2;
	_tmp9_ = g_uri_unescape_string (_tmp8_, NULL);
	_g_free0 (((RygelSearchExpression*) _tmp7_)->operand2);
	((RygelSearchExpression*) _tmp7_)->operand2 = _tmp9_;
	_tmp10_ = self->priv->expression;
	if (_tmp10_ != NULL) {
		RygelLogicalExpression* _tmp11_;
		RygelLogicalExpression* exp2;
		RygelLogicalExpression* _tmp12_;
		RygelSearchExpression* _tmp13_;
		RygelSearchExpression* _tmp14_;
		RygelLogicalExpression* _tmp15_;
		RygelRelationalExpression* _tmp16_;
		RygelSearchExpression* _tmp17_;
		RygelLogicalExpression* _tmp18_;
		RygelLogicalExpression* _tmp19_;
		RygelSearchExpression* _tmp20_;
		_tmp11_ = rygel_logical_expression_new ();
		exp2 = _tmp11_;
		_tmp12_ = exp2;
		_tmp13_ = self->priv->expression;
		_tmp14_ = _rygel_search_expression_ref0 (_tmp13_);
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp12_)->operand1);
		((RygelSearchExpression*) _tmp12_)->operand1 = _tmp14_;
		_tmp15_ = exp2;
		_tmp16_ = exp;
		_tmp17_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _tmp16_);
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp15_)->operand2);
		((RygelSearchExpression*) _tmp15_)->operand2 = _tmp17_;
		_tmp18_ = exp2;
		((RygelSearchExpression*) _tmp18_)->op = GINT_TO_POINTER (RYGEL_LOGICAL_OPERATOR_AND);
		_tmp19_ = exp2;
		_tmp20_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _tmp19_);
		_rygel_search_expression_unref0 (self->priv->expression);
		self->priv->expression = _tmp20_;
		_rygel_search_expression_unref0 (exp2);
	} else {
		RygelRelationalExpression* _tmp21_;
		RygelSearchExpression* _tmp22_;
		_tmp21_ = exp;
		_tmp22_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _tmp21_);
		_rygel_search_expression_unref0 (self->priv->expression);
		self->priv->expression = _tmp22_;
	}
	_g_free0 (op1);
	_rygel_search_expression_unref0 (exp);
}


static void rygel_media_export_query_container_class_init (RygelMediaExportQueryContainerClass * klass) {
	rygel_media_export_query_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportQueryContainerPrivate));
	RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (klass)->search = rygel_media_export_query_container_real_search;
	RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (klass)->search_finish = rygel_media_export_query_container_real_search_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_media_export_query_container_real_get_children;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_media_export_query_container_real_get_children_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_query_container_finalize;
}


static void rygel_media_export_query_container_instance_init (RygelMediaExportQueryContainer * self) {
	gchar* _tmp0_;
	self->priv = RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->pattern = _tmp0_;
}


static void rygel_media_export_query_container_finalize (GObject* obj) {
	RygelMediaExportQueryContainer * self;
	self = RYGEL_MEDIA_EXPORT_QUERY_CONTAINER (obj);
	_g_free0 (self->priv->attribute);
	_rygel_search_expression_unref0 (self->priv->expression);
	_g_free0 (self->plaintext_id);
	_g_free0 (self->priv->pattern);
	G_OBJECT_CLASS (rygel_media_export_query_container_parent_class)->finalize (obj);
}


GType rygel_media_export_query_container_get_type (void) {
	static volatile gsize rygel_media_export_query_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_query_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportQueryContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_query_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportQueryContainer), 0, (GInstanceInitFunc) rygel_media_export_query_container_instance_init, NULL };
		GType rygel_media_export_query_container_type_id;
		rygel_media_export_query_container_type_id = g_type_register_static (RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, "RygelMediaExportQueryContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_query_container_type_id__volatile, rygel_media_export_query_container_type_id);
	}
	return rygel_media_export_query_container_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



