/* rygel-media-export-object-factory.c generated by valac 0.14.1, the Vala compiler
 * generated from rygel-media-export-object-factory.vala, do not modify */

/*
 * Copyright (C) 2010 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel.h>


#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY (rygel_media_export_object_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactory))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))

typedef struct _RygelMediaExportObjectFactory RygelMediaExportObjectFactory;
typedef struct _RygelMediaExportObjectFactoryClass RygelMediaExportObjectFactoryClass;
typedef struct _RygelMediaExportObjectFactoryPrivate RygelMediaExportObjectFactoryPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER (rygel_media_export_root_container_get_type ())
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainer))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerClass))

typedef struct _RygelMediaExportRootContainer RygelMediaExportRootContainer;
typedef struct _RygelMediaExportRootContainerClass RygelMediaExportRootContainerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER (rygel_media_export_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainer))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))

typedef struct _RygelMediaExportQueryContainer RygelMediaExportQueryContainer;
typedef struct _RygelMediaExportQueryContainerClass RygelMediaExportQueryContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER (rygel_media_export_writable_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_WRITABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER, RygelMediaExportWritableDbContainer))
#define RYGEL_MEDIA_EXPORT_WRITABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER, RygelMediaExportWritableDbContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_WRITABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_WRITABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_WRITABLE_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER, RygelMediaExportWritableDbContainerClass))

typedef struct _RygelMediaExportWritableDbContainer RygelMediaExportWritableDbContainer;
typedef struct _RygelMediaExportWritableDbContainerClass RygelMediaExportWritableDbContainerClass;

struct _RygelMediaExportObjectFactory {
	GObject parent_instance;
	RygelMediaExportObjectFactoryPrivate * priv;
};

struct _RygelMediaExportObjectFactoryClass {
	GObjectClass parent_class;
	RygelMediaExportDBContainer* (*get_container) (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title, guint child_count, const gchar* uri);
	RygelMediaItem* (*get_item) (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, RygelMediaContainer* parent, const gchar* id, const gchar* title, const gchar* upnp_class);
};


static gpointer rygel_media_export_object_factory_parent_class = NULL;

GType rygel_media_export_object_factory_get_type (void) G_GNUC_CONST;
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_DUMMY_PROPERTY
};
RygelMediaExportDBContainer* rygel_media_export_object_factory_get_container (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title, guint child_count, const gchar* uri);
static RygelMediaExportDBContainer* rygel_media_export_object_factory_real_get_container (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title, guint child_count, const gchar* uri);
RygelMediaContainer* rygel_media_export_root_container_get_instance (GError** error);
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "Filesystem"
GType rygel_media_export_root_container_get_type (void) G_GNUC_CONST;
RygelMediaContainer* rygel_media_export_root_container_get_filesystem_container (RygelMediaExportRootContainer* self);
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "virtual-container:"
RygelMediaExportQueryContainer* rygel_media_export_query_container_new (RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* name);
RygelMediaExportQueryContainer* rygel_media_export_query_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* name);
GType rygel_media_export_query_container_get_type (void) G_GNUC_CONST;
RygelMediaExportDBContainer* rygel_media_export_db_container_new (RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title);
RygelMediaExportDBContainer* rygel_media_export_db_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title);
RygelMediaExportWritableDbContainer* rygel_media_export_writable_db_container_new (RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title);
RygelMediaExportWritableDbContainer* rygel_media_export_writable_db_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title);
GType rygel_media_export_writable_db_container_get_type (void) G_GNUC_CONST;
RygelMediaItem* rygel_media_export_object_factory_get_item (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, RygelMediaContainer* parent, const gchar* id, const gchar* title, const gchar* upnp_class);
static RygelMediaItem* rygel_media_export_object_factory_real_get_item (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, RygelMediaContainer* parent, const gchar* id, const gchar* title, const gchar* upnp_class);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_new (void);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_construct (GType object_type);


/**
     * Return a new instance of DBContainer
     *
     * @param media_db instance of MediaDB
     * @param title title of the container
     * @param child_count number of children in the container
     */
static RygelMediaExportDBContainer* rygel_media_export_object_factory_real_get_container (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title, guint child_count, const gchar* uri) {
	RygelMediaExportDBContainer* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp8_;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp14_;
	RygelMediaExportMediaCache* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	RygelMediaExportWritableDbContainer* _tmp22_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (media_db != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = id;
	if (g_strcmp0 (_tmp0_, "0") == 0) {
		{
			RygelMediaContainer* _tmp1_ = NULL;
			RygelMediaContainer* _tmp2_;
			_tmp1_ = rygel_media_export_root_container_get_instance (&_inner_error_);
			_tmp2_ = _tmp1_;
			if (_inner_error_ != NULL) {
				goto __catch57_g_error;
			}
			result = RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER (_tmp2_) ? ((RygelMediaExportDBContainer*) _tmp2_) : NULL;
			return result;
		}
		goto __finally57;
		__catch57_g_error:
		{
			GError* _error_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			g_assert_not_reached ();
			_g_error_free0 (_error_);
		}
		__finally57:
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = id;
		if (g_strcmp0 (_tmp3_, RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID) == 0) {
			{
				RygelMediaContainer* _tmp4_ = NULL;
				RygelMediaContainer* _tmp5_;
				RygelMediaExportRootContainer* root_container;
				RygelMediaExportRootContainer* _tmp6_;
				RygelMediaContainer* _tmp7_ = NULL;
				_tmp4_ = rygel_media_export_root_container_get_instance (&_inner_error_);
				_tmp5_ = _tmp4_;
				if (_inner_error_ != NULL) {
					goto __catch58_g_error;
				}
				root_container = RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER (_tmp5_) ? ((RygelMediaExportRootContainer*) _tmp5_) : NULL;
				_tmp6_ = root_container;
				_tmp7_ = rygel_media_export_root_container_get_filesystem_container (_tmp6_);
				result = RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER (_tmp7_) ? ((RygelMediaExportDBContainer*) _tmp7_) : NULL;
				_g_object_unref0 (root_container);
				return result;
			}
			goto __finally58;
			__catch58_g_error:
			{
				GError* _error_ = NULL;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				g_assert_not_reached ();
				_g_error_free0 (_error_);
			}
			__finally58:
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = id;
	_tmp9_ = g_str_has_prefix (_tmp8_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX);
	if (_tmp9_) {
		RygelMediaExportMediaCache* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		RygelMediaExportQueryContainer* _tmp13_;
		_tmp10_ = media_db;
		_tmp11_ = id;
		_tmp12_ = title;
		_tmp13_ = rygel_media_export_query_container_new (_tmp10_, _tmp11_, _tmp12_);
		result = (RygelMediaExportDBContainer*) _tmp13_;
		return result;
	}
	_tmp14_ = uri;
	if (_tmp14_ == NULL) {
		RygelMediaExportMediaCache* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		RygelMediaExportDBContainer* _tmp18_;
		_tmp15_ = media_db;
		_tmp16_ = id;
		_tmp17_ = title;
		_tmp18_ = rygel_media_export_db_container_new (_tmp15_, _tmp16_, _tmp17_);
		result = _tmp18_;
		return result;
	}
	_tmp19_ = media_db;
	_tmp20_ = id;
	_tmp21_ = title;
	_tmp22_ = rygel_media_export_writable_db_container_new (_tmp19_, _tmp20_, _tmp21_);
	result = (RygelMediaExportDBContainer*) _tmp22_;
	return result;
}


RygelMediaExportDBContainer* rygel_media_export_object_factory_get_container (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title, guint child_count, const gchar* uri) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_GET_CLASS (self)->get_container (self, media_db, id, title, child_count, uri);
}


/**
     * Return a new instance of MediaItem
     *
     * @param media_db instance of MediaDB
     * @param id id of the item
     * @param title title of the item
     * @param upnp_class upnp_class of the item
     */
static RygelMediaItem* rygel_media_export_object_factory_real_get_item (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, RygelMediaContainer* parent, const gchar* id, const gchar* title, const gchar* upnp_class) {
	RygelMediaItem* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	g_return_val_if_fail (media_db != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	_tmp0_ = upnp_class;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if ((_tmp3_ == g_quark_from_string (RYGEL_MUSIC_ITEM_UPNP_CLASS)) || (_tmp3_ == g_quark_from_string (RYGEL_AUDIO_ITEM_UPNP_CLASS))) {
		switch (0) {
			default:
			{
				const gchar* _tmp4_;
				RygelMediaContainer* _tmp5_;
				const gchar* _tmp6_;
				RygelMusicItem* _tmp7_;
				_tmp4_ = id;
				_tmp5_ = parent;
				_tmp6_ = title;
				_tmp7_ = rygel_music_item_new (_tmp4_, _tmp5_, _tmp6_, RYGEL_MUSIC_ITEM_UPNP_CLASS);
				result = (RygelMediaItem*) _tmp7_;
				return result;
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_VIDEO_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp8_;
				RygelMediaContainer* _tmp9_;
				const gchar* _tmp10_;
				RygelVideoItem* _tmp11_;
				_tmp8_ = id;
				_tmp9_ = parent;
				_tmp10_ = title;
				_tmp11_ = rygel_video_item_new (_tmp8_, _tmp9_, _tmp10_, RYGEL_VIDEO_ITEM_UPNP_CLASS);
				result = (RygelMediaItem*) _tmp11_;
				return result;
			}
		}
	} else if ((_tmp3_ == g_quark_from_string (RYGEL_PHOTO_ITEM_UPNP_CLASS)) || (_tmp3_ == g_quark_from_string (RYGEL_IMAGE_ITEM_UPNP_CLASS))) {
		switch (0) {
			default:
			{
				const gchar* _tmp12_;
				RygelMediaContainer* _tmp13_;
				const gchar* _tmp14_;
				RygelPhotoItem* _tmp15_;
				_tmp12_ = id;
				_tmp13_ = parent;
				_tmp14_ = title;
				_tmp15_ = rygel_photo_item_new (_tmp12_, _tmp13_, _tmp14_, RYGEL_PHOTO_ITEM_UPNP_CLASS);
				result = (RygelMediaItem*) _tmp15_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
}


RygelMediaItem* rygel_media_export_object_factory_get_item (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, RygelMediaContainer* parent, const gchar* id, const gchar* title, const gchar* upnp_class) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_GET_CLASS (self)->get_item (self, media_db, parent, id, title, upnp_class);
}


RygelMediaExportObjectFactory* rygel_media_export_object_factory_construct (GType object_type) {
	RygelMediaExportObjectFactory * self = NULL;
	self = (RygelMediaExportObjectFactory*) g_object_new (object_type, NULL);
	return self;
}


RygelMediaExportObjectFactory* rygel_media_export_object_factory_new (void) {
	return rygel_media_export_object_factory_construct (RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY);
}


static void rygel_media_export_object_factory_class_init (RygelMediaExportObjectFactoryClass * klass) {
	rygel_media_export_object_factory_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_CLASS (klass)->get_container = rygel_media_export_object_factory_real_get_container;
	RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_CLASS (klass)->get_item = rygel_media_export_object_factory_real_get_item;
}


static void rygel_media_export_object_factory_instance_init (RygelMediaExportObjectFactory * self) {
}


GType rygel_media_export_object_factory_get_type (void) {
	static volatile gsize rygel_media_export_object_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_object_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportObjectFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_object_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportObjectFactory), 0, (GInstanceInitFunc) rygel_media_export_object_factory_instance_init, NULL };
		GType rygel_media_export_object_factory_type_id;
		rygel_media_export_object_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportObjectFactory", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_object_factory_type_id__volatile, rygel_media_export_object_factory_type_id);
	}
	return rygel_media_export_object_factory_type_id__volatile;
}



