/* rygel-media-export-item.c generated by valac 0.14.1, the Vala compiler
 * generated from rygel-media-export-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-dlna/gupnp-dlna-information.h>
#include <gst/pbutils/pbutils.h>
#include <gst/gst.h>
#include <gst/tag/tag.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__gst_mini_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gst_mini_object_unref0_ (var), NULL)))
#define _gst_mini_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_mini_object_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER (rygel_media_export_jpeg_writer_get_type ())
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriter))
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriterClass))
#define RYGEL_MEDIA_EXPORT_IS_JPEG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER))
#define RYGEL_MEDIA_EXPORT_IS_JPEG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER))
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriterClass))

typedef struct _RygelMediaExportJPEGWriter RygelMediaExportJPEGWriter;
typedef struct _RygelMediaExportJPEGWriterClass RygelMediaExportJPEGWriterClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))



RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, const gchar* mime, guint64 size, guint64 mtime);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GUPnPDLNAInformation* dlna_info, const gchar* mime, guint64 size, guint64 mtime);
static void _gst_mini_object_unref0_ (gpointer var);
static void _g_list_free__gst_mini_object_unref0_ (GList* self);
RygelMediaItem* rygel_media_export_item_factory_fill_photo_item (RygelPhotoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererVideoInfo* video_info, const gchar* mime, guint64 size, guint64 mtime);
RygelMediaItem* rygel_media_export_item_factory_fill_video_item (RygelVideoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererVideoInfo* video_info, GstDiscovererAudioInfo* audio_info, const gchar* mime, guint64 size, guint64 mtime);
RygelMediaItem* rygel_media_export_item_factory_fill_music_item (RygelMusicItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererAudioInfo* audio_info, const gchar* mime, guint64 size, guint64 mtime);
void rygel_media_export_item_factory_fill_audio_item (RygelAudioItem* item, GUPnPDLNAInformation* dlna_info, GstDiscovererAudioInfo* audio_info);
void rygel_media_export_item_factory_fill_media_item (RygelMediaItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, const gchar* mime, guint64 size, guint64 mtime);
RygelMediaExportJPEGWriter* rygel_media_export_jpeg_writer_new (GError** error);
RygelMediaExportJPEGWriter* rygel_media_export_jpeg_writer_construct (GType object_type, GError** error);
GType rygel_media_export_jpeg_writer_get_type (void) G_GNUC_CONST;
void rygel_media_export_jpeg_writer_write (RygelMediaExportJPEGWriter* self, GstBuffer* buffer, GFile* file);


RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, const gchar* mime, guint64 size, guint64 mtime) {
	RygelMediaItem* result = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* title;
	RygelMediaItem* item = NULL;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	RygelMediaItem* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	RygelMediaItem* _tmp27_;
	guint64 _tmp28_;
	RygelMediaItem* _tmp29_;
	guint64 _tmp30_;
	RygelMediaItem* _tmp31_;
	GFile* _tmp32_;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (mime != NULL, NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_get_basename (_tmp0_);
	title = _tmp1_;
	_tmp2_ = mime;
	_tmp3_ = g_str_has_prefix (_tmp2_, "video/");
	if (_tmp3_) {
		GFile* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		RygelMediaContainer* _tmp7_;
		const gchar* _tmp8_;
		RygelVideoItem* _tmp9_;
		_tmp4_ = file;
		_tmp5_ = rygel_media_export_media_cache_get_id (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = parent;
		_tmp8_ = title;
		_tmp9_ = rygel_video_item_new (_tmp6_, _tmp7_, _tmp8_, RYGEL_VIDEO_ITEM_UPNP_CLASS);
		_g_object_unref0 (item);
		item = (RygelMediaItem*) _tmp9_;
		_g_free0 (_tmp6_);
	} else {
		const gchar* _tmp10_;
		gboolean _tmp11_ = FALSE;
		_tmp10_ = mime;
		_tmp11_ = g_str_has_prefix (_tmp10_, "image/");
		if (_tmp11_) {
			GFile* _tmp12_;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			RygelMediaContainer* _tmp15_;
			const gchar* _tmp16_;
			RygelPhotoItem* _tmp17_;
			_tmp12_ = file;
			_tmp13_ = rygel_media_export_media_cache_get_id (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = parent;
			_tmp16_ = title;
			_tmp17_ = rygel_photo_item_new (_tmp14_, _tmp15_, _tmp16_, RYGEL_PHOTO_ITEM_UPNP_CLASS);
			_g_object_unref0 (item);
			item = (RygelMediaItem*) _tmp17_;
			_g_free0 (_tmp14_);
		} else {
			GFile* _tmp18_;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			RygelMediaContainer* _tmp21_;
			const gchar* _tmp22_;
			RygelMusicItem* _tmp23_;
			_tmp18_ = file;
			_tmp19_ = rygel_media_export_media_cache_get_id (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = parent;
			_tmp22_ = title;
			_tmp23_ = rygel_music_item_new (_tmp20_, _tmp21_, _tmp22_, RYGEL_MUSIC_ITEM_UPNP_CLASS);
			_g_object_unref0 (item);
			item = (RygelMediaItem*) _tmp23_;
			_g_free0 (_tmp20_);
		}
	}
	_tmp24_ = item;
	_tmp25_ = mime;
	_tmp26_ = g_strdup (_tmp25_);
	_g_free0 (_tmp24_->mime_type);
	_tmp24_->mime_type = _tmp26_;
	_tmp27_ = item;
	_tmp28_ = size;
	rygel_media_item_set_size (_tmp27_, (gint64) _tmp28_);
	_tmp29_ = item;
	_tmp30_ = mtime;
	((RygelMediaObject*) _tmp29_)->modified = _tmp30_;
	_tmp31_ = item;
	_tmp32_ = file;
	_tmp33_ = g_file_get_uri (_tmp32_);
	_tmp34_ = _tmp33_;
	rygel_media_item_add_uri (_tmp31_, _tmp34_);
	_g_free0 (_tmp34_);
	result = item;
	_g_free0 (title);
	return result;
}


static void _gst_mini_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gst_mini_object_unref (var), NULL));
}


static void _g_list_free__gst_mini_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gst_mini_object_unref0_, NULL);
	g_list_free (self);
}


static gpointer _gst_mini_object_ref0 (gpointer self) {
	return self ? gst_mini_object_ref (self) : NULL;
}


RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GUPnPDLNAInformation* dlna_info, const gchar* mime, guint64 size, guint64 mtime) {
	RygelMediaItem* result = NULL;
	RygelMediaItem* item = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* id;
	GList* audio_streams = NULL;
	GList* video_streams = NULL;
	GUPnPDLNAInformation* _tmp2_;
	GstDiscovererInfo* _tmp3_;
	GstDiscovererInfo* _tmp4_;
	GList* _tmp5_ = NULL;
	GUPnPDLNAInformation* _tmp6_;
	GstDiscovererInfo* _tmp7_;
	GstDiscovererInfo* _tmp8_;
	GList* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GList* _tmp11_;
	gboolean _tmp13_;
	gboolean _tmp17_ = FALSE;
	GList* _tmp18_;
	gboolean _tmp22_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (dlna_info != NULL, NULL);
	g_return_val_if_fail (mime != NULL, NULL);
	_tmp0_ = file;
	_tmp1_ = rygel_media_export_media_cache_get_id (_tmp0_);
	id = _tmp1_;
	_tmp2_ = dlna_info;
	_tmp3_ = gupnp_dlna_information_get_info (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gst_discoverer_info_get_audio_streams (_tmp4_);
	__g_list_free__gst_mini_object_unref0_0 (audio_streams);
	audio_streams = _tmp5_;
	_tmp6_ = dlna_info;
	_tmp7_ = gupnp_dlna_information_get_info (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = gst_discoverer_info_get_video_streams (_tmp8_);
	__g_list_free__gst_mini_object_unref0_0 (video_streams);
	video_streams = _tmp9_;
	_tmp11_ = audio_streams;
	if (_tmp11_ == NULL) {
		GList* _tmp12_;
		_tmp12_ = video_streams;
		_tmp10_ = _tmp12_ == NULL;
	} else {
		_tmp10_ = FALSE;
	}
	_tmp13_ = _tmp10_;
	if (_tmp13_) {
		GFile* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		_tmp14_ = file;
		_tmp15_ = g_file_get_uri (_tmp14_);
		_tmp16_ = _tmp15_;
		g_debug ("%s had neither audio nor video/picture " "streams. Ignoring.", _tmp16_);
		_g_free0 (_tmp16_);
		result = NULL;
		__g_list_free__gst_mini_object_unref0_0 (video_streams);
		__g_list_free__gst_mini_object_unref0_0 (audio_streams);
		_g_free0 (id);
		_g_object_unref0 (item);
		return result;
	}
	_tmp18_ = audio_streams;
	if (_tmp18_ == NULL) {
		GList* _tmp19_;
		gconstpointer _tmp20_;
		gboolean _tmp21_ = FALSE;
		_tmp19_ = video_streams;
		_tmp20_ = _tmp19_->data;
		_tmp21_ = gst_discoverer_video_info_is_image ((GstDiscovererVideoInfo*) _tmp20_);
		_tmp17_ = _tmp21_;
	} else {
		_tmp17_ = FALSE;
	}
	_tmp22_ = _tmp17_;
	if (_tmp22_) {
		const gchar* _tmp23_;
		RygelMediaContainer* _tmp24_;
		RygelPhotoItem* _tmp25_;
		RygelMediaItem* _tmp26_;
		GFile* _tmp27_;
		GUPnPDLNAInformation* _tmp28_;
		GList* _tmp29_;
		gconstpointer _tmp30_;
		const gchar* _tmp31_;
		guint64 _tmp32_;
		guint64 _tmp33_;
		RygelMediaItem* _tmp34_ = NULL;
		_tmp23_ = id;
		_tmp24_ = parent;
		_tmp25_ = rygel_photo_item_new (_tmp23_, _tmp24_, "", RYGEL_PHOTO_ITEM_UPNP_CLASS);
		_g_object_unref0 (item);
		item = (RygelMediaItem*) _tmp25_;
		_tmp26_ = item;
		_tmp27_ = file;
		_tmp28_ = dlna_info;
		_tmp29_ = video_streams;
		_tmp30_ = _tmp29_->data;
		_tmp31_ = mime;
		_tmp32_ = size;
		_tmp33_ = mtime;
		_tmp34_ = rygel_media_export_item_factory_fill_photo_item (RYGEL_IS_PHOTO_ITEM (_tmp26_) ? ((RygelPhotoItem*) _tmp26_) : NULL, _tmp27_, _tmp28_, (GstDiscovererVideoInfo*) _tmp30_, _tmp31_, _tmp32_, _tmp33_);
		result = _tmp34_;
		__g_list_free__gst_mini_object_unref0_0 (video_streams);
		__g_list_free__gst_mini_object_unref0_0 (audio_streams);
		_g_free0 (id);
		_g_object_unref0 (item);
		return result;
	} else {
		GList* _tmp35_;
		_tmp35_ = video_streams;
		if (_tmp35_ != NULL) {
			const gchar* _tmp36_;
			RygelMediaContainer* _tmp37_;
			RygelVideoItem* _tmp38_;
			GstDiscovererAudioInfo* _tmp39_;
			GstDiscovererAudioInfo* audio_info;
			GList* _tmp40_;
			RygelMediaItem* _tmp44_;
			GFile* _tmp45_;
			GUPnPDLNAInformation* _tmp46_;
			GList* _tmp47_;
			gconstpointer _tmp48_;
			GstDiscovererAudioInfo* _tmp49_;
			const gchar* _tmp50_;
			guint64 _tmp51_;
			guint64 _tmp52_;
			RygelMediaItem* _tmp53_ = NULL;
			_tmp36_ = id;
			_tmp37_ = parent;
			_tmp38_ = rygel_video_item_new (_tmp36_, _tmp37_, "", RYGEL_VIDEO_ITEM_UPNP_CLASS);
			_g_object_unref0 (item);
			item = (RygelMediaItem*) _tmp38_;
			_tmp39_ = _gst_mini_object_ref0 (GST_IS_DISCOVERER_AUDIO_INFO (NULL) ? ((GstDiscovererAudioInfo*) NULL) : NULL);
			audio_info = _tmp39_;
			_tmp40_ = audio_streams;
			if (_tmp40_ != NULL) {
				GList* _tmp41_;
				gconstpointer _tmp42_;
				GstDiscovererAudioInfo* _tmp43_;
				_tmp41_ = audio_streams;
				_tmp42_ = _tmp41_->data;
				_tmp43_ = _gst_mini_object_ref0 ((GstDiscovererAudioInfo*) _tmp42_);
				_gst_mini_object_unref0 (audio_info);
				audio_info = _tmp43_;
			}
			_tmp44_ = item;
			_tmp45_ = file;
			_tmp46_ = dlna_info;
			_tmp47_ = video_streams;
			_tmp48_ = _tmp47_->data;
			_tmp49_ = audio_info;
			_tmp50_ = mime;
			_tmp51_ = size;
			_tmp52_ = mtime;
			_tmp53_ = rygel_media_export_item_factory_fill_video_item (RYGEL_IS_VIDEO_ITEM (_tmp44_) ? ((RygelVideoItem*) _tmp44_) : NULL, _tmp45_, _tmp46_, (GstDiscovererVideoInfo*) _tmp48_, _tmp49_, _tmp50_, _tmp51_, _tmp52_);
			result = _tmp53_;
			_gst_mini_object_unref0 (audio_info);
			__g_list_free__gst_mini_object_unref0_0 (video_streams);
			__g_list_free__gst_mini_object_unref0_0 (audio_streams);
			_g_free0 (id);
			_g_object_unref0 (item);
			return result;
		} else {
			GList* _tmp54_;
			_tmp54_ = audio_streams;
			if (_tmp54_ != NULL) {
				const gchar* _tmp55_;
				RygelMediaContainer* _tmp56_;
				RygelMusicItem* _tmp57_;
				RygelMediaItem* _tmp58_;
				GFile* _tmp59_;
				GUPnPDLNAInformation* _tmp60_;
				GList* _tmp61_;
				gconstpointer _tmp62_;
				const gchar* _tmp63_;
				guint64 _tmp64_;
				guint64 _tmp65_;
				RygelMediaItem* _tmp66_ = NULL;
				_tmp55_ = id;
				_tmp56_ = parent;
				_tmp57_ = rygel_music_item_new (_tmp55_, _tmp56_, "", RYGEL_MUSIC_ITEM_UPNP_CLASS);
				_g_object_unref0 (item);
				item = (RygelMediaItem*) _tmp57_;
				_tmp58_ = item;
				_tmp59_ = file;
				_tmp60_ = dlna_info;
				_tmp61_ = audio_streams;
				_tmp62_ = _tmp61_->data;
				_tmp63_ = mime;
				_tmp64_ = size;
				_tmp65_ = mtime;
				_tmp66_ = rygel_media_export_item_factory_fill_music_item (RYGEL_IS_MUSIC_ITEM (_tmp58_) ? ((RygelMusicItem*) _tmp58_) : NULL, _tmp59_, _tmp60_, (GstDiscovererAudioInfo*) _tmp62_, _tmp63_, _tmp64_, _tmp65_);
				result = _tmp66_;
				__g_list_free__gst_mini_object_unref0_0 (video_streams);
				__g_list_free__gst_mini_object_unref0_0 (audio_streams);
				_g_free0 (id);
				_g_object_unref0 (item);
				return result;
			} else {
				result = NULL;
				__g_list_free__gst_mini_object_unref0_0 (video_streams);
				__g_list_free__gst_mini_object_unref0_0 (audio_streams);
				_g_free0 (id);
				_g_object_unref0 (item);
				return result;
			}
		}
	}
	__g_list_free__gst_mini_object_unref0_0 (video_streams);
	__g_list_free__gst_mini_object_unref0_0 (audio_streams);
	_g_free0 (id);
	_g_object_unref0 (item);
}


void rygel_media_export_item_factory_fill_audio_item (RygelAudioItem* item, GUPnPDLNAInformation* dlna_info, GstDiscovererAudioInfo* audio_info) {
	GUPnPDLNAInformation* _tmp0_;
	GstDiscovererInfo* _tmp1_;
	GstDiscovererInfo* _tmp2_;
	GstClockTime _tmp3_ = 0ULL;
	GstDiscovererAudioInfo* _tmp10_;
	g_return_if_fail (item != NULL);
	g_return_if_fail (dlna_info != NULL);
	_tmp0_ = dlna_info;
	_tmp1_ = gupnp_dlna_information_get_info (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gst_discoverer_info_get_duration (_tmp2_);
	if (_tmp3_ > ((GstClockTime) 0)) {
		RygelAudioItem* _tmp4_;
		GUPnPDLNAInformation* _tmp5_;
		GstDiscovererInfo* _tmp6_;
		GstDiscovererInfo* _tmp7_;
		GstClockTime _tmp8_ = 0ULL;
		_tmp4_ = item;
		_tmp5_ = dlna_info;
		_tmp6_ = gupnp_dlna_information_get_info (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = gst_discoverer_info_get_duration (_tmp7_);
		_tmp4_->duration = (glong) (_tmp8_ / GST_SECOND);
	} else {
		RygelAudioItem* _tmp9_;
		_tmp9_ = item;
		_tmp9_->duration = (glong) (-1);
	}
	_tmp10_ = audio_info;
	if (_tmp10_ != NULL) {
		GstDiscovererAudioInfo* _tmp11_;
		GstTagList* _tmp12_ = NULL;
		RygelAudioItem* _tmp18_;
		GstDiscovererAudioInfo* _tmp19_;
		guint _tmp20_ = 0U;
		RygelAudioItem* _tmp21_;
		GstDiscovererAudioInfo* _tmp22_;
		guint _tmp23_ = 0U;
		_tmp11_ = audio_info;
		_tmp12_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp11_);
		if (_tmp12_ != NULL) {
			guint tmp = 0U;
			GstDiscovererAudioInfo* _tmp13_;
			GstTagList* _tmp14_ = NULL;
			guint _tmp15_ = 0U;
			RygelAudioItem* _tmp16_;
			guint _tmp17_;
			_tmp13_ = audio_info;
			_tmp14_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp13_);
			gst_tag_list_get_uint (_tmp14_, GST_TAG_BITRATE, &_tmp15_);
			tmp = _tmp15_;
			_tmp16_ = item;
			_tmp17_ = tmp;
			_tmp16_->bitrate = ((gint) _tmp17_) / 8;
		}
		_tmp18_ = item;
		_tmp19_ = audio_info;
		_tmp20_ = gst_discoverer_audio_info_get_channels (_tmp19_);
		_tmp18_->channels = (gint) _tmp20_;
		_tmp21_ = item;
		_tmp22_ = audio_info;
		_tmp23_ = gst_discoverer_audio_info_get_sample_rate (_tmp22_);
		_tmp21_->sample_freq = (gint) _tmp23_;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaItem* rygel_media_export_item_factory_fill_video_item (RygelVideoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererVideoInfo* video_info, GstDiscovererAudioInfo* audio_info, const gchar* mime, guint64 size, guint64 mtime) {
	RygelMediaItem* result = NULL;
	RygelVideoItem* _tmp0_;
	GUPnPDLNAInformation* _tmp1_;
	GstDiscovererAudioInfo* _tmp2_;
	RygelVideoItem* _tmp3_;
	GFile* _tmp4_;
	GUPnPDLNAInformation* _tmp5_;
	const gchar* _tmp6_;
	guint64 _tmp7_;
	guint64 _tmp8_;
	RygelVideoItem* _tmp9_;
	GstDiscovererVideoInfo* _tmp10_;
	guint _tmp11_ = 0U;
	RygelVideoItem* _tmp12_;
	GstDiscovererVideoInfo* _tmp13_;
	guint _tmp14_ = 0U;
	RygelVideoItem* _tmp15_;
	GstDiscovererVideoInfo* _tmp16_;
	guint _tmp17_ = 0U;
	RygelVideoItem* _tmp18_;
	RygelMediaItem* _tmp19_;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (dlna_info != NULL, NULL);
	g_return_val_if_fail (video_info != NULL, NULL);
	g_return_val_if_fail (mime != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = dlna_info;
	_tmp2_ = audio_info;
	rygel_media_export_item_factory_fill_audio_item (RYGEL_IS_AUDIO_ITEM (_tmp0_) ? ((RygelAudioItem*) _tmp0_) : NULL, _tmp1_, _tmp2_);
	_tmp3_ = item;
	_tmp4_ = file;
	_tmp5_ = dlna_info;
	_tmp6_ = mime;
	_tmp7_ = size;
	_tmp8_ = mtime;
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp3_, _tmp4_, _tmp5_, _tmp6_, _tmp7_, _tmp8_);
	_tmp9_ = item;
	_tmp10_ = video_info;
	_tmp11_ = gst_discoverer_video_info_get_width (_tmp10_);
	rygel_visual_item_set_width ((RygelVisualItem*) _tmp9_, (gint) _tmp11_);
	_tmp12_ = item;
	_tmp13_ = video_info;
	_tmp14_ = gst_discoverer_video_info_get_height (_tmp13_);
	rygel_visual_item_set_height ((RygelVisualItem*) _tmp12_, (gint) _tmp14_);
	_tmp15_ = item;
	_tmp16_ = video_info;
	_tmp17_ = gst_discoverer_video_info_get_depth (_tmp16_);
	rygel_visual_item_set_color_depth ((RygelVisualItem*) _tmp15_, (gint) _tmp17_);
	_tmp18_ = item;
	_tmp19_ = _g_object_ref0 ((RygelMediaItem*) _tmp18_);
	result = _tmp19_;
	return result;
}


RygelMediaItem* rygel_media_export_item_factory_fill_photo_item (RygelPhotoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererVideoInfo* video_info, const gchar* mime, guint64 size, guint64 mtime) {
	RygelMediaItem* result = NULL;
	RygelPhotoItem* _tmp0_;
	GFile* _tmp1_;
	GUPnPDLNAInformation* _tmp2_;
	const gchar* _tmp3_;
	guint64 _tmp4_;
	guint64 _tmp5_;
	RygelPhotoItem* _tmp6_;
	GstDiscovererVideoInfo* _tmp7_;
	guint _tmp8_ = 0U;
	RygelPhotoItem* _tmp9_;
	GstDiscovererVideoInfo* _tmp10_;
	guint _tmp11_ = 0U;
	RygelPhotoItem* _tmp12_;
	GstDiscovererVideoInfo* _tmp13_;
	guint _tmp14_ = 0U;
	RygelPhotoItem* _tmp15_;
	RygelMediaItem* _tmp16_;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (dlna_info != NULL, NULL);
	g_return_val_if_fail (video_info != NULL, NULL);
	g_return_val_if_fail (mime != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = file;
	_tmp2_ = dlna_info;
	_tmp3_ = mime;
	_tmp4_ = size;
	_tmp5_ = mtime;
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
	_tmp6_ = item;
	_tmp7_ = video_info;
	_tmp8_ = gst_discoverer_video_info_get_width (_tmp7_);
	rygel_visual_item_set_width ((RygelVisualItem*) _tmp6_, (gint) _tmp8_);
	_tmp9_ = item;
	_tmp10_ = video_info;
	_tmp11_ = gst_discoverer_video_info_get_height (_tmp10_);
	rygel_visual_item_set_height ((RygelVisualItem*) _tmp9_, (gint) _tmp11_);
	_tmp12_ = item;
	_tmp13_ = video_info;
	_tmp14_ = gst_discoverer_video_info_get_depth (_tmp13_);
	rygel_visual_item_set_color_depth ((RygelVisualItem*) _tmp12_, (gint) _tmp14_);
	_tmp15_ = item;
	_tmp16_ = _g_object_ref0 ((RygelMediaItem*) _tmp15_);
	result = _tmp16_;
	return result;
}


static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


RygelMediaItem* rygel_media_export_item_factory_fill_music_item (RygelMusicItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererAudioInfo* audio_info, const gchar* mime, guint64 size, guint64 mtime) {
	RygelMediaItem* result = NULL;
	RygelMusicItem* _tmp0_;
	GUPnPDLNAInformation* _tmp1_;
	GstDiscovererAudioInfo* _tmp2_;
	RygelMusicItem* _tmp3_;
	GFile* _tmp4_;
	GUPnPDLNAInformation* _tmp5_;
	const gchar* _tmp6_;
	guint64 _tmp7_;
	guint64 _tmp8_;
	GstDiscovererAudioInfo* _tmp9_;
	RygelMusicItem* _tmp56_;
	RygelMediaItem* _tmp57_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (dlna_info != NULL, NULL);
	g_return_val_if_fail (mime != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = dlna_info;
	_tmp2_ = audio_info;
	rygel_media_export_item_factory_fill_audio_item (RYGEL_IS_AUDIO_ITEM (_tmp0_) ? ((RygelAudioItem*) _tmp0_) : NULL, _tmp1_, _tmp2_);
	_tmp3_ = item;
	_tmp4_ = file;
	_tmp5_ = dlna_info;
	_tmp6_ = mime;
	_tmp7_ = size;
	_tmp8_ = mtime;
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp3_, _tmp4_, _tmp5_, _tmp6_, _tmp7_, _tmp8_);
	_tmp9_ = audio_info;
	if (_tmp9_ != NULL) {
		GstDiscovererAudioInfo* _tmp10_;
		GstTagList* _tmp11_ = NULL;
		GUPnPDLNAInformation* _tmp31_;
		GstDiscovererInfo* _tmp32_;
		GstDiscovererInfo* _tmp33_;
		GstTagList* _tmp34_ = NULL;
		RygelMusicItem* _tmp35_;
		gchar* _tmp36_ = NULL;
		GUPnPDLNAInformation* _tmp37_;
		GstDiscovererInfo* _tmp38_;
		GstDiscovererInfo* _tmp39_;
		GstTagList* _tmp40_ = NULL;
		RygelMusicItem* _tmp41_;
		gchar* _tmp42_ = NULL;
		GUPnPDLNAInformation* _tmp43_;
		GstDiscovererInfo* _tmp44_;
		GstDiscovererInfo* _tmp45_;
		GstTagList* _tmp46_ = NULL;
		RygelMusicItem* _tmp47_;
		gchar* _tmp48_ = NULL;
		guint tmp = 0U;
		GUPnPDLNAInformation* _tmp49_;
		GstDiscovererInfo* _tmp50_;
		GstDiscovererInfo* _tmp51_;
		GstTagList* _tmp52_ = NULL;
		guint _tmp53_ = 0U;
		RygelMusicItem* _tmp54_;
		guint _tmp55_;
		_tmp10_ = audio_info;
		_tmp11_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp10_);
		if (_tmp11_ != NULL) {
			GstBuffer* buffer = NULL;
			GstDiscovererAudioInfo* _tmp12_;
			GstTagList* _tmp13_ = NULL;
			GstBuffer* _tmp14_ = NULL;
			GstBuffer* _tmp15_;
			_tmp12_ = audio_info;
			_tmp13_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp12_);
			gst_tag_list_get_buffer (_tmp13_, GST_TAG_IMAGE, &_tmp14_);
			buffer = _tmp14_;
			_tmp15_ = buffer;
			if (_tmp15_ != NULL) {
				GstBuffer* _tmp16_;
				GstCaps* _tmp17_;
				const GstStructure* _tmp18_ = NULL;
				GstStructure* _tmp19_;
				GstStructure* structure;
				gint image_type = 0;
				const GstStructure* _tmp20_;
				gint _tmp21_ = 0;
				gint _tmp22_;
				_tmp16_ = buffer;
				_tmp17_ = _tmp16_->caps;
				_tmp18_ = gst_caps_get_structure (_tmp17_, (guint) 0);
				_tmp19_ = _gst_structure_copy0 (_tmp18_);
				structure = _tmp19_;
				_tmp20_ = structure;
				gst_structure_get_enum (_tmp20_, "image-type", GST_TYPE_TAG_IMAGE_TYPE, &_tmp21_);
				image_type = _tmp21_;
				_tmp22_ = image_type;
				switch (_tmp22_) {
					case GST_TAG_IMAGE_TYPE_UNDEFINED:
					case GST_TAG_IMAGE_TYPE_FRONT_COVER:
					{
						RygelMediaArtStore* _tmp23_ = NULL;
						RygelMediaArtStore* store;
						RygelMediaArtStore* _tmp24_;
						RygelMusicItem* _tmp25_;
						GFile* _tmp26_ = NULL;
						GFile* thumb;
						_tmp23_ = rygel_media_art_store_get_default ();
						store = _tmp23_;
						_tmp24_ = store;
						_tmp25_ = item;
						_tmp26_ = rygel_media_art_store_get_media_art_file (_tmp24_, "album", _tmp25_, TRUE);
						thumb = _tmp26_;
						{
							RygelMediaExportJPEGWriter* _tmp27_;
							RygelMediaExportJPEGWriter* writer;
							RygelMediaExportJPEGWriter* _tmp28_;
							GstBuffer* _tmp29_;
							GFile* _tmp30_;
							_tmp27_ = rygel_media_export_jpeg_writer_new (&_inner_error_);
							writer = _tmp27_;
							if (_inner_error_ != NULL) {
								goto __catch56_g_error;
							}
							_tmp28_ = writer;
							_tmp29_ = buffer;
							_tmp30_ = thumb;
							rygel_media_export_jpeg_writer_write (_tmp28_, _tmp29_, _tmp30_);
							_g_object_unref0 (writer);
						}
						goto __finally56;
						__catch56_g_error:
						{
							GError* _error_ = NULL;
							_error_ = _inner_error_;
							_inner_error_ = NULL;
							_g_error_free0 (_error_);
						}
						__finally56:
						if (_inner_error_ != NULL) {
							_g_object_unref0 (thumb);
							_g_object_unref0 (store);
							_gst_structure_free0 (structure);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						_g_object_unref0 (thumb);
						_g_object_unref0 (store);
						break;
					}
					default:
					{
						break;
					}
				}
				_gst_structure_free0 (structure);
			}
		}
		_tmp31_ = dlna_info;
		_tmp32_ = gupnp_dlna_information_get_info (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = gst_discoverer_info_get_tags (_tmp33_);
		_tmp35_ = item;
		gst_tag_list_get_string (_tmp34_, GST_TAG_ARTIST, &_tmp36_);
		_g_free0 (_tmp35_->artist);
		_tmp35_->artist = _tmp36_;
		_tmp37_ = dlna_info;
		_tmp38_ = gupnp_dlna_information_get_info (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = gst_discoverer_info_get_tags (_tmp39_);
		_tmp41_ = item;
		gst_tag_list_get_string (_tmp40_, GST_TAG_ALBUM, &_tmp42_);
		_g_free0 (_tmp41_->album);
		_tmp41_->album = _tmp42_;
		_tmp43_ = dlna_info;
		_tmp44_ = gupnp_dlna_information_get_info (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = gst_discoverer_info_get_tags (_tmp45_);
		_tmp47_ = item;
		gst_tag_list_get_string (_tmp46_, GST_TAG_GENRE, &_tmp48_);
		_g_free0 (_tmp47_->genre);
		_tmp47_->genre = _tmp48_;
		_tmp49_ = dlna_info;
		_tmp50_ = gupnp_dlna_information_get_info (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = gst_discoverer_info_get_tags (_tmp51_);
		gst_tag_list_get_uint (_tmp52_, GST_TAG_TRACK_NUMBER, &_tmp53_);
		tmp = _tmp53_;
		_tmp54_ = item;
		_tmp55_ = tmp;
		_tmp54_->track_number = (gint) _tmp55_;
	}
	_tmp56_ = item;
	_tmp57_ = _g_object_ref0 ((RygelMediaItem*) _tmp56_);
	result = _tmp57_;
	return result;
}


void rygel_media_export_item_factory_fill_media_item (RygelMediaItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, const gchar* mime, guint64 size, guint64 mtime) {
	gchar* title;
	gboolean _tmp0_ = FALSE;
	GUPnPDLNAInformation* _tmp1_;
	GstDiscovererInfo* _tmp2_;
	GstDiscovererInfo* _tmp3_;
	GstTagList* _tmp4_ = NULL;
	gboolean _tmp11_;
	RygelMediaItem* _tmp14_;
	const gchar* _tmp15_;
	GUPnPDLNAInformation* _tmp16_;
	GstDiscovererInfo* _tmp17_;
	GstDiscovererInfo* _tmp18_;
	GstTagList* _tmp19_ = NULL;
	RygelMediaItem* _tmp32_;
	const gchar* _tmp33_;
	RygelMediaItem* _tmp38_;
	guint64 _tmp39_;
	RygelMediaItem* _tmp40_;
	guint64 _tmp41_;
	GUPnPDLNAInformation* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	RygelMediaItem* _tmp58_;
	GFile* _tmp59_;
	gchar* _tmp60_ = NULL;
	gchar* _tmp61_;
	g_return_if_fail (item != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (dlna_info != NULL);
	g_return_if_fail (mime != NULL);
	title = NULL;
	_tmp1_ = dlna_info;
	_tmp2_ = gupnp_dlna_information_get_info (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gst_discoverer_info_get_tags (_tmp3_);
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GUPnPDLNAInformation* _tmp5_;
		GstDiscovererInfo* _tmp6_;
		GstDiscovererInfo* _tmp7_;
		GstTagList* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp5_ = dlna_info;
		_tmp6_ = gupnp_dlna_information_get_info (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = gst_discoverer_info_get_tags (_tmp7_);
		_tmp10_ = gst_tag_list_get_string (_tmp8_, GST_TAG_TITLE, &_tmp9_);
		_g_free0 (title);
		title = _tmp9_;
		_tmp0_ = !_tmp10_;
	}
	_tmp11_ = _tmp0_;
	if (_tmp11_) {
		GFile* _tmp12_;
		gchar* _tmp13_ = NULL;
		_tmp12_ = file;
		_tmp13_ = g_file_get_basename (_tmp12_);
		_g_free0 (title);
		title = _tmp13_;
	}
	_tmp14_ = item;
	_tmp15_ = title;
	rygel_media_object_set_title ((RygelMediaObject*) _tmp14_, _tmp15_);
	_tmp16_ = dlna_info;
	_tmp17_ = gupnp_dlna_information_get_info (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = gst_discoverer_info_get_tags (_tmp18_);
	if (_tmp19_ != NULL) {
		GDate* date = NULL;
		GUPnPDLNAInformation* _tmp20_;
		GstDiscovererInfo* _tmp21_;
		GstDiscovererInfo* _tmp22_;
		GstTagList* _tmp23_ = NULL;
		GDate* _tmp24_ = NULL;
		gboolean _tmp25_ = FALSE;
		_tmp20_ = dlna_info;
		_tmp21_ = gupnp_dlna_information_get_info (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = gst_discoverer_info_get_tags (_tmp22_);
		_tmp25_ = gst_tag_list_get_date (_tmp23_, GST_TAG_DATE, &_tmp24_);
		_g_free0 (date);
		date = _tmp24_;
		if (_tmp25_) {
			gchar* _tmp26_ = NULL;
			gchar* datestr;
			gint datestr_length1;
			gint _datestr_size_;
			GDate* _tmp27_;
			gchar* _tmp28_;
			gint _tmp28__length1;
			RygelMediaItem* _tmp29_;
			gchar* _tmp30_;
			gint _tmp30__length1;
			gchar* _tmp31_;
			_tmp26_ = g_new0 (gchar, 30);
			datestr = _tmp26_;
			datestr_length1 = 30;
			_datestr_size_ = datestr_length1;
			_tmp27_ = date;
			_tmp28_ = datestr;
			_tmp28__length1 = datestr_length1;
			g_date_strftime (_tmp28_, _tmp28__length1, "%F", _tmp27_);
			_tmp29_ = item;
			_tmp30_ = datestr;
			_tmp30__length1 = datestr_length1;
			_tmp31_ = g_strdup ((const gchar*) _tmp30_);
			_g_free0 (_tmp29_->date);
			_tmp29_->date = _tmp31_;
			datestr = (g_free (datestr), NULL);
		}
		_g_free0 (date);
	}
	_tmp32_ = item;
	_tmp33_ = _tmp32_->date;
	if (_tmp33_ == NULL) {
		guint64 _tmp34_;
		GTimeVal _tmp35_ = {0};
		GTimeVal tv;
		RygelMediaItem* _tmp36_;
		gchar* _tmp37_ = NULL;
		_tmp34_ = mtime;
		_tmp35_.tv_sec = (glong) _tmp34_;
		_tmp35_.tv_usec = (glong) 0;
		tv = _tmp35_;
		_tmp36_ = item;
		_tmp37_ = g_time_val_to_iso8601 (&tv);
		_g_free0 (_tmp36_->date);
		_tmp36_->date = _tmp37_;
	}
	_tmp38_ = item;
	_tmp39_ = size;
	rygel_media_item_set_size (_tmp38_, (gint64) _tmp39_);
	_tmp40_ = item;
	_tmp41_ = mtime;
	((RygelMediaObject*) _tmp40_)->modified = (guint64) ((gint64) _tmp41_);
	_tmp42_ = dlna_info;
	_tmp43_ = gupnp_dlna_information_get_name (_tmp42_);
	_tmp44_ = _tmp43_;
	if (_tmp44_ != NULL) {
		RygelMediaItem* _tmp45_;
		GUPnPDLNAInformation* _tmp46_;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		RygelMediaItem* _tmp50_;
		GUPnPDLNAInformation* _tmp51_;
		const gchar* _tmp52_;
		const gchar* _tmp53_;
		gchar* _tmp54_;
		_tmp45_ = item;
		_tmp46_ = dlna_info;
		_tmp47_ = gupnp_dlna_information_get_name (_tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = g_strdup (_tmp48_);
		_g_free0 (_tmp45_->dlna_profile);
		_tmp45_->dlna_profile = _tmp49_;
		_tmp50_ = item;
		_tmp51_ = dlna_info;
		_tmp52_ = gupnp_dlna_information_get_mime (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = g_strdup (_tmp53_);
		_g_free0 (_tmp50_->mime_type);
		_tmp50_->mime_type = _tmp54_;
	} else {
		RygelMediaItem* _tmp55_;
		const gchar* _tmp56_;
		gchar* _tmp57_;
		_tmp55_ = item;
		_tmp56_ = mime;
		_tmp57_ = g_strdup (_tmp56_);
		_g_free0 (_tmp55_->mime_type);
		_tmp55_->mime_type = _tmp57_;
	}
	_tmp58_ = item;
	_tmp59_ = file;
	_tmp60_ = g_file_get_uri (_tmp59_);
	_tmp61_ = _tmp60_;
	rygel_media_item_add_uri (_tmp58_, _tmp61_);
	_g_free0 (_tmp61_);
	_g_free0 (title);
}



