
def print_with_tags(buf, tag):
    it = buf.get_start_iter()
    while it:
        if it.starts_tag(tag):
            print('[', end='')
        elif it.ends_tag(tag):
            print(']', end='')
        print(it.get_char(), end='')
        if not it.forward_char():
            break
    print()


def test_ree(meldbuffer):
    from gi.repository import Gtk
    from gi.repository import Gdk

    def have_atom(mb, atom_str):
        atom = Gdk.Atom.intern(atom_str, False)
        target_list = mb.get_copy_target_list()
        print("find in test", target_list.find(atom))

    have_atom(meldbuffer, 'application/x-gtk-text-buffer-rich-text')
    have_atom(meldbuffer, 'GTK_TEXT_BUFFER_CONTENTS')

    meldbuffer.set_text('<a b="b" a="a">')
    tag = meldbuffer.create_tag('test')

    start_it = meldbuffer.get_iter_at_offset(2)
    end_it = meldbuffer.get_iter_at_offset(8)
    assert meldbuffer.get_text(start_it, end_it, False) == ' b="b"'

    meldbuffer.apply_tag(tag, start_it, end_it)
    print_with_tags(meldbuffer, tag)

    clip = Gtk.Clipboard.get_default(Gdk.Display.get_default())

    meldbuffer.select_range(start_it, end_it)
    meldbuffer.cut_clipboard(clip, True)

    print_with_tags(meldbuffer, tag)

    paste_it = meldbuffer.get_iter_at_offset(-1)
    paste_it.backward_cursor_position()
    meldbuffer.paste_clipboard(clip, paste_it, True)

    print_with_tags(meldbuffer, tag)

    # print(meldbuffer.get_text(*meldbuffer.get_bounds(), False))

    assert False
