/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.javagnome.Handle;
import org.gnu.glib.Type;

/**
 * GtkVRuler displays a vertically-oriented scale that optionally can
 * contain tic marcs and a current-position pointer. You can set the
 * pointer position from inside the program - it follows the mouse.
 */
public class VRuler extends Ruler 
{
	public VRuler() {
		super(gtk_vruler_new());
	}
	
	/**
	 * Construct a VRuler from a handle to a native resource.
	 */
	public VRuler(Handle handle) {
	    super(handle);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_vruler_get_type());
	}

    native static final protected int gtk_vruler_get_type ();
    native static final protected Handle gtk_vruler_new ();
}

