/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;
import org.gnu.javagnome.Handle;

/**
 * The InputDialog window is designed specifically to be used in
 * software that controls access to XInput defices - input devices
 * other than the mouse and keyboard.
 */
public class InputDialog extends Dialog 
{
	/**
	 * Construct a new InputDialog.
	 */
	public InputDialog() {
		super(gtk_input_dialog_new());
	}
	
	/**
	 * Construct an InputDialog using a handle to a native resource.
	 */
	public InputDialog(Handle handle) {
	    super(handle);
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_input_dialog_get_type());
	}


    native static final protected int gtk_input_dialog_get_type ();
    native static final protected Handle gtk_input_dialog_new ();

}

