/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;
import org.gnu.javagnome.Handle;

/**
 * A CheckButton widget displays a small button with a label next to
 * it. The button can be toggled on or off by the mouse, and will
 * retain its state until it is toggled again.
 */
public class CheckButton extends ToggleButton 
{
	/**
	 * Creates a new CheckButton
	 */
	public CheckButton(){
		super(gtk_check_button_new());
	}
	
	/**
	 * Construct a check button using a handle to a native resource.
	 */
	public CheckButton(Handle handle) {
	    super(handle);
	}

	/**
	 * Creates a new Checkbutton with a label. If hasMnemonic is true, any mnemonic
	 * characters in the {@link Label} will be interpreted. See the description
	 * of the {@link Label} class for more details of mnemonic characters.
	 *
	 * @param label Text to be displayed in a label next to the check box.
	 * @param hasMnemonic Determines whether to interpret Mnemonic characters
	 */
	public CheckButton(String label, boolean hasMnemonic){
		super(init(label, hasMnemonic));
	}
	
	private static Handle init(String label, boolean hasMnemonic) {
		if (hasMnemonic)
			return gtk_check_button_new_with_mnemonic(label);
		else
			return gtk_check_button_new_with_label(label);
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_check_button_get_type());
	}


    native static final protected int gtk_check_button_get_type ();
    native static final protected Handle gtk_check_button_new ();
    native static final protected Handle gtk_check_button_new_with_label (String label);
    native static final protected Handle gtk_check_button_new_with_mnemonic (String label);

}

