/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;
import org.gnu.javagnome.Handle;

/**
 * This is a simple arrowhead widget that points up, down, left, or
 * right.
 */
public class Arrow extends Misc 
{
	/**
	 * Construct a new Arrow.
	 */
	public Arrow(ArrowType type, ShadowType shadowType) {
		super(gtk_arrow_new(type.getValue(), shadowType.getValue()));
	}
	
	/**
	 * Construct an Arrow from a handle to a native resource.
	 */
	public Arrow(Handle handle) {
	    super(handle);
	}
	
	/**
	 * Set the values for this Arrow object.
	 */
	public void setValues(ArrowType type, ShadowType shadowType) {
		gtk_arrow_set(getHandle(), type.getValue(), shadowType.getValue());
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_arrow_get_type());
	}
	

    native static final protected int gtk_arrow_get_type ();
    native static final protected Handle gtk_arrow_new (int arrowType, int shadowType);
    native static final protected void gtk_arrow_set (Handle arrow, int arrowType, int shadowType);

}

