/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.pango;
import org.gnu.glib.Enum;


/**
 * Describes how to wrap the lines of a PangoLayout to the desired width.
 */
public class WrapMode extends Enum 
{
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    static final private int _WORD = 0;
    /** Wrap lines at word boundaries. */
    static final public org.gnu.pango.WrapMode WORD = new org.gnu.pango.WrapMode (_WORD);
    static final private int _CHAR = 1;
    /** Wrap lines at character boundaries. */
    static final public org.gnu.pango.WrapMode CHAR = new org.gnu.pango.WrapMode (_CHAR);
    static final private int _WORD_CHAR = 2;
    /**
     * Wrap lines at word boundaries, but fall back to character
     * boundaries if there is not enough space for a full word.
     */
    static final public WrapMode WORD_CHAR = new WrapMode(_WORD_CHAR);
    static final private org.gnu.pango.WrapMode[] theInterned = new org.gnu.pango.WrapMode[] 
    {
        WORD, CHAR, WORD_CHAR
    }

;
    static private java.util.Hashtable theInternedExtras;
    static final private org.gnu.pango.WrapMode theSacrificialOne = new org.gnu.pango.WrapMode (0);
    static public org.gnu.pango.WrapMode intern (int value) 
    {
        if (value < theInterned.length) 
        {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) 
        {
            theInternedExtras = new java.util.Hashtable();
        }
        org.gnu.pango.WrapMode already = (org.gnu.pango.WrapMode) theInternedExtras.get (
            theSacrificialOne);
        if (already == null) 
        {
            already = new org.gnu.pango.WrapMode(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private WrapMode (int value) 
    {
        value_ = value;
    }

    public org.gnu.pango.WrapMode or (org.gnu.pango.WrapMode other) 
    {
        return intern(value_ | other.value_);
    }

    public org.gnu.pango.WrapMode and (org.gnu.pango.WrapMode other) 
    {
        return intern(value_ & other.value_);
    }

    public org.gnu.pango.WrapMode xor (org.gnu.pango.WrapMode other) 
    {
        return intern(value_ ^ other.value_);
    }

    public boolean test (org.gnu.pango.WrapMode other) 
    {
        return (value_ & other.value_) == other.value_;
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

