/*
 * Java-Gnome Bindings Library
 *
 * Copyright 2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

/**
 * Interface used in determining whether a given row should be
 * rendered as a separator.  A common way to implement this is to have
 * a boolean column in the {@link TreeModel}, whose values the {@link
 * #isSeparator} method returns.
 */
public interface TreeViewRowSeparatorMethod {
    /**
     * Determine if the given row (<tt>iter</tt> in the given {@link TreeModel}
     * should be displayed as a separator.
     *
     * @return <tt>true</tt> if the row is a separator, <tt>false</tt> 
     * otherwise.
     */
    public boolean isSeparator( TreeModel model, TreeIter iter );
}
