/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif


GdkEventType GdkEventExpose_get_type (GdkEventExpose * cptr) 
{
    return cptr->type;
}

/*
 * Class:     org.gnu.gdk.EventExpose
 * Method:    getType
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventExpose_getType (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventExpose *obj_g = (GdkEventExpose *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventExpose_get_type (obj_g));
}

GdkWindow * GdkEventExpose_get_window (GdkEventExpose * cptr) 
{
    return cptr->window;
}

/*
 * Class:     org.gnu.gdk.EventExpose
 * Method:    getWindow
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventExpose_getWindow (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventExpose *obj_g = (GdkEventExpose *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventExpose_get_window (obj_g));
}

gboolean GdkEventExpose_get_send_event (GdkEventExpose * cptr) 
{
    return cptr->send_event;
}

/*
 * Class:     org.gnu.gdk.EventExpose
 * Method:    getSendEvent
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_EventExpose_getSendEvent (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventExpose *obj_g = (GdkEventExpose *)getPointerFromHandle(env, obj);
    return (jboolean) (GdkEventExpose_get_send_event (obj_g));
}

GdkRegion * GdkEventExpose_get_region (GdkEventExpose * cptr) 
{
    return cptr->region;
}

/*
 * Class:     org.gnu.gdk.EventExpose
 * Method:    getRegion
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventExpose_getRegion (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventExpose *obj_g = (GdkEventExpose *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventExpose_get_region (obj_g));
}

GdkRectangle * GdkEventExpose_get_area (GdkEventExpose * cptr) 
{
    return &cptr->area;
}

/*
 * Class:     org.gnu.gdk.EventExpose
 * Method:    getArea
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventExpose_getArea (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventExpose *obj_g = (GdkEventExpose *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventExpose_get_area (obj_g));
}

gint32 GdkEventExpose_get_count (GdkEventExpose * cptr) 
{
    return cptr->count;
}

/*
 * Class:     org.gnu.gdk.EventExpose
 * Method:    getCount
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventExpose_getCount (JNIEnv *env, jclass cls, jobject obj)
{
    GdkEventExpose *obj_g = (GdkEventExpose *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventExpose_get_count (obj_g));
}


#ifdef __cplusplus
}

#endif
