/*
 * Java-Gnome Bindings Library
 * 
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 * 
 * The Java-Gnome bindings library is free software distributed under the terms
 * of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;
import org.gnu.gdk.Pixbuf;
import org.gnu.glib.Boxed;
/**
 * This object represents a set of Icons that are a variant of a 
 * particular icon.
 */
public class IconSet extends Boxed 
{
	/**
	 * Initialize an IconSet with a handle to a native resource.
	 */
	public IconSet(int handle) {
		this.handle = handle;
	}
	

	/**
	 * Construct a new empty IconSet.
	 */
	public IconSet() {
		handle = gtk_icon_set_new();
	}
	
	/**
	 * Construct a new IconSet from a Pixbuf.
	 */
	public IconSet(Pixbuf pixbuf) {
		handle = gtk_icon_set_new_from_pixbuf(pixbuf.getHandle());
	}
	
	/**
	 * Icon sets have a list of {@link IconSource} which they use as base
	 * icons for rendering icons in different states and sizes.  The base 
	 * images and when to use them are described by a IconSource.  This
	 * method adds an IconSource to the IconSet.
	 * @param iconSource The IconSource to add to this IconSet.
	 */
	public void addSource(IconSource iconSource) {
		gtk_icon_set_add_source(handle, iconSource.getHandle());
	}
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_icon_set_new ();
    native static final protected int gtk_icon_set_new_from_pixbuf (int pixbuf);
    native static final protected int gtk_icon_set_ref (int iconSet);
    native static final protected void gtk_icon_set_unref (int iconSet);
    native static final protected int gtk_icon_set_copy (int iconSet);
    native static final protected int gtk_icon_set_render_icon (int iconSet, int style, int 
        direction, int state, int size, int widget, String detail);
    native static final protected void gtk_icon_set_add_source (int iconSet, int source);
    native static final protected void gtk_icon_set_get_sizes (int iconSet, int [] sizes, int [] 
        numSizes);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

