/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;

import org.gnu.glib.GObject;
import org.gnu.glib.Handle;

/**
 */
public class Screen extends GObject {
	
	public Screen() {
		super(gdk_screen_get_default());
	}
	
	public Screen(Handle handle) {
		super(handle);
	}
	
	public Colormap getDefaultColormap() {
	    Handle hndl = gdk_screen_get_default_colormap(getHandle());
		GObject obj = getGObjectFromHandle(hndl);
		if (null != obj)
			return (Colormap)obj;
		return new Colormap(hndl);
	}
	
	public void setDefaultColormap(Colormap colormap) {
		gdk_screen_set_default_colormap(getHandle(), colormap.getHandle());
	}
	
	public Colormap getSystemColormap() {
	    Handle hndl = gdk_screen_get_system_colormap(getHandle());
		GObject obj = getGObjectFromHandle(hndl);
		if (null != obj)
			return (Colormap)obj;
		return new Colormap(hndl);
	}
	
	public Visual gdtSystemVisual() {
	    Handle hndl = gdk_screen_get_system_visual(getHandle());
		GObject obj = getGObjectFromHandle(hndl);
		if (null != obj)
			return (Visual)obj;
		return new Visual(hndl);
	}
	
	public Colormap getRGBColormap() {
	    Handle hndl = gdk_screen_get_rgb_colormap(getHandle());
		GObject obj = getGObjectFromHandle(hndl);
		if (null != obj)
			return (Colormap)obj;
		return new Colormap(hndl);
	}
	
	public Visual getRGBVisual() {
	    Handle hndl = gdk_screen_get_rgb_visual(getHandle());
		GObject obj = getGObjectFromHandle(hndl);
		if (null != obj)
			return (Visual)obj;
		return new Visual(hndl);
	}
	
	public Window getRootWindow() {
	    Handle hndl = gdk_screen_get_root_window(getHandle());
		GObject obj = getGObjectFromHandle(hndl);
		if (null != obj)
			return (Window)obj;
		return new Window(hndl);
	}
	
	public Display getDisplay() {
	    Handle hndl = gdk_screen_get_display(getHandle());
		GObject obj = getGObjectFromHandle(hndl);
		if (null != obj)
			return (Display)obj;
		return new Display(hndl);
	}

	
	public int getNumber() {
		return gdk_screen_get_number(getHandle());
	}
	
	public int getHeight() {
		return gdk_screen_get_height(getHandle());
	}
	
	public int getWidth() {
		return gdk_screen_get_width(getHandle());
	}
	
	public int getHeightMM() {
		return gdk_screen_get_height_mm(getHandle());
	}
	
	public int getWidthMM() {
		return gdk_screen_get_width_mm(getHandle());
	}
	
	public Visual[] ListVisuals() {
	    Handle[] hndls = gdk_screen_list_visuals(getHandle());
		Visual[] vis = new Visual[hndls.length];
		for (int i = 0; i < hndls.length; i++) {
			vis[i] = new Visual(hndls[i]);
		}
		return vis;
	}
	
	public Window[] getToplevelWindows() {
	    Handle[] hndls = gdk_screen_get_toplevel_windows(getHandle());
		Window[] win = new Window[hndls.length];
		for (int i = 0; i < hndls.length; i++) {
			GObject obj = getGObjectFromHandle(hndls[i]);
			if (null != obj)
				win[i] = (Window)obj;
			else
				win[i] = new Window(hndls[i]);
		}
		return win;
	}

	public String makeDisplayName() {
		return gdk_screen_make_display_name(getHandle());
	}

	public int getNumMonitors() {
		return gdk_screen_get_n_monitors(getHandle());
	}
	
	public Rectangle getMonitorGeometry(int monitorNum) {
	    Handle hndl = GObject.getNullHandle();
		gdk_screen_get_monitor_geometry(getHandle(), monitorNum, hndl);
		return new Rectangle(hndl);
	}
	
	public int getMonitorAtPoint(int x, int y) {
		return gdk_screen_get_monitor_at_point(getHandle(), x, y);
	}
	
	public int getMonitorAtWindow(Window win) {
		return gdk_screen_get_monitor_at_window(getHandle(), win.getHandle());
	}
	
	public void broadcastClientMessage(Event evt) {
		gdk_screen_broadcast_client_message(getHandle(), evt.getHandle());
	}


	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int gdk_screen_get_type();
	native static final protected Handle gdk_screen_get_default_colormap(Handle screen);
	native static final protected void gdk_screen_set_default_colormap(Handle screen, Handle colormap);
	native static final protected Handle gdk_screen_get_system_colormap(Handle screen);
	native static final protected Handle gdk_screen_get_system_visual(Handle screen);
	native static final protected Handle gdk_screen_get_rgb_colormap(Handle screen);
	native static final protected Handle gdk_screen_get_rgb_visual(Handle screen);
	native static final protected Handle gdk_screen_get_root_window(Handle screen);
	native static final protected Handle gdk_screen_get_display(Handle screen);
	native static final protected int gdk_screen_get_number(Handle screen);
	native static final protected int gdk_screen_get_height(Handle screen);
	native static final protected int gdk_screen_get_width(Handle screen);
	native static final protected int gdk_screen_get_height_mm(Handle screen);
	native static final protected int gdk_screen_get_width_mm(Handle screen);
	native static final protected Handle[] gdk_screen_list_visuals(Handle screen);
	native static final protected Handle[] gdk_screen_get_toplevel_windows(Handle screen);
	native static final protected String gdk_screen_make_display_name(Handle screen);
	native static final protected int gdk_screen_get_n_monitors(Handle screen);
	native static final protected void gdk_screen_get_monitor_geometry(Handle screen, int monitorNum, Handle rect);
	native static final protected int gdk_screen_get_monitor_at_point(Handle screen, int x, int y);
	native static final protected int gdk_screen_get_monitor_at_window(Handle screen, Handle window);
	native static final protected void gdk_screen_broadcast_client_message(Handle screen, Handle event);
	native static final protected Handle gdk_screen_get_default();
	native static final protected boolean gdk_screen_get_setting(Handle screen, String name, Handle value);
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
}
