/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-01 07:00:36 EDT
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>
#ifdef __cplusplus
extern "C" 
{
#endif
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_new
     * Signature: (III)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Window_gdk_1window_1new (JNIEnv *env, jclass cls, jint 
        parent, jint attriutes, jint attributesMask) 
    {
        GdkWindow *parent_g = (GdkWindow *)parent;
        GdkWindowAttr *attriutes_g = (GdkWindowAttr *)attriutes;
        gint32 attributesMask_g = (gint32) attributesMask;
        {
            return (jint)gdk_window_new (parent_g, attriutes_g, attributesMask_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_get_window_type
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Window_gdk_1window_1get_1window_1type (JNIEnv *env, 
        jclass cls, jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            jint result_j = (jint) (gdk_window_get_window_type (window_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_destroy
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1destroy (JNIEnv *env, jclass cls, 
        jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            gdk_window_destroy (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_at_pointer
     * Signature: ([Lint ;[Lint ;)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Window_gdk_1window_1at_1pointer (JNIEnv *env, jclass 
        cls, jintArray winX, jintArray winY) 
    {
        gint *winX_g = (gint *) (*env)->GetIntArrayElements (env, winX, NULL);
        gint *winY_g = (gint *) (*env)->GetIntArrayElements (env, winY, NULL);
        {
            return (jint)gdk_window_at_pointer (winX_g, winY_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_show
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1show (JNIEnv *env, jclass cls, jint 
        window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            gdk_window_show (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_hide
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1hide (JNIEnv *env, jclass cls, jint 
        window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            gdk_window_hide (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_withdraw
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1withdraw (JNIEnv *env, jclass cls, 
        jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            gdk_window_withdraw (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_show_unraised
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1show_1unraised (JNIEnv *env, jclass 
        cls, jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            gdk_window_show_unraised (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_move
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1move (JNIEnv *env, jclass cls, jint 
        window, jint x, jint y) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        gint32 x_g = (gint32) x;
        gint32 y_g = (gint32) y;
        {
            gdk_window_move (window_g, x_g, y_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_resize
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1resize (JNIEnv *env, jclass cls, 
        jint window, jint width, jint height) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        gint32 width_g = (gint32) width;
        gint32 height_g = (gint32) height;
        {
            gdk_window_resize (window_g, width_g, height_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_move_resize
     * Signature: (IIIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1move_1resize (JNIEnv *env, jclass 
        cls, jint window, jint x, jint y, jint width, jint height) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        gint32 x_g = (gint32) x;
        gint32 y_g = (gint32) y;
        gint32 width_g = (gint32) width;
        gint32 height_g = (gint32) height;
        {
            gdk_window_move_resize (window_g, x_g, y_g, width_g, height_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_reparent
     * Signature: (IIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1reparent (JNIEnv *env, jclass cls, 
        jint window, jint newParent, jint x, jint y) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        GdkWindow *newParent_g = (GdkWindow *)newParent;
        gint32 x_g = (gint32) x;
        gint32 y_g = (gint32) y;
        {
            gdk_window_reparent (window_g, newParent_g, x_g, y_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_clear
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1clear (JNIEnv *env, jclass cls, 
        jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            gdk_window_clear (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_clear_area
     * Signature: (IIIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1clear_1area (JNIEnv *env, jclass 
        cls, jint window, jint x, jint y, jint width, jint height) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        gint32 x_g = (gint32) x;
        gint32 y_g = (gint32) y;
        gint32 width_g = (gint32) width;
        gint32 height_g = (gint32) height;
        {
            gdk_window_clear_area (window_g, x_g, y_g, width_g, height_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_clear_area_e
     * Signature: (IIIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1clear_1area_1e (JNIEnv *env, jclass 
        cls, jint window, jint x, jint y, jint width, jint height) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        gint32 x_g = (gint32) x;
        gint32 y_g = (gint32) y;
        gint32 width_g = (gint32) width;
        gint32 height_g = (gint32) height;
        {
            gdk_window_clear_area_e (window_g, x_g, y_g, width_g, height_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_raise
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1raise (JNIEnv *env, jclass cls, 
        jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            gdk_window_raise (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_lower
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1lower (JNIEnv *env, jclass cls, 
        jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            gdk_window_lower (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_focus
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1focus (JNIEnv *env, jclass cls, 
        jint window, jint timestamp) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        gint32 timestamp_g = (gint32) timestamp;
        {
            gdk_window_focus (window_g, timestamp_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_set_user_data
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1set_1user_1data (JNIEnv *env, 
        jclass cls, jint window, jint userData) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        gpointer *userData_g = (gpointer *)userData;
        {
            gdk_window_set_user_data (window_g, userData_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_set_override_redirect
     * Signature: (IZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1set_1override_1redirect (JNIEnv 
        *env, jclass cls, jint window, jboolean overrideRedirect) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        gboolean overrideRedirect_g = (gboolean) overrideRedirect;
        {
            gdk_window_set_override_redirect (window_g, overrideRedirect_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_scroll
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1scroll (JNIEnv *env, jclass cls, 
        jint window, jint dx, jint dy) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        gint32 dx_g = (gint32) dx;
        gint32 dy_g = (gint32) dy;
        {
            gdk_window_scroll (window_g, dx_g, dy_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_shape_combine_mask
     * Signature: (IIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1shape_1combine_1mask (JNIEnv *env, 
        jclass cls, jint window, jint shape_mask, jint offsetX, jint offsetY) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        GdkBitmap *shape_mask_g = (GdkBitmap *)shape_mask;
        gint32 offsetX_g = (gint32) offsetX;
        gint32 offsetY_g = (gint32) offsetY;
        {
            gdk_window_shape_combine_mask (window_g, shape_mask_g, offsetX_g, offsetY_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_shape_combine_region
     * Signature: (IIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1shape_1combine_1region (JNIEnv 
        *env, jclass cls, jint window, jint shape_region, jint offsetX, jint offsetY) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        GdkRegion *shape_region_g = (GdkRegion *)shape_region;
        gint32 offsetX_g = (gint32) offsetX;
        gint32 offsetY_g = (gint32) offsetY;
        {
            gdk_window_shape_combine_region (window_g, shape_region_g, offsetX_g, offsetY_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_set_child_shapes
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1set_1child_1shapes (JNIEnv *env, 
        jclass cls, jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            gdk_window_set_child_shapes (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_merge_child_shapes
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1merge_1child_1shapes (JNIEnv *env, 
        jclass cls, jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            gdk_window_merge_child_shapes (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_is_visible
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Window_gdk_1window_1is_1visible (JNIEnv *env, 
        jclass cls, jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            jboolean result_j = (jboolean) (gdk_window_is_visible (window_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_is_viewable
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Window_gdk_1window_1is_1viewable (JNIEnv *env, 
        jclass cls, jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            jboolean result_j = (jboolean) (gdk_window_is_viewable (window_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_get_state
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Window_gdk_1window_1get_1state (JNIEnv *env, jclass 
        cls, jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            jint result_j = (jint) (gdk_window_get_state (window_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_set_static_gravities
     * Signature: (IZ)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Window_gdk_1window_1set_1static_1gravities (JNIEnv 
        *env, jclass cls, jint window, jboolean useStatic) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        gboolean useStatic_g = (gboolean) useStatic;
        {
            jboolean result_j = (jboolean) (gdk_window_set_static_gravities (window_g, useStatic_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_foreign_new
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Window_gdk_1window_1foreign_1new (JNIEnv *env, jclass 
        cls, jint anid) 
    {
        GdkNativeWindow anid_g = (GdkNativeWindow)anid;
        {
            return (jint)gdk_window_foreign_new (anid_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_set_type_hint
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1set_1type_1hint (JNIEnv *env, 
        jclass cls, jint window, jint hint) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        GdkWindowTypeHint hint_g = (GdkWindowTypeHint) hint;
        {
            gdk_window_set_type_hint (window_g, hint_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_set_modal_hint
     * Signature: (IZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1set_1modal_1hint (JNIEnv *env, 
        jclass cls, jint window, jboolean modal) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        gboolean modal_g = (gboolean) modal;
        {
            gdk_window_set_modal_hint (window_g, modal_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_set_geometry_hints
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1set_1geometry_1hints (JNIEnv *env, 
        jclass cls, jint window, jint geometry, jint flags) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        GdkGeometry *geometry_g = (GdkGeometry *)geometry;
        GdkWindowHints flags_g = (GdkWindowHints) flags;
        {
            gdk_window_set_geometry_hints (window_g, geometry_g, flags_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_begin_paint_rect
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1begin_1paint_1rect (JNIEnv *env, 
        jclass cls, jint window, jint rectangle) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        GdkRectangle *rectangle_g = (GdkRectangle *)rectangle;
        {
            gdk_window_begin_paint_rect (window_g, rectangle_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_begin_paint_region
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1begin_1paint_1region (JNIEnv *env, 
        jclass cls, jint window, jint region) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        GdkRegion *region_g = (GdkRegion *)region;
        {
            gdk_window_begin_paint_region (window_g, region_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_end_paint
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1end_1paint (JNIEnv *env, jclass 
        cls, jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            gdk_window_end_paint (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_set_title
     * Signature: (Ijava.lang.String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1set_1title (JNIEnv *env, jclass 
        cls, jint window, jstring title) 
    {
        const gchar* title_g = (*env)->GetStringUTFChars(env, title, 0);
        gdk_window_set_title ((GdkWindow*)window, title_g);
        (*env)->ReleaseStringUTFChars(env, title, title_g);
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_set_role
     * Signature: (Ijava.lang.String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1set_1role (JNIEnv *env, jclass cls, 
        jint window, jstring role) 
    {
        const gchar* role_g = (*env)->GetStringUTFChars(env, role, 0);
        gdk_window_set_role ((GdkWindow*)window, role_g);
        (*env)->ReleaseStringUTFChars(env, role, role_g);
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_set_transient_for
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1set_1transient_1for (JNIEnv *env, 
        jclass cls, jint Window, jint leader) 
    {
        GdkWindow *Window_g = (GdkWindow *)Window;
        GdkWindow *leader_g = (GdkWindow *)leader;
        {
            gdk_window_set_transient_for (Window_g, leader_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_set_background
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1set_1background (JNIEnv *env, 
        jclass cls, jint window, jint color) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        GdkColor *color_g = (GdkColor *)color;
        {
            gdk_window_set_background (window_g, color_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_set_back_pixmap
     * Signature: (IIZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1set_1back_1pixmap (JNIEnv *env, 
        jclass cls, jint window, jint pixmap, jboolean parentRelative) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        GdkPixmap *pixmap_g = (GdkPixmap *)pixmap;
        gboolean parentRelative_g = (gboolean) parentRelative;
        {
            gdk_window_set_back_pixmap (window_g, pixmap_g, parentRelative_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_set_cursor
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1set_1cursor (JNIEnv *env, jclass 
        cls, jint window, jint cursor) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        GdkCursor *cursor_g = (GdkCursor *)cursor;
        {
            gdk_window_set_cursor (window_g, cursor_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_get_geometry
     * Signature: (I[Lint ;[Lint ;[Lint ;[Lint ;[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1get_1geometry (JNIEnv *env, jclass 
        cls, jint window, jintArray x, jintArray y, jintArray width, jintArray height, jintArray 
        depth) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        gint *x_g = (gint *) (*env)->GetIntArrayElements (env, x, NULL);
        gint *y_g = (gint *) (*env)->GetIntArrayElements (env, y, NULL);
        gint *width_g = (gint *) (*env)->GetIntArrayElements (env, width, NULL);
        gint *height_g = (gint *) (*env)->GetIntArrayElements (env, height, NULL);
        gint *depth_g = (gint *) (*env)->GetIntArrayElements (env, depth, NULL);
        {
            gdk_window_get_geometry (window_g, x_g, y_g, width_g, height_g, depth_g);
            (*env)->ReleaseIntArrayElements (env, x, (jint *) x_g, 0);
            (*env)->ReleaseIntArrayElements (env, y, (jint *) y_g, 0);
            (*env)->ReleaseIntArrayElements (env, width, (jint *) width_g, 0);
            (*env)->ReleaseIntArrayElements (env, height, (jint *) height_g, 0);
            (*env)->ReleaseIntArrayElements (env, depth, (jint *) depth_g, 0);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_get_position
     * Signature: (I[Lint ;[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1get_1position (JNIEnv *env, jclass 
        cls, jint window, jintArray x, jintArray y) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        gint *x_g = (gint *) (*env)->GetIntArrayElements (env, x, NULL);
        gint *y_g = (gint *) (*env)->GetIntArrayElements (env, y, NULL);
        {
            gdk_window_get_position (window_g, x_g, y_g);
            (*env)->ReleaseIntArrayElements (env, x, (jint *) x_g, 0);
            (*env)->ReleaseIntArrayElements (env, y, (jint *) y_g, 0);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_get_origin
     * Signature: (I[Lint ;[Lint ;)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Window_gdk_1window_1get_1origin (JNIEnv *env, jclass 
        cls, jint window, jintArray x, jintArray y) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        gint *x_g = (gint *) (*env)->GetIntArrayElements (env, x, NULL);
        gint *y_g = (gint *) (*env)->GetIntArrayElements (env, y, NULL);
        {
            jint result_j = (jint) (gdk_window_get_origin (window_g, x_g, y_g));
            (*env)->ReleaseIntArrayElements (env, x, (jint *) x_g, 0);
            (*env)->ReleaseIntArrayElements (env, y, (jint *) y_g, 0);
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_get_root_origin
     * Signature: (I[Lint ;[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1get_1root_1origin (JNIEnv *env, 
        jclass cls, jint window, jintArray x, jintArray y) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        gint *x_g = (gint *) (*env)->GetIntArrayElements (env, x, NULL);
        gint *y_g = (gint *) (*env)->GetIntArrayElements (env, y, NULL);
        {
            gdk_window_get_root_origin (window_g, x_g, y_g);
            (*env)->ReleaseIntArrayElements (env, x, (jint *) x_g, 0);
            (*env)->ReleaseIntArrayElements (env, y, (jint *) y_g, 0);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_get_frame_extents
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1get_1frame_1extents (JNIEnv *env, 
        jclass cls, jint window, jint rect) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        GdkRectangle *rect_g = (GdkRectangle *)rect;
        {
            gdk_window_get_frame_extents (window_g, rect_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_get_parent
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Window_gdk_1window_1get_1parent (JNIEnv *env, jclass 
        cls, jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            return (jint)gdk_window_get_parent (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_get_toplevel
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Window_gdk_1window_1get_1toplevel (JNIEnv *env, jclass 
        cls, jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            return (jint)gdk_window_get_toplevel (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_get_children
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Window_gdk_1window_1get_1children (JNIEnv *env, jclass 
        cls, jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            return (jint)gdk_window_get_children (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_peek_children
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Window_gdk_1window_1peek_1children (JNIEnv *env, jclass 
        cls, jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            return (jint)gdk_window_peek_children (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_get_events
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Window_gdk_1window_1get_1events (JNIEnv *env, jclass 
        cls, jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            jint result_j = (jint) (gdk_window_get_events (window_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_set_events
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1set_1events (JNIEnv *env, jclass 
        cls, jint window, jint eventMask) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        GdkEventMask eventMask_g = (GdkEventMask) eventMask;
        {
            gdk_window_set_events (window_g, eventMask_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_set_icon_list
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1set_1icon_1list (JNIEnv *env, 
        jclass cls, jint window, jint pixbufs) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        GList *pixbufs_g = (GList *)pixbufs;
        {
            gdk_window_set_icon_list (window_g, pixbufs_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_set_icon
     * Signature: (IIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1set_1icon (JNIEnv *env, jclass cls, 
        jint window, jint iconWindow, jint pixmap, jint mask) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        GdkWindow *iconWindow_g = (GdkWindow *)iconWindow;
        GdkPixmap *pixmap_g = (GdkPixmap *)pixmap;
        GdkBitmap *mask_g = (GdkBitmap *)mask;
        {
            gdk_window_set_icon (window_g, iconWindow_g, pixmap_g, mask_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_set_icon_name
     * Signature: (Ijava.lang.String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1set_1icon_1name (JNIEnv *env, 
        jclass cls, jint window, jstring name) 
    {
        const gchar* name_g = (*env)->GetStringUTFChars(env, name, 0);
        gdk_window_set_icon_name ((GdkWindow*)window, name_g);
        (*env)->ReleaseStringUTFChars(env, name, name_g);
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_set_group
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1set_1group (JNIEnv *env, jclass 
        cls, jint window, jint leader) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        GdkWindow *leader_g = (GdkWindow *)leader;
        {
            gdk_window_set_group (window_g, leader_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_set_decorations
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1set_1decorations (JNIEnv *env, 
        jclass cls, jint window, jint decorations) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        GdkWMDecoration decorations_g = (GdkWMDecoration) decorations;
        {
            gdk_window_set_decorations (window_g, decorations_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_set_functions
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1set_1functions (JNIEnv *env, jclass 
        cls, jint window, jint functions) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        GdkWMFunction functions_g = (GdkWMFunction) functions;
        {
            gdk_window_set_functions (window_g, functions_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_get_toplevels
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Window_gdk_1window_1get_1toplevels (JNIEnv *env, jclass 
        cls) 
    {
        {
            return (jint)gdk_window_get_toplevels ();
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_iconify
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1iconify (JNIEnv *env, jclass cls, 
        jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            gdk_window_iconify (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_deiconify
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1deiconify (JNIEnv *env, jclass cls, 
        jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            gdk_window_deiconify (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_stick
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1stick (JNIEnv *env, jclass cls, 
        jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            gdk_window_stick (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_unstick
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1unstick (JNIEnv *env, jclass cls, 
        jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            gdk_window_unstick (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_maximize
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1maximize (JNIEnv *env, jclass cls, 
        jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            gdk_window_maximize (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_unmaximize
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1unmaximize (JNIEnv *env, jclass 
        cls, jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            gdk_window_unmaximize (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_register_dnd
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1register_1dnd (JNIEnv *env, jclass 
        cls, jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            gdk_window_register_dnd (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_begin_resize_drag
     * Signature: (IIIIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1begin_1resize_1drag (JNIEnv *env, 
        jclass cls, jint window, jint edge, jint button, jint rootX, jint rootY, jint timestamp) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        GdkWindowEdge edge_g = (GdkWindowEdge) edge;
        gint32 button_g = (gint32) button;
        gint32 rootX_g = (gint32) rootX;
        gint32 rootY_g = (gint32) rootY;
        gint32 timestamp_g = (gint32) timestamp;
        {
            gdk_window_begin_resize_drag (window_g, edge_g, button_g, rootX_g, rootY_g, timestamp_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_begin_move_drag
     * Signature: (IIIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1begin_1move_1drag (JNIEnv *env, 
        jclass cls, jint window, jint button, jint rootX, jint rootY, jint timestamp) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        gint32 button_g = (gint32) button;
        gint32 rootX_g = (gint32) rootX;
        gint32 rootY_g = (gint32) rootY;
        gint32 timestamp_g = (gint32) timestamp;
        {
            gdk_window_begin_move_drag (window_g, button_g, rootX_g, rootY_g, timestamp_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_invalidate_rect
     * Signature: (IIZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1invalidate_1rect (JNIEnv *env, 
        jclass cls, jint window, jint rect, jboolean invalidateChildren) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        GdkRectangle *rect_g = (GdkRectangle *)rect;
        gboolean invalidateChildren_g = (gboolean) invalidateChildren;
        {
            gdk_window_invalidate_rect (window_g, rect_g, invalidateChildren_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_invalidate_region
     * Signature: (IIZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1invalidate_1region (JNIEnv *env, 
        jclass cls, jint window, jint region, jboolean invalidateChildren) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        GdkRegion *region_g = (GdkRegion *)region;
        gboolean invalidateChildren_g = (gboolean) invalidateChildren;
        {
            gdk_window_invalidate_region (window_g, region_g, invalidateChildren_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_get_update_area
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Window_gdk_1window_1get_1update_1area (JNIEnv *env, 
        jclass cls, jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            return (jint)gdk_window_get_update_area (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_freeze_updates
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1freeze_1updates (JNIEnv *env, 
        jclass cls, jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            gdk_window_freeze_updates (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_thaw_updates
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1thaw_1updates (JNIEnv *env, jclass 
        cls, jint window) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        {
            gdk_window_thaw_updates (window_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_process_all_updates
     * Signature: ()V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1process_1all_1updates (JNIEnv *env, 
        jclass cls) 
    {
        {
            gdk_window_process_all_updates ();
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_process_updates
     * Signature: (IZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1process_1updates (JNIEnv *env, 
        jclass cls, jint window, jboolean updateChildren) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        gboolean updateChildren_g = (gboolean) updateChildren;
        {
            gdk_window_process_updates (window_g, updateChildren_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_set_debug_updates
     * Signature: (Z)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1set_1debug_1updates (JNIEnv *env, 
        jclass cls, jboolean setting) 
    {
        gboolean setting_g = (gboolean) setting;
        {
            gdk_window_set_debug_updates (setting_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_constrain_size
     * Signature: (IIII[Lint ;[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1constrain_1size (JNIEnv *env, 
        jclass cls, jint geometry, jint flags, jint width, jint height, jintArray newWidth, 
        jintArray newHeight) 
    {
        GdkGeometry *geometry_g = (GdkGeometry *)geometry;
        gint32 flags_g = (gint32) flags;
        gint32 width_g = (gint32) width;
        gint32 height_g = (gint32) height;
        gint *newWidth_g = (gint *) (*env)->GetIntArrayElements (env, newWidth, NULL);
        gint *newHeight_g = (gint *) (*env)->GetIntArrayElements (env, newHeight, NULL);
        {
            gdk_window_constrain_size (geometry_g, flags_g, width_g, height_g, newWidth_g, 
                newHeight_g);
            (*env)->ReleaseIntArrayElements (env, newWidth, (jint *) newWidth_g, 0);
            (*env)->ReleaseIntArrayElements (env, newHeight, (jint *) newHeight_g, 0);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_window_get_internal_paint_info
     * Signature: (I[Lint ;[Lint ;[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1window_1get_1internal_1paint_1info (JNIEnv 
        *env, jclass cls, jint window, jintArray realDrawable, jintArray xOffset, jintArray yOffset)
    {
        GdkWindow *window_g = (GdkWindow *)window;
        GdkDrawable **realDrawable_g = NULL;
        gint *xOffset_g = (gint *) (*env)->GetIntArrayElements (env, xOffset, NULL);
        gint *yOffset_g = (gint *) (*env)->GetIntArrayElements (env, yOffset, NULL);
	jsize len = (*env)->GetArrayLength(env, realDrawable);
	gint i;

	for (i = 0; i < len; i++) {
		jint ptr;
		(*env)->GetIntArrayRegion(env, realDrawable, i, 1, &ptr);
		realDrawable_g[i] = (GdkDrawable*)ptr;
	}
        gdk_window_get_internal_paint_info (window_g, realDrawable_g, xOffset_g, yOffset_g);
        (*env)->ReleaseIntArrayElements (env, xOffset, (jint *) xOffset_g, 0);
        (*env)->ReleaseIntArrayElements (env, yOffset, (jint *) yOffset_g, 0);
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_draw_point
     * Signature: (IIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1draw_1point (JNIEnv *env, jclass cls, jint 
        obj, jint gc, jint x, jint y) 
    {
      GdkDrawable *drawable = (GdkDrawable *)obj;
        GdkGC *gc_g = (GdkGC *)gc;
        gint32 x_g = (gint32) x;
        gint32 y_g = (gint32) y;
        {
            gdk_draw_point (drawable, gc_g, x_g, y_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_draw_line
     * Signature: (IIIIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1draw_1line (JNIEnv *env, jclass cls, jint 
        obj, jint gc, jint x1, jint y1, jint x2, jint y2) 
    {
      GdkDrawable *drawable = (GdkDrawable *)obj;
        GdkGC *gc_g = (GdkGC *)gc;
        gint32 x1_g = (gint32) x1;
        gint32 y1_g = (gint32) y1;
        gint32 x2_g = (gint32) x2;
        gint32 y2_g = (gint32) y2;
        {
            gdk_draw_line (drawable, gc_g, x1_g, y1_g, x2_g, y2_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_draw_rectangle
     * Signature: (IIZIIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1draw_1rectangle (JNIEnv *env, jclass cls, 
        jint obj, jint gc, jboolean filled, jint x, jint y, jint width, jint height) 
    {
      GdkDrawable *drawable = (GdkDrawable *)obj;
        GdkGC *gc_g = (GdkGC *)gc;
        gboolean filled_g = (gboolean) filled;
        gint32 x_g = (gint32) x;
        gint32 y_g = (gint32) y;
        gint32 width_g = (gint32) width;
        gint32 height_g = (gint32) height;
        {
            gdk_draw_rectangle (drawable, gc_g, filled_g, x_g, y_g, width_g, height_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Window
     * Method:    gdk_draw_arc
     * Signature: (IIZIIIIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Window_gdk_1draw_1arc (JNIEnv *env, jclass cls, jint 
        obj, jint gc, jboolean filled, jint x, jint y, jint width, jint height, jint angle1, jint 
        angle2) 
    {
      GdkDrawable *drawable = (GdkDrawable *)obj;
        GdkGC *gc_g = (GdkGC *)gc;
        gboolean filled_g = (gboolean) filled;
        gint32 x_g = (gint32) x;
        gint32 y_g = (gint32) y;
        gint32 width_g = (gint32) width;
        gint32 height_g = (gint32) height;
        gint32 angle1_g = (gint32) angle1;
        gint32 angle2_g = (gint32) angle2;
        {
            gdk_draw_arc (drawable, gc_g, filled_g, x_g, y_g, width_g, height_g, angle1_g, angle2_g);
        }
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
