/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2003 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;


/**
 * This class is a catch-all for methods in GTK that are not
 * associated with a GTK object.
 */

public class Gtk 
{
	
	/**
	 * This method should be called before using any java-gnome
	 * objects.  It initialized everything needed to use the native
	 * libraries.  This method will terminate you program if it is
	 * unable to initialize the native libraries.
	 * 
	 * @param args The command line arguments passed to the applicaion.
	 */
	public static void init(String[] args) {
	    int [] argLen = new int[1];
	    // I add one to the length since the makeArgv
	    // method will add one additional parameter to
	    // the array.
	    argLen[0] = args.length+1;

	    String appName = System.getProperty("gnome.appName", "java-gnome");

		if (args == null) {
			args = new String[] { appName };
		} else {
			String[] newArr = new String[args.length + 1];
			System.arraycopy(args, 0, newArr, 1, args.length);
			newArr[0] = appName;
			args = newArr;
		}
	    Gtk.gtk_init(argLen, args);
	}
	
	/**
	 * Runs the main event loop.
	 */
	public static void main() {
        gtkThread = Thread.currentThread();
	    Gtk.gtk_main();
	}

    private static Thread gtkThread;
    /**
     * Returns true if the current thread is the Gtk thread
     */
    public static boolean isGtkThread() {
        return gtkThread == Thread.currentThread();
    }
	
	/**
	 * Runs a single iteration of the main loop.  If no events are waiting
	 * to be processed GTK will block until the next event is noticed.
	 */
	public static boolean mainIteration() {
		return Gtk.gtk_main_iteration();
	}

	/**
	 * Quit the main event loop.
	 */
	public static void mainQuit() {
		Gtk.gtk_main_quit();
	}
	
	/**
	 * Checks if any events are pending.  This can be used to update the 
	 * GUI and invoke timeouts etc. while doing some time intensive 
	 * computation.
	 * 
	 * @return true if any events are pending.
	 */
	public static boolean eventsPending() {
		if (Gtk.gtk_events_pending() != 0)
			return true;
		return false;
	}

        static String getTypeName(int handle) {
	    try {
	    return gtk_type_name(handle);
	    } catch (Throwable t) {
		System.err.println(t.toString());
	        return null;
	    }
	}

	// Load the library
	static {
		System.loadLibrary("gtkjava2.4");
	}


    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected void gtk_init (int [] argc, String[] args);
    native static final protected void gtk_init_check (int [] argc, String[] args);
    native static final protected void gtk_disable_setlocale ();
    native static final protected String gtk_set_locale ();
    native static final protected int gtk_get_default_language ();
    native static final protected int gtk_events_pending ();
    native static final protected void gtk_main_do_event (int event);
    native static final protected void gtk_main ();
    native static final protected int gtk_main_level ();
    native static final protected void gtk_main_quit ();
    native static final protected boolean gtk_main_iteration ();
    native static final protected void gtk_grab_add (int widget);
    native static final protected int gtk_grab_get_current ();
    native static final protected void gtk_grab_remove (int widget);
    native static final protected int gtk_get_current_event ();
    native static final protected int gtk_get_current_event_time ();
    native static final protected int gtk_get_event_widget (int event);
    native static final protected String gtk_type_name (int type);
    native static final protected int gtk_type_from_name (String name);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/

    private Gtk() {
	// prevent instantiation
    }
}

