/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef _Included_org_gnu_gtk_IconInfo
#define _Included_org_gnu_gtk_IconInfo
#ifdef __cplusplus
extern "C" {
#endif
/*
 * Class:     org_gnu_gtk_IconInfo
 * Method:    gtk_icon_info_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_IconInfo_gtk_1icon_1info_1get_1type
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_icon_info_get_type();
}

/*
 * Class:     org_gnu_gtk_IconInfo
 * Method:    gtk_icon_info_copy
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_IconInfo_gtk_1icon_1info_1copy
  (JNIEnv *env, jclass cls, jint info)
{
	return (jint)gtk_icon_info_copy((GtkIconInfo*)info);
}

/*
 * Class:     org_gnu_gtk_IconInfo
 * Method:    gtk_icon_info_free
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_IconInfo_gtk_1icon_1info_1free
  (JNIEnv *env, jclass cls, jint info)
{
	gtk_icon_info_free((GtkIconInfo*)info);
}

/*
 * Class:     org_gnu_gtk_IconInfo
 * Method:    gtk_icon_info_get_base_size
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_IconInfo_gtk_1icon_1info_1get_1base_1size
  (JNIEnv *env, jclass cls, jint info)
{
	return (jint)gtk_icon_info_get_base_size((GtkIconInfo*)info);
}

/*
 * Class:     org_gnu_gtk_IconInfo
 * Method:    gtk_icon_info_get_filename
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_IconInfo_gtk_1icon_1info_1get_1filename
  (JNIEnv *env, jclass cls, jint info)
{
	return (*env)->NewStringUTF(env, gtk_icon_info_get_filename((GtkIconInfo*)info));
}

/*
 * Class:     org_gnu_gtk_IconInfo
 * Method:    gtk_icon_info_get_builtin_pixbuf
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_IconInfo_gtk_1icon_1info_1get_1builtin_1pixbuf
  (JNIEnv *env, jclass cls, jint info)
{
	return (jint)gtk_icon_info_get_builtin_pixbuf((GtkIconInfo*)info);
}

/*
 * Class:     org_gnu_gtk_IconInfo
 * Method:    gtk_icon_info_load_icon
 * Signature: (I[I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_IconInfo_gtk_1icon_1info_1load_1icon
  (JNIEnv *env,  jclass cls, jint info, jintArray error)
{
	GError* e = (GError*)(*env)->GetIntArrayElements(env, error, NULL);
	jint value = (jint)gtk_icon_info_load_icon((GtkIconInfo*)info, &e);
	(*env)->ReleaseIntArrayElements(env, error, (jint*)e, 0);
	return value;
}
	
/*
 * Class:     org_gnu_gtk_IconInfo
 * Method:    gtk_icon_info_set_raw_coordinates
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_IconInfo_gtk_1icon_1info_1set_1raw_1coordinates
  (JNIEnv *env, jclass cls, jint info, jboolean raw)
{
	gtk_icon_info_set_raw_coordinates((GtkIconInfo*)info, (gboolean)raw);
}

/*
 * Class:     org_gnu_gtk_IconInfo
 * Method:    gtk_icon_info_get_embedded_rect
 * Signature: (II)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_IconInfo_gtk_1icon_1info_1get_1embedded_1rect
  (JNIEnv *env, jclass cls, jint info, int rect)
{
	return (jboolean)gtk_icon_info_get_embedded_rect((GtkIconInfo*)info, (GdkRectangle*)rect);
}

/*
 * Class:     org_gnu_gtk_IconInfo
 * Method:    gtk_icon_info_get_attach_points
 * Signature: (I[II)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_IconInfo_gtk_1icon_1info_1get_1attach_1points
  (JNIEnv *env, jclass cls, jint info, jintArray points, jint numPoints)
{
	GdkPoint** point = g_malloc(sizeof(GdkPoint*) * (gint)numPoints);
	jint* elements = (*env)->GetIntArrayElements(env, points, NULL);
	int index;
	
	for (index = 0; index < (gint)numPoints; index++)
	{
		point[index] = (GdkPoint*)elements[index];
	}
	return gtk_icon_info_get_attach_points((GtkIconInfo*)info, point, &(gint)numPoints);
}

/*
 * Class:     org_gnu_gtk_IconInfo
 * Method:    gtk_icon_info_get_display_name
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_IconInfo_gtk_1icon_1info_1get_1display_1name
  (JNIEnv *env, jclass cls, jint info)
{
	return (*env)->NewStringUTF(env, gtk_icon_info_get_display_name((GtkIconInfo*)info));
}

#ifdef __cplusplus
}
#endif
#endif
