/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * A GtkPlug window is a top-level window that can be made available to
 * a separate process from the one that created it. The separate
 * process uses a GtkSocket to access the widget just as if it were
 * local.
 */
public class Plug extends Window 
{
	
	public Plug(int handle) {
		super(handle);
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_plug_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_plug_get_type ();
    native static final protected int gtk_plug_new (int socketId);
    native static final protected void gtk_plug_construct (int plug, int socketId);
    native static final protected int gtk_plug_get_id (int plug);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

