/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.pango;
import org.gnu.glib.Enum;

/**
 * An enumeration specifying the various slant styles possible for a font.
 */
public class Style extends Enum 
{
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    static final private int _NORMAL = 0;
	/**  the font is upright. */
    static final public org.gnu.pango.Style NORMAL = new org.gnu.pango.Style (_NORMAL);
    static final private int _OBLIQUE = 1;
	/**  the font is slanted, but in a roman style. */
    static final public org.gnu.pango.Style OBLIQUE = new org.gnu.pango.Style (_OBLIQUE);
    static final private int _ITALIC = 2;
	/**  the font is slanted in an italic style. */
    static final public org.gnu.pango.Style ITALIC = new org.gnu.pango.Style (_ITALIC);
    static final private org.gnu.pango.Style[] theInterned = new org.gnu.pango.Style[] 
    {
        NORMAL, OBLIQUE, ITALIC 
    }

;
    static private java.util.Hashtable theInternedExtras;
    static final private org.gnu.pango.Style theSacrificialOne = new org.gnu.pango.Style (0);
    static public org.gnu.pango.Style intern (int value) 
    {
        if (value < theInterned.length) 
        {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) 
        {
            theInternedExtras = new java.util.Hashtable();
        }
        org.gnu.pango.Style already = (org.gnu.pango.Style) theInternedExtras.get (
            theSacrificialOne);
        if (already == null) 
        {
            already = new org.gnu.pango.Style(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private Style (int value) 
    {
        value_ = value;
    }

    public org.gnu.pango.Style or (org.gnu.pango.Style other) 
    {
        return intern(value_ | other.value_);
    }

    public org.gnu.pango.Style and (org.gnu.pango.Style other) 
    {
        return intern(value_ & other.value_);
    }

    public org.gnu.pango.Style xor (org.gnu.pango.Style other) 
    {
        return intern(value_ ^ other.value_);
    }

    public boolean test (org.gnu.pango.Style other) 
    {
        return (value_ & other.value_) == other.value_;
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

